/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.calculator;

import com.kingdee.bos.ctrl.swing.CtrlPlainDocument;
import com.kingdee.bos.ctrl.swing.ICtrTextDocumentFilter;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.calculator.KDCalculatorPopup;
import com.kingdee.bos.ctrl.swing.calculator.plaf.KingdeeCalculatorUI;
import java.math.BigDecimal;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class KDCalculator
extends JComponent
implements IKDComponent {
    private static final long serialVersionUID = -4615081284775721216L;
    public static final int DEFALULT_DECIMAL_DIGITS = 2;
    private static final String uiClassID = "CalculatorUI";
    private KDCalculatorPopup calculatorPopup;
    private Object userObject;
    private BigDecimal value;
    private KDFormattedTextField display = this.createDisplay();

    public KDCalculator() {
        this.calculatorPopup = this.createCalculatorPopup(this);
        this.setPrecision(0);
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public KingdeeCalculatorUI getUI() {
        return (KingdeeCalculatorUI)this.ui;
    }

    public void setUI(KingdeeCalculatorUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((KingdeeCalculatorUI)UIManager.getUI(this));
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public KDCalculatorPopup getCalculatorPopup() {
        if (this.calculatorPopup == null) {
            this.display = this.createDisplay();
            this.calculatorPopup = this.createCalculatorPopup(this);
        }
        return this.calculatorPopup;
    }

    public KDFormattedTextField getDisplay() {
        if (this.display == null) {
            this.display = this.createDisplay();
        }
        return this.display;
    }

    public void setDisplay(KDFormattedTextField display) {
        this.display = display;
        this.updateUI();
        this.calculatorPopup = this.createCalculatorPopup(this);
    }

    public void setPrecision(int precision) {
        this.setPrecision(precision, false);
    }

    private void setPrecision(int precision, boolean enableChange) {
        if (precision < 0 || precision > 15) {
            throw new ArithmeticException("Precision out of range [0,15]");
        }
        this.calculatorPopup.setPrecision(precision);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        if (value != null) {
            BigDecimal oldValue = this.value;
            this.value = value;
            this.firePropertyChange("value", oldValue, value);
        }
    }

    private KDFormattedTextField createDisplay() {
        KDFormattedTextField txtField = new KDFormattedTextField();
        txtField.setHorizontalAlignment(4);
        DefaultPlaintDocument numberDocument = new DefaultPlaintDocument();
        DefaultCtrlTextDocumentFilter ctrlTextDocuFilter = new DefaultCtrlTextDocumentFilter();
        numberDocument.setCtrTextDocumentFilter(ctrlTextDocuFilter);
        txtField.setDocument(numberDocument);
        txtField.setFocusTraversalKeysEnabled(false);
        return txtField;
    }

    public void commitEdit() throws ParseException {
        this.getCalculatorPopup().getModel().setExpressValue(this.display.getText());
    }

    public boolean isRemoveExtraZero() {
        return this.getCalculatorPopup().isShowExtraZero();
    }

    public void setShowExtraZero(boolean showExtraZero) {
        this.getCalculatorPopup().setShowExtraZero(showExtraZero);
    }

    private KDCalculatorPopup createCalculatorPopup(KDCalculator calculator) {
        KDCalculatorPopup calculatorPopup = new KDCalculatorPopup(calculator);
        return calculatorPopup;
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.bos.ctrl.swing.calculator.plaf.KingdeeCalculatorUI");
    }

    private class DefaultPlaintDocument
    extends CtrlPlainDocument {
        private static final long serialVersionUID = 4717595221519587607L;

        private DefaultPlaintDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (this.isFocusing() && this.getCtrTextDocumentFilter() != null && !this.getCtrTextDocumentFilter().isValidateStr(text)) {
                return;
            }
            if (!this.getCtrTextDocumentFilter().isValidLength(this)) {
                return;
            }
            if (this.isFocusing() && this.getCtrTextDocumentFilter() != null && text != null && text.length() == 1 && offset != 0 && text.equals("-")) {
                return;
            }
            super.replace(offset, length, text, attrs);
        }
    }

    public static class DefaultCtrlTextDocumentFilter
    implements ICtrTextDocumentFilter {
        private String validateStr = "-+.%,";
        private boolean supportEmptyValue = false;

        public DefaultCtrlTextDocumentFilter() {
        }

        public DefaultCtrlTextDocumentFilter(boolean supportEmptyValue) {
            this();
            this.supportEmptyValue = supportEmptyValue;
        }

        @Override
        public boolean isValidateStr(String str) {
            boolean b = false;
            if (str != null && str.length() > 0) {
                if (str.indexOf(43) != -1) {
                    b = false;
                } else {
                    int len = str.length();
                    if (len > 1) {
                        if (str.lastIndexOf(45) != -1 && str.lastIndexOf(45) != 0) {
                            b = false;
                        }
                    } else {
                        for (int i = 0; i < len; ++i) {
                            char tChar = str.charAt(i);
                            b = Character.isDigit(tChar) || this.validateStr.indexOf(tChar) != -1;
                        }
                    }
                }
            }
            if (this.supportEmptyValue && (str == null || str.length() == 0)) {
                b = true;
            }
            return b;
        }

        @Override
        public boolean isValidLength(Document doc) {
            return true;
        }

        @Override
        public void setValidateStr(String newValue) {
            if (newValue != null) {
                this.validateStr = newValue;
            }
        }

        @Override
        public String getValidateStr() {
            return this.validateStr;
        }

        @Override
        public void setValidLength(int len) {
        }

        public void setNegativeble(boolean newValue) {
            if (newValue) {
                String string = this.validateStr = this.validateStr == null ? "-+.%," : this.validateStr;
                if (this.validateStr.indexOf("-") == -1) {
                    this.validateStr = this.validateStr + "-";
                }
            } else {
                String string = this.validateStr = this.validateStr == null ? "+.%," : this.validateStr;
                if (this.validateStr.indexOf("-") != -1) {
                    this.validateStr = this.validateStr.replaceAll("-", "");
                }
            }
        }
    }
}

