/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.model;

import com.kingdee.bos.ctrl.swing.event.DateTimeValueChangeEvent;
import com.kingdee.bos.ctrl.swing.model.AbstractDateTimeModel;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class DateTimeModel
extends AbstractDateTimeModel
implements Serializable {
    private static final long serialVersionUID = 8124884844829342276L;
    private Calendar value = null;
    static final Object LOCK = new Object();

    public DateTimeModel() {
        this(null, false);
    }

    public DateTimeModel(Date date, boolean isTimeEnable) {
        Date newDate = date;
        if (newDate == null) {
            Calendar calendar = Calendar.getInstance();
            if (!isTimeEnable) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            newDate = calendar.getTime();
        }
        this.value = Calendar.getInstance();
        this.value.setTime(newDate);
        this.setTimeEnable(isTimeEnable);
    }

    @Override
    public int getDay() {
        return this.getValueOfField(this.value, 5);
    }

    @Override
    public int getHour() {
        return this.getValueOfField(this.value, 11);
    }

    @Override
    public int getMilliSecond() {
        return this.getValueOfField(this.value, 14);
    }

    @Override
    public int getMinute() {
        return this.getValueOfField(this.value, 12);
    }

    @Override
    public int getMonth() {
        return this.getValueOfField(this.value, 2);
    }

    @Override
    public int getNanos() {
        return this.getValueOfField(this.value, 1977);
    }

    @Override
    public Object getNextValue() {
        Calendar cal = Calendar.getInstance();
        if (this.value == null) {
            cal.setTime(new Date(System.currentTimeMillis()));
        }
        cal.setTime(this.value.getTime());
        cal.add(this.getCalendarField(), 1);
        Date next = cal.getTime();
        return next;
    }

    @Override
    public Object getPreviousValue() {
        Calendar cal = Calendar.getInstance();
        if (this.value == null) {
            cal.setTime(new Date(System.currentTimeMillis()));
        }
        cal.setTime(this.value.getTime());
        cal.add(this.getCalendarField(), -1);
        Date prev = cal.getTime();
        return prev;
    }

    @Override
    public int getSecond() {
        return this.getValueOfField(this.value, 13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getValue() {
        Object object = LOCK;
        synchronized (object) {
            if (this.value != null) {
                return this.value.getTime();
            }
            return NULLDATE;
        }
    }

    @Override
    public int getYear() {
        return this.getValueOfField(this.value, 1);
    }

    @Override
    public void setDay(int d) {
        if (!this.isMaxMinScope(5, d)) {
            return;
        }
        boolean b = this.setValueOfField(this.value, 5, d);
        if (b) {
            Date old = this.value.getTime();
            DateTimeValueChangeEvent event = new DateTimeValueChangeEvent(this);
            event.setFieldType(2);
            event.setOldValue(old);
            event.setNewValue(this.value.getTime());
            this.fireDataChanged(event);
        }
    }

    @Override
    public void setHour(int h) {
        if (!this.isMaxMinScope(11, h)) {
            return;
        }
        boolean b = this.setValueOfField(this.value, 11, h);
        if (b) {
            Date old = this.value.getTime();
            DateTimeValueChangeEvent event = new DateTimeValueChangeEvent(this);
            event.setFieldType(3);
            event.setOldValue(old);
            event.setNewValue(this.value.getTime());
            this.fireDataChanged(event);
        }
    }

    @Override
    public void setMilliSecond(int ms) {
        if (!this.isMaxMinScope(14, ms)) {
            return;
        }
        boolean b = this.setValueOfField(this.value, 14, ms);
        if (b) {
            Date old = this.value.getTime();
            DateTimeValueChangeEvent event = new DateTimeValueChangeEvent(this);
            event.setFieldType(6);
            event.setOldValue(old);
            event.setNewValue(this.value.getTime());
            this.fireDataChanged(event);
        }
    }

    @Override
    public void setMinute(int m) {
        if (!this.isMaxMinScope(12, m)) {
            return;
        }
        boolean b = this.setValueOfField(this.value, 12, m);
        if (b) {
            Date old = this.value.getTime();
            DateTimeValueChangeEvent event = new DateTimeValueChangeEvent(this);
            event.setFieldType(4);
            event.setOldValue(old);
            event.setNewValue(this.value.getTime());
            this.fireDataChanged(event);
        }
    }

    @Override
    public void setMonth(int m) {
        if (!this.isMaxMinScope(2, m)) {
            return;
        }
        boolean b = this.setValueOfField(this.value, 2, m);
        if (b) {
            Date old = this.value.getTime();
            DateTimeValueChangeEvent event = new DateTimeValueChangeEvent(this);
            event.setFieldType(1);
            event.setOldValue(old);
            event.setNewValue(this.value.getTime());
            this.fireDataChanged(event);
        }
    }

    @Override
    public void setNanos(int nanos) {
        if (!this.isMaxMinScope(1977, nanos)) {
            return;
        }
        boolean b = this.setValueOfField(this.value, 1977, nanos);
        if (b) {
            Date old = this.value.getTime();
            DateTimeValueChangeEvent event = new DateTimeValueChangeEvent(this);
            event.setFieldType(7);
            event.setOldValue(old);
            event.setNewValue(this.value.getTime());
            this.fireDataChanged(event);
        }
    }

    @Override
    public void setSecond(int s) {
        if (!this.isMaxMinScope(13, s)) {
            return;
        }
        boolean b = this.setValueOfField(this.value, 13, s);
        if (b) {
            Date old = this.value.getTime();
            DateTimeValueChangeEvent event = new DateTimeValueChangeEvent(this);
            event.setFieldType(5);
            event.setOldValue(old);
            event.setNewValue(this.value.getTime());
            this.fireDataChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Date date) {
        Object object = LOCK;
        synchronized (object) {
            Date oldDate;
            boolean isC = false;
            Date date2 = oldDate = this.value != null ? this.value.getTime() : null;
            if (date != null) {
                if (this.value != null && date.getTime() != this.value.getTime().getTime()) {
                    this.value.setTime(date);
                    isC = true;
                } else if (this.value == null) {
                    this.value = Calendar.getInstance();
                    this.value.setTime(date);
                    isC = true;
                }
            } else if (oldDate != null) {
                this.value = null;
                isC = true;
            }
            if (isC) {
                DateTimeValueChangeEvent event = new DateTimeValueChangeEvent(this);
                event.setFieldType(8);
                event.setOldValue(oldDate);
                event.setNewValue(date);
                this.fireDataChanged(event);
            }
        }
    }

    @Override
    public void setYear(int y) {
        boolean b = this.setValueOfField(this.value, 1, y);
        if (b) {
            Date old = this.value.getTime();
            DateTimeValueChangeEvent event = new DateTimeValueChangeEvent(this);
            event.setFieldType(0);
            event.setOldValue(old);
            event.setNewValue(this.value.getTime());
            this.fireDataChanged(event);
        }
    }
}

