/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.DatePickerDownList;
import com.kingdee.bos.ctrl.swing.DateTimeEditor;
import com.kingdee.bos.ctrl.swing.KDArrowButton;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.bos.ctrl.swing.util.CtrlCommonConstant;
import com.kingdee.bos.ctrl.swing.util.CtrlImageUtilities;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;

public class KingdeeDatePickerUI
extends ComponentUI {
    private KDDatePicker datePicker = null;
    private ArrowButtonHandler arrowButtonHandler = null;
    private DatePickerDownList datePickerDownList = null;
    private transient JDialog popup = null;
    private DecorateButtonHandler decorateButtonHandler = null;
    private Calendar calendar = null;
    private DownListMouseHandler downListMouseHanlder = null;
    private KeyListener popDateListPaneHandler = null;
    private int labelLength = -1;
    private int labelAlignment = 7;
    private JButton selfArrowButton = null;
    private boolean isClosedByArrBtn = false;
    private WindowListener popupWindowHandler = null;
    private Action enterEscActionHandler = null;
    private static final String SHORTCUT_ESC_POPUP = "esckeyforpopup";
    private final int space = 1;

    public static ComponentUI createUI(JComponent x) {
        return new KingdeeDatePickerUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (this.datePicker.getAccessAuthority() == 1) {
            ((BasicFormattedTextField)this.datePicker.getEditor().getEditorComponent()).getForeground();
        } else if (!this.datePicker.isEnabled() || (this.datePicker.isRequired() ? this.datePicker.isEditable() : this.datePicker.isEditable())) {
            // empty if block
        }
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return super.getAccessibleChild(c, i);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return super.getAccessibleChildrenCount(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return super.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return super.getPreferredSize(c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.datePicker = (KDDatePicker)c;
        this.datePicker.setLayout(this.createDatePickerLayout());
        this.installComponents(this.datePicker);
        this.installDefaults(this.datePicker);
        this.installListeners(this.datePicker);
        this.installKeyboardActions(this.datePicker);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.unInstallKeyboardActions(this.datePicker);
        this.unInstallListeners(this.datePicker);
        this.unInstallDefaults(this.datePicker);
        this.unInstallComponents(this.datePicker);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    protected void installComponents(KDDatePicker datePicker) {
        datePicker.setRequestFocusEnabled(true);
        DateTimeEditor editor = datePicker.getEditor();
        this.selfArrowButton = this.createArrowButton();
        datePicker.add((Component)editor, "editor");
        datePicker.add((Component)this.selfArrowButton, "arrowButton");
        if (this.getCompositeLabel() != null) {
            datePicker.add((Component)this.getCompositeLabel(), "label");
        }
    }

    protected void installDefaults(KDDatePicker datePicker) {
        Object obj = datePicker.getValue();
        this.calendar = Calendar.getInstance();
        if (obj != null && obj instanceof Date) {
            this.calendar.setTime(new Date(((Date)obj).getTime()));
        } else {
            this.calendar.setTime(new Date(System.currentTimeMillis()));
        }
        datePicker.getEditor().setValue(this.calendar.getTime());
        datePicker.getEditor().getEditorComponent().setBorder(KingdeeBorders.createWideEditorBorder());
        this.labelAlignment = datePicker.getLabelAlignment();
        this.labelLength = datePicker.getLabelLength();
    }

    protected void installListeners(KDDatePicker datePicker) {
        datePicker.addPropertyChangeListener(new DatePickerPropertyChangeListener());
        if (this.popDateListPaneHandler == null) {
            this.popDateListPaneHandler = new DownPopDateListPaneHandler();
            datePicker.getEditor().getEditorComponent().addKeyListener(this.popDateListPaneHandler);
        }
    }

    protected void installKeyboardActions(KDDatePicker datePicker) {
    }

    protected void unInstallDefaults(KDDatePicker datePicker) {
    }

    protected void unInstallListeners(KDDatePicker datePicker) {
        if (this.popDateListPaneHandler != null) {
            datePicker.getEditor().getEditorComponent().removeKeyListener(this.popDateListPaneHandler);
            this.popDateListPaneHandler = null;
        }
    }

    protected void unInstallKeyboardActions(KDDatePicker datePicker) {
    }

    protected void unInstallComponents(KDDatePicker datePicker) {
        datePicker.removeAll();
        this.datePickerDownList = null;
    }

    protected JButton createArrowButton() {
        KDArrowButton b = new KDArrowButton(5);
        if (this.arrowButtonHandler == null) {
            this.arrowButtonHandler = new ArrowButtonHandler();
        }
        b.setInitIcon((ImageIcon)UIManager.getIcon("DatePicker.initIcon"));
        b.setActiveIcon((ImageIcon)UIManager.getIcon("DatePicker.activeIcon"));
        b.setMouseOverIcon((ImageIcon)UIManager.getIcon("DatePicker.mouseOverIcon"));
        b.setDeactiveIcon(CtrlImageUtilities.createDisableIcon(UIManager.getIcon("DatePicker.initIcon")));
        b.addMouseListener(this.arrowButtonHandler);
        return b;
    }

    protected void configurePopup() {
        if (this.popup == null) {
            Window w;
            if (this.datePickerDownList == null) {
                this.createDatePickerDownList();
            }
            this.popup = (w = SwingUtilities.getWindowAncestor(this.datePicker)) instanceof Frame ? new JDialog((Frame)w) : (w instanceof Dialog ? new JDialog((Dialog)w) : new JDialog());
            JButton bu = (JButton)this.datePickerDownList.getClientProperty("DownList.DefaultButton");
            if (bu != null) {
                this.popup.getRootPane().setDefaultButton(bu);
            }
            this.popup.setModal(false);
            this.popup.setUndecorated(true);
            this.popup.getContentPane().add(this.datePickerDownList);
            this.popup.setResizable(false);
            this.popup.pack();
            if (this.popupWindowHandler != null) {
                this.popup.removeWindowListener(this.popupWindowHandler);
                this.popupWindowHandler = null;
            }
            if (this.popupWindowHandler == null) {
                this.popupWindowHandler = new PopupWindowHandler();
                this.popup.addWindowListener(this.popupWindowHandler);
            }
            this.putEscActionToPopup(this.popup.getRootPane());
        }
    }

    private void putEscActionToPopup(JComponent comp) {
        if (this.enterEscActionHandler == null) {
            this.enterEscActionHandler = new EnterEscActionHandler();
        }
        CtrlSwingUtilities.appendActionToComponent(comp, 2, CtrlCommonConstant.KEYSTROKE_ESC, SHORTCUT_ESC_POPUP, this.enterEscActionHandler);
    }

    protected void createDatePickerDownList() {
        this.datePickerDownList = this.datePicker.getDatePickerDownList();
        if (this.decorateButtonHandler == null) {
            this.decorateButtonHandler = new DecorateButtonHandler();
            this.datePickerDownList.addActionListener(this.decorateButtonHandler);
        }
        if (this.downListMouseHanlder == null) {
            this.downListMouseHanlder = new DownListMouseHandler();
            this.datePickerDownList.addMouseListener(this.downListMouseHanlder);
        }
    }

    protected void popDatePickerDownList() {
        if (!this.datePicker.hasDatePickerDownList()) {
            return;
        }
        this.configurePopup();
        boolean b = this.popup.isVisible();
        if (!b) {
            CtrlSwingUtilities.locateWindowToComponent(this.popup, null, this.datePicker, 3);
            Date cd = (Date)this.datePicker.getValue();
            if (cd != null) {
                this.datePickerDownList.setValue(cd);
            } else {
                this.datePickerDownList.setValue(new Date(System.currentTimeMillis()));
            }
            this.popup.show();
        } else {
            this.popup.dispose();
            this.datePickerDownList.getUI().removeAllRollOverEffect();
            this.popup = null;
        }
    }

    protected void createPopupComponentListener() {
    }

    public void setPopupVisible(boolean v) {
        if (this.popup == null && v) {
            this.popDatePickerDownList();
        } else if (this.popup != null) {
            boolean b = this.popup.isVisible();
            if (!b && v) {
                this.popDatePickerDownList();
            } else if (b && !v) {
                this.popDatePickerDownList();
            }
        }
    }

    public boolean isPopupVisible() {
        return this.popup != null ? this.popup.isVisible() : false;
    }

    protected boolean reveivedValueFromDownList() {
        Date oldDate = (Date)this.datePicker.getValue();
        this.datePickerDownList.commitComfirm();
        Date newDate = (Date)this.datePickerDownList.getValue();
        if (oldDate == null || newDate == null || newDate.compareTo(oldDate) != 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            this.datePicker.setValue(calendar.getTime());
        }
        return true;
    }

    protected boolean receivedValueFromDownList() {
        if (this.datePicker.getAccessAuthority() == 1) {
            return true;
        }
        this.datePickerDownList.commitComfirm();
        this.datePicker.setValue(this.datePickerDownList.getValue());
        return true;
    }

    protected void doDecorateButtonHandler(String command) {
        if (command.equals("okButton")) {
            if (this.receivedValueFromDownList()) {
                this.setPopupVisible(false);
            }
        } else if (command.equals("cancelButton")) {
            this.setPopupVisible(false);
        }
    }

    protected void mouseDoubleClicked(MouseEvent me) {
        boolean b = this.datePickerDownList.mouseDoubleClicked(me.getX(), me.getY());
        this.receivedValueFromDownList();
        if (b) {
            this.setPopupVisible(false);
        }
    }

    protected LayoutManager createDatePickerLayout() {
        return new DatePickerLayout();
    }

    private void revalidateWithParent() {
        this.datePicker.revalidate();
        Container ct = this.datePicker.getParent();
        if (ct != null) {
            ct.validate();
        }
    }

    private JLabel getCompositeLabel() {
        return this.datePicker.getCompositeLabel();
    }

    private boolean isCompositeLabelVisible() {
        if (this.getCompositeLabel() == null) {
            return false;
        }
        return this.getCompositeLabel().getText().length() > 0;
    }

    private void setlabelLength(Object newLabelBlankLen) {
        if (newLabelBlankLen != null && newLabelBlankLen instanceof Integer) {
            this.labelLength = (Integer)newLabelBlankLen;
            this.setLabeWidthHeight(this.labelLength);
            this.setLabelAlignment(new Integer(this.labelAlignment));
            this.revalidateWithParent();
        }
    }

    private void setLabeWidthHeight(int labLen) {
        switch (this.labelAlignment) {
            case 3: 
            case 7: {
                if (this.getCompositeLabel() == null) break;
                Dimension labDim = this.getCompositeLabel().getPreferredSize();
                if (labLen < labDim.width) {
                    labLen = labDim.width;
                }
                this.getCompositeLabel().setPreferredSize(new Dimension(labLen, labDim.height));
                break;
            }
            default: {
                if (this.getCompositeLabel() == null) break;
                Dimension labDim = this.getCompositeLabel().getPreferredSize();
                if (labLen < labDim.height) {
                    labLen = labDim.height;
                }
                this.getCompositeLabel().setPreferredSize(new Dimension(labDim.width, labLen));
            }
        }
    }

    private void setLabelAlignment(Object newLabelAlig) {
        if (newLabelAlig != null && newLabelAlig instanceof Integer) {
            this.labelAlignment = (Integer)newLabelAlig;
            if (this.getCompositeLabel() != null) {
                this.getCompositeLabel().setVerticalAlignment(1);
            }
            switch (this.labelAlignment) {
                case 3: {
                    if (this.getCompositeLabel() == null) break;
                    this.getCompositeLabel().setHorizontalAlignment(4);
                    this.getCompositeLabel().setVerticalAlignment(3);
                    break;
                }
                case 2: {
                    if (this.getCompositeLabel() == null) break;
                    this.getCompositeLabel().setHorizontalAlignment(4);
                    break;
                }
                case 1: {
                    if (this.getCompositeLabel() == null) break;
                    this.getCompositeLabel().setHorizontalAlignment(0);
                    break;
                }
                case 8: {
                    if (this.getCompositeLabel() == null) break;
                    this.getCompositeLabel().setHorizontalAlignment(2);
                    break;
                }
                default: {
                    if (this.getCompositeLabel() == null) break;
                    this.getCompositeLabel().setHorizontalAlignment(2);
                    this.getCompositeLabel().setVerticalAlignment(3);
                }
            }
            this.revalidateWithParent();
        }
    }

    private void setCompositeLable(Object old, Object newLabel) {
        if (newLabel != null && newLabel instanceof JLabel) {
            if (old == null) {
                this.datePicker.add((Component)this.getCompositeLabel(), "label");
            } else {
                this.datePicker.remove((Component)old);
                this.datePicker.add((Component)this.getCompositeLabel(), "label");
            }
            this.setLabeWidthHeight(this.labelLength);
            this.setLabelAlignment(new Integer(this.labelAlignment));
            this.revalidateWithParent();
        }
    }

    private class PopupWindowHandler
    extends WindowAdapter {
        private PopupWindowHandler() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            KingdeeDatePickerUI.this.datePicker.getEditor().getEditorComponent().requestFocusInWindow();
            KingdeeDatePickerUI.this.isClosedByArrBtn = false;
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            KingdeeDatePickerUI.this.isClosedByArrBtn = true;
            KingdeeDatePickerUI.this.setPopupVisible(false);
        }

        @Override
        public void windowActivated(WindowEvent e) {
            KingdeeDatePickerUI.this.datePicker.getDatePickerDownList().doFocus();
        }
    }

    class InnerArrowButton
    extends BasicArrowButton {
        private static final long serialVersionUID = 4836271112253001797L;
        private Color shadow;
        private Color darkShadow;
        private Color highlight;

        public InnerArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
            super(direction, background, shadow, darkShadow, highlight);
            this.shadow = shadow;
            this.darkShadow = darkShadow;
            this.highlight = highlight;
        }

        public InnerArrowButton(int direction) {
            super(direction);
            this.shadow = Color.decode("#A5A2A5");
            this.darkShadow = Color.decode("#B5B6B5");
            this.highlight = Color.decode("#63A2FF");
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getSize().width;
            int h = this.getSize().height;
            Color origColor = g.getColor();
            boolean isPressed = this.getModel().isPressed();
            boolean isEnabled = this.isEnabled();
            g.setColor(this.getBackground());
            g.fillRect(1, 1, w - 2, h - 2);
            if (isPressed) {
                g.setColor(this.darkShadow);
                g.drawRect(0, 0, w - 1, h - 1);
            } else {
                g.setColor(this.shadow);
                g.drawLine(0, 0, w - 1, 0);
                g.drawLine(0, h - 1, w - 1, h - 1);
                g.drawLine(0, 1, 0, h - 1);
                g.drawLine(w - 1, 1, w - 1, h - 1);
            }
            if (h < 5 || w < 5) {
                g.setColor(origColor);
                return;
            }
            if (isPressed) {
                g.translate(1, 1);
            }
            int size = Math.min((h - 4) / 3, (w - 4) / 3);
            size = Math.max(size, 2);
            this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
            if (isPressed) {
                g.translate(-1, -1);
            }
            g.setColor(origColor);
        }

        @Override
        public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
            Color oldColor = g.getColor();
            int j = 0;
            size = Math.max(size, 2);
            int mid = size / 2 - 1;
            g.translate(x, y);
            if (isEnabled) {
                g.setColor(this.highlight);
            } else {
                g.setColor(this.shadow);
            }
            switch (direction) {
                case 1: {
                    int i;
                    for (i = 0; i < size; ++i) {
                        g.drawLine(mid - i, i, mid + i, i);
                    }
                    if (isEnabled) break;
                    g.setColor(this.highlight);
                    g.drawLine(mid - i + 2, i, mid + i, i);
                    break;
                }
                case 5: {
                    int i;
                    if (!isEnabled) {
                        g.translate(1, 1);
                        g.setColor(this.highlight);
                        for (i = size - 1; i >= 0; --i) {
                            g.drawLine(mid - i, j, mid + i, j);
                            ++j;
                        }
                        g.translate(-1, -1);
                        g.setColor(this.shadow);
                    }
                    j = 0;
                    for (i = size - 1; i >= 0; --i) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                    }
                    break;
                }
                case 7: {
                    int i;
                    for (i = 0; i < size; ++i) {
                        g.drawLine(i, mid - i, i, mid + i);
                    }
                    if (isEnabled) break;
                    g.setColor(this.highlight);
                    g.drawLine(i, mid - i + 2, i, mid + i);
                    break;
                }
                case 3: {
                    int i;
                    if (!isEnabled) {
                        g.translate(1, 1);
                        g.setColor(this.highlight);
                        for (i = size - 1; i >= 0; --i) {
                            g.drawLine(j, mid - i, j, mid + i);
                            ++j;
                        }
                        g.translate(-1, -1);
                        g.setColor(this.shadow);
                    }
                    j = 0;
                    for (i = size - 1; i >= 0; --i) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                    }
                    break;
                }
            }
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    class DatePickerLayout
    implements LayoutManager {
        JComponent editor = null;
        JComponent arrowButton = null;
        JComponent label = null;

        DatePickerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name.equals("editor")) {
                this.editor = (JComponent)comp;
            } else if (name.equals("arrowButton")) {
                this.arrowButton = (JComponent)comp;
            } else if (name.equals("label")) {
                this.label = (JComponent)comp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                Dimension pDim = parent.getSize();
                Dimension ediDim = this.editor.getPreferredSize();
                Dimension labDim = new Dimension(0, 0);
                if (this.label != null) {
                    labDim = this.label.getPreferredSize();
                }
                Dimension arrDim = this.arrowButton.getPreferredSize();
                int w = pDim.width - insets.left - insets.right;
                int h = pDim.height - insets.top - insets.bottom;
                int x = insets.left;
                int y = insets.top;
                int labW = 0;
                int ediW = 0;
                int labH = 0;
                int ediH = 0;
                boolean isLab = KingdeeDatePickerUI.this.isCompositeLabelVisible();
                switch (KingdeeDatePickerUI.this.labelAlignment) {
                    case 3: {
                        if (isLab) {
                            if (w > arrDim.width + ediDim.width + labDim.width) {
                                ediW = w - arrDim.width - labDim.width;
                                labW = labDim.width;
                            } else if (w > arrDim.width + ediDim.width) {
                                ediW = ediDim.width;
                                labW = w - arrDim.width - ediDim.width;
                            } else if (w > arrDim.width) {
                                ediW = w - arrDim.width;
                                labW = 0;
                            } else {
                                ediW = 0;
                                labW = 0;
                            }
                            this.editor.setBounds(x, y, ediW, h);
                            this.arrowButton.setBounds((x += ediW) + 1, y, arrDim.width, h);
                            this.label.setBounds(x += arrDim.width + 1, y, labW, h);
                            break;
                        }
                        ediW = w - arrDim.width;
                        this.editor.setBounds(x, y, ediW, h);
                        this.arrowButton.setBounds(x + ediW + 1, y, arrDim.width, h);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        ediW = Math.max(w - arrDim.width, 0);
                        if (isLab) {
                            if (h > ediDim.height + labDim.height) {
                                ediH = h - labDim.height;
                                labH = labDim.height;
                            } else if (h > ediDim.height) {
                                ediH = ediDim.height;
                                labH = h - ediDim.height;
                            } else {
                                ediH = h;
                                labH = 0;
                            }
                            this.label.setBounds(x, y, w, labH);
                            this.editor.setBounds(x, y + labH, ediW, ediH);
                            this.arrowButton.setBounds(x + ediW + 1, y + labH, arrDim.width, ediH);
                            break;
                        }
                        this.editor.setBounds(x, y, ediW, h);
                        this.arrowButton.setBounds(x + ediW + 1, y, arrDim.width, h);
                        break;
                    }
                    default: {
                        x = pDim.width - arrDim.width - insets.right - 1;
                        int interval = 3;
                        this.arrowButton.setBounds(x - interval + 1, y - 1, arrDim.width + 1, h);
                        if (isLab) {
                            if (w - arrDim.width > ediDim.width + labDim.width) {
                                ediW = w - arrDim.width - labDim.width;
                                labW = labDim.width;
                            } else if (w - arrDim.width > ediDim.width) {
                                ediW = ediDim.width;
                                labW = w - arrDim.width - ediDim.width;
                            } else {
                                ediW = w - arrDim.width;
                                labW = 0;
                            }
                            this.editor.setBounds(x -= ediW, y, ediW, h);
                            this.label.setBounds(insets.left, y, labW, h);
                            break;
                        }
                        w = x - insets.left;
                        this.editor.setBounds(insets.left, y, w - interval, h);
                    }
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                Rectangle rect = parent.getBounds();
                Dimension pDim = new Dimension(rect.width, rect.height);
                Dimension ediDim = this.editor.getPreferredSize();
                Dimension labDim = new Dimension(0, 0);
                if (this.label != null) {
                    labDim = this.label.getPreferredSize();
                }
                Dimension arrDim = this.arrowButton.getPreferredSize();
                int w = pDim.width - insets.left - insets.right;
                int h = pDim.height - insets.top - insets.bottom;
                int tempW = 0;
                boolean isLab = KingdeeDatePickerUI.this.isCompositeLabelVisible();
                switch (KingdeeDatePickerUI.this.labelAlignment) {
                    case 1: 
                    case 2: 
                    case 8: {
                        w = ediDim.width + arrDim.width + insets.left + insets.right;
                        h = Math.max(ediDim.height, arrDim.height);
                        h += insets.top + insets.bottom;
                        if (isLab) {
                            tempW = insets.left + insets.right + labDim.width;
                            w = Math.max(tempW, w);
                            h += labDim.height;
                        }
                        return new Dimension(w + 2 + 1, h);
                    }
                }
                w = ediDim.width + arrDim.width;
                h = Math.max(ediDim.height, arrDim.height);
                if (isLab) {
                    w += labDim.width;
                    if (KingdeeDatePickerUI.this.labelAlignment > 0) {
                        w += KingdeeDatePickerUI.this.labelAlignment;
                    }
                    h = Math.max(h, labDim.height);
                }
                w += insets.left + insets.right;
                h += insets.top + insets.bottom;
                w = Math.max(w, pDim.width);
                h = Math.max(h, pDim.height);
                return new Dimension(w + 2 + 1, h);
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == this.editor) {
                this.editor = null;
            }
            if (comp == this.arrowButton) {
                this.arrowButton = null;
            }
            if (comp == this.label) {
                this.label = null;
            }
        }
    }

    class DownListMouseHandler
    extends MouseAdapter {
        DownListMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getModifiers() != 16) {
                return;
            }
            int cc = me.getClickCount();
            if (cc == 2) {
                KingdeeDatePickerUI.this.mouseDoubleClicked(me);
            }
        }
    }

    class DatePickerPropertyChangeListener
    implements PropertyChangeListener {
        DatePickerPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("labelLength")) {
                KingdeeDatePickerUI.this.setlabelLength(evt.getNewValue());
            } else if (name.equals("labelAlignment")) {
                KingdeeDatePickerUI.this.setLabelAlignment(evt.getNewValue());
            } else if (name.equals("compositeLabel")) {
                KingdeeDatePickerUI.this.setCompositeLable(evt.getOldValue(), evt.getNewValue());
            } else if (name.equals("preferredSize")) {
                KingdeeDatePickerUI.this.revalidateWithParent();
            } else if (name.equals("hasDatePickerDownList")) {
                if (KingdeeDatePickerUI.this.selfArrowButton != null) {
                    Boolean b = (Boolean)evt.getNewValue();
                    KingdeeDatePickerUI.this.selfArrowButton.setEnabled(b);
                }
            } else if (evt.getPropertyName().equals("required") && evt.getNewValue() != evt.getOldValue()) {
                Component c = (Component)evt.getSource();
                c.repaint();
            }
        }
    }

    private class DecorateButtonHandler
    implements ActionListener {
        private DecorateButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            KingdeeDatePickerUI.this.doDecorateButtonHandler(actionCommand);
        }
    }

    private class ArrowButtonHandler
    extends MouseAdapter {
        private ArrowButtonHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            KingdeeDatePickerUI.this.setPopupVisible(true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class EnterEscActionHandler
    extends AbstractAction {
        private static final long serialVersionUID = 8655100269677888008L;

        private EnterEscActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            KingdeeDatePickerUI.this.setPopupVisible(false);
        }
    }

    private class DownPopDateListPaneHandler
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            int modi = e.getModifiers();
            if (modi == 8 && keyCode == 40) {
                KingdeeDatePickerUI.this.popDatePickerDownList();
            }
        }
    }
}

