/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.plaf.KingdeeUtils;
import com.kingdee.bos.ctrl.swing.plaf.PaintUtil;
import com.kingdee.bos.ctrl.swing.util.CtrlImageUtilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.text.View;

public class KingdeeMenuItemUI
extends BasicMenuItemUI {
    private static final int BG_INIT = 0;
    private static final int BG_ROLLVER = 1;
    private static final int BG_DISABLE = 2;
    private int leftAreaWidth = 22;
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();
    private String acceleratorDelimiter;
    static int minWidth = UIManager.getInt("MenuItem.minWidth");
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";

    public static ComponentUI createUI(JComponent x) {
        return new KingdeeMenuItemUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String prefix = this.getPropertyPrefix();
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(prefix + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(prefix + ".checkIcon");
        }
        this.leftAreaWidth = (Integer)UIManager.get("MenuItem.leftAreaWidth") + 3;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension dim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        dim.width += this.leftAreaWidth;
        if (dim.width < minWidth) {
            dim.width = minWidth;
        }
        return dim;
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        if (model.isEnabled()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(UIManager.getColor("MenuItem.selectionForeground"));
            } else {
                g.setColor(UIManager.getColor("MenuItem.foreground"));
            }
        } else {
            g.setColor(UIManager.getColor("MenuItem.disabledForeground"));
        }
        textRect.x = this.leftAreaWidth + 5;
        super.paintText(g, menuItem, textRect, text);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            if (model.isEnabled()) {
                if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                    g.setColor(UIManager.getColor("MenuItem.selectionBackground"));
                    g.fillRect(this.leftAreaWidth, 0, menuWidth, menuHeight);
                    this.paintLeftBackground(g, 1);
                    this.paintMiddleSeparator(g, 1);
                } else {
                    g.setColor(UIManager.getColor("MenuItem.background"));
                    g.fillRect(this.leftAreaWidth, 0, menuWidth, menuHeight);
                    this.paintLeftBackground(g, 0);
                    this.paintMiddleSeparator(g, 0);
                }
            } else {
                g.setColor(UIManager.getColor("MenuItem.disabledBackground"));
                g.fillRect(this.leftAreaWidth, 0, menuWidth, menuHeight);
                this.paintLeftBackground(g, 2);
                this.paintMiddleSeparator(g, 2);
            }
            g.setColor(oldColor);
        }
    }

    protected void paintLeftBackground(Graphics g, int state) {
        Rectangle rect = new Rectangle(0, 0, this.leftAreaWidth, this.menuItem.getHeight());
        switch (state) {
            case 1: {
                PaintUtil.drawShadow(g, 1.0f, 1.0f, UIManager.getColor("MenuItem.leftRollBgShadow"), this.leftAreaWidth, 1.0f, UIManager.getColor("MenuItem.leftRollBgDarkShadow"), rect, 0);
                break;
            }
            case 2: {
                PaintUtil.drawShadow(g, 1.0f, 1.0f, UIManager.getColor("MenuItem.leftDisableShadow"), this.leftAreaWidth, 1.0f, UIManager.getColor("MenuItem.leftDisableDarkShadow"), rect, 0);
                break;
            }
            default: {
                PaintUtil.drawShadow(g, 1.0f, 1.0f, UIManager.getColor("MenuItem.leftBgShadow"), this.leftAreaWidth, 1.0f, UIManager.getColor("MenuItem.leftBgDarkShadow"), rect, 0);
            }
        }
    }

    protected void paintMiddleSeparator(Graphics g, int state) {
        int h = this.menuItem.getHeight();
        switch (state) {
            case 1: {
                g.setColor(UIManager.getColor("MenuItem.separatorRollShadow"));
                g.drawLine(this.leftAreaWidth, 0, this.leftAreaWidth, h);
                g.setColor(UIManager.getColor("MenuItem.separatorRollDarkShadow"));
                g.drawLine(this.leftAreaWidth + 1, 0, this.leftAreaWidth + 1, h);
                break;
            }
            case 2: {
                g.setColor(UIManager.getColor("MenuItem.separatorDisableShadow"));
                g.drawLine(this.leftAreaWidth, 0, this.leftAreaWidth, h);
                g.setColor(UIManager.getColor("MenuItem.separatorDisableDarkShadow"));
                g.drawLine(this.leftAreaWidth + 1, 0, this.leftAreaWidth + 1, h);
                break;
            }
            default: {
                g.setColor(UIManager.getColor("MenuItem.separatorShadow"));
                g.drawLine(this.leftAreaWidth, 0, this.leftAreaWidth, h);
                g.setColor(UIManager.getColor("MenuItem.separatorDarkShadow"));
                g.drawLine(this.leftAreaWidth + 1, 0, this.leftAreaWidth + 1, h);
            }
        }
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        KingdeeMenuItemUI.viewRect.x += i.left;
        KingdeeMenuItemUI.viewRect.y += i.top;
        KingdeeMenuItemUI.viewRect.width -= i.right + KingdeeMenuItemUI.viewRect.x;
        KingdeeMenuItemUI.viewRect.height -= i.bottom + KingdeeMenuItemUI.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        this.paintBackground(g, b, background);
        Color holdc = g.getColor();
        if (checkIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (this.useCheckAndArrow()) {
                checkIcon.paintIcon(c, g, KingdeeMenuItemUI.checkIconRect.x, KingdeeMenuItemUI.checkIconRect.y);
            }
            g.setColor(holdc);
        }
        if (b.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = CtrlImageUtilities.createDisableIcon(b.getIcon());
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                KingdeeMenuItemUI.iconRect.x = (this.leftAreaWidth - KingdeeMenuItemUI.iconRect.width) / 2 + KingdeeMenuItemUI.viewRect.x - 1;
                icon.paintIcon(c, g, KingdeeMenuItemUI.iconRect.x, KingdeeMenuItemUI.iconRect.y);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent != null && parent instanceof JComponent) {
                JComponent p = (JComponent)parent;
                Integer maxValueInt = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
                int maxValue = maxValueInt != null ? maxValueInt : KingdeeMenuItemUI.acceleratorRect.width;
                accOffset = maxValue - KingdeeMenuItemUI.acceleratorRect.width;
            }
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g.setColor(this.disabledForeground);
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, KingdeeMenuItemUI.acceleratorRect.x - accOffset, KingdeeMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                } else {
                    g.setColor(UIManager.getColor("MenuItem.background").brighter());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, KingdeeMenuItemUI.acceleratorRect.x - accOffset, KingdeeMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                    g.setColor(UIManager.getColor("MenuItem.background").darker());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, KingdeeMenuItemUI.acceleratorRect.x - accOffset - 1, KingdeeMenuItemUI.acceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, KingdeeMenuItemUI.acceleratorRect.x - accOffset, KingdeeMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    private boolean useCheckAndArrow() {
        boolean b = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            b = false;
        }
        return b;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    private String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (KingdeeUtils.isLeftToRight(this.menuItem)) {
            textRect.x += menuItemGap;
            iconRect.x += menuItemGap;
            acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
            if (this.useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + menuItemGap;
                textRect.x += menuItemGap + checkIconRect.width;
                iconRect.x += menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
            }
        } else {
            textRect.x -= menuItemGap;
            iconRect.x -= menuItemGap;
            acceleratorRect.x = viewRect.x + arrowIconRect.width + menuItemGap;
            if (this.useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
        }
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (this.useCheckAndArrow()) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
        }
        return text;
    }
}

