/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.plaf.KingdeeIconFactory;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class KingdeeRadioButtonUI
extends BasicRadioButtonUI {
    private static KingdeeRadioButtonUI kdRadioButtonUI = new KingdeeRadioButtonUI();
    protected Color disabledTextColor = new Color(0x6E6E6E);
    protected EnterHandler listener;

    public static ComponentUI createUI(JComponent c) {
        return kdRadioButtonUI;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Font ft = b.getFont();
        if (ft != null) {
            b.setFont(ft.deriveFont(0));
        }
        b.setOpaque(false);
        this.listener = new EnterHandler();
        b.addKeyListener(this.listener);
        this.setTravelsalKeys(b);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.removeKeyListener(this.listener);
    }

    private void setTravelsalKeys(AbstractButton b) {
        CtrlSwingUtilities.addManagingFocusForwardTraversalKeys(b, KeyStroke.getKeyStroke(39, 0));
        CtrlSwingUtilities.addManagingFocusBackwardTraversalKeys(b, KeyStroke.getKeyStroke(37, 0));
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension size = c.getSize();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = c.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Icon altIcon = b.getIcon();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : super.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        if (altIcon != null) {
            altIcon.paintIcon(c, g, iconRect.x, iconRect.y);
        } else {
            KingdeeIconFactory.getCheckBoxIcon().paintIcon(c, g, iconRect.x, iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                int mnemIndex = b.getDisplayedMnemonicIndex();
                if (model.isEnabled()) {
                    g.setColor(b.getForeground());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                } else {
                    g.setColor(this.getDisabledTextColor());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                }
                if (b.hasFocus() && b.isFocusPainted() && textRect.width > 0 && textRect.height > 0) {
                    this.paintFocus(g, textRect, size);
                }
            }
        }
    }

    @Override
    protected void paintFocus(Graphics g, Rectangle textRect, Dimension d) {
        int INSETS = 2;
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, textRect.x - 2, textRect.y, textRect.width + 4, textRect.height);
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return Color.GRAY;
    }

    protected static class EnterHandler
    implements KeyListener {
        protected EnterHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() != 10) {
                return;
            }
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            model.setArmed(true);
            model.setPressed(true);
            if (!b.hasFocus()) {
                b.requestFocus();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() != 10) {
                return;
            }
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            model.setPressed(false);
            model.setArmed(false);
        }
    }
}

