/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class Tile {
    public void paintTile(Graphics g, Component c, Point l, Dimension d) {
        this.paintTile(g, c, l.x, l.y, d.width, d.height);
    }

    public void paintTile(Graphics g, Component c, Rectangle bounds) {
        this.paintTile(g, c, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public abstract void paintTile(Graphics var1, Component var2, int var3, int var4, int var5, int var6);

    public abstract Dimension getSize();

    public static class NullTile
    extends Tile {
        private static Dimension size = new Dimension(0, 0);
        private static NullTile instance = null;

        @Override
        public void paintTile(Graphics g, Component c, int x, int y, int w, int h) {
        }

        @Override
        public Dimension getSize() {
            return size;
        }

        public static NullTile getInstance() {
            if (instance == null) {
                instance = new NullTile();
            }
            return instance;
        }
    }

    public static class ImageTile
    extends Tile {
        private Image image = null;
        private Color transColor = null;
        private int sizingMode;
        private float alpha;
        private boolean alphaEnabled;
        public static final int SIZING_HSTRETCH = 1;
        public static final int SIZING_VSTRETCH = 2;
        public static final int SIZING_STRETCH = 3;
        public static final int SIZING_VTILE = 4;
        public static final int SIZING_HTILE = 8;
        public static final int SIZING_TILE = 12;
        public static final int SIZING_VALIGNCENTRE = 16;
        public static final int SIZING_HALIGNCENTRE = 32;

        public ImageTile(Image image, Color transColor, float alpha, int sizingMode) {
            this.setImage(image);
            this.transColor = transColor;
            this.sizingMode = sizingMode;
            this.alpha = alpha;
            this.alphaEnabled = true;
        }

        public ImageTile(Image image, Color transColor, int sizingMode) {
            this.setImage(image);
            this.transColor = transColor;
            this.sizingMode = sizingMode;
            this.alphaEnabled = false;
        }

        public ImageTile(Image image, float alpha, int sizingMode) {
            this.setImage(image);
            this.alpha = alpha;
            this.alphaEnabled = true;
            this.sizingMode = sizingMode;
        }

        public ImageTile(Image image, int sizingMode) {
            this.setImage(image);
            this.alphaEnabled = false;
            this.sizingMode = sizingMode;
        }

        public ImageTile(Image image) {
            this(image, 48);
        }

        public float getAlpha() {
            return this.alpha;
        }

        public Color getTransColor() {
            return this.transColor;
        }

        public float getSizingMode() {
            return this.sizingMode;
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public Rectangle getBounds() {
            return new Rectangle(0, 0, this.image.getWidth(null), this.image.getHeight(null));
        }

        public boolean isAlphaEnabled() {
            return this.alphaEnabled;
        }

        @Override
        public Dimension getSize() {
            return this.getBounds().getSize();
        }

        @Override
        public void paintTile(Graphics g, Component c, int x, int y, int w, int h) {
            if ((this.sizingMode & 8) > 0) {
                g.drawImage(this.image, x, y, w, h, null);
                return;
            }
            if ((this.sizingMode & 4) > 0) {
                g.drawImage(this.image, x, y, w, h, null);
                return;
            }
            g.drawImage(this.image, x, y, null);
        }
    }

    public static class ColorTile
    extends Tile {
        public Color color;
        private static final Dimension SIZE = new Dimension(0, 0);

        @Override
        public void paintTile(Graphics g, Component c, int x, int y, int w, int h) {
            Color oldColor = g.getColor();
            g.setColor(this.color);
            g.fillRect(x, y, w, h);
            g.setColor(oldColor);
        }

        @Override
        public Dimension getSize() {
            return SIZE;
        }

        public ColorTile(Color color) {
            this.color = new Color(color.getRGB());
        }
    }

    public static class GradientTile
    extends Tile {
        public static final int VERTICAL = 1;
        public static final int HORIZONTAL = 2;
        private Color color1;
        private Color color2 = null;
        private int gradientMode = 1;
        private GradientPaint paint = null;

        public GradientTile(int gradientMode, Color color1, Color color2) {
            if (color1 == null || color2 == null) {
                return;
            }
            this.gradientMode = gradientMode;
            this.color1 = new Color(color1.getRGB());
            this.color2 = new Color(color2.getRGB());
        }

        @Override
        public void paintTile(Graphics g, Component c, int x, int y, int w, int h) {
            Graphics2D g2d = (Graphics2D)g;
            this.paint = this.gradientMode == 1 ? new GradientPaint(x, y, this.color1, x, y + h - 1, this.color2) : new GradientPaint(x, y, this.color1, x + w - 1, y, this.color2);
            Paint old = g2d.getPaint();
            g2d.setPaint(this.paint);
            try {
                g2d.fillRect(x, y, w, h);
            }
            catch (Exception exception) {
                // empty catch block
            }
            g2d.setPaint(old);
            this.paint = null;
        }

        @Override
        public Dimension getSize() {
            return new Dimension(0, 0);
        }
    }

    public static class ColorLineTile
    extends Tile {
        private Color[] colors = null;

        public ColorLineTile(String[] colors) {
            if (colors == null) {
                return;
            }
            this.colors = new Color[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                this.colors[i] = Color.decode(colors[i]);
            }
        }

        @Override
        public void paintTile(Graphics g, Component c, int x, int y, int w, int h) {
            int index = 0;
            int last = y + h;
            for (int i = y; i < last; ++i) {
                g.setColor(this.colors[index]);
                g.drawLine(x, i, x + w - 1, i);
                index = (index + 1) % this.colors.length;
            }
        }

        @Override
        public Dimension getSize() {
            return new Dimension(0, this.colors.length);
        }
    }

    public static class BoxTile
    extends Tile {
        public Tile leftTop = NullTile.getInstance();
        public Tile top = NullTile.getInstance();
        public Tile rightTop = NullTile.getInstance();
        public Tile left = NullTile.getInstance();
        public Tile centre = NullTile.getInstance();
        public Tile right = NullTile.getInstance();
        public Tile leftBottom = NullTile.getInstance();
        public Tile bottom = NullTile.getInstance();
        public Tile rightBottom = NullTile.getInstance();
        public Insets sizingMargin = new Insets(0, 0, 0, 0);

        @Override
        public void paintTile(Graphics g, Component c, int x, int y, int w, int h) {
            this.leftTop.paintTile(g, c, x, y, this.sizingMargin.left, this.sizingMargin.top);
            this.top.paintTile(g, c, x + this.sizingMargin.left, y, w - this.sizingMargin.left - this.sizingMargin.right, this.sizingMargin.top);
            this.rightTop.paintTile(g, c, x + (w - this.sizingMargin.right), y, this.sizingMargin.right, this.sizingMargin.top);
            this.left.paintTile(g, c, x, y + this.sizingMargin.top, this.sizingMargin.left, h - this.sizingMargin.top - this.sizingMargin.bottom);
            this.centre.paintTile(g, c, x + this.sizingMargin.left, y + this.sizingMargin.top, w - this.sizingMargin.left - this.sizingMargin.right, h - this.sizingMargin.top - this.sizingMargin.bottom);
            this.right.paintTile(g, c, x + (w - this.sizingMargin.right), y + this.sizingMargin.top, this.sizingMargin.right, h - this.sizingMargin.top - this.sizingMargin.bottom);
            this.leftBottom.paintTile(g, c, x, y + (h - this.sizingMargin.bottom), this.sizingMargin.left, this.sizingMargin.bottom);
            this.bottom.paintTile(g, c, x + this.sizingMargin.left, y + (h - this.sizingMargin.bottom), w - this.sizingMargin.left - this.sizingMargin.right, this.sizingMargin.bottom);
            this.rightBottom.paintTile(g, c, x + (w - this.sizingMargin.right), y + (h - this.sizingMargin.bottom), this.sizingMargin.right, this.sizingMargin.bottom);
        }

        @Override
        public Dimension getSize() {
            Insets margin = this.getMargin();
            Dimension result = new Dimension();
            result.width += margin.left + margin.right + this.centre.getSize().width;
            result.height += margin.top + margin.bottom + this.centre.getSize().height;
            return result;
        }

        public Insets getMargin() {
            return this.sizingMargin;
        }

        public Insets getDefaultMargin() {
            Insets result = new Insets(0, 0, 0, 0);
            result.top = this.top.getSize().height;
            result.bottom = this.bottom.getSize().height;
            result.left = this.left.getSize().width;
            result.right = this.right.getSize().width;
            return result;
        }
    }
}

