/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.tree;

import com.kingdee.bos.ctrl.common.util.FontUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.plaf.lfm.KDFontUIResource;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlImageUtilities;
import com.kingdee.bos.ctrl.swing.util.SwingLogUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellRenderer;

public class DefaultKingdeeTreeCellRenderer
extends JPanel
implements TreeCellRenderer,
LayoutManager {
    private static final long serialVersionUID = -6519115139566709234L;
    private KDTree tree;
    private boolean showCheckBox;
    protected boolean selected;
    protected boolean hasFocus;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected transient Icon useIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    protected boolean textBold;
    protected Color textColor;
    private DefaultKingdeeTreeNode node;
    protected int iconTextGap = 2;
    protected KDCheckBox box = new KDCheckBox("");
    protected KDLabel label;

    public DefaultKingdeeTreeCellRenderer() {
        this.box.setSwitch(false);
        this.label = new KDLabel("");
        this.label.setOpaque(true);
        this.label.setHorizontalAlignment(2);
        this.setLeafIcon(this.getDefaultLeafIcon());
        this.setClosedIcon(this.getDefaultClosedIcon());
        this.setOpenIcon(this.getDefaultOpenIcon());
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setFont(UIManager.getFont("Tree.font"));
        this.setLayout(this);
        this.add(this.box);
        this.add(this.label);
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        Icon tempIcon = UIManager.getIcon("Tree.closedIcon");
        if (tempIcon == null) {
            SwingLogUtil.error((String)"Warning: Tree.closedIcon is not perfect.");
            return CtrlImageUtilities.getCurrentDirectoryImageIcon(null, "./tree_folder_close.gif");
        }
        return tempIcon;
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public void setOpenIcon(Icon newIcon) {
        this.openIcon = newIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon newIcon) {
        this.closedIcon = newIcon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon newIcon) {
        this.leafIcon = newIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    @Override
    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    @Override
    public void setLayout(LayoutManager l) {
        super.setLayout(l);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jtree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = "";
        if (jtree instanceof KDTree) {
            this.tree = (KDTree)jtree;
            stringValue = this.tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            this.hasFocus = hasFocus;
            if (!jtree.isEnabled()) {
                this.setEnabled(false);
                if (leaf) {
                    this.setDisabledIcon(this.getLeafIcon());
                } else if (expanded) {
                    this.setDisabledIcon(this.getOpenIcon());
                } else {
                    this.setDisabledIcon(this.getClosedIcon());
                }
                this.box.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.box.setEnabled(true);
                if (leaf) {
                    this.setIcon(this.getLeafIcon());
                } else if (expanded) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            }
            this.setComponentOrientation(this.tree.getComponentOrientation());
            this.selected = selected;
        }
        try {
            Icon icon;
            this.node = (DefaultKingdeeTreeNode)value;
            this.showCheckBox = this.tree.isShowCheckBox() && this.node.isCheckBoxVisible();
            if (expanded) {
                icon = this.node.getCustomOpenIcon();
                if (icon != null) {
                    this.setIcon(icon);
                }
            } else if (!leaf && (icon = this.node.getCustomClosedIcon()) != null) {
                this.setIcon(icon);
            }
            Icon customIcon = this.node.getCustomIcon();
            if (customIcon != null) {
                this.setIcon(customIcon);
            }
            this.box.setSelected(this.node.getCheckedValue());
            this.setToolTipText(stringValue);
            this.setText(this.node.getText());
            this.setTextColor(this.node.getTextColor());
            if (selected) {
                this.setForeground(this.getTextSelectionColor());
            } else {
                this.setForeground(this.getTextColor());
            }
            this.setBackgroundNonSelectionColor(this.tree.getBackground());
            this.setTextBold(this.node.isTextBold());
            Font font = FontUtil.getDefaultFont();
            if (font != null) {
                this.setFont(font);
            } else {
                int fontStyle;
                font = this.getFont();
                String fontFamily = font.getFamily();
                int fontSize = font.getSize();
                int n = fontStyle = this.isTextBold() ? 1 : font.getStyle();
                if (font instanceof KDFontUIResource) {
                    this.setFont((Font)new KDFontUIResource(new Font(fontFamily, fontStyle, fontSize)));
                } else if (font instanceof FontUIResource) {
                    this.setFont(new FontUIResource(new Font(fontFamily, fontStyle, fontSize)));
                } else if (font instanceof KDFont) {
                    this.setFont(new KDFont(fontFamily, fontStyle, fontSize));
                } else {
                    this.setFont(new Font(fontFamily, fontStyle, fontSize));
                }
            }
        }
        catch (Exception e) {
            SwingLogUtil.error((String)("DefaultKingdeeTreeCellRenderer : " + e.getMessage()));
        }
        return this;
    }

    private void setText(String text) {
        this.label.setText(text);
    }

    private void setDisabledIcon(Icon icon) {
        this.useIcon = icon;
    }

    private void setIcon(Icon icon) {
        this.useIcon = icon;
    }

    protected Icon getIcon() {
        return this.useIcon;
    }

    private Icon getUseIcon() {
        if (this.useIcon == null) {
            return CtrlImageUtilities.getNotFoundIcon();
        }
        return this.useIcon;
    }

    @Override
    public void paint(Graphics g) {
        if (this.selected) {
            if (this.tree.hasFocus()) {
                this.label.setBackground(this.getBackgroundSelectionColor());
                this.label.setForeground(this.getTextSelectionColor());
            } else {
                Color tempColor = UIManager.getColor("Tree.selectionFocusLostBackground");
                if (tempColor == null) {
                    tempColor = Color.decode("#C9C8BB");
                }
                this.label.setBackground(tempColor);
                this.label.setForeground(this.getTextNonSelectionColor());
            }
        } else {
            this.label.setBackground(this.getBackgroundNonSelectionColor());
            this.label.setForeground(this.getTextColor());
        }
        super.paint(g);
        if (this.getUseIcon() != null) {
            int y = (this.tree.getRowHeight() - this.getUseIcon().getIconHeight()) / 2;
            this.getUseIcon().paintIcon(this, g, 0, y);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension retDimension = this.label.getPreferredSize();
        int iconWidth = 0;
        if (this.getUseIcon() != null) {
            iconWidth = this.getUseIcon().getIconWidth();
        }
        int height = this.tree.getRowHeight();
        int width = iconWidth + this.getIconTextGap() + retDimension.width + 4;
        retDimension = this.showCheckBox ? new Dimension(width + 18, height) : new Dimension(width, height);
        return retDimension;
    }

    @Override
    public void addLayoutComponent(String name, Component child) {
    }

    @Override
    public void removeLayoutComponent(Component child) {
    }

    @Override
    public Dimension preferredLayoutSize(Container Container2) {
        return this.getPreferredSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container Container2) {
        return this.getMinimumSize();
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension sbSize = container.getSize();
        Component checkBox = container.getComponent(0);
        JLabel label = (JLabel)container.getComponent(1);
        int x = 0;
        if (this.getUseIcon() != null) {
            x = this.getUseIcon().getIconWidth();
        }
        if (this.showCheckBox && checkBox != null) {
            checkBox.setVisible(true);
            int y = (this.tree.getRowHeight() - 18) / 2;
            checkBox.setBounds(x, y, 18, 18);
            label.setBounds(x += 18 + this.getIconTextGap(), 0, sbSize.width - x, sbSize.height);
        } else {
            if (checkBox != null) {
                checkBox.setVisible(false);
            }
            label.setBounds(x += this.getIconTextGap(), 0, sbSize.width - x, sbSize.height);
        }
    }

    public boolean isTextBold() {
        return this.textBold;
    }

    public void setTextBold(boolean b) {
        this.textBold = b;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int i) {
        this.iconTextGap = i;
    }
}

