/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.workbench.persist;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.workbench.persist.IIOProvider;
import com.kingdee.bos.ctrl.workbench.persist.TrimWidgetDescriptor;
import com.kingdee.bos.ctrl.workbench.persist.Trinity;
import com.kingdee.bos.ctrl.workbench.ui.ITrimWidget;
import com.kingdee.bos.ctrl.workbench.ui.Perspective;
import com.kingdee.bos.ctrl.workbench.ui.TrimWidgetViewport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FilenameUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class TrimDatabase
extends HashMap {
    public static final String KEY_TITLE = "title";
    public static final String KEY_MSG = "msg1";
    public static final String KEY_GENERAL = "general";
    public static final String KEY_OK = "ok";
    public static final String KEY_CANCEL = "cancel";
    public static final String KEY_VIEW_MANAGE = "viewManage";
    private static final boolean DEBUG = false;
    public static final String VERSION = "1.0.0";
    public static String CONFIG_DIR = System.getProperty("user.dir");
    private static IIOProvider ioProvider;
    private static HashMap descriptors;
    private static boolean parsed;

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, TrimDatabase.class, (String)defaultStr);
    }

    public static void setIOProvider(IIOProvider ioProvider) {
        TrimDatabase.ioProvider = ioProvider;
        TrimDatabase.parseXmlToDescriptors();
    }

    public static IIOProvider getIOProvider() {
        return ioProvider;
    }

    public static void registerTrimWidget(ITrimWidget trim) {
        if (trim != null) {
            descriptors.put(trim.getId(), new TrimWidgetDescriptor(trim));
        }
    }

    public static ITrimWidget createTrimWidget(String id) {
        TrimWidgetDescriptor desc;
        if (!parsed) {
            TrimDatabase.parseXmlToDescriptors();
            parsed = true;
        }
        if ((desc = (TrimWidgetDescriptor)descriptors.get(id)) == null) {
            return null;
        }
        return desc.toTrimWidget();
    }

    public static void persist() {
        long t1 = System.currentTimeMillis();
        Document doc = new Document();
        Element root = new Element("workspace");
        root.setAttribute("version", VERSION);
        doc.setRootElement(root);
        Iterator it = descriptors.values().iterator();
        while (it.hasNext()) {
            root.addContent((Content)((TrimWidgetDescriptor)it.next()).toXmlElement());
        }
        OutputStream os = null;
        try {
            os = ioProvider != null ? ioProvider.getPersistenceOutputStream() : new FileOutputStream(new File(FilenameUtils.normalize((String)(CONFIG_DIR + File.separator + "workbench.xml"))));
            new XMLOutputter().output(doc, os);
        }
        catch (Exception e) {
            try {
                throw new IllegalArgumentException("unable to persist the workbench config file");
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{os});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseXmlToDescriptors() {
        InputStream is;
        block10: {
            is = null;
            if (ioProvider != null) {
                is = ioProvider.getPersistenceInputStream();
                break block10;
            }
            String filepath = FilenameUtils.normalize((String)(CONFIG_DIR + File.separator + "workbench.xml"));
            File file = new File(filepath);
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                CloseUtil.close((Closeable[])new Closeable[]{is});
                return;
            }
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            try {
                SAXParser saxParser = factory.newSAXParser();
                long t1 = System.currentTimeMillis();
                saxParser.parse(is, (DefaultHandler)new WorkbenchSAXHandler());
            }
            catch (Exception e) {
                descriptors.clear();
                MessageDialog.show(null, (Object)TrimDatabase.getLocalText(KEY_MSG, "\u5de5\u4f5c\u53f0\u5c06\u88ab\u91cd\u7f6e\uff0c\u6240\u6709\u89c6\u56fe\u7684\u4e2a\u6027\u5316\u914d\u7f6e\u5931\u6548\n\u539f\u56e0\u53ef\u80fd\u4e3a\uff1a\n1.\u5de5\u4f5c\u53f0\u914d\u7f6e\u6570\u636e\u88ab\u635f\u574f\n2.\u670d\u52a1\u5668\u53d1\u5e03\u5f3a\u5236\u6027\u7248\u672c\u66f4\u65b0"), (String)TrimDatabase.getLocalText(KEY_TITLE, "\u5de5\u4f5c\u53f0\u6d88\u606f"), (int)-1);
            }
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e1) {
            try {
                e1.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{is});
        }
        CloseUtil.close((Closeable[])new Closeable[]{is});
    }

    private static TreeModel getSortedTrimTreeModel(Perspective perspective) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        HashMap trims = perspective.getTrims();
        if (trims == null) {
            return new KingdeeTreeModel((TreeNode)root);
        }
        for (ITrimWidget trim : trims.values()) {
            TrimWidgetDescriptor twd = (TrimWidgetDescriptor)descriptors.get(trim.getId());
            String category = twd.getCategory();
            boolean inserted = false;
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (!category.equals(node.getUserObject())) continue;
                node.add((MutableTreeNode)((Object)new TrimNodeItem(twd.getId(), twd.getTitle(), twd.getIconURL())));
                inserted = true;
                break;
            }
            if (inserted) continue;
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)category);
            node.add((MutableTreeNode)((Object)new TrimNodeItem(twd.getId(), twd.getTitle(), twd.getIconURL())));
            root.add((MutableTreeNode)node);
        }
        return new KingdeeTreeModel((TreeNode)root);
    }

    public static void showTrimList(Perspective perspective) {
        Window w = SwingUtilities.getWindowAncestor(perspective);
        TrimWidgetListDialog trimListDialog = null;
        trimListDialog = w instanceof Frame ? new TrimWidgetListDialog((Frame)w, perspective) : new TrimWidgetListDialog((Dialog)w, perspective);
        trimListDialog.configTreeModel(TrimDatabase.getSortedTrimTreeModel(perspective));
        trimListDialog.setLocationRelativeTo(perspective);
        trimListDialog.setVisible(true);
    }

    static {
        descriptors = new HashMap();
    }

    private static class TrimWidgetListDialog
    extends JDialog {
        private KDTree sortedTrimTree = new KDTree();
        private JButton submit = new JButton(TrimDatabase.getLocalText("ok", "\u786e\u5b9a"));
        private JButton cancel = new JButton(TrimDatabase.getLocalText("cancel", "\u53d6\u6d88"));
        private Perspective perspective;
        private Icon leafIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(TrimWidgetViewport.class.getResource("default_symbol.gif")));

        TrimWidgetListDialog(Frame w, Perspective perspective) {
            super(w, true);
            this.perspective = perspective;
            this.initUI();
            this.initListeners();
        }

        TrimWidgetListDialog(Dialog w, Perspective perspective) {
            super(w, true);
            this.perspective = perspective;
            this.initUI();
            this.initListeners();
        }

        private void initUI() {
            this.setTitle(TrimDatabase.getLocalText(TrimDatabase.KEY_VIEW_MANAGE, "\u89c6\u56fe\u7ba1\u7406"));
            this.setSize(248, 400);
            this.setResizable(false);
            this.sortedTrimTree.setRootVisible(false);
            KDTreeView treeView = new KDTreeView(this.sortedTrimTree);
            treeView.setShowButton(false);
            Container c = this.getContentPane();
            c.setLayout(null);
            c.add((Component)treeView);
            c.add(this.submit);
            c.add(this.cancel);
            treeView.setBounds(5, 5, 230, 340);
            DefaultTreeCellRenderer render = new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    URL iconURL;
                    super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    if (value instanceof TrimNodeItem && (iconURL = ((TrimNodeItem)((Object)value)).getIconURL()) != null) {
                        this.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(iconURL)));
                    }
                    return this;
                }
            };
            render.setLeafIcon(this.leafIcon);
            this.sortedTrimTree.setCellRenderer((TreeCellRenderer)render);
            this.submit.setBounds(65, 350, 80, 20);
            this.submit.setEnabled(false);
            this.cancel.setBounds(155, 350, 80, 20);
            this.sortedTrimTree.requestFocusInWindow();
        }

        private void initListeners() {
            this.sortedTrimTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath tp = e.getNewLeadSelectionPath();
                    if ("root".equals(((DefaultMutableTreeNode)((TreeNode)tp.getLastPathComponent()).getParent()).getUserObject())) {
                        submit.setEnabled(false);
                    } else {
                        submit.setEnabled(true);
                    }
                }
            });
            this.sortedTrimTree.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        submit.doClick();
                    }
                }
            });
            this.submit.addActionListener(new ActionListener(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    String trimId = ((TrimNodeItem)((Object)sortedTrimTree.getSelectionPath().getLastPathComponent())).getId();
                    ITrimWidget trim = perspective.getTrimWidget(trimId);
                    if (trim != null) {
                        if (((Component)((Object)trim)).isDisplayable()) {
                            this.setVisible(false);
                            this.dispose();
                            return;
                        }
                        perspective.getTrimWidgetManager().addTrim(trim);
                    } else {
                        perspective.getTrimWidgetManager().addTrim(TrimDatabase.createTrimWidget(trimId));
                    }
                    perspective.revalidate();
                    perspective.repaint();
                    perspective.persistToCache();
                    this.setVisible(false);
                    this.dispose();
                }
            });
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                    this.dispose();
                }
            });
        }

        void configTreeModel(TreeModel treemodel) {
            this.sortedTrimTree.setModel(treemodel);
            TreePath treepath = new TreePath(new Object[]{treemodel.getRoot(), ((TreeNode)treemodel.getRoot()).getChildAt(0)});
            this.sortedTrimTree.setSelectionPath(treepath);
            this.sortedTrimTree.expandPath(treepath);
        }
    }

    private static class TrimNodeItem
    extends DefaultKingdeeTreeNode {
        private String id;
        private String title;
        private URL iconURL;

        TrimNodeItem(String id, String title, URL iconURL) {
            super((Object)title);
            this.id = id;
            this.title = title;
            this.iconURL = iconURL;
        }

        String getId() {
            return this.id;
        }

        String getTitle() {
            return this.title;
        }

        URL getIconURL() {
            return this.iconURL;
        }
    }

    static class WorkbenchSAXHandler
    extends DefaultHandler {
        private TrimWidgetDescriptor trimDescriptor;
        private int cursor = 0;
        private int type;
        private String key;
        private String value;
        private String content;

        WorkbenchSAXHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            if ("workspace".equals(qName)) {
                String version = attrs.getValue("version");
                if (!TrimDatabase.VERSION.equals(version)) {
                    throw new SAXException("workbench's persistent file isn't a current version.");
                }
            } else if ("trim".equals(qName)) {
                String id = attrs.getValue("id");
                this.trimDescriptor = new TrimWidgetDescriptor(id, attrs.getValue("clsName"));
                descriptors.put(id, this.trimDescriptor);
            } else if ("type".equals(qName)) {
                this.cursor = 1;
            } else if ("key".equals(qName)) {
                this.cursor = 2;
            } else if ("value".equals(qName)) {
                this.cursor = 3;
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            if ("trinity".equals(qName)) {
                this.trimDescriptor.addTrinity(new Trinity(this.type, this.key, this.value));
            }
            this.content = null;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.content = this.content == null ? new String(ch, start, length) : this.content + new String(ch, start, length);
            switch (this.cursor) {
                case 1: {
                    this.type = new Integer(this.content);
                    break;
                }
                case 2: {
                    this.key = this.content;
                    break;
                }
                case 3: {
                    this.value = this.content;
                    break;
                }
            }
        }
    }
}

