/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.IBatchExecuteResult;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BatchActionResults
implements Serializable,
Cloneable,
IBatchExecuteResult {
    private static final long serialVersionUID = -4259484175635469607L;
    protected HashMap resultMap;
    private static final ActionResult SUCCESS = new ActionResult(ActionResultEnum.SUCCESS, "");
    private static final String STRING_TYPE = "STRING";
    private static final String PK_TYPE = "PK";
    private static final String VO_TYPE = "OBJECTVALUE";
    private String idType = "STRING";
    private transient List idIndex;
    private transient IObjectCollection objCollection = null;
    private transient List addedSelector;
    private ResponseContext response;
    public static final String NEWID = "NEWID";
    private boolean isNewId = false;
    private transient BatchExecuteParamsEntry[] paramEntries;
    private int errorCount = 0;
    private int ignoreErrorCount = 0;
    private HashSet ignoreCheckItems;
    private transient Map transformResults;
    transient EASBizException bizException;
    transient BizController caller;

    public BizController getCaller() {
        return this.caller;
    }

    public BatchActionResults(String idType) {
        this.idType = idType;
        this.idIndex = new ArrayList();
        this.resultMap = new HashMap();
        this.ignoreCheckItems = new HashSet();
    }

    public BatchActionResults(String idType, boolean isNewId) {
        this(idType);
        this.isNewId = isNewId;
    }

    public BatchActionResults() {
        this.idIndex = new ArrayList();
        this.resultMap = new HashMap();
        this.ignoreCheckItems = new HashSet();
    }

    public static BatchActionResults populateActionResults(BatchExecuteParamsEntry[] entries) {
        BatchActionResults results = null;
        if (entries != null && entries.length > 0) {
            String idType = BatchActionResults.getIdType(entries[0].get(0));
            results = new BatchActionResults(idType);
            if (idType.equals(PK_TYPE)) {
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    results.addSuccess((IObjectPK)entries[i].get(0));
                }
            } else if (idType.equals(STRING_TYPE)) {
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    results.addSuccess((String)entries[i].get(0));
                }
            } else if (idType.equals(VO_TYPE)) {
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    IObjectValue objValue = (IObjectValue)entries[i].get(0);
                    BatchActionResults.addAObjValue(results, idType, objValue);
                }
            }
            results.setParamEntries(entries);
        } else {
            results = new BatchActionResults();
        }
        return results;
    }

    public static BatchActionResults populateActionResults(IObjectCollection objCollection) {
        String idType = VO_TYPE;
        BatchActionResults results = new BatchActionResults(idType);
        if (objCollection == null) {
            return results;
        }
        for (IObjectValue objValue : objCollection) {
            BatchActionResults.addAObjValue(results, idType, objValue);
        }
        return results;
    }

    private static void addAObjValue(BatchActionResults results, String idType, IObjectValue objValue) {
        Object pk = objValue.get(objValue.getPKField());
        if (pk == null) {
            results.isNewId = true;
            results.addSuccess(NEWID);
        } else {
            results.addSuccess(pk.toString());
        }
    }

    public static BatchActionResults populateActionResults(BatchExecuteParamsEntry[] entries, BizController caller) {
        BatchActionResults results = BatchActionResults.populateActionResults(entries);
        results.caller = caller;
        return results;
    }

    public static BatchActionResults populateActionResults(Context ctx, BatchExecuteParamsEntry[] entries) {
        String idType;
        BatchActionResults results = BatchActionResults.populateActionResults(entries);
        if (ctx != null && entries != null && entries.length > 0 && results.paramEntries != null && (idType = BatchActionResults.getIdType(entries[0].get(0))).equals(VO_TYPE)) {
            try {
                IObjectValue objValue = (IObjectValue)entries[0].get(0);
                IObjectCollection collection = BatchActionUtil.getCollectionInstance(ctx, objValue.getBOSType());
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    objValue = (IObjectValue)entries[i].get(0);
                    collection.addObject(objValue);
                }
                results.objCollection = collection;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public static BatchActionResults populateActionResults(Context ctx, Object[] entries) {
        BatchActionResults results = BatchActionResults.populateActionResults(entries);
        if (ctx != null && entries != null && entries.length > 0) {
            String idType = BatchActionResults.getIdType(entries[0]);
            if (!idType.equals(VO_TYPE)) {
                return results;
            }
            try {
                IObjectValue objValue = (IObjectValue)entries[0];
                IObjectCollection collection = BatchActionUtil.getCollectionInstance(ctx, objValue.getBOSType());
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    objValue = (IObjectValue)entries[i];
                    collection.addObject(objValue);
                }
                results.objCollection = collection;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    private static String getIdType(Object o) {
        if (o instanceof IObjectPK) {
            return PK_TYPE;
        }
        if (o instanceof String) {
            return STRING_TYPE;
        }
        if (o instanceof IObjectValue) {
            return VO_TYPE;
        }
        throw new IllegalArgumentException("The ID parameter should be IObjectPK or String type.");
    }

    public static BatchActionResults populateActionResults(Object[] entries) {
        BatchActionResults results;
        block4: {
            String idType;
            block6: {
                block5: {
                    results = null;
                    if (entries == null || entries.length == 0) {
                        return new BatchActionResults();
                    }
                    if (entries == null || entries.length <= 0) break block4;
                    idType = BatchActionResults.getIdType(entries[0]);
                    results = new BatchActionResults(idType);
                    if (!idType.equals(PK_TYPE)) break block5;
                    int size = entries.length;
                    for (int i = 0; i < size; ++i) {
                        results.addSuccess((IObjectPK)entries[i]);
                    }
                    break block4;
                }
                if (!idType.equals(STRING_TYPE)) break block6;
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    results.addSuccess((String)entries[i]);
                }
                break block4;
            }
            if (!idType.equals(VO_TYPE)) break block4;
            int size = entries.length;
            for (int i = 0; i < size; ++i) {
                IObjectValue objValue = (IObjectValue)entries[i];
                BatchActionResults.addAObjValue(results, idType, objValue);
            }
        }
        return results;
    }

    public static BatchActionResults populateActionResults(Object[] entries, BizController caller) {
        BatchActionResults results = BatchActionResults.populateActionResults(entries);
        if (results != null) {
            results.caller = caller;
        }
        return results;
    }

    public void add(String id, ActionResultEnum actionResult, String message) {
        if (actionResult.equals(ActionResultEnum.ERROR)) {
            this.addError(id, message);
        } else {
            this.addSuccess(id);
        }
    }

    private void addIndex(Object id) {
        if (!this.resultMap.containsKey(id)) {
            this.idIndex.add(id);
        }
    }

    public void addSuccess(String id) {
        this.addIndex(id);
        this.resultMap.put(id, SUCCESS);
    }

    public void replaceNewId(String id) {
        Object result = this.resultMap.get(NEWID);
        if (result != null) {
            this.resultMap.put(id, result);
            this.resultMap.remove(NEWID);
        }
    }

    public void addSuccess(IObjectPK id) {
        this.addIndex(id);
        this.resultMap.put(id, SUCCESS);
    }

    public void addError(String id, String message) {
        Object key = this.getAppropriateKey(id);
        ActionResult result = (ActionResult)this.resultMap.get(key);
        this.putError(result, key, message);
        ++this.errorCount;
    }

    public void addError(String id, String message, String ignoreCheckItemId) {
        this.addError(id, message);
        if (ignoreCheckItemId != null && !this.ignoreCheckItems.contains(ignoreCheckItemId)) {
            this.ignoreCheckItems.add(ignoreCheckItemId);
            ++this.ignoreErrorCount;
        }
    }

    private void putError(ActionResult result, Object key, String message) {
        if (result != null && ActionResultEnum.ERROR.equals(result.getResult())) {
            String msgExist = result.getMessage();
            if (!result.isHasMultiErrors() && result.getException() != null) {
                msgExist = result.getException().getMessage();
            }
            if (msgExist != null) {
                StringBuffer sb = new StringBuffer();
                if (!result.isHasMultiErrors()) {
                    sb.append("[");
                }
                sb.append(msgExist);
                if (!result.isHasMultiErrors()) {
                    sb.append("]");
                }
                sb.append("[");
                sb.append(message);
                sb.append("]");
                result.setMessage(sb.toString());
                result.setHasMultiErrors(true);
            }
        } else {
            this.resultMap.put(key, new ActionResult(ActionResultEnum.ERROR, message));
        }
    }

    private Object getAppropriateKey(Object id) {
        Object pk = id instanceof String ? (this.idType.equals(STRING_TYPE) || this.idType.equals(VO_TYPE) ? id : new ObjectUuidPK(BOSUuid.read((String)((String)id)))) : (this.idType.equals(STRING_TYPE) || this.idType.equals(VO_TYPE) ? ((IObjectPK)id).toString() : id);
        return pk;
    }

    public void addError(String id, Exception exception) {
        Object key = this.getAppropriateKey(id);
        ActionResult result = (ActionResult)this.resultMap.get(key);
        if (result != null && result.isHasMultiErrors()) {
            this.putError(result, key, exception.getMessage());
            result.addException(exception);
        } else {
            this.resultMap.put(this.getAppropriateKey(id), new ActionResult(ActionResultEnum.ERROR, exception));
        }
        ++this.errorCount;
    }

    public void addError(String id, Exception exception, String ignoreCheckItemId) {
        this.addError(id, exception);
        if (ignoreCheckItemId != null && !this.ignoreCheckItems.contains(ignoreCheckItemId)) {
            this.ignoreCheckItems.add(ignoreCheckItemId);
            ++this.ignoreErrorCount;
        }
    }

    public void addErrors(List idList, String message) {
        if (idList == null || idList.size() <= 0) {
            return;
        }
        ActionResult errorResult = new ActionResult(ActionResultEnum.ERROR, message);
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            this.resultMap.put(this.getAppropriateKey(idList.get(i)), errorResult);
        }
    }

    public ActionResult getActionResult(Object id) {
        if (id == null) {
            return SUCCESS;
        }
        if (this.isNewId) {
            return (ActionResult)this.resultMap.get(NEWID);
        }
        if (id instanceof String) {
            if (this.idType.equals(STRING_TYPE) || this.idType.equals(VO_TYPE)) {
                return (ActionResult)this.resultMap.get(id);
            }
            if (this.idType.equals(PK_TYPE)) {
                for (Map.Entry entry : this.resultMap.entrySet()) {
                    IObjectPK pk = (IObjectPK)entry.getKey();
                    if (!pk.toString().equals(id)) continue;
                    return (ActionResult)entry.getValue();
                }
            }
        } else {
            if (this.idType.equals(STRING_TYPE) || this.idType.equals(VO_TYPE)) {
                return (ActionResult)this.resultMap.get(((IObjectPK)id).toString());
            }
            if (this.idType.equals(PK_TYPE)) {
                return (ActionResult)this.resultMap.get(id);
            }
        }
        return SUCCESS;
    }

    private boolean containsKey(Object id) {
        boolean result = false;
        if (id == null) {
            return false;
        }
        if (id instanceof String) {
            if (this.idType.equals(STRING_TYPE)) {
                return this.resultMap.containsKey(id);
            }
            for (IObjectPK pk : this.resultMap.keySet()) {
                result = pk.toString().equals(id);
                if (!result) continue;
                return true;
            }
        } else {
            if (this.idType.equals(STRING_TYPE)) {
                return this.resultMap.containsKey(((IObjectPK)id).toString());
            }
            return this.resultMap.containsKey(id);
        }
        return result;
    }

    public ActionResult getActionResult(IObjectPK id) {
        if (this.isNewId) {
            return (ActionResult)this.resultMap.get(NEWID);
        }
        Object key = this.idType.equals(PK_TYPE) ? id : id.toString();
        if (this.containsKey(key)) {
            return (ActionResult)this.resultMap.get(key);
        }
        return SUCCESS;
    }

    public BatchActionResults getToDoResults() {
        BatchActionResults todo = null;
        try {
            todo = (BatchActionResults)this.clone();
            Iterator iter = todo.resultMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ActionResult result = (ActionResult)entry.getValue();
                if (!result.getResult().equals(ActionResultEnum.ERROR)) continue;
                iter.remove();
                if (todo.objCollection == null || entry.getKey().equals(NEWID)) continue;
                BOSUuid key = BOSUuid.read((String)entry.getKey().toString());
                todo.objCollection.removeObject((Object)key);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return todo;
    }

    public Object clone() throws CloneNotSupportedException {
        BatchActionResults results = (BatchActionResults)super.clone();
        results.resultMap = (HashMap)this.resultMap.clone();
        results.objCollection = this.objCollection;
        return results;
    }

    public void mergeResults(BatchActionResults actionResults) {
        for (Map.Entry entry : actionResults.resultMap.entrySet()) {
            Object id = entry.getKey();
            ActionResult result = (ActionResult)entry.getValue();
            ActionResult oldResult = (ActionResult)this.resultMap.get(id);
            if (oldResult != null && oldResult.getResult().equals(ActionResultEnum.ERROR) && result.getResult().equals(ActionResultEnum.ERROR)) {
                oldResult.setMessage(new StringBuffer().append("[").append(oldResult.getMessage()).append("]").append(" [").append(result.getMessage()).append("]").toString());
                continue;
            }
            this.resultMap.put(id, result);
            if (ActionResultEnum.ERROR.equals(result.getResult()) || !this.resultMap.containsKey(NEWID) || id.equals(NEWID)) continue;
            this.resultMap.remove(NEWID);
        }
        this.objCollection = actionResults.objCollection;
        if (actionResults.response != null) {
            if (this.response == null) {
                this.response = actionResults.response;
            } else {
                this.response.putAll(actionResults.response.getResponse());
            }
        }
    }

    public String[] getToDoIdsArray() {
        String[] results;
        List list = this.getToDoIdsList();
        if (list != null && list.size() > 0) {
            int size = list.size();
            results = new String[size];
            if (list.get(0) instanceof String) {
                list.toArray(results);
            } else {
                for (int i = 0; i < size; ++i) {
                    results[i] = list.get(i).toString();
                }
            }
        } else {
            results = new String[]{};
        }
        return results;
    }

    public List getToDoIdsList() {
        Iterator iter = this.resultMap.entrySet().iterator();
        ArrayList todoList = new ArrayList();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ActionResult result = (ActionResult)entry.getValue();
            if (result.getResult().equals(ActionResultEnum.ERROR)) continue;
            todoList.add(entry.getKey());
        }
        return todoList;
    }

    public Set getToDoIdsSet() {
        Iterator iter = this.resultMap.entrySet().iterator();
        HashSet todoSet = new HashSet();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ActionResult result = (ActionResult)entry.getValue();
            if (result.getResult().equals(ActionResultEnum.ERROR)) continue;
            todoSet.add(entry.getKey());
        }
        return todoSet;
    }

    public IObjectPK[] getToDoPkArray() {
        IObjectPK[] results;
        List list = this.getToDoIdsList();
        if (list != null && list.size() > 0) {
            results = new IObjectPK[list.size()];
            if (list.get(0) instanceof IObjectPK) {
                System.arraycopy(list.toArray(), 0, results, 0, list.size());
            } else {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    String id = (String)list.get(i);
                    if (NEWID.equals(list.get(i))) continue;
                    results[i] = new ObjectUuidPK(BOSUuid.read((String)id));
                }
            }
        } else {
            results = new IObjectPK[]{};
        }
        return results;
    }

    public void throwExceptions() throws BOSException, EASBizException {
        for (Map.Entry entry : this.resultMap.entrySet()) {
            ActionResult result = (ActionResult)entry.getValue();
            if (!ActionResultEnum.ERROR.equals(result.getResult())) continue;
            Exception exp = result.getException();
            if (exp != null) {
                if (exp instanceof BOSException) {
                    throw (BOSException)((Object)exp);
                }
                if (exp instanceof EASBizException) {
                    throw (EASBizException)exp;
                }
                throw new BOSException((Throwable)exp);
            }
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(result.getMessage());
            throw bizExp;
        }
    }

    public boolean exceptionOccured(int index) {
        if (index >= this.idIndex.size()) {
            throw new IndexOutOfBoundsException("The index is out of the idIndex size.");
        }
        ActionResult result = (ActionResult)this.resultMap.get(this.idIndex.get(index));
        return result != null && ActionResultEnum.ERROR.equals(result.getResult());
    }

    public IObjectCollection getObjCollection() {
        return this.objCollection;
    }

    public void setObjCollection(IObjectCollection objCollection) {
        this.objCollection = objCollection;
    }

    public List getAddedSelector() {
        return this.addedSelector;
    }

    public void setAddedSelector(List addedSelector) {
        this.addedSelector = addedSelector;
    }

    public boolean hasToDos() {
        for (Map.Entry entry : this.resultMap.entrySet()) {
            ActionResult result = (ActionResult)entry.getValue();
            if (result.getResult().equals(ActionResultEnum.ERROR)) continue;
            return true;
        }
        return false;
    }

    public ResponseContext getResponse() {
        return this.response;
    }

    public void setResponse(ResponseContext response) {
        this.response = response;
    }

    public BatchExecuteParamsEntry[] getParamEntries() {
        return this.paramEntries;
    }

    public Object getParamEntryValue(Object id, int index) {
        if (id == null) {
            return null;
        }
        int idx = -1;
        int cnt = 0;
        Iterator iter = this.idIndex.iterator();
        while (iter.hasNext()) {
            if (id.toString().equals(iter.next().toString())) {
                idx = cnt;
                break;
            }
            ++cnt;
        }
        if (idx < 0 || idx >= this.paramEntries.length) {
            return null;
        }
        return this.paramEntries[idx].get(index);
    }

    public void setParamEntries(BatchExecuteParamsEntry[] paramEntries) {
        this.paramEntries = paramEntries;
    }

    public boolean isCanIgnore() {
        return this.ignoreErrorCount > 0 && this.ignoreErrorCount == this.errorCount;
    }

    public HashSet getIgnoreCheckItems() {
        return this.ignoreCheckItems;
    }

    public BTPTransformResult getTransformResult(String id) {
        if (this.transformResults == null || id == null) {
            return null;
        }
        return (BTPTransformResult)this.transformResults.get(id);
    }

    public void addTransformResult(String id, BTPTransformResult transformResult) {
        if (this.transformResults == null) {
            this.transformResults = new HashMap();
        }
        this.transformResults.put(id, transformResult);
    }

    public int transformResultSize() {
        if (this.transformResults == null) {
            return 0;
        }
        return this.transformResults.size();
    }

    public boolean isError(IObjectPK id) {
        ActionResult actionResult = this.getActionResult(id);
        if (actionResult == null) {
            return true;
        }
        return ActionResultEnum.ERROR.equals(actionResult.getResult());
    }

    public boolean isToDo(String id) {
        ActionResult actionResult = this.getActionResult(id);
        if (actionResult == null) {
            return false;
        }
        return !ActionResultEnum.ERROR.equals(actionResult.getResult());
    }

    public boolean hasException(EASBizException exception) {
        boolean result = ActionResult.equalSubCode(this.bizException, exception);
        if (result) {
            return result;
        }
        for (Map.Entry entry : this.resultMap.entrySet()) {
            ActionResult aresult = (ActionResult)entry.getValue();
            if (!aresult.hasException(exception)) continue;
            return true;
        }
        return false;
    }

    public void setBizException(EASBizException bizException) {
        this.bizException = bizException;
    }

    public String[] getAllIDs() {
        Iterator iter = this.resultMap.keySet().iterator();
        ArrayList<String> idList = new ArrayList<String>();
        while (iter.hasNext()) {
            Object id = iter.next();
            idList.add(id.toString());
        }
        return idList.toArray(new String[0]);
    }

    public int size() {
        return this.resultMap.size();
    }

    public BatchActionResults[] splitActionResults(Context ctx, BatchActionResults batchResults) throws BOSException {
        BatchActionResults todoResults = batchResults.getToDoResults();
        BatchActionResults[] results = new BatchActionResults[todoResults.size()];
        List idList = todoResults.getToDoIdsList();
        HashMap<Object, IObjectValue> colMap = new HashMap<Object, IObjectValue>();
        if (this.objCollection != null) {
            for (IObjectValue objValue : this.objCollection) {
                Object id = objValue.get(objValue.getPKField());
                if (id != null) {
                    colMap.put(id, objValue);
                    continue;
                }
                colMap.put(NEWID, objValue);
            }
        }
        try {
            for (int i = 0; i < results.length; ++i) {
                results[i] = (BatchActionResults)super.clone();
                results[i].resultMap = new HashMap(1);
                Object id = idList.get(i);
                results[i].resultMap.put(id, SUCCESS);
                IObjectValue objValue = (IObjectValue)colMap.get(id);
                if (objValue == null) continue;
                IObjectCollection col = BatchActionUtil.getCollectionInstance(ctx, objValue.getBOSType());
                col.addObject(objValue);
                results[i].objCollection = col;
            }
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
        return results;
    }
}

