/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BatchSelectionEntries
implements Serializable {
    private static final long serialVersionUID = -3606702672259975329L;
    private List entries = null;
    private ActionLevelEnum actionLevel = ActionLevelEnum.HEAD;
    private transient IObjectValue editdata;
    transient BatchActionResults batchResults;

    public void setBatchResults(BatchActionResults batchResults) {
        this.batchResults = batchResults;
    }

    public BatchActionResults getBatchResults() {
        return this.batchResults;
    }

    private void init(int initialCapacity) {
        this.entries = initialCapacity > 0 ? new ArrayList(initialCapacity) : new ArrayList();
    }

    public BatchSelectionEntries(ActionLevelEnum actionLevel) {
        this.actionLevel = actionLevel;
        this.init(0);
    }

    public BatchSelectionEntries(ActionLevelEnum actionLevel, int initialCapacity) {
        this.actionLevel = actionLevel;
        this.init(initialCapacity);
    }

    public BatchSelectionEntries() {
        this.init(0);
    }

    public BatchSelectionEntries(int initialCapacity) {
        this.init(initialCapacity);
    }

    public void add(BatchSelectionEntry entry) {
        this.entries.add(entry);
    }

    public String[] getIdArray() {
        boolean isHead = this.isHead();
        String[] results = new String[this.size()];
        int size = this.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = (BatchSelectionEntry)this.entries.get(idxOfEntry);
            results[idxOfEntry] = isHead ? entry.getId() : entry.getEntryId();
        }
        return results;
    }

    public String[] getToDoIdArray() {
        List list = this.getToDoIdList();
        String[] results = new String[list.size()];
        list.toArray(results);
        return results;
    }

    public List getToDoIdList() {
        boolean isHead = this.isHead();
        ArrayList<String> list = new ArrayList<String>(this.size());
        int size = this.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = (BatchSelectionEntry)this.entries.get(idxOfEntry);
            if (entry == null || ActionResultEnum.ERROR.equals(entry.getResult())) continue;
            list.add(isHead ? entry.getId() : entry.getEntryId());
        }
        return list;
    }

    public List getIdList(ActionResultEnum actionResult) {
        boolean isHead = this.isHead();
        ArrayList<String> results = new ArrayList<String>(this.size());
        int size = this.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = (BatchSelectionEntry)this.entries.get(idxOfEntry);
            if (!actionResult.equals(entry.getResult())) continue;
            results.add(isHead ? entry.getId() : entry.getEntryId());
        }
        return results;
    }

    public List getOrgList() {
        ArrayList<String> result = new ArrayList<String>();
        int size = this.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = (BatchSelectionEntry)this.entries.get(idxOfEntry);
            if (entry.getOrgId() == null || result.contains(entry.getOrgId())) continue;
            result.add(entry.getOrgId());
        }
        return result;
    }

    public int size() {
        return this.entries.size();
    }

    public List getEntries() {
        return this.entries;
    }

    public BatchSelectionEntry get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("BatchSelectionEntries: The index exceed the size of entries.");
        }
        return (BatchSelectionEntry)this.entries.get(index);
    }

    public boolean isHead() {
        return this.actionLevel.equals(ActionLevelEnum.HEAD);
    }

    public List getToDoHeadIdList() {
        boolean isHead = this.isHead();
        ArrayList<String> list = null;
        if (isHead) {
            list = new ArrayList<String>(this.size());
            int size = this.size();
            for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                BatchSelectionEntry entry = (BatchSelectionEntry)this.entries.get(idxOfEntry);
                if (ActionResultEnum.ERROR.equals(entry.getResult())) continue;
                list.add(entry.getId());
            }
        } else {
            HashSet<String> set = new HashSet<String>();
            int size = this.size();
            for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                BatchSelectionEntry entry = (BatchSelectionEntry)this.entries.get(idxOfEntry);
                if (ActionResultEnum.ERROR.equals(entry.getResult())) continue;
                set.add(entry.getId());
            }
            list = new ArrayList(set.size());
            list.addAll(set);
        }
        return list;
    }

    public IObjectValue getEditdata() {
        return this.editdata;
    }

    public void setEditdata(IObjectValue editdata) {
        this.editdata = editdata;
    }
}

