/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction.service;

import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.service.ActionProxy;
import com.kingdee.eas.framework.batchaction.service.AuditActionProxy;
import com.kingdee.eas.framework.batchaction.service.ConfirmActionProxy;
import com.kingdee.eas.framework.batchaction.service.GeneralActionProxy;
import com.kingdee.eas.framework.batchaction.service.MoveActionProxy;
import com.kingdee.eas.framework.batchaction.service.SubmitActionProxy;
import java.util.HashSet;

public class ActionProxyFactory {
    public static final HashSet moveActionSet = new HashSet(4);

    public static ActionProxy createActionProxy(BatchActionEnum bizAction, ItemAction action) throws IllegalArgumentException {
        String clzName = action.getClass().getName();
        if (clzName.endsWith("Action")) {
            return ActionProxyFactory.createActionProxy(bizAction, action, clzName.substring(0, clzName.length() - 6));
        }
        throw new IllegalArgumentException("The action name is not ends with 'Acton', please provide action method. ");
    }

    public static ActionProxy createActionProxy(BatchActionEnum bizAction, ItemAction action, String actionMethod) {
        if (bizAction.equals(BatchActionEnum.DELETE)) {
            return new ConfirmActionProxy(action, actionMethod, bizAction);
        }
        if (bizAction.equals(BatchActionEnum.AUDIT)) {
            return new AuditActionProxy(action, actionMethod, bizAction);
        }
        return new GeneralActionProxy(action, actionMethod, bizAction);
    }

    public static ActionProxy createActionProxy(BatchActionEnum bizAction, ItemAction action, String actionMethod, ContextTypeEnum contextType) {
        if (contextType.equals((Object)ContextTypeEnum.INMAINTAINING) && (bizAction.equals(BatchActionEnum.SUBMIT) || bizAction.equals(BatchActionEnum.SAVE))) {
            return new SubmitActionProxy(action, actionMethod, bizAction);
        }
        if (moveActionSet.contains(bizAction)) {
            return new MoveActionProxy(action, actionMethod, bizAction);
        }
        return ActionProxyFactory.createActionProxy(bizAction, action, actionMethod);
    }

    static {
        moveActionSet.add(BatchActionEnum.FIRST);
        moveActionSet.add(BatchActionEnum.PREVIOUS);
        moveActionSet.add(BatchActionEnum.NEXT);
        moveActionSet.add(BatchActionEnum.LAST);
    }
}

