/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.console.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.console.service.IConsoleFacade;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterUtil;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBPoolManager;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.bibench.platform.services.AbstractService;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConsoleFacadeImpl
extends AbstractService
implements IConsoleFacade {
    private static final Logger log = LogUtil.getPackageLogger(ConsoleFacadeImpl.class);
    private static final String DEFAULT_USER = "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F";

    @Override
    public RDRowSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, 0, -1);
    }

    public RDRowSet executeQuery(String sql, int from, int len) throws SQLException {
        return this.executeQuery(sql, null, from, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDRowSet executeQuery(String sql, Object[] params, int from, int len) throws SQLException {
        RDRowSet rDRowSet;
        Connection cn = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            RDRowSet dbrs;
            cn = this.getConnection();
            stmt = cn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
            }
            rs = stmt.executeQuery();
            rDRowSet = dbrs = RDRowSet.parse((ResultSet)rs, (int)from, (int)len);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)cn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return rDRowSet;
    }

    @Override
    public int executeUpdate(String sql) throws DBCenterException {
        return this.executeUpdate(sql, null);
    }

    public int executeUpdate(String sql, Object[] params) throws DBCenterException {
        int i;
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = this.getConnection();
            stmt = cn.prepareStatement(sql);
            if (params != null) {
                for (i = 0; i < params.length; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
            }
            i = stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new DBCenterException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return i;
    }

    @Override
    public Map getViews(String listType, Map parameters) throws DBCenterException {
        StringBuffer sb = new StringBuffer();
        String tableName = null;
        if ("dbCenter".equalsIgnoreCase(listType)) {
            tableName = this.getTableName(listType);
            sb.append("select ").append("A.FID ").append("ID");
            sb.append(",A.FDBCenterName ").append("DBCENTERNAME");
            sb.append(",A.FBizType ").append("BIZTYPE");
            sb.append(",A.FDBType ").append("DBTYPE");
            sb.append(",A.FDBUrl ").append("URL");
            sb.append(",A.FDBPort ").append("PORT");
            sb.append(",A.FDBName ").append("DBNAME");
            sb.append(",A.FDBUserName ").append("DBUSERNAME");
            sb.append(",A.FUseFlag ").append("USEFLAG");
            sb.append(",U.FName_l2 ").append("CREATOR");
            sb.append(",A.FLastUpdateTime ").append("LASTUPDATE");
            sb.append(",A.FDiscription ").append("DISCRIPTION");
            sb.append("\tfrom ").append(tableName).append(" A, T_PM_USER U where ");
            sb.append("A.FCreatorID = U.FID ");
            if (parameters == null) {
                sb.append("order by A.FLastUpdateTime desc");
            }
        }
        HashMap mapRet = new HashMap();
        Connection cn = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            cn = this.getConnection();
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sb.toString());
            this.putRsToMap(rs, mapRet);
        }
        catch (SQLException e) {
            try {
                throw new DBCenterException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return mapRet;
    }

    private String getTableName(String type) {
        if ("dbCenter".equalsIgnoreCase(type)) {
            return "T_BI_DB_CENTER";
        }
        return null;
    }

    private void putRsToMap(ResultSet rs, Map map) throws SQLException {
        int i;
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        List[] lstColumn = new List[columnCount];
        while (rs.next()) {
            for (i = 1; i <= columnCount; ++i) {
                if (lstColumn[i - 1] == null) {
                    lstColumn[i - 1] = new ArrayList();
                }
                Object o = rs.getObject(i);
                lstColumn[i - 1].add(o == null ? "" : o.toString());
            }
        }
        for (i = 1; i <= columnCount; ++i) {
            if (lstColumn[i - 1] == null) {
                map.put(rsmd.getColumnName(i), new String[0]);
                continue;
            }
            map.put(rsmd.getColumnName(i), lstColumn[i - 1].toArray(new String[lstColumn[i - 1].size()]));
        }
    }

    public int delete(String modelType, Object param) throws DBCenterException {
        String tableName = this.getTableName(modelType);
        if (param == null || tableName == null) {
            return -1;
        }
        StringBuffer sbd = new StringBuffer();
        sbd.append("delete from ").append(tableName).append(" where fid=").append(param);
        return this.executeUpdate(sbd.toString());
    }

    @Override
    public String getCurrentUser() {
        try {
            Context ctx = this.getBosContext();
            return ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        catch (Throwable e) {
            log.error((Object)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237", e);
            return DEFAULT_USER;
        }
    }

    public Connection getConnection() throws SQLException {
        return super.getConnection();
    }

    @Override
    public Map executeQuery2(String sql) throws DBCenterException {
        HashMap mapRet = new HashMap();
        Connection cn = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            cn = this.getConnection();
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sql);
            this.putRsToMap(rs, mapRet);
        }
        catch (SQLException e) {
            try {
                throw new DBCenterException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return mapRet;
    }

    @Override
    public String getUUID() {
        return StringUtil.getUUID();
    }

    @Override
    public Connection getDBCenterConnection(String dbCenterId) throws DBCenterException {
        Connection con = null;
        try {
            con = this.getConnection();
        }
        catch (SQLException e) {
            log.error((Object)("\u670d\u52a1\u5668\u7aef\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\uff1a" + e.getMessage()));
            throw new DBCenterException("\u670d\u52a1\u5668\u7aef\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\uff1a" + e);
        }
        return DBPoolManager.getConnection((Connection)con, (String)dbCenterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testDBCenterConnection(String dbCenterId) {
        Connection con = null;
        try {
            con = this.getDBCenterConnection(dbCenterId);
            if (con == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (DBCenterException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            DBCenterUtil.closeConnection((Connection)con);
        }
    }

    @Override
    public void shutdownDBCenterPool(String dbCenterId) throws DBCenterException {
        DBPoolManager.shutdownPool((String)dbCenterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testDBCenterConnection(DBCenterModel model) {
        Connection con = null;
        try {
            con = this.getDBCenterConnection(model);
            if (con == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (DBCenterException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            DBCenterUtil.closeConnection((Connection)con);
        }
    }

    @Override
    public Connection getDBCenterConnection(DBCenterModel model) throws DBCenterException {
        return DBPoolManager.getConnection((DBCenterModel)model);
    }

    public String executeQuery3(String sql) throws DBCenterException {
        String result = null;
        Connection cn = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            cn = this.getConnection();
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBCenterException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return result;
    }
}

