/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.general.importscheme;

import com.kingdee.bos.bi.model.common.mm.general.db.Column;
import com.kingdee.bos.ctrl.common.DataType;

public class SchemeChecking {
    public static final String NVARCHAR = "nvarchar";
    public static final String DATETIME = "datetime";
    public static final String INT = "int";
    public static final String DECIMAL = "decimal";

    public static int checkType(Column tagColumn, Column srcColumn) {
        if (NVARCHAR.equalsIgnoreCase(tagColumn.getType())) {
            return SchemeChecking.matcheToNvarchar(srcColumn.getJdbcType());
        }
        if (DATETIME.equalsIgnoreCase(tagColumn.getType())) {
            return SchemeChecking.matcheToDateTime(srcColumn.getJdbcType());
        }
        if (INT.equalsIgnoreCase(tagColumn.getType())) {
            if (SchemeChecking.matcheToInt(srcColumn.getJdbcType()) > 0) {
                return 1;
            }
            if (SchemeChecking.matcheToDecimal(srcColumn.getJdbcType()) > 0) {
                return 0;
            }
            return -1;
        }
        if (DECIMAL.equalsIgnoreCase(tagColumn.getType())) {
            if (SchemeChecking.matcheToDecimal(srcColumn.getJdbcType()) > 0) {
                return 1;
            }
            if (SchemeChecking.matcheToInt(srcColumn.getJdbcType()) > 0) {
                return 0;
            }
            return -1;
        }
        return 1;
    }

    public static boolean checkLength(Column tagColumn, Column srcColumn) {
        if (DECIMAL.equalsIgnoreCase(tagColumn.getType())) {
            return tagColumn.getPrecision() - tagColumn.getScale() >= srcColumn.getPrecision() - srcColumn.getScale();
        }
        return tagColumn.getLength() >= srcColumn.getLength();
    }

    public static boolean checkScale(Column tagColumn, Column srcColumn) {
        if (DECIMAL.equalsIgnoreCase(tagColumn.getType())) {
            return tagColumn.getScale() >= srcColumn.getScale();
        }
        return true;
    }

    public static DataType fromJdbcType(int jdbcType) {
        return DataType.fromJdbcType((int)jdbcType);
    }

    public static int matcheToNvarchar(int jdbcType) {
        return 1;
    }

    public static int matcheToDateTime(int jdbcType) {
        switch (jdbcType) {
            case 91: 
            case 92: 
            case 93: {
                return 1;
            }
        }
        return -1;
    }

    public static int matcheToInt(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 16: {
                return 1;
            }
        }
        return -1;
    }

    public static int matcheToDecimal(int jdbcType) {
        switch (jdbcType) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return 1;
            }
        }
        return -1;
    }

    public static DataType matchJdbcType(int jdbcType) {
        return DataType.fromJdbcType((int)jdbcType);
    }
}

