/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.general.importscheme;

import com.kingdee.bos.bi.model.common.mm.commonfilter.CommonFilterModel;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeModel;
import com.kingdee.bos.bi.model.util.XmlUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class SchemeParse {
    public static final String ELE_IMPORTDATASCHEME = "importDataScheme";
    public static final String ELE_TYPE = "type";
    public static final String ELE_DATASOURCE = "dataSource";
    public static final String ELE_METADATA = "metaData";
    public static final String ATR_METADATAID = "metaDataId";
    public static final String ELE_DBCENTER = "dbCenter";
    public static final String ATR_DBCENTERID = "dbCenterId";
    public static final String ELE_TABLENAME = "dbCenterTableName";
    public static final String ELE_SQL = "sql";
    public static final String ELE_MAPPING = "mapping";
    public static final String ELE_PROPERTY = "property";
    public static final String ATR_SRC = "src";
    public static final String ATR_DEF = "def";
    public static final String ELE_FILTERING = "filtering";
    public static final String ELE_CUFILTER = "cuFilter";
    public static final String ATR_CUENABLED = "cuEnabled";
    public static final String ATR_CUFIELD = "cuField";
    public static final String ELE_ADMINUINT = "adminUint";
    public static final String ELE_ITEAM = "iteam";
    public static final String ELE_COMMONFILTER = "commonFilter";
    public static final String ATR_LEFT = "left";
    public static final String ATR_FIELD = "field";
    public static final String ATR_COMPARE = "compare";
    public static final String ATR_VALUE = "value";
    public static final String ATR_RIGHT = "right";
    public static final String ATR_LOGIC = "logic";
    public static final String ATR_ISNUMERIC = "isNumeric";
    public static final String TRUE = "true";

    public static String toXml(SchemeModel model) throws IOException {
        Element dbCenterElement;
        if (model == null) {
            return "";
        }
        Element rootElement = new Element(ELE_IMPORTDATASCHEME);
        Element typeElement = new Element(ELE_TYPE);
        String type = model.getType();
        typeElement.setText(type);
        Element sourceElement = new Element(ELE_DATASOURCE);
        if ("entity".equalsIgnoreCase(type) || "query".equalsIgnoreCase(type) || "table".equalsIgnoreCase(type)) {
            Element metaDataElement = new Element(ELE_METADATA);
            metaDataElement.setAttribute(ATR_METADATAID, model.getMetaDataFullName());
            sourceElement.addContent((Content)metaDataElement);
        } else if ("dbTable".equalsIgnoreCase(type)) {
            dbCenterElement = new Element(ELE_DBCENTER);
            dbCenterElement.setAttribute(ATR_DBCENTERID, model.getDbCenterId());
            Element tableNameElement = new Element(ELE_TABLENAME);
            tableNameElement.setText(model.getDbCenterTable());
            dbCenterElement.addContent((Content)tableNameElement);
            sourceElement.addContent((Content)dbCenterElement);
        } else if (ELE_SQL.equalsIgnoreCase(type)) {
            dbCenterElement = new Element(ELE_DBCENTER);
            dbCenterElement.setAttribute(ATR_DBCENTERID, model.getDbCenterId());
            Element sqlElement = new Element(ELE_SQL);
            sqlElement.addContent((Content)new CDATA(model.getDbCenterSql()));
            dbCenterElement.addContent((Content)sqlElement);
            sourceElement.addContent((Content)dbCenterElement);
        }
        Element mappingElement = new Element(ELE_MAPPING);
        Element propertyElement = null;
        Map.Entry entry = null;
        String def = null;
        String src = null;
        Iterator it = model.getMappings().entrySet().iterator();
        while (it.hasNext()) {
            propertyElement = new Element(ELE_PROPERTY);
            entry = it.next();
            def = (String)entry.getKey();
            src = (String)entry.getValue();
            propertyElement.setAttribute(ATR_DEF, def);
            propertyElement.setAttribute(ATR_SRC, src);
            mappingElement.addContent((Content)propertyElement);
        }
        Element filteringElement = new Element(ELE_FILTERING);
        Element cuFilterElement = new Element(ELE_CUFILTER);
        boolean cuEnabled = model.getFiltering().getCuEnabled();
        cuFilterElement.setAttribute(ATR_CUENABLED, Boolean.toString(cuEnabled));
        if (cuEnabled) {
            cuFilterElement.setAttribute(ATR_CUFIELD, model.getFiltering().getFilterField());
            Element adminUnitElement = new Element(ELE_ADMINUINT);
            Element iteamElement = null;
            String adminUintId2 = null;
            for (String adminUintId2 : model.getFiltering().getAdminUint()) {
                iteamElement = new Element(ELE_ITEAM);
                iteamElement.setText(adminUintId2);
                adminUnitElement.addContent((Content)iteamElement);
            }
            cuFilterElement.addContent((Content)adminUnitElement);
        }
        filteringElement.addContent((Content)cuFilterElement);
        Element commonFilterElement = new Element(ELE_COMMONFILTER);
        CommonFilterModel commonFilterModel2 = null;
        Element iteamElement = null;
        for (CommonFilterModel commonFilterModel2 : model.getFiltering().getCommonFilter()) {
            iteamElement = new Element(ELE_ITEAM);
            iteamElement.setAttribute(ATR_LEFT, commonFilterModel2.getLeft());
            iteamElement.setAttribute(ATR_FIELD, commonFilterModel2.getField());
            iteamElement.setAttribute(ATR_COMPARE, commonFilterModel2.getCompare());
            iteamElement.setAttribute(ATR_VALUE, commonFilterModel2.getValue());
            iteamElement.setAttribute(ATR_RIGHT, commonFilterModel2.getRight());
            iteamElement.setAttribute(ATR_LOGIC, commonFilterModel2.getLogic());
            iteamElement.setAttribute(ATR_ISNUMERIC, String.valueOf(commonFilterModel2.getIsNumeric()));
            commonFilterElement.addContent((Content)iteamElement);
        }
        filteringElement.addContent((Content)commonFilterElement);
        rootElement.addContent((Content)typeElement);
        rootElement.addContent((Content)sourceElement);
        rootElement.addContent((Content)mappingElement);
        rootElement.addContent((Content)filteringElement);
        return XmlUtil.toGBKString(rootElement);
    }

    public static SchemeModel toModel(String xml) throws JDOMException, IOException {
        String dbCenterId;
        Element dbCenterElement;
        SchemeModel m = new SchemeModel();
        Element rootElement = XmlUtil.toRootElement(xml);
        Element typeElement = rootElement.getChild(ELE_TYPE);
        String type = typeElement.getText();
        m.setType(type);
        Element sourceElement = rootElement.getChild(ELE_DATASOURCE);
        if ("entity".equalsIgnoreCase(type) || "query".equalsIgnoreCase(type) || "table".equalsIgnoreCase(type)) {
            Element metaDataElement = sourceElement.getChild(ELE_METADATA);
            String metaDataId = metaDataElement.getAttributeValue(ATR_METADATAID);
            m.setMetaDataFulName(metaDataId);
        } else if ("dbTable".equalsIgnoreCase(type)) {
            dbCenterElement = sourceElement.getChild(ELE_DBCENTER);
            dbCenterId = dbCenterElement.getAttributeValue(ATR_DBCENTERID);
            Element tableNameElement = dbCenterElement.getChild(ELE_TABLENAME);
            String tableName = tableNameElement.getText();
            m.setDbCenterId(dbCenterId);
            m.setDbCenterTable(tableName);
        } else if (ELE_SQL.equalsIgnoreCase(type)) {
            dbCenterElement = sourceElement.getChild(ELE_DBCENTER);
            dbCenterId = dbCenterElement.getAttributeValue(ATR_DBCENTERID);
            Element sqlElement = dbCenterElement.getChild(ELE_SQL);
            String sql = sqlElement.getText();
            m.setDbCenterId(dbCenterId);
            m.setDbCenterSql(sql);
        }
        Element mappingElement = rootElement.getChild(ELE_MAPPING);
        Element mapElement2 = null;
        String def = null;
        String src = null;
        for (Element mapElement2 : mappingElement.getChildren()) {
            def = mapElement2.getAttributeValue(ATR_DEF);
            src = mapElement2.getAttributeValue(ATR_SRC);
            m.getMappings().put(def, src);
        }
        Element filteringElement = rootElement.getChild(ELE_FILTERING);
        Element cuFilterElement = filteringElement.getChild(ELE_CUFILTER);
        boolean cuFilterEnabled = TRUE.equalsIgnoreCase(cuFilterElement.getAttributeValue(ATR_CUENABLED));
        m.getFiltering().setCuEnabled(cuFilterEnabled);
        if (cuFilterEnabled) {
            String cuFilterField = cuFilterElement.getAttributeValue(ATR_CUFIELD);
            m.getFiltering().setFilterField(cuFilterField);
            Element adminUnitElement = cuFilterElement.getChild(ELE_ADMINUINT);
            Element cuIteamElement2 = null;
            String unitId = null;
            for (Element cuIteamElement2 : adminUnitElement.getChildren()) {
                unitId = cuIteamElement2.getText();
                m.getFiltering().getAdminUint().add(unitId);
            }
        }
        Element commonFilterElement = filteringElement.getChild(ELE_COMMONFILTER);
        Element commonIteamElement2 = null;
        String left = null;
        String field = null;
        String compare = null;
        String value = null;
        String right = null;
        String logic = null;
        boolean isNumeric = false;
        CommonFilterModel commonFilterModel = null;
        for (Element commonIteamElement2 : commonFilterElement.getChildren()) {
            left = commonIteamElement2.getAttributeValue(ATR_LEFT);
            field = commonIteamElement2.getAttributeValue(ATR_FIELD);
            compare = commonIteamElement2.getAttributeValue(ATR_COMPARE);
            compare = compare.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            value = commonIteamElement2.getAttributeValue(ATR_VALUE);
            right = commonIteamElement2.getAttributeValue(ATR_RIGHT);
            logic = commonIteamElement2.getAttributeValue(ATR_LOGIC);
            isNumeric = TRUE.equalsIgnoreCase(commonIteamElement2.getAttributeValue(ATR_ISNUMERIC));
            commonFilterModel = new CommonFilterModel(left, field, compare, value, right, logic, isNumeric);
            m.getFiltering().getCommonFilter().add(commonFilterModel);
        }
        return m;
    }

    public static void main(String[] args) {
        SchemeModel m = new SchemeModel();
        m.setType(ELE_SQL);
        String xml = "<importDataScheme><type>sql</type><dataSource><metaData metaDataId=\"\u5143\u6570\u636ePK\"></metaData><dbCenter dbCenterId=\"\u6570\u636e\u4e2d\u5fc3id\"><tableName>\u6570\u636e\u5e93\u8868\u540d</tableName><sql><![CDATA[ sql\u8bed\u53e5  ]]></sql></dbCenter></dataSource><mapping> <property def =\"\u5b9a\u4e49\u5217\" src=\"\u6e90\u5217\" /><property def =\"\u5b9a\u4e49\u52172\" src=\"\u6e90\u52172\" /></mapping></importDataScheme>";
        try {
            SchemeParse.toModel(xml);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

