/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.time;

import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.mm.customdim.CustomDimUtil;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.bi.model.util.XmlUtil;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class TimeModel {
    private Date dateBegin;
    private Date dateEnd;
    private boolean useYear;
    private boolean useHalfYear;
    private boolean useQuarter;
    private boolean useMonth;
    private boolean useDay;
    private String description;

    public Date getDateBegin() {
        return this.dateBegin;
    }

    public void setDateBegin(Date dateBegin) {
        this.dateBegin = dateBegin;
    }

    public Date getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public boolean getUseYear() {
        return this.useYear;
    }

    public void setUseYear(boolean useYear) {
        this.useYear = useYear;
    }

    public boolean getUseHalfYear() {
        return this.useHalfYear;
    }

    public void setUseHalfYear(boolean useHalfYear) {
        this.useHalfYear = useHalfYear;
    }

    public boolean getUseQuarter() {
        return this.useQuarter;
    }

    public void setUseQuarter(boolean useQuarter) {
        this.useQuarter = useQuarter;
    }

    public boolean getUseMonth() {
        return this.useMonth;
    }

    public void setUseMonth(boolean useMonth) {
        this.useMonth = useMonth;
    }

    public boolean getUseDay() {
        return this.useDay;
    }

    public void setUseDay(boolean useDay) {
        this.useDay = useDay;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TimeModel) {
            TimeModel another = (TimeModel)obj;
            return TimeUtil.equalsIgnoreHmss(another.getDateBegin(), this.getDateBegin()) && TimeUtil.equalsIgnoreHmss(another.getDateEnd(), this.getDateEnd()) && another.getUseYear() == this.getUseYear() && another.getUseHalfYear() == this.getUseHalfYear() && another.getUseQuarter() == this.getUseQuarter() && another.getUseMonth() == this.getUseMonth() && another.getUseDay() == this.getUseDay();
        }
        return false;
    }

    public static void save(IManagementFacade facade, String viewId, TimeModel m, String dimId) throws SQLException {
        String tableName = CustomDimUtil.getTableName(facade, dimId);
        String[] sqls = new String[]{"DELETE FROM " + tableName + " where FViewID='" + viewId + "'"};
        facade.executeBatch(sqls);
        sqls[0] = "INSERT INTO " + tableName + " (FViewID,FTimeBegin,FTimeEnd,FYearEnabled,FHalfYearEnabled,FQuarterEnabled,FMonthEnabled,FDayEnabled) Values(?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] objs = new Object[]{viewId, new Timestamp(m.getDateBegin().getTime()), new Timestamp(m.getDateEnd().getTime()), new Integer(m.getUseYear() ? 1 : 0), new Integer(m.getUseHalfYear() ? 1 : 0), new Integer(m.getUseQuarter() ? 1 : 0), new Integer(m.getUseMonth() ? 1 : 0), new Integer(m.getUseDay() ? 1 : 0)};
        paramList.add(objs);
        facade.executeBatch(sqls[0], paramList);
    }

    public static TimeModel load(IManagementFacade facade, String viewId, String dimId) throws SQLException {
        TimeModel m = null;
        String tableName = CustomDimUtil.getTableName(facade, dimId);
        String sql = "select FTimeBegin,FTimeEnd,FYearEnabled,FHalfYearEnabled,FQuarterEnabled,FMonthEnabled,FDayEnabled from " + tableName + " where FViewID='" + viewId + "'";
        RDRowSet rs = facade.executeQuery(sql);
        if (rs.next()) {
            m = new TimeModel();
            m.setDateBegin((Date)rs.getObject("FTimeBegin"));
            m.setDateEnd((Date)rs.getObject("FTimeEnd"));
            m.setUseYear(rs.getInt("FYearEnabled") == 1);
            m.setUseHalfYear(rs.getInt("FHalfYearEnabled") == 1);
            m.setUseQuarter(rs.getInt("FQuarterEnabled") == 1);
            m.setUseMonth(rs.getInt("FMonthEnabled") == 1);
            m.setUseDay(rs.getInt("FDayEnabled") == 1);
        }
        return m;
    }

    public static TimeModel load2(IManagementFacade facade, String viewId, String dimNumber) throws SQLException {
        TimeModel m = null;
        String tableName = CustomDimUtil.getTableName("time", dimNumber);
        String sql = "select FTimeBegin,FTimeEnd,FYearEnabled,FHalfYearEnabled,FQuarterEnabled,FMonthEnabled,FDayEnabled from " + tableName + " where FViewID='" + viewId + "'";
        RDRowSet rs = facade.executeQuery(sql);
        if (rs.next()) {
            m = new TimeModel();
            m.setDateBegin((Date)rs.getObject("FTimeBegin"));
            m.setDateEnd((Date)rs.getObject("FTimeEnd"));
            m.setUseYear(rs.getInt("FYearEnabled") == 1);
            m.setUseHalfYear(rs.getInt("FHalfYearEnabled") == 1);
            m.setUseQuarter(rs.getInt("FQuarterEnabled") == 1);
            m.setUseMonth(rs.getInt("FMonthEnabled") == 1);
            m.setUseDay(rs.getInt("FDayEnabled") == 1);
        }
        return m;
    }

    public static TimeModel load(Connection cn, String viewId, String number) throws SQLException {
        TimeModel m = null;
        String tableName = CustomDimUtil.getTableName("time", number);
        String sql = "select FTimeBegin,FTimeEnd,FYearEnabled,FHalfYearEnabled,FQuarterEnabled,FMonthEnabled,FDayEnabled from " + tableName + " where FViewID='" + viewId + "'";
        RDRowSet rs = DBUtil.executeQuery(sql, cn);
        if (rs.next()) {
            m = new TimeModel();
            m.setDateBegin((Date)rs.getObject("FTimeBegin"));
            m.setDateEnd((Date)rs.getObject("FTimeEnd"));
            m.setUseYear(rs.getInt("FYearEnabled") == 1);
            m.setUseHalfYear(rs.getInt("FHalfYearEnabled") == 1);
            m.setUseQuarter(rs.getInt("FQuarterEnabled") == 1);
            m.setUseMonth(rs.getInt("FMonthEnabled") == 1);
            m.setUseDay(rs.getInt("FDayEnabled") == 1);
        }
        return m;
    }

    public static TimeModel load2(Connection cn, String pubNumber, String number) throws SQLException, JDOMException, IOException, ParseException {
        TimeModel m = null;
        String sql = "select FDimMetaData from T_BI_AppModel A,T_BI_AM_MetaData M where A.FID=M.FAMID and FPublishNumber='" + pubNumber + "' and FDimType='" + number + "'";
        RDRowSet rs = DBUtil.executeQuery(sql, cn);
        if (rs.next()) {
            m = TimeModel.toModel(rs.getString("FDimMetaData"));
        }
        return m;
    }

    public static TimeModel load3(IManagementFacade facade, String amId, String number) throws SQLException, JDOMException, IOException, ParseException {
        TimeModel m = null;
        String sql = "select FDimMetaData from T_BI_AppModel A,T_BI_AM_MetaData M where A.FID=M.FAMID and FID='" + amId + "' and FDimType='" + number + "'";
        RDRowSet rs = facade.executeQuery(sql);
        if (rs.next()) {
            m = TimeModel.toModel(rs.getString("FDimMetaData"));
        }
        return m;
    }

    public static String toXml(TimeModel model) throws IOException {
        Element rootElement = new Element("customDim");
        rootElement.setAttribute("type", "time");
        Element timeElement = new Element("time");
        timeElement.setAttribute("begin", TimeUtil.getTime(model.getDateBegin()));
        timeElement.setAttribute("end", TimeUtil.getTime(model.getDateEnd()));
        Element levelElement = new Element("level");
        levelElement.setAttribute("year", Boolean.toString(model.getUseYear()));
        levelElement.setAttribute("halfYear", Boolean.toString(model.getUseHalfYear()));
        levelElement.setAttribute("quarter", Boolean.toString(model.getUseQuarter()));
        levelElement.setAttribute("month", Boolean.toString(model.getUseMonth()));
        levelElement.setAttribute("date", Boolean.toString(model.getUseDay()));
        timeElement.addContent((Content)levelElement);
        rootElement.addContent((Content)timeElement);
        return XmlUtil.toGBKString(rootElement);
    }

    public static TimeModel toModel(String xml) throws JDOMException, IOException, ParseException {
        TimeModel model = new TimeModel();
        Element rootElement = XmlUtil.toRootElement(xml);
        Element timeElement = rootElement.getChild("time");
        Element levelElement = timeElement.getChild("level");
        String beginTime = timeElement.getAttributeValue("begin");
        String endTime = timeElement.getAttributeValue("end");
        String year = levelElement.getAttributeValue("year");
        String halfYear = levelElement.getAttributeValue("halfYear");
        String quarter = levelElement.getAttributeValue("quarter");
        String month = levelElement.getAttributeValue("month");
        String date = levelElement.getAttributeValue("date");
        model.setDateBegin(TimeUtil.parse(beginTime));
        model.setDateEnd(TimeUtil.parse(endTime));
        model.setUseYear(StringUtil.toBoolean(year));
        model.setUseHalfYear(StringUtil.toBoolean(halfYear));
        model.setUseQuarter(StringUtil.toBoolean(quarter));
        model.setUseMonth(StringUtil.toBoolean(month));
        model.setUseDay(StringUtil.toBoolean(date));
        return model;
    }
}

