/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.propsheet.panel;

import com.kingdee.bos.bi.model.commonui.propsheet.panel.IProperty;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class AbstractProperty
implements IProperty {
    private static final long serialVersionUID = 520103077285533731L;
    private Object value;
    private transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object clone() {
        AbstractProperty clone = null;
        try {
            clone = (AbstractProperty)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setValue(Object value) {
        this.setValue(value, true);
    }

    public void setValue(Object newValue, boolean fireEvent) {
        Object oldValue = this.value;
        this.value = newValue;
        if (fireEvent && newValue != oldValue && (newValue == null || !newValue.equals(oldValue))) {
            try {
                this.firePropertyChange(oldValue, newValue);
            }
            catch (RuntimeException e) {
                this.value = oldValue;
                throw e;
            }
        }
    }

    protected void initializeValue(Object value) {
        this.value = value;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
        IProperty[] subProperties = this.getSubProperties();
        if (subProperties != null) {
            for (int i = 0; i < subProperties.length; ++i) {
                subProperties[i].addPropertyChangeListener(listener);
            }
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
        IProperty[] subProperties = this.getSubProperties();
        if (subProperties != null) {
            for (int i = 0; i < subProperties.length; ++i) {
                subProperties[i].removePropertyChangeListener(listener);
            }
        }
    }

    protected void firePropertyChange(Object oldValue, Object newValue) {
        this.listeners.firePropertyChange("value", oldValue, newValue);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new PropertyChangeSupport(this);
    }

    @Override
    public IProperty getParentProperty() {
        return null;
    }

    @Override
    public IProperty[] getSubProperties() {
        return null;
    }
}

