/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.propsheet.panel;

import com.kingdee.bos.bi.model.commonui.propsheet.beans.ExtendedPropertyDescriptor;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.renderer.BooleanCellRenderer;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.renderer.DateRenderer;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.renderer.DefaultCellRenderer;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.BooleanValue;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.DateValue;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.DoubleValue;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.FloatValue;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.IntegerValue;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.LongValue;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.ShortValue;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.StringValue;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.IProperty;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.IPropertyRendererFactory;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.PropertyDescriptorAdapter;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class PropertyRendererFactory
implements IPropertyRendererFactory {
    private Map typeToRenderer = new HashMap();
    private Map propertyToRenderer = new HashMap();

    public PropertyRendererFactory() {
        this.registerDefaults();
    }

    @Override
    public TableCellRenderer createTableCellRenderer(IProperty property) {
        return this.doCreateTableCellRenderer(property);
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Class type) {
        return this.doCreateTableCellRenderer(type);
    }

    private synchronized TableCellRenderer doCreateTableCellRenderer(IProperty property) {
        Object value;
        PropertyDescriptor descriptor;
        TableCellRenderer renderer = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) instanceof ExtendedPropertyDescriptor && ((ExtendedPropertyDescriptor)((Object)descriptor)).getPropertyTableRendererClass() != null) {
            try {
                return (TableCellRenderer)((ExtendedPropertyDescriptor)((Object)descriptor)).getPropertyTableRendererClass().newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((value = this.propertyToRenderer.get(property)) instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            renderer = this.doCreateTableCellRenderer(property.getType());
        }
        return renderer;
    }

    private synchronized TableCellRenderer doCreateTableCellRenderer(Class type) {
        TableCellRenderer renderer = null;
        Object value = this.typeToRenderer.get(type);
        if (value instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return renderer;
    }

    public void registerDefaults() {
        this.typeToRenderer.clear();
        this.propertyToRenderer.clear();
        DefaultCellRenderer renderer = new DefaultCellRenderer();
        renderer.setShowOddAndEvenRows(false);
        BooleanCellRenderer booleanRenderer = new BooleanCellRenderer();
        DateRenderer dateRenderer = new DateRenderer();
        dateRenderer.setShowOddAndEvenRows(false);
        this.registerRenderer(BooleanValue.class, (TableCellRenderer)booleanRenderer);
        this.registerRenderer(StringValue.class, (TableCellRenderer)renderer);
        this.registerRenderer(DoubleValue.class, (TableCellRenderer)renderer);
        this.registerRenderer(FloatValue.class, (TableCellRenderer)renderer);
        this.registerRenderer(IntegerValue.class, (TableCellRenderer)renderer);
        this.registerRenderer(LongValue.class, (TableCellRenderer)renderer);
        this.registerRenderer(ShortValue.class, (TableCellRenderer)renderer);
        this.registerRenderer(DateValue.class, (TableCellRenderer)dateRenderer);
        this.registerRenderer(Integer.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(Boolean.TYPE, (TableCellRenderer)new BooleanCellRenderer());
    }

    public synchronized void registerRenderer(Class type, Class rendererClass) {
        this.typeToRenderer.put(type, rendererClass);
    }

    public synchronized void registerRenderer(Class type, TableCellRenderer renderer) {
        this.typeToRenderer.put(type, renderer);
    }

    public synchronized void unregisterRenderer(Class type) {
        this.typeToRenderer.remove(type);
    }

    public synchronized void registerRenderer(IProperty property, Class rendererClass) {
        this.propertyToRenderer.put(property, rendererClass);
    }

    public synchronized void registerRenderer(IProperty property, TableCellRenderer renderer) {
        this.propertyToRenderer.put(property, renderer);
    }

    public synchronized void unregisterRenderer(IProperty property) {
        this.propertyToRenderer.remove(property);
    }
}

