/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.appmodel;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.mm.appmodel.AppModelUtil;
import com.kingdee.bos.bi.model.common.mm.appmodel.GeneralDRDetailXmlModel;
import com.kingdee.bos.bi.model.common.mm.appmodel.GeneralSQLMappingModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.appmodel.DimensionViewRef;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.fact.Fact;
import com.kingdee.bos.bi.model.rt.migration.TableInfo;
import com.kingdee.bos.bi.model.rt.migration.TableMigration;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterManager;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterUtil;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

public class SQLDataRule {
    private static final Logger log = CommonLogger.getLogger(SQLDataRule.class);
    private AppModel appModel;
    private String schemeId;
    private GeneralDRDetailXmlModel sqlDetail;
    private String tempTableName = null;
    private StringBuffer errorMessage = new StringBuffer();
    private boolean hasTimeStamp = false;
    public static final String QU = "\"";

    public SQLDataRule(AppModel appModel, String schemeId) {
        this.appModel = appModel;
        this.schemeId = schemeId;
    }

    public void run(Context ctx, Date start, Date end) throws DBCenterException, SQLException, JDOMException, IOException, SqlTranslateException {
        String pubNumber = this.appModel.getPubnumber();
        List measureMemberList = this.getMeasureMemberList(ctx);
        this.sqlDetail = this.getSQLDataRuleDetail(ctx);
        Map mapping = this.sqlDetail.getMapping();
        GeneralSQLMappingModel timeStampField = SQLDataRule.getTimeStampMappingField(this.sqlDetail);
        Date lastUpdateTime = this.getLastUpdateTime(ctx, pubNumber);
        this.hasTimeStamp = !StringUtil.isEmpty(timeStampField.getSrc());
        boolean isManualExecute = start != null;
        this.dropOldData(ctx, pubNumber, this.hasTimeStamp, lastUpdateTime, isManualExecute, start, end);
        DimensionType[] dimTypes = this.appModel.getDimTypes();
        Map noMappingMeasureMap = SQLDataRule.getNoMappingMeasureMap(mapping, measureMemberList);
        StringBuffer insertSQL = this.getInsertSQL(dimTypes, measureMemberList, noMappingMeasureMap, pubNumber);
        StringBuffer selectSubSQL = this.getSelectSubSQL(dimTypes, measureMemberList, noMappingMeasureMap, pubNumber, timeStampField);
        insertSQL.append(selectSubSQL.toString());
        StringBuffer cloneSQL = this.getCloneSQL(timeStampField, start, end, lastUpdateTime, isManualExecute);
        Object[] params = this.getCloneSQLParams(start, end, lastUpdateTime, isManualExecute);
        this.cloneTable(ctx, cloneSQL.toString(), params);
        this.migrationDatas(ctx, insertSQL.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrationDatas(Context ctx, String insertSQL) throws DBCenterException, SQLException {
        Connection cn = null;
        try {
            cn = DBCenterManager.getConnection((Context)ctx, (String)this.getToDBCenterId());
            DBUtil.executeUpdate(insertSQL, cn);
        }
        catch (Throwable throwable) {
            DBCenterUtil.closeConnection(cn);
            throw throwable;
        }
        DBCenterUtil.closeConnection((Connection)cn);
    }

    private void cloneTable(Context ctx, String cloneSQL, Object[] params) throws SQLException, DBCenterException, SqlTranslateException {
        TableInfo srcTable = new TableInfo(this.getFromDBCenterId(), cloneSQL);
        srcTable.setParams(params);
        TableInfo destTable = new TableInfo(this.getToDBCenterId(), this.getTempTableName());
        TableMigration.cloneTable(ctx, srcTable, destTable);
    }

    private StringBuffer getCloneSQL(GeneralSQLMappingModel tsField, Date start, Date end, Date lastUpdateTime, boolean isManualExecute) {
        StringBuffer cloneSQL = new StringBuffer();
        cloneSQL.append(StringUtil.getViewSQL(this.sqlDetail.getSQL(), false));
        if (!this.hasTimeStamp) {
            return cloneSQL;
        }
        if (isManualExecute) {
            return cloneSQL.append(" where ").append("? <= ").append(tsField.getSrc()).append(" and ").append(tsField.getSrc()).append(" < ?");
        }
        if (lastUpdateTime != null) {
            return cloneSQL.append(" where ").append(" ? <= ").append(tsField.getSrc());
        }
        return cloneSQL;
    }

    private Object[] getCloneSQLParams(Date start, Date end, Date lastUpdateTime, boolean isManualExecute) {
        if (!this.hasTimeStamp) {
            return null;
        }
        if (isManualExecute) {
            return new Object[]{new Timestamp(start.getTime()), new Timestamp(TimeUtil.getNextDate(end).getTime())};
        }
        if (lastUpdateTime != null) {
            return new Object[]{new Timestamp(lastUpdateTime.getTime())};
        }
        return null;
    }

    private StringBuffer getSelectSubSQL(DimensionType[] dimTypes, List measureMemberList, Map noMappingMeasureMap, String pubNumber, GeneralSQLMappingModel timeStampField) {
        Map mapping = this.sqlDetail.getMapping();
        StringBuffer selectSubSQL = new StringBuffer();
        selectSubSQL.append(" select ");
        int n = dimTypes.length;
        block0: for (int i = 0; i < n; ++i) {
            String typeName = dimTypes[i].getName();
            if (!"measure".equalsIgnoreCase(typeName)) {
                for (Map.Entry entry : mapping.entrySet()) {
                    GeneralSQLMappingModel model;
                    String key = (String)entry.getKey();
                    if (key.indexOf("type.nonMeasure.commonDimension.") != 0 && key.indexOf("type.nonMeasure.timeDimension.") != 0 || !(model = (GeneralSQLMappingModel)entry.getValue()).getTag().equals(typeName)) continue;
                    selectSubSQL.append(QU).append(typeName).append(QU).append(".FID AS ").append(QU).append(typeName).append(QU).append(",");
                    continue block0;
                }
                continue;
            }
            block2: for (String string : measureMemberList) {
                if (noMappingMeasureMap.containsKey(string)) continue;
                for (Map.Entry entry : mapping.entrySet()) {
                    GeneralSQLMappingModel model;
                    String key = (String)entry.getKey();
                    if (key.indexOf("type.measure.member.") != 0 || !(model = (GeneralSQLMappingModel)entry.getValue()).getTag().equals(string)) continue;
                    selectSubSQL.append(QU).append(this.getTempTableName()).append(QU).append(".");
                    selectSubSQL.append(QU).append(model.getSrc()).append(QU).append(",").append("2,");
                    continue block2;
                }
            }
        }
        if (this.hasTimeStamp) {
            selectSubSQL.append(QU).append(this.getTempTableName()).append(QU).append(".").append(QU).append(timeStampField.getSrc()).append(QU);
        } else {
            selectSubSQL.deleteCharAt(selectSubSQL.length() - 1);
        }
        selectSubSQL.append(" from ").append(this.getTempTableName()).append(" AS ");
        selectSubSQL.append(QU).append(this.getTempTableName()).append(QU).append(",");
        AppModelView appModelView = this.appModel.getAppModelView();
        DimensionViewRef dimViewRef = appModelView.getDimRef();
        for (DimensionView dimensionView : dimViewRef.getDimensionViews()) {
            DimensionMeta dimensionMeta = dimensionView.getDimensionDef();
            DimensionType dimType = dimensionMeta.getDimensionType();
            if ("measure".equalsIgnoreCase(dimType.getName())) continue;
            selectSubSQL.append(dimensionMeta.getTablename(pubNumber)).append(" AS ").append(QU).append(dimType.getName()).append(QU).append(",");
        }
        selectSubSQL.deleteCharAt(selectSubSQL.length() - 1);
        selectSubSQL.append(" where ");
        for (Map.Entry entry : mapping.entrySet()) {
            String string = (String)entry.getKey();
            GeneralSQLMappingModel mm = (GeneralSQLMappingModel)entry.getValue();
            if (string.indexOf("type.nonMeasure.commonDimension.") == 0) {
                for (DimensionView dimView : dimViewRef.getDimensionViews()) {
                    DimensionMeta dimMeta = dimView.getDimensionDef();
                    DimensionType dimType = dimMeta.getDimensionType();
                    if (!dimType.getName().equals(mm.getTag())) continue;
                    String bizKey = dimMeta.getBizKey();
                    selectSubSQL.append(QU).append(this.getTempTableName()).append(QU).append(".").append(QU).append(mm.getSrc()).append(QU);
                    selectSubSQL.append("=").append(QU).append(mm.getTag()).append(QU).append(".").append(bizKey).append(" and ");
                }
            }
            if (string.indexOf("type.nonMeasure.timeDimension.") != 0) continue;
            String timeField = QU + this.getTempTableName() + QU + "." + mm.getSrc();
            selectSubSQL.append("YEAR(").append(timeField).append(")=").append(QU).append(mm.getTag()).append(QU).append(".fyear").append(" and ");
            selectSubSQL.append("MONTH(").append(timeField).append(")=").append(QU).append(mm.getTag()).append(QU).append(".fmonth").append(" and ");
            selectSubSQL.append("DAYOFMONTH(").append(timeField).append(")=").append(QU).append(mm.getTag()).append(QU).append(".fday").append(" and ");
        }
        selectSubSQL.delete(selectSubSQL.lastIndexOf(" and "), selectSubSQL.length() - 1);
        return selectSubSQL;
    }

    private StringBuffer getInsertSQL(DimensionType[] dimTypes, List measureMemberList, Map noMappingMeasureMap, String pubNumber) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(Fact.getTablename(pubNumber)).append(" ( ");
        int n = dimTypes.length;
        for (int i = 0; i < n; ++i) {
            String typeName = dimTypes[i].getName();
            if (!"measure".equalsIgnoreCase(typeName)) {
                insertSQL.append("F").append(typeName).append("ID,");
                continue;
            }
            for (String measureNumber : measureMemberList) {
                if (noMappingMeasureMap.containsKey(measureNumber)) continue;
                insertSQL.append("FM_").append(measureNumber).append(",");
                insertSQL.append("FM_").append(measureNumber).append("_flag,");
            }
        }
        if (this.hasTimeStamp) {
            insertSQL.append(Fact.getTimeStampField());
        } else {
            insertSQL.deleteCharAt(insertSQL.length() - 1);
        }
        insertSQL.append(" ) ");
        return insertSQL;
    }

    private static Map getNoMappingMeasureMap(Map mapping, List measureMemberList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : measureMemberList) {
            map.put(string, string);
        }
        for (Map.Entry entry : mapping.entrySet()) {
            GeneralSQLMappingModel model;
            String key = (String)entry.getKey();
            if (key.indexOf("type.measure.member.") != 0 || StringUtil.isEmpty((model = (GeneralSQLMappingModel)entry.getValue()).getSrc())) continue;
            map.remove(model.getTag());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getMeasureMemberList(Context ctx) throws DBCenterException, SQLException {
        Connection cn = null;
        try {
            cn = DBCenterManager.getConnection((Context)ctx, null);
            Dimension dim = this.appModel.getDimension("measure");
            List list = dim.getMembers(cn, ctx, false, false);
            return list;
        }
        finally {
            DBCenterUtil.closeConnection((Connection)cn);
        }
    }

    private static GeneralSQLMappingModel getTimeStampMappingField(GeneralDRDetailXmlModel sqlDetail) {
        return (GeneralSQLMappingModel)sqlDetail.getMapping().get("type.timeStamp.mark.tsFiled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropOldData(Context ctx, String pubNumber, boolean hasTimeStamp, Date lastUpdateDate, boolean isManualExecute, Date start, Date end) throws DBCenterException, SQLException {
        Connection cn = null;
        Object[] params = null;
        StringBuffer sb = new StringBuffer();
        sb.append("delete from ").append(Fact.getTablename(pubNumber));
        if (hasTimeStamp && lastUpdateDate != null) {
            if (isManualExecute) {
                sb.append(" where ?<=").append(Fact.getTimeStampField()).append(" and ").append(Fact.getTimeStampField()).append("<?");
                params = new Object[]{new Timestamp(start.getTime()), new Timestamp(TimeUtil.getNextDate(end).getTime())};
            } else {
                sb.append(" where ").append(Fact.getTimeStampField()).append("=?");
                params = new Object[]{new Timestamp(lastUpdateDate.getTime())};
            }
        }
        try {
            cn = DBCenterManager.getConnection((Context)ctx, (String)this.getToDBCenterId());
            DBUtil.executeUpdate(cn, sb.toString(), params);
        }
        catch (Throwable throwable) {
            DBCenterUtil.closeConnection(cn);
            throw throwable;
        }
        DBCenterUtil.closeConnection((Connection)cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getLastUpdateTime(Context ctx, String pubNumber) throws DBCenterException, SQLException {
        Connection cn;
        block3: {
            Date date;
            cn = null;
            StringBuffer sb = new StringBuffer();
            sb.append("select max(").append(Fact.getTimeStampField()).append(") from ").append(Fact.getTablename(pubNumber));
            try {
                cn = DBCenterManager.getConnection((Context)ctx, (String)this.getToDBCenterId());
                SQLDataRule.compatibleOldPublishFactTable(cn, Fact.getTablename(pubNumber));
                RDRowSet rs = DBUtil.executeQuery(sb.toString(), cn);
                if (!rs.next()) break block3;
                date = (Date)rs.getObject(0);
            }
            catch (Throwable throwable) {
                DBCenterUtil.closeConnection(cn);
                throw throwable;
            }
            DBCenterUtil.closeConnection((Connection)cn);
            return date;
        }
        Date date = null;
        DBCenterUtil.closeConnection((Connection)cn);
        return date;
    }

    private static void compatibleOldPublishFactTable(Connection cn, String factTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME='FTimeStamp' AND KSQL_COL_TABNAME='");
        sb.append(factTableName).append("'");
        StringBuffer alert = new StringBuffer();
        alert.append("ALTER TABLE ").append(factTableName).append(" ").append("ADD FTimeStamp dateTime");
        try {
            RDRowSet rs = DBUtil.executeQuery(sb.toString(), cn);
            if (rs.next()) {
                return;
            }
            DBUtil.executeUpdate(alert.toString(), cn);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private GeneralDRDetailXmlModel getSQLDataRuleDetail(Context ctx) throws DBCenterException, SQLException, JDOMException, IOException {
        if (this.sqlDetail == null) {
            Connection cn = null;
            try {
                cn = DBCenterManager.getConnection((Context)ctx, null);
                this.sqlDetail = AppModelUtil.getSQLDataRuleDetail(cn, this.schemeId);
            }
            finally {
                DBCenterUtil.closeConnection((Connection)cn);
            }
        }
        return this.sqlDetail;
    }

    public boolean isHasTimeStamp() {
        return this.hasTimeStamp;
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }

    public void appendErrorMessage(Exception e) {
        this.errorMessage.append("\u3010").append(e).append("\u3011,");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dropTempTable(Context ctx) throws DBCenterException, SQLException {
        Connection cn = null;
        try {
            cn = DBCenterManager.getConnection((Context)ctx, null);
            String sql = "drop table " + this.getTempTableName();
            int n = DBUtil.executeUpdate(sql, cn);
            return n;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private String getFromDBCenterId() {
        return this.sqlDetail.getFromDBCenterId();
    }

    private String getToDBCenterId() {
        return this.appModel.getDBCenterId();
    }

    public String getTempTableName() {
        if (StringUtil.isEmpty(this.tempTableName)) {
            this.tempTableName = SQLDataRule.createTempTableName(this.appModel.getPubnumber());
        }
        return this.tempTableName;
    }

    private static synchronized String createTempTableName(String pubNumber) {
        return "T_" + pubNumber + "_" + System.currentTimeMillis();
    }
}

