/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport.calmember;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.bireport.DimensionMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalculatorType;
import com.kingdee.bos.bi.model.rt.bireport.calmember.NullCalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.accum.AccumCalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.agg.AggCalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.history.HistoryCalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.lastmonth.LastMonthCalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.lastyear.LastYearCalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.zrate.ZRateCalMember;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class CalMemberFactory {
    public static CalMember createCalMember(Context ctx, String appmodelId, Dimension dim, String name, String caption, DimensionType dt, CalculatorType ct, String schema) {
        if (CalculatorType.agg.equals(ct)) {
            return CalMemberFactory.createAggCalMember(ctx, appmodelId, dim, name, caption, dt, schema);
        }
        if (CalculatorType.zRate.equals(ct)) {
            return CalMemberFactory.createZRateCalMember(ctx, appmodelId, dim, name, caption, dt, schema);
        }
        if (CalculatorType.lastMonth.equals(ct)) {
            return CalMemberFactory.createLastMonthCalMember(ctx, appmodelId, dim, name, caption, dt, schema);
        }
        if (CalculatorType.lastYear.equals(ct)) {
            return CalMemberFactory.createLastYearCalMember(name, caption, dt, schema);
        }
        if (CalculatorType.accum.equals(ct)) {
            return CalMemberFactory.createAccumCalMember(ctx, appmodelId, dim, name, caption, dt, schema);
        }
        if (CalculatorType.history.equals(ct)) {
            return CalMemberFactory.createHistoryCalMember(name, caption, dt, schema);
        }
        return NullCalMember.createNullCalMemberInstance();
    }

    public static CalMember fromXML(String xml, Context ctx) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalMember fromDB(DimensionMember dimMember, Context ctx) {
        StringBuffer sb = new StringBuffer();
        Dimension dimension = dimMember.getDimension();
        DimensionType dt = dimension.getDimensionDef().getDimensionType();
        String dim = dt.getName();
        String appmodelId = dimension.getAppModel().getId();
        String calName = dimMember.getName();
        sb.append("select * from T_BI_AppModel_Cal");
        sb.append(" where FAppModelID = ? ");
        sb.append(" and FDimension = ? ");
        sb.append(" and FCalName = ? ");
        Connection cn = null;
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            RDRowSet rs = DBUtil.executeQuery(sb.toString(), new Object[]{appmodelId, dim, calName}, cn);
            if (rs.next()) {
                String caption = rs.getString("FCalCaption");
                String schema = rs.getString("FCalSchema");
                CalMember calMember = CalMemberFactory.createCalMember(ctx, appmodelId, dimension, calName, caption, dt, CalculatorType.getObj(rs.getString("FCalType")), schema);
                return calMember;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return NullCalMember.createNullCalMemberInstance();
    }

    public static AggCalMember createAggCalMember(Context ctx, String appmodelId, Dimension dim, String name, String caption, DimensionType dt, String schema) {
        return new AggCalMember(ctx, appmodelId, dim, name, caption, dt, schema);
    }

    public static HistoryCalMember createHistoryCalMember(String name, String caption, DimensionType dt, String schema) {
        return new HistoryCalMember(name, caption, dt, schema);
    }

    public static LastMonthCalMember createLastMonthCalMember(Context ctx, String appmodelId, Dimension dim, String name, String caption, DimensionType dt, String schema) {
        return new LastMonthCalMember(ctx, appmodelId, dim, name, caption, dt, schema);
    }

    public static LastYearCalMember createLastYearCalMember(String name, String caption, DimensionType dt, String schema) {
        return new LastYearCalMember(name, caption, dt, schema);
    }

    public static ZRateCalMember createZRateCalMember(Context ctx, String appmodelId, Dimension dim, String name, String caption, DimensionType dt, String schema) {
        return new ZRateCalMember(ctx, appmodelId, dim, name, caption, dt, schema);
    }

    public static AccumCalMember createAccumCalMember(Context ctx, String appmodelId, Dimension dim, String name, String caption, DimensionType dt, String schema) {
        return new AccumCalMember(ctx, appmodelId, dim, name, caption, dt, schema);
    }
}

