/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dim;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.custom.general.GeneralDimensionView;
import com.kingdee.bos.bi.model.rt.dim.custom.time.TimeDimensionView;
import com.kingdee.bos.bi.model.rt.dim.measure.MeasureDimensionView;
import com.kingdee.bos.bi.model.rt.dim.metric.MetricDimensionView;
import com.kingdee.bos.bi.model.rt.dim.org.OrgDimensionView;
import com.kingdee.bos.bi.model.rt.dim.period.PeriodDimensionView;
import com.kingdee.bos.bi.model.rt.dim.year.YearDimensionView;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.util.StringUtil;

public class DimensionViewFactory {
    public static DimensionView createDimensionView(DimensionType dt, String viewId, Context ctx) {
        String type = dt.getName();
        String innerType = dt.getInnerType();
        if ("org".equalsIgnoreCase(type)) {
            return new OrgDimensionView(viewId);
        }
        if ("metric".equalsIgnoreCase(type)) {
            return new MetricDimensionView(viewId);
        }
        if ("year".equalsIgnoreCase(type)) {
            return new YearDimensionView(viewId);
        }
        if ("period".equalsIgnoreCase(type)) {
            return new PeriodDimensionView(viewId);
        }
        if ("measure".equalsIgnoreCase(type)) {
            return new MeasureDimensionView(viewId);
        }
        if (!StringUtil.isEmpty(innerType)) {
            if ("time".equalsIgnoreCase(innerType)) {
                return new TimeDimensionView(dt, viewId);
            }
            if ("general".equalsIgnoreCase(innerType)) {
                return new GeneralDimensionView(dt, viewId, ctx);
            }
        }
        return null;
    }

    public static DimensionView createDimensionView(DimensionType dt, String viewId, IManagementFacade facade) {
        String type = dt.getName();
        String innerType = dt.getInnerType();
        if ("org".equalsIgnoreCase(type)) {
            return new OrgDimensionView(viewId);
        }
        if ("metric".equalsIgnoreCase(type)) {
            return new MetricDimensionView(viewId);
        }
        if ("year".equalsIgnoreCase(type)) {
            return new YearDimensionView(viewId);
        }
        if ("period".equalsIgnoreCase(type)) {
            return new PeriodDimensionView(viewId);
        }
        if ("measure".equalsIgnoreCase(type)) {
            return new MeasureDimensionView(viewId);
        }
        if (!StringUtil.isEmpty(innerType)) {
            if ("time".equalsIgnoreCase(innerType)) {
                return new TimeDimensionView(dt, viewId);
            }
            if ("general".equalsIgnoreCase(innerType)) {
                return new GeneralDimensionView(dt, viewId, facade);
            }
        }
        return null;
    }
}

