/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dim.year;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.DB.Field;
import com.kingdee.bos.bi.model.common.mm.year.YearDimensionNode;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.rt.dim.year.Range;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class YearDimensionView
extends DimensionView {
    public YearDimensionView(String id) {
        super(DimensionType.year, id, null, null);
    }

    @Override
    public Member[] getMembers(IManagementFacade facade) throws SQLException {
        String sql = "select FYearBegin,FYearEnd from T_BI_MM_Year where FVIEWID='" + this.id + "'";
        RDRowSet rs = facade.executeQuery(sql);
        return this.getMembersFromRowSet(rs);
    }

    private Member[] getMembersFromRowSet(RDRowSet rs) {
        int start = 0;
        int end = 0;
        if (!rs.next()) {
            return null;
        }
        start = rs.getInt(0);
        end = rs.getInt(1);
        ArrayList<Member> lstMember = new ArrayList<Member>();
        for (int year = start; year <= end; ++year) {
            lstMember.add(new Member("" + year, "" + year + "\u5e74"));
        }
        return lstMember.toArray(new Member[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Member[] getMembers(Context ctx) throws SQLException {
        String sql = "select FYearBegin,FYearEnd from T_BI_MM_Year where FVIEWID='" + this.id + "'";
        RDRowSet rs = null;
        Connection cn = null;
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            rs = DBUtil.executeQuery(sql, cn);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return this.getMembersFromRowSet(rs);
    }

    public Member[] getMembers(Connection cn) throws SQLException {
        String sql = "select FYearBegin,FYearEnd from T_BI_MM_Year where FVIEWID='" + this.id + "'";
        RDRowSet rs = DBUtil.executeQuery(sql, cn);
        return this.getMembersFromRowSet(rs);
    }

    @Override
    protected void transData(String pubnumber, Connection cn) throws SQLException {
        Range r = this.getRange(this.id, cn);
        this.insertYearsData(pubnumber, this.id, r, cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range getRange(String viewid, Connection cn) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        int endYear;
        int startYear;
        block4: {
            Range range;
            startYear = 0;
            endYear = 0;
            stmt = null;
            rs = null;
            try {
                String sql = "select FYearBegin,FYearEnd from T_BI_MM_Year where FVIEWID='" + viewid + "'";
                stmt = cn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    startYear = rs.getInt("FYearBegin");
                    endYear = rs.getInt("FYearEnd");
                    break block4;
                }
                range = null;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return range;
        }
        stmt.close();
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return new Range(startYear, endYear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertYearsData(String pubnumber, String viewid, Range range, Connection cn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("insert into " + this.dm.getTablename(pubnumber) + " ");
            for (int year = range.start; year <= range.end; ++year) {
                if (year != range.start) {
                    sb.append(" union all ");
                }
                sb.append(" select ");
                List fields = this.dm.getFields();
                int len = fields.size();
                for (int i = 0; i < len; ++i) {
                    Field f = (Field)fields.get(i);
                    if (f.value == null) {
                        sb.append(year);
                        sb.append(",");
                        continue;
                    }
                    sb.append(f.value);
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            stmt = cn.prepareStatement(sb.toString());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt);
    }

    @Override
    protected void synData(String pubnumber, String viewid, Connection cn) throws SQLException {
        String tablename = this.dm.getTablename(pubnumber);
        Range rangeNew = this.getRange(viewid, cn);
        Range rangeOld = this.getRangeNow(pubnumber, cn);
        ArrayList lstNewRange = new ArrayList();
        ArrayList lstCrossRange = new ArrayList();
        ArrayList lstDelRange = new ArrayList();
        this.calcCrossRange(rangeNew, rangeOld, lstNewRange, lstCrossRange, lstDelRange);
        for (Range r : lstNewRange) {
            String sql = "delete from " + tablename + " where FYear >=" + r.start + " and FYear <=" + r.end;
            DBUtil.executeUpdate(sql, cn);
            this.insertYearsData(pubnumber, null, r, cn);
        }
        for (Range r : lstCrossRange) {
            String sql = "update " + tablename + " set FLastUpdateTime = getdate() where FYear >=" + r.start + " and FYear <=" + r.end;
            DBUtil.executeUpdate(sql, cn);
        }
        for (Range r : lstDelRange) {
            String sql = "update " + tablename + " set FFlag = 1 where FYear >=" + r.start + " and FYear <=" + r.end;
            DBUtil.executeUpdate(sql, cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range getRangeNow(String pubnumber, Connection cn) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        int end;
        int start;
        block3: {
            Range range;
            String tablename = this.dm.getTablename(pubnumber);
            start = 0;
            end = 0;
            stmt = null;
            rs = null;
            try {
                String sql = "select max(FYear),min(FYear) from " + tablename + " where FFlag is null or FFlag <> 1";
                stmt = cn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    start = rs.getInt(2);
                    end = rs.getInt(1);
                    break block3;
                }
                range = null;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return range;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return new Range(start, end);
    }

    private void calcCrossRange(Range rangeNew, Range rangeOld, List lstNewRange, List lstCrossRange, List lstDelRange) {
        if (rangeNew.start < rangeOld.start) {
            if (rangeNew.end < rangeOld.start) {
                lstNewRange.add(rangeNew);
                lstDelRange.add(rangeOld);
            } else if (rangeNew.end > rangeOld.end) {
                this.addRange(lstNewRange, rangeNew.start, rangeOld.start - 1);
                this.addRange(lstNewRange, rangeOld.end + 1, rangeNew.end);
                lstCrossRange.add(rangeOld);
            } else {
                this.addRange(lstNewRange, rangeNew.start, rangeOld.start - 1);
                this.addRange(lstCrossRange, rangeOld.start, rangeNew.end);
                this.addRange(lstDelRange, rangeNew.end + 1, rangeOld.end);
            }
        } else if (rangeNew.start > rangeOld.end) {
            lstNewRange.add(rangeNew);
            lstDelRange.add(rangeOld);
        } else if (rangeNew.end < rangeOld.end) {
            this.addRange(lstDelRange, rangeOld.start, rangeNew.start - 1);
            this.addRange(lstDelRange, rangeNew.end + 1, rangeOld.end);
            lstCrossRange.add(rangeNew);
        } else {
            this.addRange(lstDelRange, rangeOld.start, rangeNew.start - 1);
            this.addRange(lstCrossRange, rangeNew.start, rangeOld.end);
            this.addRange(lstNewRange, rangeOld.end + 1, rangeNew.end);
        }
    }

    private void addRange(List list, int start, int end) {
        if (start <= end) {
            list.add(new Range(start, end));
        }
    }

    @Override
    public AbstractTreeNode getRootNode(IManagementFacade facade) throws BIModelRemoteException {
        return YearDimensionNode.load(facade, this.id);
    }
}

