/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dupont;

import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.rt.dupont.RtTreeNode;
import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;

class MetricRtModel
implements RtTreeNode.IRtNodeValue {
    private static final Logger log = LogUtil.getPackageLogger(MetricRtModel.class);
    private String _caption;
    private Measure[] _measures;
    private AbstractExpr _formula;
    private String _formatString;

    public MetricRtModel(int measureCount) {
        this.reset(measureCount);
    }

    public void reset(int measureCount) {
        this._measures = new Measure[measureCount];
        int c = measureCount;
        for (int i = 0; i < c; ++i) {
            this._measures[i] = new Measure();
        }
    }

    public String getCaption() {
        return this._caption;
    }

    public void setCaption(String caption) {
        this._caption = caption;
    }

    public int getMeasureCount() {
        return this._measures.length;
    }

    public Measure getMeasure(int idx) {
        return this._measures[idx];
    }

    public void setFormula(AbstractExpr expr) {
        this._formula = expr;
    }

    public AbstractExpr getFormula() {
        return this._formula;
    }

    public void setFormatString(String formatString) {
        this._formatString = formatString;
    }

    public String getFormatString() {
        return this._formatString;
    }

    public static class Measure {
        public static final int PREDICT_NOCHANGE = 0;
        public static final int PREDICT_EDITED = 1;
        public static final int PREDICT_CALCULATED = 2;
        private static final Format FORMATER = Formats.getFormat((String)"0.########");
        private String _text;
        private String _formatString;
        private Variant _digital;
        private Variant _oriDigital;
        private float _unitScale = 1.0f;
        private Variant _scale;
        private String _unitText;
        private int _changeState = 0;
        private boolean _isForbidden = false;

        public String getText() {
            return this._text;
        }

        public void setFormatString(String fs) {
            this._formatString = fs;
            if (fs != null && fs.trim().endsWith("%")) {
                this.setUnitScale(0.01f);
                this.setUnitText("%");
            }
        }

        public String getFormatString() {
            return this._formatString;
        }

        private void formatText() {
            Number value = null;
            if (this._changeState == 0) {
                if (this._oriDigital != null) {
                    value = (Number)this._oriDigital.getValue();
                }
            } else {
                value = (Number)this._digital.getValue();
            }
            if (value != null) {
                if (StringUtil.isEmptyString((String)this._formatString)) {
                    this._text = value.toString();
                } else {
                    DecimalFormat df = new DecimalFormat(this._formatString);
                    this._text = df.format(value);
                }
            } else {
                this._text = "";
            }
        }

        public void setEditingDigital(BigDecimal decimal) {
            this._digital = new Variant((Object)decimal);
            if (this._unitScale != 1.0f) {
                try {
                    this._digital.multiply(this._scale);
                }
                catch (SyntaxErrorException e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
            this._changeState = 1;
            this.formatText();
        }

        public String getEditingDigital() {
            if (this._digital == null) {
                return null;
            }
            return this.makeStringForClient(this._digital);
        }

        public void setOriDigital(Variant digital) {
            this._oriDigital = digital;
            this.formatText();
        }

        public String getEditingOriDigital() {
            if (this._oriDigital == null) {
                return null;
            }
            return this.makeStringForClient(this._oriDigital);
        }

        public Variant getDigitalForCalculate() {
            if (this._changeState == 0) {
                return this._oriDigital;
            }
            return this._digital;
        }

        public void setDigitalCalculated(Variant digital) {
            this._digital = digital;
            this._changeState = 2;
            this.formatText();
        }

        private void setUnitScale(float scale) {
            this._unitScale = scale;
            this._scale = scale == 1.0f ? null : new Variant((Object)new BigDecimal(String.valueOf(scale)));
        }

        public String getUnitText() {
            return this._unitText;
        }

        private void setUnitText(String text) {
            this._unitText = text;
        }

        public int getChangeState() {
            return this._changeState;
        }

        public void clearChangeState() {
            this._changeState = 0;
            this._digital = null;
            this.formatText();
        }

        public void setForbidden(boolean isForbidden) {
            this._isForbidden = isForbidden;
        }

        public boolean isForbidden() {
            return this._isForbidden;
        }

        private String makeStringForClient(Variant v) {
            Variant var = new Variant();
            if (this._unitScale == 1.0f) {
                var.setObject(v.getValue());
            } else {
                try {
                    v.divide(this._scale, var);
                }
                catch (SyntaxErrorException e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
            String result = FORMATER.format(var).toString();
            return result;
        }
    }
}

