/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security.cell;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.security.SecureFilter;
import com.kingdee.bos.bi.model.security.SecureFilterItems;
import com.kingdee.bos.bi.model.security.SelSecurityObjects;
import com.kingdee.bos.bi.model.security.exception.BISecurityException;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class CellSecureFilter
extends SecureFilter
implements Serializable {
    private static final long serialVersionUID = -909837236052144232L;
    private Map mapBizKey;
    private Member measure;
    private static final String TAG_DIM = "dimmension";
    private static final String ATTR_DIM_NAME = "name";

    public CellSecureFilter(Member measure, SecureFilterItems filterItems, SelSecurityObjects sos, Map mapBizKey) {
        super(filterItems, sos);
        this.mapBizKey = mapBizKey;
        this.measure = measure;
    }

    public Object clone() {
        Member measureClone = (Member)this.measure.clone();
        SecureFilterItems sfiClone = (SecureFilterItems)this.filterItems.clone();
        SelSecurityObjects sosClone = (SelSecurityObjects)this.sos.clone();
        HashMap<DimensionType, Object> mapClone = null;
        if (this.mapBizKey != null) {
            mapClone = new HashMap<DimensionType, Object>();
            for (DimensionType dt : this.mapBizKey.keySet()) {
                SecureFilterItems sfis = (SecureFilterItems)this.mapBizKey.get(dt);
                mapClone.put(dt, sfis.clone());
            }
        }
        return new CellSecureFilter(measureClone, sfiClone, sosClone, mapClone);
    }

    public Map getDimFilterItems() {
        return this.mapBizKey;
    }

    public Map getMapBizKey() {
        return this.mapBizKey;
    }

    public Member getMeasure() {
        return this.measure;
    }

    public void setMeasure(Member measure) {
        this.measure = measure;
    }

    public static CellSecureFilter fromXML(String xml, Context ctx, Member measure, String objectType, String[] objectIds, AppModelView apv) throws IOException, JDOMException, BISecurityException, SQLException {
        Element e = XmlUtil.loadXmlString((String)xml);
        DimensionMeta dm = apv.getDimRef().getMeasureDimensionView().getDimensionDef();
        SecureFilterItems fis = SecureFilterItems.fromNode(e, dm);
        HashMap<DimensionType, SecureFilterItems> mapBizKey = new HashMap<DimensionType, SecureFilterItems>();
        List lstDim = e.getChildren(TAG_DIM);
        for (Element ele : lstDim) {
            String dimType = ele.getAttributeValue(ATTR_DIM_NAME);
            dm = apv.getDimRef().getDimensionView(dimType).getDimensionDef();
            SecureFilterItems sfis = SecureFilterItems.fromNode(ele, dm);
            mapBizKey.put(DimensionType.getObj(ctx, dimType), sfis);
        }
        SelSecurityObjects sos = new SelSecurityObjects(objectType, objectIds, ctx);
        return new CellSecureFilter(measure, fis, sos, mapBizKey);
    }

    @Override
    public String toXML() {
        StringBuffer xb = new StringBuffer();
        xb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        xb.append("<SFilterExp type=\"cell\" measure=\"" + this.measure.getNumber() + "\" version=\"1.0\">");
        if (this.mapBizKey != null) {
            for (DimensionType dt : this.mapBizKey.keySet()) {
                xb.append("<dimmension name=\"" + dt.getName() + "\">");
                SecureFilterItems sfis = (SecureFilterItems)this.mapBizKey.get(dt);
                xb.append(sfis.toXML());
                xb.append("</dimmension>");
            }
        }
        xb.append(this.filterItems.toXML());
        xb.append("</SFilterExp>");
        return xb.toString();
    }

    public String toSql(Context ctx) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(Number value, AppModel apv, Map mapValue, Member measure, Context ctx) throws SQLException {
        if (!this.measure.equals(measure)) {
            return false;
        }
        if (!this.sos.match(ctx)) {
            return false;
        }
        Iterator it = mapValue.keySet().iterator();
        Connection cn = null;
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            while (it.hasNext()) {
                String dimType = (String)it.next();
                Object memberValue = mapValue.get(dimType);
                DimensionType dt = DimensionType.getObj(ctx, dimType);
                if (dt == null || dt.equals(DimensionType.measure)) continue;
                SecureFilterItems sfis = (SecureFilterItems)this.mapBizKey.get(dt);
                if (sfis == null || sfis.match(memberValue, apv.getDimension(dimType), cn)) continue;
                boolean bl = false;
                return bl;
            }
            if (!this.filterItems.matchMeasure(value)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return true;
    }

    public boolean match(Context ctx) throws SQLException {
        return this.sos.match(ctx);
    }

    @Override
    public String getFilterInfo() {
        StringBuffer sb = new StringBuffer();
        if (this.mapBizKey != null) {
            for (DimensionType dt : this.mapBizKey.keySet()) {
                sb.append(dt.getAlias() + ":");
                SecureFilterItems sfis = (SecureFilterItems)this.mapBizKey.get(dt);
                sb.append(sfis.toString());
                sb.append("\n");
            }
        }
        if (this.filterItems != null) {
            sb.append(this.filterItems.toString());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getFilterInfo();
    }
}

