/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security.row;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.security.SecurityObjectType;
import com.kingdee.bos.bi.model.security.row.IRowSecure;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.Serializable;
import java.sql.SQLException;

public class RowSecureMapping
implements IRowSecure,
Serializable {
    private static final long serialVersionUID = 1L;
    private String centerId;
    private String mapTablename;
    private SecurityObjectType objectType;
    private String mapObjColumn;
    private String filterAttr;
    private String mapAttrColumn;
    private String view_id;
    private boolean usedFlag;

    public RowSecureMapping(String centerId, String mapTablename, SecurityObjectType objectType, String mapObjColumn, String filterAttr, String mapAttrColumn, String view_id, boolean usedFlag) {
        this.centerId = centerId;
        this.mapTablename = mapTablename;
        this.objectType = objectType;
        this.mapObjColumn = mapObjColumn;
        this.filterAttr = filterAttr;
        this.mapAttrColumn = mapAttrColumn;
        this.view_id = view_id;
        this.usedFlag = usedFlag;
    }

    public boolean getUsedFlag() {
        return this.usedFlag;
    }

    public void setUsedFlag(boolean usedFlag) {
        this.usedFlag = usedFlag;
    }

    public String getMapObjColumn() {
        return this.mapObjColumn;
    }

    public String getFilterAttr() {
        return this.filterAttr;
    }

    public String getMapAtrColumn() {
        return this.mapAttrColumn;
    }

    public String getViewId() {
        return this.view_id;
    }

    public String getCenterId() {
        return this.centerId;
    }

    public String getMapTable() {
        return this.mapTablename;
    }

    @Override
    public String toSql(Context ctx, Dimension dim) {
        String objectId = "";
        if (SecurityObjectType.user.equals(this.objectType)) {
            objectId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        } else if (SecurityObjectType.org.equals(this.objectType)) {
            objectId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6620\u5c04\u7c7b\u578b" + this.objectType);
        }
        StringBuffer sb = new StringBuffer();
        String bizKey = dim.getDimensionDef().getBizKey();
        sb.append(" " + bizKey + " in ");
        sb.append("(select T_STO_DIM." + bizKey + " from " + this.mapTablename + " T_STO_MAP,");
        sb.append(dim.getTablename() + " T_STO_DIM ");
        sb.append("Where T_STO_MAP." + this.mapAttrColumn + "=");
        String attrField = dim.getDimensionDef().findProperty(this.filterAttr).getField();
        sb.append("T_STO_DIM." + attrField);
        sb.append(" and ");
        sb.append("T_STO_MAP." + this.mapObjColumn + "='" + objectId + "')");
        return sb.toString();
    }

    public String getObjectId() {
        return null;
    }

    @Override
    public SecurityObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public String getSecureType() {
        return "mapping";
    }

    @Override
    public boolean match(Context ctx) throws SQLException {
        return this.usedFlag;
    }
}

