/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security.ui;

import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.DimensionViewFactory;
import com.kingdee.bos.bi.model.security.SecureFilterItems;
import com.kingdee.bos.bi.model.security.SecurityObjectType;
import com.kingdee.bos.bi.model.security.SelSecurityObjects;
import com.kingdee.bos.bi.model.security.row.RowSecureFilter;
import com.kingdee.bos.bi.model.security.row.RowSecureMapping;
import com.kingdee.bos.bi.model.security.ui.FilterMappingDialog;
import com.kingdee.bos.bi.model.security.ui.FilterMethod;
import com.kingdee.bos.bi.model.security.ui.RowFilterDialog;
import com.kingdee.bos.bi.model.security.ui.SecurityObjectSelectorListener;
import com.kingdee.bos.bi.model.security.ui.editor.ConditionStyledEditorModel;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.analysis.util.editor.EditorStyleModel;
import com.kingdee.bos.ctrl.analysis.util.editor.StyledEditor;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RowSecureDialog
extends TypicalDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger log = CommonLogger.getLogger(RowSecureDialog.class);
    private KDLabel lblList;
    private KDLabel lblInfo;
    private KDWorkButton btnAddRow;
    private KDWorkButton btnDelRow;
    private KDWorkButton btnUserMapping;
    private KDWorkButton btnOrgMapping;
    private KDTable tblList;
    private KDScrollPane scrInfo;
    private StyledEditor txtInfo;
    private KDCheckBox chkUserMapping;
    private KDCheckBox chkOrgMapping;
    private DimensionView dv;
    private List lstRSF;
    private IManagementFacade facade;
    private String dimTypename;
    private String viewId;
    private boolean userMappingUsed;
    private boolean orgMappingUsed;
    private static final String COL_KEY_TYPE = "FType";
    private static final String COL_KEY_OBJECTS = "FObjects";
    private static final String COL_KEY_FILTER = "FFilter";
    private static final String COL_KEY_METHOD = "FMethod";

    public RowSecureDialog() {
    }

    public RowSecureDialog(Dialog owner) {
        super(owner);
    }

    public RowSecureDialog(Frame owner) {
        super(owner);
    }

    public void setView(String viewId, String viewName, String dimTypename) throws SQLException {
        this.viewId = viewId;
        this.dimTypename = dimTypename;
        DimensionType dt = this.facade.getDimensionType(dimTypename);
        this.dv = DimensionViewFactory.createDimensionView(dt, viewId, this.facade);
        this.setTitle("\u6570\u636e\u6743\u9650\u8bbe\u7f6e [" + viewName + "]");
    }

    public void setFacade(IManagementFacade facade) {
        this.facade = facade;
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table tbl = thisCell.split(6, 1);
        tbl.rowStyle(0).lockHeight(25);
        tbl.rowStyle(0).setMarginBottom(5);
        tbl.rowStyle(2).lockHeight(25);
        tbl.rowStyle(2).setMarginTop(5);
        tbl.rowStyle(3).setMarginTop(5);
        tbl.rowStyle(3).lockHeight(150);
        tbl.rowStyle(4).setMarginTop(5);
        tbl.rowStyle(4).lockHeight(30);
        tbl.rowStyle(4).setMarginBottom(5);
        tbl.rowStyle(5).lockHeight(20);
        Table tbl01 = tbl.cell(0).splitCol(5);
        parent.add((Component)this.lblList, tbl01.cell(0));
        parent.add((Component)this.btnAddRow, tbl01.cell(2));
        parent.add((Component)this.btnDelRow, tbl01.cell(4));
        tbl01.colStyle(2).lockWidth(80);
        tbl01.colStyle(3).lockWidth(10);
        tbl01.colStyle(4).lockWidth(80);
        parent.add((Component)this.tblList, tbl.cell(1));
        parent.add((Component)this.lblInfo, tbl.cell(2));
        parent.add((Component)this.scrInfo, tbl.cell(3));
        Table tbl02 = tbl.cell(4).splitCol(3);
        this.chkUserMapping.setMinimumSize(new Dimension(150, 10));
        parent.add((Component)this.chkUserMapping, tbl02.cell(0));
        parent.add((Component)this.btnUserMapping, tbl02.cell(1));
        this.chkUserMapping.setSelected(false);
        this.btnUserMapping.setEnabled(false);
        tbl02.colStyle(0).lockWidth(150);
        tbl02.colStyle(1).lockWidth(80);
        Table tbl03 = tbl.cell(5).splitCol(3);
        this.chkOrgMapping.setMinimumSize(new Dimension(150, 10));
        parent.add((Component)this.chkOrgMapping, tbl03.cell(0));
        parent.add((Component)this.btnOrgMapping, tbl03.cell(1));
        this.chkOrgMapping.setSelected(false);
        this.btnOrgMapping.setEnabled(false);
        tbl03.colStyle(0).lockWidth(150);
        tbl03.colStyle(1).lockWidth(80);
        String[] columnKeys = new String[]{COL_KEY_TYPE, COL_KEY_OBJECTS, COL_KEY_FILTER, COL_KEY_METHOD};
        Object[] headNames = new String[]{"\u5bf9\u8c61\u7c7b\u578b", "\u8bbe\u7f6e\u5bf9\u8c61", "\u7b5b\u9009\u6210\u5458", "\u7b5b\u9009\u65b9\u5f0f"};
        Object[][] bodyDatas = null;
        KDTableHelper.initTable((KDTable)this.tblList, (String[])columnKeys, (Object[])headNames, (Object[][])bodyDatas);
        this.tblList.getColumn(COL_KEY_TYPE).setWidth(100);
        this.tblList.getColumn(COL_KEY_OBJECTS).setWidth(180);
        this.tblList.getColumn(COL_KEY_FILTER).setWidth(350);
        this.tblList.getColumn(COL_KEY_METHOD).setWidth(100);
        try {
            this.lstRSF = this.facade.getRowSecureItems(this.viewId, this.dimTypename);
            this.loadTableData();
            RowSecureMapping rsm = this.facade.getRowSecurityMapping(this.viewId, SecurityObjectType.user);
            if (rsm != null) {
                this.userMappingUsed = rsm.getUsedFlag();
                this.chkUserMapping.setSelected(this.userMappingUsed);
                if (this.userMappingUsed) {
                    this.btnUserMapping.setEnabled(true);
                } else {
                    this.btnUserMapping.setEnabled(false);
                }
            }
            if ((rsm = this.facade.getRowSecurityMapping(this.viewId, SecurityObjectType.org)) != null) {
                this.orgMappingUsed = rsm.getUsedFlag();
                this.chkOrgMapping.setSelected(this.orgMappingUsed);
                if (this.orgMappingUsed) {
                    this.btnOrgMapping.setEnabled(true);
                } else {
                    this.btnOrgMapping.setEnabled(false);
                }
            }
        }
        catch (BIModelRemoteException e) {
            log.error((Object)"\u88c5\u8f7d\u884c\u5b89\u5168\u5b9a\u4e49\u65f6\u51fa\u9519", (Throwable)((Object)e));
        }
        catch (SQLException e) {
            log.error((Object)"\u88c5\u8f7d\u884c\u5b89\u5168\u5b9a\u4e49\u65f6\u51fa\u9519", (Throwable)e);
        }
    }

    private void loadTableData() {
        for (RowSecureFilter rsf : this.lstRSF) {
            this.addFilterRow(rsf);
        }
    }

    protected void todoInit() {
        this.lblList = new KDLabel("\u6570\u636e\u6743\u9650\u89c4\u5219\u5217\u8868\uff1a");
        this.lblInfo = new KDLabel("\u9009\u4e2d\u884c\u7684\u7b5b\u9009\u6210\u5458\u8be6\u60c5\uff1a");
        this.btnAddRow = new KDWorkButton("\u65b0\u589e\u884c");
        this.btnAddRow.addActionListener((ActionListener)new addRowActionHandler());
        this.btnDelRow = new KDWorkButton("\u5220\u9664\u884c");
        this.btnDelRow.addActionListener((ActionListener)new delRowActionHandler());
        this.tblList = new KDTable();
        this.tblList.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int row = e.getSelectBlock().getEndRow();
                if (row == -1) {
                    return;
                }
                RowSecureDialog.this.showTipInfo((SecureFilterItems)RowSecureDialog.this.tblList.getRow(row).getCell(RowSecureDialog.COL_KEY_FILTER).getValue());
            }
        });
        this.tblList.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int curCol = e.getColIndex();
                String curColKey = RowSecureDialog.this.tblList.getColumnKey(curCol);
                int curRow = e.getRowIndex();
                if (RowSecureDialog.COL_KEY_TYPE.equalsIgnoreCase(curColKey) && e.getOldValue() != null && !e.getOldValue().equals(e.getValue())) {
                    RowSecureDialog.this.tblList.getCell(curRow, RowSecureDialog.COL_KEY_OBJECTS).setValue(null);
                }
            }
        });
        this.txtInfo = new StyledEditor((EditorStyleModel)new ConditionStyledEditorModel());
        this.txtInfo.setText("");
        this.scrInfo = new KDScrollPane((Component)this.txtInfo);
        this.scrInfo.setVerticalScrollBarPolicy(20);
        this.txtInfo.setEditable(false);
        this.btnUserMapping = new KDWorkButton("\u8bbe\u7f6e");
        this.btnUserMapping.addActionListener((ActionListener)new userMappingActionHandler());
        this.btnOrgMapping = new KDWorkButton("\u8bbe\u7f6e");
        this.btnOrgMapping.addActionListener((ActionListener)new orgMappingActionHandler());
        this.chkUserMapping = new KDCheckBox("\u542f\u7528\u7528\u6237\u6743\u9650\u8868\u6620\u5c04");
        this.chkOrgMapping = new KDCheckBox("\u542f\u7528\u7ec4\u7ec7\u6743\u9650\u8868\u6620\u5c04");
        this.chkUserMapping.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (((KDCheckBox)e.getSource()).getSelected() == 32) {
                    RowSecureDialog.this.btnUserMapping.setEnabled(true);
                } else {
                    RowSecureDialog.this.btnUserMapping.setEnabled(false);
                }
            }
        });
        this.chkOrgMapping.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (((KDCheckBox)e.getSource()).getSelected() == 32) {
                    RowSecureDialog.this.btnOrgMapping.setEnabled(true);
                } else {
                    RowSecureDialog.this.btnOrgMapping.setEnabled(false);
                }
            }
        });
    }

    protected boolean verify() {
        int rows = this.tblList.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IRow row_RX = this.tblList.getRow(i);
            SelSecurityObjects so = (SelSecurityObjects)row_RX.getCell(COL_KEY_OBJECTS).getValue();
            if (so == null) {
                WindowUtil.msgboxError((Object)("\u7b2c" + (i + 1) + "\u884c\u7b5b\u9009\u5bf9\u8c61\u672a\u9009\u62e9\uff01"), (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
                return false;
            }
            SecureFilterItems sfis = (SecureFilterItems)row_RX.getCell(COL_KEY_FILTER).getValue();
            if (sfis == null) {
                WindowUtil.msgboxError((Object)("\u7b2c" + (i + 1) + "\u884c\u7b5b\u9009\u6761\u4ef6\u672a\u9009\u62e9\uff01"), (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
                return false;
            }
            FilterMethod fm = (FilterMethod)row_RX.getCell(COL_KEY_METHOD).getValue();
            if (fm != null) continue;
            WindowUtil.msgboxError((Object)("\u7b2c" + (i + 1) + "\u884c\u7b5b\u9009\u65b9\u5f0f\u672a\u9009\u62e9\uff01"), (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
            return false;
        }
        return true;
    }

    public void save() throws SQLException {
        boolean orgChecked;
        this.facade.delRowSecurityFilterItems(this.viewId);
        int rows = this.tblList.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IRow row_RX = this.tblList.getRow(i);
            SelSecurityObjects so = (SelSecurityObjects)row_RX.getCell(COL_KEY_OBJECTS).getValue();
            SecureFilterItems sris = (SecureFilterItems)row_RX.getCell(COL_KEY_FILTER).getValue();
            FilterMethod fm = (FilterMethod)row_RX.getCell(COL_KEY_METHOD).getValue();
            RowSecureFilter rsf = new RowSecureFilter(sris, so, fm);
            this.facade.saveRowSecurityFilterItem(this.viewId, i, rsf);
        }
        boolean userChecked = this.chkUserMapping.getSelected() == 32;
        boolean bl = orgChecked = this.chkOrgMapping.getSelected() == 32;
        if (userChecked != this.userMappingUsed) {
            this.facade.saveRowSecurityMappingStatus(this.viewId, userChecked, SecurityObjectType.user);
        }
        if (orgChecked != this.orgMappingUsed) {
            this.facade.saveRowSecurityMappingStatus(this.viewId, orgChecked, SecurityObjectType.org);
        }
    }

    private void addFilterRow(RowSecureFilter rsf) {
        IRow row_RX = this.tblList.addRow();
        SecurityObjectType st = SecurityObjectType.user;
        ICell cell = row_RX.getCell(COL_KEY_TYPE);
        KDComboBox cmbType = new KDComboBox();
        SecurityObjectType[] types = SecurityObjectType.getAllObjs();
        for (int i = 0; i < types.length; ++i) {
            cmbType.addItem((Object)types[i]);
        }
        cmbType.setSelectedIndex(0);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbType));
        if (rsf != null) {
            st = rsf.getSecurityObjects().getType();
        }
        cell.setValue((Object)st);
        cell = row_RX.getCell(COL_KEY_OBJECTS);
        KDPromptBox promFilterObject = new KDPromptBox();
        promFilterObject.setEditable(false);
        promFilterObject.addSelectorListener((SelectorListener)new SecurityObjectSelectorListener(row_RX.getCell(COL_KEY_TYPE), cell, this.getRootPane(), this.facade));
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promFilterObject));
        if (rsf != null) {
            cell.setValue((Object)rsf.getSecurityObjects());
        }
        cell = row_RX.getCell(COL_KEY_FILTER);
        KDPromptBox promFilterCondition = new KDPromptBox();
        promFilterCondition.setEditable(false);
        promFilterCondition.addSelectorListener((SelectorListener)new RowFilterListerner(cell));
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promFilterCondition));
        if (rsf != null) {
            cell.setValue((Object)rsf.getFilterItems());
        }
        cell = row_RX.getCell(COL_KEY_METHOD);
        KDComboBox cmbFilterMethod = new KDComboBox();
        FilterMethod[] fms = FilterMethod.getAllObjs();
        for (int i = 0; i < fms.length; ++i) {
            cmbFilterMethod.addItem((Object)fms[i]);
        }
        cmbFilterMethod.setSelectedIndex(0);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbFilterMethod));
        if (rsf != null) {
            cell.setValue((Object)rsf.getFilterMethod());
        } else {
            cell.setValue((Object)FilterMethod.include);
        }
    }

    private void showTipInfo(SecureFilterItems sfis) {
        this.txtInfo.setText(sfis == null ? "" : sfis.toString());
    }

    private void delFilterRow() {
        if (this.checkSelectedTbl(this.tblList)) {
            ArrayList selectBlocks = this.tblList.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            for (int i = 0; i < selectBlocks.size(); ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u5220\u9664\uff01", (String)this.getTitle(), (Component)((Object)this));
                    return;
                }
                this.tblList.removeRow(selectBlock.getTop());
            }
        }
    }

    private boolean checkSelectedTbl(KDTable tblMain) {
        if (tblMain.getRowCount() == 0 || tblMain.getSelectManager().size() == 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    class orgMappingActionHandler
    implements ActionListener {
        orgMappingActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterMappingDialog dlg = (FilterMappingDialog)((Object)WindowUtil.createWindow(FilterMappingDialog.class, (Component)RowSecureDialog.this.getRootPane()));
            dlg.setSize(500, 300);
            dlg.setTitle("\u7ec4\u7ec7\u6620\u5c04");
            dlg.setParameter(RowSecureDialog.this.dv, RowSecureDialog.this.facade, SecurityObjectType.org, RowSecureDialog.this.orgMappingUsed);
            if (dlg.showDialog()) {
                dlg.save();
            }
        }
    }

    class userMappingActionHandler
    implements ActionListener {
        userMappingActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterMappingDialog dlg = (FilterMappingDialog)((Object)WindowUtil.createWindow(FilterMappingDialog.class, (Component)RowSecureDialog.this.getRootPane()));
            dlg.setSize(500, 300);
            dlg.setTitle("\u7528\u6237\u6620\u5c04");
            dlg.setParameter(RowSecureDialog.this.dv, RowSecureDialog.this.facade, SecurityObjectType.user, RowSecureDialog.this.userMappingUsed);
            if (dlg.showDialog()) {
                dlg.save();
            }
        }
    }

    class delRowActionHandler
    implements ActionListener {
        delRowActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RowSecureDialog.this.delFilterRow();
        }
    }

    class addRowActionHandler
    implements ActionListener {
        addRowActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RowSecureDialog.this.addFilterRow(null);
        }
    }

    class RowFilterListerner
    implements SelectorListener {
        ICell cell;

        public RowFilterListerner(ICell cell) {
            this.cell = cell;
        }

        public void willShow(SelectorEvent e) {
            RowFilterDialog dlg = (RowFilterDialog)((Object)WindowUtil.createWindow(RowFilterDialog.class, (Component)RowSecureDialog.this.getRootPane()));
            dlg.setSize(800, 600);
            dlg.setTitle("\u9009\u62e9\u7b5b\u9009\u6210\u5458");
            dlg.setDimensionView(RowSecureDialog.this.dv, RowSecureDialog.this.facade);
            dlg.setCurrentValue((SecureFilterItems)this.cell.getValue());
            if (dlg.showDialog()) {
                SecureFilterItems sfis = dlg.getRowSecureFilterItems();
                this.cell.setValue((Object)sfis);
                RowSecureDialog.this.showTipInfo(sfis);
            }
        }
    }
}

