/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.content;

import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.content.ContentTable;
import com.kingdee.bos.bi.model.ui.content.ICanRefresh;
import com.kingdee.bos.bi.model.ui.context.BIModelConsoleContext;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.console.AbstractConsoleAction;
import com.kingdee.bos.ctrl.common.ui.console.content.AbstractConsoleContent;
import com.kingdee.bos.ctrl.common.ui.console.content.IConsoleContent;
import com.kingdee.bos.ctrl.common.ui.console.content.ILeafContent;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class AbstractContent
extends AbstractConsoleContent
implements ILeafContent,
ICanRefresh {
    protected static final Logger log = LogUtil.getPackageLogger(AbstractContent.class);
    private KDPanel _panAll;
    private String _caption;
    Map sortParams = null;

    public abstract String getViewType();

    public abstract String getDimensionType();

    public AbstractContent(String caption) {
        this.setCaption(caption);
        this.initListener();
    }

    private void initListener() {
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (SwingUtilities.isLeftMouseButton((MouseEvent)e) && e.getClickCount() == 2 && e.getType() == 1) {
                    AbstractContent.this.doDoubleClickTable(e);
                }
            }
        });
        this.getTable().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                AbstractContent.this.selChanged(AbstractContent.this.getRowAttrs(((ContentTable)((Object)e.getSource())).getSelectionRow()));
            }
        });
    }

    protected void selChanged(Map rowAttrs) {
    }

    protected void doDoubleClickTable(KDTMouseEvent e) {
        this.viewDetail(e.getRowIndex());
    }

    protected abstract void viewDetail(int var1);

    public void installCtrl(JPanel panel) {
        if (this._panAll == null) {
            this._panAll = new KDPanel((LayoutManager)new BorderLayout());
            ContentTable t = this.getTable();
            this._panAll.add((Component)((Object)t), (Object)"Center");
            t.setParent((Component)this._panAll);
        }
        this.refresh();
        panel.add((Component)this._panAll, "Center");
    }

    protected abstract ContentTable getTable();

    protected void addPopMenuItem(AbstractConsoleAction action) {
        if (action == null) {
            this.getTable().getPopMenu().add((Component)new KDSeparator());
            return;
        }
        action.setUI((IConsoleContent)this);
        this.getTable().getPopMenu().add((JMenuItem)new KDMenuItem((Action)action));
    }

    protected IManagementFacade getManFacade() throws BIModelRemoteException {
        if (this.getContext() instanceof BIModelConsoleContext) {
            return ((BIModelConsoleContext)this.getContext()).getManController();
        }
        throw new RuntimeException("Context must be BIModelConsoleContext.");
    }

    @Override
    public void refresh() {
        Map allAttrs;
        try {
            IManagementFacade facade = this.getManFacade();
            allAttrs = this.refreshImpl(facade, this.sortParams);
        }
        catch (BIModelRemoteException ex) {
            log.error((Object)"Error when refresh.", (Throwable)((Object)ex));
            return;
        }
        this.getTable().removeRows();
        if (allAttrs != null) {
            this.updateTable(allAttrs);
        }
    }

    public void sort(KDTable table) {
        if (table == null) {
            return;
        }
        KDTSortManager kdsm = new KDTSortManager(table){

            public void sort(int colIndex, int sortType) {
                super.sort(colIndex, sortType);
                if (AbstractContent.this.sortParams == null) {
                    AbstractContent.this.sortParams = new HashMap();
                }
                AbstractContent.this.sortParams.put("sortType", this.table.getColumnKey(colIndex));
                if (sortType == 0) {
                    AbstractContent.this.sortParams.put("sortOrder", "asc");
                } else {
                    AbstractContent.this.sortParams.put("sortOrder", "desc");
                }
                AbstractContent.this.sortKDT(AbstractContent.this.sortParams);
            }
        };
    }

    private void sortKDT(Map sortParams) {
        Map allAttrs;
        try {
            allAttrs = this.refreshImpl(this.getManFacade(), sortParams);
        }
        catch (BIModelRemoteException ex) {
            log.error((Object)"Error when sort.", (Throwable)((Object)ex));
            return;
        }
        this.getTable().removeRows();
        if (allAttrs != null) {
            this.updateTable(allAttrs);
        }
    }

    protected abstract Map refreshImpl(IManagementFacade var1, Map var2) throws BIModelRemoteException;

    protected abstract void updateTable(Map var1);

    protected String getRowID(int r) {
        return (String)this.getRowAttrs(r).get("ID");
    }

    protected String getRowName(int r) {
        return (String)this.getRowAttrs(r).get("NAME");
    }

    protected int findRow(String id) {
        int len = this.getTable().getRowCount();
        for (int r = 0; r < len; ++r) {
            if (!id.equals(this.getRowAttrs(r).get("ID"))) continue;
            return r;
        }
        return -1;
    }

    protected HashMap getRowAttrs(int r) {
        return (HashMap)this.getTable().getRowUserObject(r);
    }

    protected boolean isPublish(int r) {
        return "1".equalsIgnoreCase((String)this.getRowAttrs(r).get("USEFLAG"));
    }

    protected int checkTableSingleSelection(String title) {
        int idx = this.getTable().getSelectionRow();
        if (idx < 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u5728\u5217\u8868\u4e2d\u9009\u4e2d\u64cd\u4f5c\u7684\u76ee\u6807\u884c\u3002", (String)title, (Component)this.getRootCtrl());
            return -1;
        }
        if (this.getTable().getSelectManager().getBlocks().size() > 1) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u5355\u9009\u64cd\u4f5c\u7684\u76ee\u6807\u884c\u3002", (String)title, (Component)this.getRootCtrl());
            return -1;
        }
        return idx;
    }

    public String getCaption() {
        return this._caption;
    }

    public void setCaption(String caption) {
        this._caption = caption;
    }
}

