/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.content;

import com.kingdee.bos.bi.model.common.bireport.BIReportModel;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.content.AbstractLeafViewUI;
import com.kingdee.bos.bi.model.ui.dialog.bireport.BIReportDialog;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import java.awt.Component;
import java.sql.SQLException;
import java.util.Map;

public class BIReportUI
extends AbstractLeafViewUI {
    public BIReportUI(String caption) {
        super(caption);
    }

    @Override
    public String getViewType() {
        return "bireport";
    }

    @Override
    protected Map refreshImpl(IManagementFacade facade, Map sortParams) throws BIModelRemoteException {
        return facade.getViews(this.getViewType(), sortParams);
    }

    @Override
    protected void viewDetail(int rowIdx) {
        String viewId = this.getRowID(rowIdx);
        String viewName = this.getRowName(rowIdx);
        try {
            if (!this.checkViewIdExist(viewId)) {
                WindowUtil.msgboxWarning((Object)(viewName + "\r\n\u8be5\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5c1d\u8bd5\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002"), (String)this.createTitle("\u67e5\u770b", viewName), (Component)this.getRootCtrl());
                return;
            }
        }
        catch (BIModelRemoteException ex) {
            log.error((Object)"", (Throwable)((Object)ex));
            return;
        }
        this.innerEdit(viewId, viewName, "\u67e5\u770b", true, new Boolean(this.getPubFlag()));
    }

    @Override
    protected void doEdit(String viewId, String viewName) {
        this.innerEdit(viewId, viewName, "\u7f16\u8f91", false, new Boolean(this.getPubFlag()));
    }

    @Override
    protected boolean innerEdit(String viewId, String viewName, String operate, boolean isReadOnly, Object param) {
        BIReportDialog dlg = (BIReportDialog)((Object)WindowUtil.createWindow(BIReportDialog.class, (Component)((Object)this.getTable())));
        dlg.setTitle(this.createTitle(operate, viewName));
        dlg.setSize(950, 700);
        dlg.setReadOnly(isReadOnly);
        BIReportModel bireportModel = null;
        try {
            IManagementFacade facade = this.getManFacade();
            dlg.setFacade(facade);
            bireportModel = facade.getBIReportModel(viewId);
            dlg.setBIReportDef(bireportModel);
        }
        catch (BIModelRemoteException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (dlg.showDialog()) {
            try {
                if (null != bireportModel) {
                    bireportModel.setModelType(0);
                    bireportModel.setRefModelId(dlg.getSelectAppModel());
                    bireportModel.setLayout(dlg.getReportLayout());
                    bireportModel.setDiscription(dlg.getBIReportDiscription());
                    this.getManFacade().saveBIReport(viewId, bireportModel);
                }
            }
            catch (BIModelRemoteException e) {
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public String getDimensionTypename() {
        return null;
    }

    @Override
    public String getDimensionType() {
        return null;
    }
}

