/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.content;

import com.kingdee.bos.bi.model.common.mm.customdim.AbstractCustomDimModel;
import com.kingdee.bos.bi.model.common.mm.customdim.CustomDimUtil;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.BIModelManageConsoleHelper;
import com.kingdee.bos.bi.model.ui.content.AbstractBranchViewUI;
import com.kingdee.bos.bi.model.ui.content.AbstractContent;
import com.kingdee.bos.bi.model.ui.content.GeneralDimensionUI;
import com.kingdee.bos.bi.model.ui.content.TimeDimensionUI;
import com.kingdee.bos.bi.model.ui.dialog.customDim.CustomDimensionDialogFactory;
import com.kingdee.bos.bi.model.ui.dialog.customDim.ICustomDim;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.ui.resource.Resource;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import java.awt.Component;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CustomDefineDimensionUI
extends AbstractBranchViewUI {
    public CustomDefineDimensionUI(String captoin) {
        super(captoin);
    }

    @Override
    public String getViewType() {
        return "custom";
    }

    @Override
    public void addNew(String type) {
        String name = null;
        String id = null;
        String dimensionType = null;
        AbstractCustomDimModel model = null;
        ICustomDim dlg = this.createNewCustomDimensionDialog(type);
        dlg.setTitle("\u65b0\u5efa" + this.getCaption() + ("time".equalsIgnoreCase(type) ? "\u65f6\u95f4\u7ef4\u5ea6" : "\u666e\u901a\u7ef4\u5ea6"));
        if (dlg.showDialog()) {
            model = dlg.getModel();
            try {
                id = CustomDimUtil.save(this.getManFacade(), null, model);
                name = model.getName();
                dimensionType = model.getNumber();
            }
            catch (BIModelRemoteException e) {
                log.error((Object)"\u65b0\u589e\u7ef4\u5ea6\u5931\u8d25\uff1a", (Throwable)((Object)e));
                WindowUtil.msgboxInfo((Object)("\u65b0\u5efa\u7ef4\u5ea6\u5931\u8d25\uff1a" + e), (String)this.createTitle("\u65b0\u5efa", model.getName()), (Component)this.getRootCtrl());
            }
        }
        this.refresh();
        if (model == null) {
            return;
        }
        this.addLeafContent(type, name, id, dimensionType);
        try {
            model.createTable(this.getManFacade());
        }
        catch (BIModelRemoteException e) {
            log.error((Object)"\u83b7\u53d6facade\u5931\u8d25\uff1a", (Throwable)((Object)e));
            WindowUtil.msgboxInfo((Object)("\u65b0\u5efa\u7ef4\u5ea6\u6570\u636e\u8868\u5931\u8d25\uff1a\u83b7\u53d6facade\u5931\u8d25\uff0c" + e), (String)this.createTitle("\u65b0\u5efa", model.getName()), (Component)this.getRootCtrl());
        }
        catch (SQLException e) {
            log.error((Object)"\u65b0\u5efa\u7ef4\u5ea6\u6570\u636e\u8868\u5931\u8d25\uff1a", (Throwable)e);
            WindowUtil.msgboxInfo((Object)("\u65b0\u5efa\u7ef4\u5ea6\u6570\u636e\u8868\u5931\u8d25\uff1a" + e), (String)this.createTitle("\u65b0\u5efa", model.getName()), (Component)this.getRootCtrl());
        }
    }

    private ICustomDim createNewCustomDimensionDialog(String type) {
        ICustomDim dlg = CustomDimensionDialogFactory.createNewCustomDimensionDialog(type, this.getRootCtrl());
        dlg.setChecker(new ICustomDim.IChecker(){

            @Override
            public boolean isNumberExists(String dimType, String number, String dialogTitle, Component parentCtrl) {
                try {
                    if (CustomDimUtil.checkCustomDefNumberDefault(number)) {
                        WindowUtil.msgboxWarning((Object)"\u7ef4\u5ea6\u7f16\u7801\u4e0e\u9ed8\u8ba4\u7ef4\u5ea6\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01", (String)dialogTitle, (Component)parentCtrl);
                        return false;
                    }
                    if (CustomDimUtil.checkCustomDefNumberExist(CustomDefineDimensionUI.this.getManFacade(), CustomDefineDimensionUI.this.getViewType(), dimType, number)) {
                        WindowUtil.msgboxWarning((Object)"\u7ef4\u5ea6\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01", (String)dialogTitle, (Component)parentCtrl);
                        return false;
                    }
                }
                catch (BIModelRemoteException e) {
                    AbstractContent.log.error((Object)"\u6821\u9a8c\u7ef4\u5ea6\u7f16\u7801\u662f\u5426\u5b58\u5728\u65f6\u51fa\u9519\uff1a", (Throwable)((Object)e));
                    WindowUtil.msgboxWarning((Object)"\u6821\u9a8c\u7f16\u7801\u662f\u5426\u5b58\u5728\u65f6\u51fa\u9519\uff01", (String)dialogTitle, (Component)parentCtrl);
                    return false;
                }
                catch (SQLException e) {
                    AbstractContent.log.error((Object)"\u6821\u9a8c\u7ef4\u5ea6\u7f16\u7801\u662f\u5426\u5b58\u5728\u65f6\u51fa\u9519\uff1a", (Throwable)e);
                    WindowUtil.msgboxWarning((Object)"\u6821\u9a8c\u7f16\u7801\u662f\u5426\u5b58\u5728\u65f6\u51fa\u9519\uff01", (String)dialogTitle, (Component)parentCtrl);
                    return false;
                }
                return true;
            }
        });
        return dlg;
    }

    @Override
    protected Map refreshImpl(IManagementFacade facade, Map sortParams) throws BIModelRemoteException {
        HashMap<String, String> parm = new HashMap<String, String>();
        parm.put("DIR", "\u81ea\u5b9a\u4e49");
        if (sortParams != null) {
            parm.putAll(sortParams);
        }
        return facade.getViews(this.getViewType(), parm);
    }

    @Override
    protected void viewDetail(int rowIdx) {
        String operator = "\u67e5\u770b";
        String viewId = this.getRowID(rowIdx);
        String viewType = this.getRowType(rowIdx);
        String viewName = this.getRowName(rowIdx);
        String viewNumber = this.getRowNumber(rowIdx);
        try {
            if (!this.checkDimIdExist(viewId)) {
                WindowUtil.msgboxWarning((Object)(viewName + "\r\n\u8be5\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5c1d\u8bd5\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002"), (String)this.createTitle(operator, viewName), (Component)this.getRootCtrl());
                return;
            }
        }
        catch (BIModelRemoteException e) {
            log.error((Object)e);
            return;
        }
        catch (SQLException e) {
            log.error((Object)e);
            return;
        }
        AbstractCustomDimModel model = this.loadModel(viewType, viewNumber, this.createMsgTitle(operator, viewName));
        this.innerEdit(viewType, viewId, viewName, operator, true, model);
    }

    private AbstractCustomDimModel loadModel(String viewType, String viewNumber, String msgTitle) {
        AbstractCustomDimModel model = null;
        try {
            model = CustomDimUtil.load(viewType, viewNumber, this.getManFacade());
        }
        catch (BIModelRemoteException e) {
            log.error((Object)"", (Throwable)((Object)e));
            WindowUtil.msgboxInfo((Object)("\u4e0d\u80fd\u6b63\u786e\u8bfb\u53d6\u5185\u5bb9\u3002" + e.getMessage()), (String)msgTitle, (Component)this.getRootCtrl());
        }
        return model;
    }

    private String createMsgTitle(String operator, String viewName) {
        return this.createTitle(operator, viewName);
    }

    @Override
    protected void doEdit(String viewType, String viewId, String viewName, String viewNumber) {
        AbstractCustomDimModel model = this.loadModel(viewType, viewNumber, this.createMsgTitle("\u7f16\u8f91", viewName));
        boolean isEdited = this.innerEdit(viewType, viewId, viewName, "\u7f16\u8f91", false, model);
        this.refresh();
        if (isEdited && model != null) {
            this.removeUINode(viewId);
            this.addLeafContent(viewType, model.getName(), viewId, model.getNumber());
        }
    }

    @Override
    protected boolean innerEdit(String viewType, String viewId, String viewName, String operator, boolean isReadOnly, Object param) {
        AbstractCustomDimModel m = (AbstractCustomDimModel)param;
        ICustomDim dlg = CustomDimensionDialogFactory.createNewCustomDimensionDialog(viewType, this.getRootCtrl());
        dlg.setTitle(this.createTitle(operator, viewName));
        dlg.setModel(m);
        dlg.setReadOnly(isReadOnly);
        try {
            dlg.setIsExistView(m.isExistView(this.getManFacade(), viewId));
        }
        catch (BIModelRemoteException e) {
            log.error((Object)e);
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        if (dlg.showDialog()) {
            AbstractCustomDimModel newModel = dlg.getModel();
            try {
                CustomDimUtil.save(this.getManFacade(), viewId, newModel);
                newModel.alertColumn(this.getManFacade(), newModel.getFields(false));
            }
            catch (BIModelRemoteException e) {
                WindowUtil.msgboxInfo((Object)("\u4e0d\u80fd\u6b63\u786e\u4fdd\u5b58\u5185\u5bb9\u3002" + e.getMessage()), (String)dlg.getTitle(), (Component)this.getRootCtrl());
                log.error((Object)"", (Throwable)((Object)e));
                return false;
            }
            catch (SQLException e) {
                WindowUtil.msgboxInfo((Object)("\u4e0d\u80fd\u6b63\u786e\u66f4\u65b0\u8868\u3002" + e.getMessage()), (String)dlg.getTitle(), (Component)this.getRootCtrl());
                log.error((Object)"", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void addLeafContent(String type, String name, String number, String dimensionType) {
        if ("time".equalsIgnoreCase(type)) {
            TimeDimensionUI time = new TimeDimensionUI(name, number, dimensionType);
            BIModelManageConsoleHelper.addContentFunction(time);
            this.addLeaf(time, Resource.ICON_TIME_DIMENSION);
        } else if ("general".equalsIgnoreCase(type)) {
            GeneralDimensionUI general = new GeneralDimensionUI(name, number, dimensionType);
            BIModelManageConsoleHelper.addContentFunction(general);
            this.addLeaf(general, Resource.ICON_GENERAL_DIMENSION);
        }
    }

    public void dataPermission() {
    }

    @Override
    public void dataSecurity() {
    }

    @Override
    public String getDimensionType() {
        return null;
    }
}

