/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog;

import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class EditableTree {
    private KDTree _tree;
    private ITreeCustomTailor _tailor;
    private KDWorkButton _btnNewNode;
    private KDWorkButton _btnNewChild;
    private KDWorkButton _btnModifyNode;
    private KDWorkButton _btnDeleteNode;
    private KDWorkButton _btnMoveUp;
    private KDWorkButton _btnMoveDown;
    private ArrayList _customOperates;

    public EditableTree() {
        this.init();
    }

    private void init() {
        this._tree = new KDTree();
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.getSelectionModel().setSelectionMode(1);
        AbstractTreeNode rootNode = new AbstractTreeNode();
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)rootNode);
        KingdeeTreeModel mo = new KingdeeTreeModel((TreeNode)root);
        this._tree.setModel((TreeModel)mo);
    }

    public KDTreeView createTreeView() {
        KDTreeView tv = new KDTreeView(this._tree);
        tv.setShowButton(false);
        if (this._customOperates != null) {
            for (int i = 0; i < this._customOperates.size(); ++i) {
                KDWorkButton btn = (KDWorkButton)this._customOperates.get(i);
                tv.getControlPane().add((Component)btn);
            }
        }
        this._btnNewNode = new KDWorkButton((Action)new ActionNewNode());
        this._btnNewChild = new KDWorkButton((Action)new ActionNewChildNode());
        this._btnModifyNode = new KDWorkButton((Action)new ActionModifyNode());
        this._btnDeleteNode = new KDWorkButton((Action)new ActionDeleteNode());
        this._btnMoveUp = new KDWorkButton((Action)new ActionMoveUp());
        this._btnMoveDown = new KDWorkButton((Action)new ActionMoveDown());
        tv.getControlPane().add((Component)this._btnNewNode);
        tv.getControlPane().add((Component)this._btnNewChild);
        tv.getControlPane().add((Component)this._btnModifyNode);
        tv.getControlPane().add((Component)this._btnDeleteNode);
        tv.getControlPane().add((Component)this._btnMoveUp);
        tv.getControlPane().add((Component)this._btnMoveDown);
        return tv;
    }

    public KDTree getTree() {
        return this._tree;
    }

    public void addCustomOperate(KDWorkButton btn) {
        if (this._customOperates == null) {
            this._customOperates = new ArrayList();
        }
        this._customOperates.add(btn);
    }

    public void setReadOnly(boolean isReadOnly) {
        this._btnNewNode.setVisible(!isReadOnly);
        this._btnNewChild.setVisible(!isReadOnly);
        this._btnModifyNode.setVisible(!isReadOnly);
        this._btnDeleteNode.setVisible(!isReadOnly);
        this._btnMoveUp.setVisible(!isReadOnly);
        this._btnMoveDown.setVisible(!isReadOnly);
        if (this._customOperates != null) {
            for (int i = 0; i < this._customOperates.size(); ++i) {
                KDWorkButton btn = (KDWorkButton)this._customOperates.get(i);
                btn.setVisible(!isReadOnly);
            }
        }
    }

    public void setCustomTailor(ITreeCustomTailor tailor) {
        this._tailor = tailor;
    }

    private ITreeCustomTailor getCustomTailor() {
        if (this._tailor == null) {
            throw new RuntimeException("You must setCustomTailor first.");
        }
        return this._tailor;
    }

    private DefaultKingdeeTreeNode getSelectedNode() {
        TreePath path = this._tree.getSelectionPath();
        if (path != null) {
            return (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    private boolean modifyNode(DefaultKingdeeTreeNode node) {
        if (node == null) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u8981\u7f16\u8f91\u7684\u76ee\u6807\u8282\u70b9\u3002", (String)"\u7f16\u8f91\u8282\u70b9", (Component)this._tree);
            return false;
        }
        if (this.getCustomTailor().modifyNode(this._tree, node)) {
            ((KingdeeTreeModel)this._tree.getModel()).nodeChanged((TreeNode)node);
            return true;
        }
        return false;
    }

    private DefaultKingdeeTreeNode addNewNode(DefaultKingdeeTreeNode parentNode) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode();
        this.getCustomTailor().initNewNode(this._tree, newNode);
        this._tree.addNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode);
        this._tree.setSelectionNode(newNode);
        return newNode;
    }

    private static boolean checkCanMove(JComponent parentCtrl, DefaultKingdeeTreeNode node) {
        if (node == null) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u8981\u79fb\u52a8\u7684\u76ee\u6807\u8282\u70b9\u3002", (String)"\u79fb\u52a8\u8282\u70b9", (Component)parentCtrl);
            return false;
        }
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
        if (parentNode == null) {
            WindowUtil.msgboxInfo((Object)"\u6839\u8282\u70b9\u4e0d\u80fd\u79fb\u52a8\u3002", (String)"\u79fb\u52a8\u8282\u70b9", (Component)parentCtrl);
            return false;
        }
        return true;
    }

    public static interface ITreeCustomTailor {
        public void initNewNode(KDTree var1, DefaultKingdeeTreeNode var2);

        public boolean modifyNode(KDTree var1, DefaultKingdeeTreeNode var2);

        public boolean isMultiRootSupported();

        public void modelChanged(String var1);
    }

    private class ActionMoveDown
    extends AbstractAction {
        public ActionMoveDown() {
            this.putValue("Name", "\u4e0b\u79fb");
            this.putValue("ShortDescription", "\u5728\u7236\u8282\u70b9\u8303\u56f4\u5185\u4e0b\u79fb\u8282\u70b9");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = EditableTree.this.getSelectedNode();
            if (EditableTree.checkCanMove((JComponent)EditableTree.this._tree, node)) {
                int count;
                DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
                int idx = parentNode.getIndex((TreeNode)node);
                if (idx == (count = parentNode.getChildCount()) - 1) {
                    WindowUtil.msgboxInfo((Object)"\u5df2\u7ecf\u662f\u8be5\u5c42\u6700\u540e\u4e00\u4e2a\u8282\u70b9\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"\u79fb\u52a8\u8282\u70b9", (Component)EditableTree.this._tree);
                    return;
                }
                EditableTree.this._tree.removeNodeFromParent((MutableTreeNode)node);
                EditableTree.this._tree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parentNode, ++idx);
                EditableTree.this._tree.setSelectionNode(node);
                EditableTree.this.getCustomTailor().modelChanged("moveDown");
            }
        }
    }

    private class ActionMoveUp
    extends AbstractAction {
        public ActionMoveUp() {
            this.putValue("Name", "\u4e0a\u79fb");
            this.putValue("ShortDescription", "\u5728\u7236\u8282\u70b9\u8303\u56f4\u5185\u4e0a\u79fb\u8282\u70b9");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = EditableTree.this.getSelectedNode();
            if (EditableTree.checkCanMove((JComponent)EditableTree.this._tree, node)) {
                DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
                int idx = parentNode.getIndex((TreeNode)node);
                if (idx == 0) {
                    WindowUtil.msgboxInfo((Object)"\u5df2\u7ecf\u662f\u8be5\u5c42\u7b2c\u4e00\u4e2a\u8282\u70b9\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"\u79fb\u52a8\u8282\u70b9", (Component)EditableTree.this._tree);
                    return;
                }
                EditableTree.this._tree.removeNodeFromParent((MutableTreeNode)node);
                EditableTree.this._tree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parentNode, --idx);
                EditableTree.this._tree.setSelectionNode(node);
                EditableTree.this.getCustomTailor().modelChanged("moveUp");
            }
        }
    }

    private class ActionModifyNode
    extends AbstractAction {
        public ActionModifyNode() {
            this.putValue("Name", "\u7f16\u8f91");
            this.putValue("ShortDescription", "\u4fee\u6539\u8282\u70b9\u5bf9\u5e94\u7684\u5185\u5bb9");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EditableTree.this._tree.getModel().getRoot() == EditableTree.this.getSelectedNode()) {
                WindowUtil.msgboxInfo((Object)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"\u7f16\u8f91\u8282\u70b9", (Component)EditableTree.this._tree);
                return;
            }
            if (EditableTree.this.modifyNode(EditableTree.this.getSelectedNode())) {
                EditableTree.this.getCustomTailor().modelChanged("edit");
            }
        }
    }

    private class ActionDeleteNode
    extends AbstractAction {
        public ActionDeleteNode() {
            this.putValue("Name", "\u5220\u9664");
            this.putValue("ShortDescription", "\u5220\u9664\u8282\u70b9");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = EditableTree.this.getSelectedNode();
            if (node == null) {
                WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u8981\u5220\u9664\u7684\u76ee\u6807\u8282\u70b9\u3002", (String)"\u5220\u9664\u8282\u70b9", (Component)EditableTree.this._tree);
            } else if (node == EditableTree.this._tree.getModel().getRoot()) {
                if (WindowUtil.msgboxYesNo((Component)EditableTree.this._tree, (Object)"\u6ce8\u610f\uff1a\u8be5\u64cd\u4f5c\u5c06\u6e05\u9664\u9664\u6839\u8282\u70b9\u4ee5\u5916\u7684\u6240\u6709\u8282\u70b9\uff0c\u6700\u7ec8\u53ea\u6709\u6839\u8282\u70b9\u88ab\u4fdd\u7559\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"\u5220\u9664\u8282\u70b9")) {
                    EditableTree.this._tree.removeAllChildrenFromParent((MutableTreeNode)node);
                    EditableTree.this._tree.setSelectionNode(node);
                    EditableTree.this.getCustomTailor().modelChanged("delete");
                }
            } else if (WindowUtil.msgboxYesNo((Component)EditableTree.this._tree, (Object)"\u60a8\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u7684\u8282\u70b9\u5417\uff1f", (String)"\u5220\u9664\u8282\u70b9")) {
                DefaultKingdeeTreeNode nextNode = (DefaultKingdeeTreeNode)node.getNextNode();
                if (nextNode == null) {
                    nextNode = (DefaultKingdeeTreeNode)node.getPreviousNode();
                }
                EditableTree.this._tree.removeNodeFromParent((MutableTreeNode)node);
                if (nextNode != null && nextNode != EditableTree.this._tree.getModel().getRoot()) {
                    EditableTree.this._tree.setSelectionNode(nextNode);
                }
                EditableTree.this.getCustomTailor().modelChanged("delete");
            }
        }
    }

    private class ActionNewNode
    extends AbstractAction {
        public ActionNewNode() {
            this.putValue("Name", "\u65b0\u589e");
            this.putValue("ShortDescription", "\u65b0\u589e\u540c\u7ea7\u8282\u70b9");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode parentNode;
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)EditableTree.this._tree.getModel().getRoot();
            DefaultKingdeeTreeNode oriNode = null;
            if (root.getChildCount() == 0) {
                parentNode = root;
            } else {
                oriNode = EditableTree.this.getSelectedNode();
                if (oriNode == null) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u5148\u9009\u4e2d\u65b0\u589e\u4f4d\u7f6e\u540c\u7ea7\u8282\u70b9\u3002", (String)"\u65b0\u589e\u8282\u70b9", (Component)EditableTree.this._tree);
                    return;
                }
                if (root == oriNode) {
                    WindowUtil.msgboxInfo((Object)"\u865a\u62df\u6839\u8282\u70b9\u4e0d\u80fd\u6dfb\u52a0\u540c\u7ea7\u8282\u70b9\u3002", (String)"\u65b0\u589e\u8282\u70b9", (Component)EditableTree.this._tree);
                    return;
                }
                parentNode = (DefaultKingdeeTreeNode)oriNode.getParent();
                if (parentNode == root && !EditableTree.this._tailor.isMultiRootSupported()) {
                    WindowUtil.msgboxInfo((Object)"\u6839\u8282\u70b9\u4e0d\u80fd\u6dfb\u52a0\u540c\u7ea7\u8282\u70b9\u3002", (String)"\u65b0\u589e\u8282\u70b9", (Component)EditableTree.this._tree);
                    return;
                }
            }
            DefaultKingdeeTreeNode newNode = EditableTree.this.addNewNode(parentNode);
            if (EditableTree.this.modifyNode(newNode)) {
                EditableTree.this.getCustomTailor().modelChanged("addSibling");
            } else {
                EditableTree.this._tree.removeNodeFromParent((MutableTreeNode)newNode);
                if (oriNode != null) {
                    EditableTree.this._tree.setSelectionNode(oriNode);
                }
            }
        }
    }

    private class ActionNewChildNode
    extends AbstractAction {
        public ActionNewChildNode() {
            this.putValue("Name", "\u65b0\u5b50");
            this.putValue("ShortDescription", "\u65b0\u589e\u5b50\u8282\u70b9");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode parentNode = EditableTree.this.getSelectedNode();
            if (parentNode == null) {
                WindowUtil.msgboxInfo((Object)"\u8bf7\u5148\u9009\u4e2d\u7236\u8282\u70b9\u3002", (String)"\u65b0\u589e\u5b50\u8282\u70b9", (Component)EditableTree.this._tree);
            } else {
                DefaultKingdeeTreeNode newNode = EditableTree.this.addNewNode(parentNode);
                if (EditableTree.this.modifyNode(newNode)) {
                    EditableTree.this.getCustomTailor().modelChanged("addChild");
                } else {
                    EditableTree.this._tree.removeNodeFromParent((MutableTreeNode)newNode);
                    EditableTree.this._tree.setSelectionNode(parentNode);
                }
            }
        }
    }
}

