/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.appmodel;

import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.common.mm.appmodel.AbstractSchemeModel;
import com.kingdee.bos.bi.model.common.mm.appmodel.FinanceSchemeModel;
import com.kingdee.bos.bi.model.common.mm.appmodel.GeneralSchemeModel;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JComponent;

public class SchemeDialog
extends TypicalDialog {
    private static final long serialVersionUID = -678164072546238050L;
    protected KDPanel panMain;
    protected KDLabelContainer lctnSchemaName;
    protected KDLabelContainer lctnType;
    protected KDTextField txtSchemeName;
    protected KDComboBox cbxType;
    protected Vector cbxIteams = new Vector();
    private AbstractSchemeModel model = null;
    private boolean isGeneralModel = false;
    private boolean editFlag = false;
    private boolean readOnly = false;

    public SchemeDialog() {
    }

    public SchemeDialog(Frame owner) {
        super(owner);
    }

    public SchemeDialog(Dialog owner) {
        super(owner);
    }

    protected void todoInit() {
        this.setTitle("\u89c4\u5219\u65b9\u6848");
        this.setSize(260, 160);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        this.initComBoxIteams();
        parent.add((Component)this.getPanMain(), thisCell);
    }

    private void initComBoxIteams() {
        if (this.isGeneralModel) {
            this.cbxIteams.add(new ComboBoxObject("sql", "SQL \u53d6\u6570"));
        } else {
            this.cbxIteams.add(new ComboBoxObject("eas", "EAS\u53d6\u6570\u516c\u5f0f"));
            this.cbxIteams.add(new ComboBoxObject("calc", "\u805a\u5408\u89c4\u5219"));
        }
    }

    private Container getPanMain() {
        if (this.panMain == null) {
            this.panMain = new KDPanel();
            TableLayout tly = new TableLayout(4, 1);
            tly.style().setSize(-100, 80);
            tly.rowStyle(0).lockHeight(10);
            tly.rowStyle(1).lockHeight(20);
            tly.rowStyle(2).lockHeight(10);
            tly.rowStyle(3).lockHeight(20);
            this.panMain.setLayout((LayoutManager)tly);
            this.panMain.add(this.getLctnSchemaName(), (Object)tly.cell(1, 0));
            this.panMain.add(this.getLctnType(), (Object)tly.cell(3, 0));
        }
        return this.panMain;
    }

    private Component getLctnSchemaName() {
        if (this.lctnSchemaName == null) {
            this.lctnSchemaName = CtrlSwingUtilities.createLabelContainer((JComponent)this.getTxtSchemeName(), (String)"\u89c4\u5219\u65b9\u6848\u540d", (int)70);
        }
        return this.lctnSchemaName;
    }

    private JComponent getTxtSchemeName() {
        if (this.txtSchemeName == null) {
            this.txtSchemeName = new KDTextField();
            this.txtSchemeName.setEnabled(!this.readOnly);
            if (this.model != null) {
                this.txtSchemeName.setText(this.model.getFSchemeName());
            }
        }
        return this.txtSchemeName;
    }

    private Component getLctnType() {
        if (this.lctnType == null) {
            this.lctnType = CtrlSwingUtilities.createLabelContainer((JComponent)this.getCbxType(), (String)"\u8ba1\u7b97\u65b9\u5f0f", (int)70);
        }
        return this.lctnType;
    }

    private JComponent getCbxType() {
        if (this.cbxType == null) {
            this.cbxType = new KDComboBox(this.cbxIteams);
            this.cbxType.setEnabled(!this.readOnly);
            this.cbxType.setEnabled(!this.editFlag);
            if (this.model != null) {
                String type = this.model.getType();
                if (type.equals("eas")) {
                    this.cbxType.setSelectedIndex(0);
                } else if (type.equals("calc")) {
                    this.cbxType.setSelectedIndex(1);
                } else if (type.equals("sql")) {
                    this.cbxType.setSelectedIndex(0);
                }
            }
        }
        return this.cbxType;
    }

    public AbstractSchemeModel getModel() {
        if (this.model == null) {
            this.model = this.isGeneralModel ? new GeneralSchemeModel() : new FinanceSchemeModel();
        }
        this.model.setFSchemeName(this.txtSchemeName.getText());
        this.model.setType(((ComboBoxObject)this.cbxType.getSelectedItem()).getCode());
        return this.model;
    }

    public void setModel(AbstractSchemeModel model) {
        this.model = model;
    }

    public void setEditFlag(boolean editFlag) {
        this.editFlag = editFlag;
    }

    public void setIsGeneralModel(boolean isGeneralModel) {
        this.isGeneralModel = isGeneralModel;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

