/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.bireport.namedset.tree;

import com.kingdee.bos.bi.model.common.bireport.namedset.DimensionRootAdapter;
import com.kingdee.bos.bi.model.commonui.contentree.panel.view.DefaultTreeView;
import com.kingdee.bos.bi.model.rt.bireport.namedset.NamedSet;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.dialog.bireport.namedset.panel.SetContent;
import com.kingdee.bos.bi.model.ui.dialog.bireport.namedset.tree.ITreeSynchronizeListener;
import com.kingdee.bos.bi.model.ui.dialog.bireport.namedset.tree.SetBranch;
import com.kingdee.bos.bi.model.ui.dialog.bireport.namedset.tree.SetLeaf;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.Dialog;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;

public class SetTreeView
extends DefaultTreeView {
    private static final long serialVersionUID = 9199394770704607207L;
    private Dialog owner = null;
    private ITreeSynchronizeListener treeSynchronizeListener = null;

    public Dialog getOwner() {
        return this.owner;
    }

    public SetTreeView(Dialog owner, KDTree tree) {
        super(tree);
        this.owner = owner;
    }

    @Override
    protected void installButtonComponent() {
        super.installButtonComponent();
    }

    @Override
    protected void initButtonListener() {
        super.initButtonListener();
    }

    @Override
    protected void syncTreeViewButtonStatus() {
        super.syncTreeViewButtonStatus();
    }

    @Override
    protected void action_New() {
        try {
            DefaultKingdeeTreeNode selNode = this.getSelectedNode();
            if (selNode.getUserObject() instanceof SetBranch) {
                this.addNewNode(selNode);
            } else {
                this.addNewNode((DefaultKingdeeTreeNode)selNode.getParent());
            }
        }
        catch (BIModelRemoteException e) {
            e.printStackTrace();
        }
    }

    private DefaultKingdeeTreeNode addNewNode(DefaultKingdeeTreeNode parentNode) throws BIModelRemoteException {
        SetBranch branch = (SetBranch)parentNode.getUserObject();
        NamedSet setModel = null;
        setModel = NamedSet.createNewInstanceOfNamedSet(branch.getApm().getDimension(branch.getDt().getName()), null, "Members", null);
        DefaultKingdeeTreeNode root = branch.getApv().getDimRef().getDimensionView(branch.getDt().getName()).getRootMember(branch.getFacade());
        DefaultKingdeeTreeNode newRoot = DimensionRootAdapter.translateRoot(root, branch.getDt());
        SetLeaf newLeaf = new SetLeaf(this.getOwner(), "\u672a\u547d\u540d", setModel, newRoot, branch.getFacade());
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)newLeaf);
        newNode.setAllowsChildren(false);
        this.getTree().addNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode);
        this.getTree().setSelectionNode(newNode);
        return newNode;
    }

    @Override
    protected void action_Save() {
        DefaultKingdeeTreeNode selNode = this.getSelectedNode();
        SetContent content = ((SetLeaf)selNode.getUserObject()).getSetContent();
        IManagementFacade facade = content.getFacade();
        NamedSet set = content.getvalue();
        if (set == null) {
            return;
        }
        SetBranch branch = (SetBranch)((DefaultKingdeeTreeNode)selNode.getParent()).getUserObject();
        String appId = branch.getApm().getId();
        Dimension dim = branch.getApm().getDimension(branch.getDt().getName());
        try {
            if (set.isNew() && NamedSet.isExist(facade, appId, dim, set.getAlias())) {
                this.showMsg("\u540d\u4e3a" + set.getAlias() + "\u7684\u96c6\u5408\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u96c6\u5408\u540d\u79f0\uff01");
                return;
            }
            NamedSet.save(facade, appId, dim, set);
        }
        catch (BIModelRemoteException e) {
            e.printStackTrace();
            this.showMsg("\u4fdd\u5b58\u96c6\u5408\u3010" + set.getAlias() + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.showMsg("\u4fdd\u5b58\u96c6\u5408\u3010" + set.getAlias() + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.refreshrefreshCalMember(set, 4);
        selNode.setText(set.getAlias());
        this.showMsg("\u4fdd\u5b58\u96c6\u5408\u3010" + set.getAlias() + "\u3011\u6210\u529f\uff01");
    }

    public void refreshrefreshCalMember(NamedSet set, int actionType) {
        if (this.treeSynchronizeListener != null) {
            this.treeSynchronizeListener.synchronizeTree(set, actionType);
        }
    }

    private void showMsg(String msg) {
        WindowUtil.msgboxInfo((Object)msg, (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getTree());
    }

    @Override
    protected void doDelete() {
        DefaultKingdeeTreeNode selNode = this.getSelectedNode();
        SetContent content = ((SetLeaf)selNode.getUserObject()).getSetContent();
        IManagementFacade facade = content.getFacade();
        NamedSet set = content.getvalue();
        if (set == null) {
            return;
        }
        SetBranch branch = (SetBranch)((DefaultKingdeeTreeNode)selNode.getParent()).getUserObject();
        String appId = branch.getApm().getId();
        Dimension dim = branch.getApm().getDimension(branch.getDt().getName());
        try {
            NamedSet.delete(facade, appId, dim, set);
        }
        catch (BIModelRemoteException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.refreshrefreshCalMember(set, 3);
    }

    @Override
    protected void action_Delete() {
        super.action_Delete();
    }

    @Override
    protected boolean canNew() {
        Object root = this.getTree().getModel().getRoot();
        DefaultKingdeeTreeNode select = this.getSelectedNode();
        return select == null || root != select && root != select.getParent();
    }

    @Override
    protected boolean canSave() {
        return this.getSelectedNode() != null && this.getSelectedNode().getUserObject() instanceof SetLeaf;
    }

    @Override
    protected boolean canDelete() {
        return this.getSelectedNode() != null && this.getSelectedNode().getUserObject() instanceof SetLeaf;
    }

    @Override
    protected Map getBtnRegister() {
        if (this.btnRegister == null || this.btnRegister.size() == 0) {
            this.btnRegister = new Hashtable();
            this.btnRegister.put("new", "\u65b0\u589e\u6309\u94ae");
            this.btnRegister.put("delete", "\u5220\u9664\u6309\u94ae");
            this.btnRegister.put("save", "\u4fdd\u5b58\u6309\u94ae");
        }
        return this.btnRegister;
    }

    public void setTreeSynchronizeListener(ITreeSynchronizeListener treeSynchronizeListener) {
        this.treeSynchronizeListener = treeSynchronizeListener;
    }
}

