/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.metric;

import com.kingdee.bos.bi.model.common.formularengine.FormularChecker;
import com.kingdee.bos.bi.model.common.formularengine.FormularParser;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringParsingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.mm.metric.MetricDimensionNode;
import com.kingdee.bos.bi.model.common.mm.metric.MetricModel;
import com.kingdee.bos.bi.model.common.mm.metric.TimeAgg;
import com.kingdee.bos.bi.model.common.mm.metric.TimeCycle;
import com.kingdee.bos.bi.model.ui.dialog.EditableTree;
import com.kingdee.bos.bi.model.ui.dialog.FormulaWizardWrapper;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.formulawizard.Formula;
import com.kingdee.bos.ctrl.common.ui.formulawizard.Group;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MetricDimensionDialog
extends TypicalDialog {
    private static final long serialVersionUID = 1L;
    private InnerUI _ui;
    private boolean _isReadOnly;

    public MetricDimensionDialog() {
    }

    public MetricDimensionDialog(Frame owner) {
        super(owner);
    }

    public MetricDimensionDialog(Dialog owner) {
        super(owner);
    }

    protected void todoInit() {
        this._ui = new InnerUI();
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        parent.add((Component)this._ui.getCtrl(), thisCell);
    }

    public void setModel(MetricDimensionNode root) {
        this._ui.setModel(root);
    }

    public MetricDimensionNode getModel() {
        return this._ui.getModel();
    }

    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
        this._ui.getTreeWrapper().setReadOnly(isReadOnly);
        this._ui.txaDiscription.setEnabled(!isReadOnly);
        if (isReadOnly) {
            this.btnOk.setVisible(false);
            this.btnCancel.setText("\u5173\u95ed");
        }
    }

    protected boolean verify() {
        AbstractExpr rootExpr;
        if (this.getDiscriptionTxt().length() > 2000) {
            WindowUtil.msgboxWarning((Object)"\u8bf4\u660e\u6587\u5b57\u7684\u6700\u5927\u957f\u5ea6\u4e3a2000\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        MetricDimensionNode moRoot = this.getModel();
        if (moRoot == null) {
            WindowUtil.msgboxWarning((Object)"\u4e0d\u5141\u8bb8\u6a21\u578b\u6ca1\u6709\u5185\u5bb9\u3002\u5982\u679c\u60a8\u60f3\u6e05\u9664\u6240\u6709\u5185\u5bb9\uff0c\u8bf7\u5728\u89c6\u56fe\u5217\u8868\u4e2d\u901a\u8fc7\u5220\u9664\u64cd\u4f5c\u6765\u5b8c\u6210\u3002", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        HashMap refers = new HashMap();
        try {
            rootExpr = MetricDimensionDialog.pickAllFormulas(moRoot, refers);
        }
        catch (StringParsingException e) {
            WindowUtil.msgboxWarning((Object)("\u516c\u5f0f\u9519\u8bef" + StringUtil.RETURN + e.getMessage() + " \u3002"), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        FormularChecker checker = new FormularChecker();
        for (String number : refers.keySet()) {
            Object value = refers.get(number);
            if (value instanceof AbstractExpr) {
                checker.addRefersFormula(number, (AbstractExpr)value);
                continue;
            }
            checker.addExistVarName(number);
        }
        return rootExpr == null || checker.check(rootExpr, this.getTitle(), (Component)((Object)this));
    }

    private static AbstractExpr pickAllFormulas(MetricDimensionNode node, Map refers) throws StringParsingException {
        MetricModel model = node.getMetricModel();
        String number = model.getNumber();
        String formula = model.getFormula();
        AbstractExpr expr = null;
        if (StringUtil.isEmptyString((String)formula)) {
            refers.put(number, Boolean.TRUE);
        } else {
            FormularParser fp = new FormularParser();
            expr = fp.parse(formula);
            expr.setNumber(number);
            refers.put(number, expr);
        }
        int c = node.getChildCount();
        for (int i = 0; i < c; ++i) {
            MetricDimensionDialog.pickAllFormulas(node.getChild(i), refers);
        }
        return expr;
    }

    protected void onCancel() {
        if (!this._isReadOnly && this._ui.isDirty()) {
            int askResult = WindowUtil.msgboxYesNoCancel((Component)((Object)this), (Object)"\u662f\u5426\u4fdd\u5b58\u5bf9\u5f53\u524d\u7684\u4fee\u6539\uff1f", (String)this.getTitle());
            if (askResult == 2) {
                return;
            }
            if (askResult == 0) {
                this.onOk();
                return;
            }
        }
        super.onCancel();
    }

    private static void initCtrlNode(DefaultKingdeeTreeNode ctrlNode, MetricDimensionNode moNode) {
        ctrlNode.setUserObject((Object)moNode);
        ctrlNode.setText(moNode.getMetricModel().getText4UI());
    }

    private static String checkModel(MetricModel model) {
        String number = model.getNumber();
        if (StringUtil.isEmptyString((String)number)) {
            return "\u672a\u8bbe\u7f6e\u7f16\u7801\u3002";
        }
        if (StringUtil.isEmptyString((String)model.getName())) {
            return "\u672a\u8bbe\u7f6e\u540d\u79f0\u3002";
        }
        if (model.getTimeAgg() == null) {
            return "\u672a\u8bbe\u7f6e\u6307\u6807\u9891\u7387\u3002";
        }
        if (model.getTimeCycle() == null) {
            return "\u672a\u8bbe\u7f6e\u65f6\u95f4\u6c47\u603b\u7c7b\u578b\u3002";
        }
        if (!Pattern.matches("\\w+", number)) {
            return "\u7f16\u7801\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002";
        }
        if (number.length() > 80) {
            return "\u7f16\u7801\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26\u3002";
        }
        if (model.getName().length() > 255) {
            return "\u540d\u79f0\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26\u3002";
        }
        if (model.getFormula().length() > 2000) {
            return "\u516c\u5f0f\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc72000\u4e2a\u5b57\u7b26\u3002";
        }
        return null;
    }

    public String getDiscriptionTxt() {
        return this._ui.getDiscriptionTxt();
    }

    public void setDiscriptionTxt(String discription) {
        this._ui.setDiscriptionTxt(discription);
    }

    private static class CustomGroup
    extends Group {
        private static final long serialVersionUID = 8479827137197349534L;

        public CustomGroup() {
            this.getTree().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DefaultKingdeeTreeNode node;
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    TreePath path = this.getTree().getSelectionPath();
                    if (path != null && path.equals(this.getTree().getClosestPath(e.getX(), e.getY())) && (node = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getChildCount() != 0) {
                        this.fireSelectionEvent(this.getTree(), 0, (Formula)node.getUserObject());
                    }
                }
            });
        }
    }

    private static class DetailUI
    extends KDPanel
    implements SimpleDialog.PanelOfSimpleDialog {
        private static final long serialVersionUID = 1L;
        private static final String[] SUPPLY_FORMATSTRING = new String[]{null, "#,##0", "#,##0.00", "0.000%", "0.00%", "0.0%", "0%"};
        private KDTextField _txtNumber;
        private KDTextField _txtName;
        private KDComboBox _cmbTimeAgg;
        private KDComboBox _cmbTimeCycle;
        private KDTextArea _txaFormula;
        private KDWorkButton _btnWizard;
        private KDCheckBox _chkCalculateAgain;
        private KDComboBox _cmbFormat;
        private KDTextArea _txaFMemo;
        private KDTree _editingTree;
        private String _selfNumber;
        private FormulaWizardWrapper _formulaWizard;
        private Group _formulaWizardSupply;

        public DetailUI() {
            this.init();
            this.installListener();
        }

        private void init() {
            this._txtNumber = new KDTextField();
            this._txtName = new KDTextField();
            this._cmbTimeAgg = new KDComboBox((Object[])TimeAgg.getAllObjs());
            this._cmbTimeCycle = new KDComboBox((Object[])TimeCycle.getAllObjs());
            this._cmbFormat = new KDComboBox((Object[])SUPPLY_FORMATSTRING);
            this._cmbFormat.setEditable(true);
            this._cmbTimeCycle = new KDComboBox((Object[])new TimeCycle[]{TimeCycle.MONTH});
            this._cmbTimeCycle.setEnabled(false);
            KDLabelContainer lbcId = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtNumber, (String)"\u6307\u6807\u7f16\u7801", (int)80);
            KDLabelContainer lbcName = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtName, (String)"\u6307\u6807\u540d\u79f0", (int)80);
            KDLabelContainer lbcTimeAgg = CtrlSwingUtilities.createLabelContainer((JComponent)this._cmbTimeAgg, (String)"\u65f6\u95f4\u6c47\u603b\u7c7b\u578b", (int)80);
            KDLabelContainer lbcTimeCycle = CtrlSwingUtilities.createLabelContainer((JComponent)this._cmbTimeCycle, (String)"\u6307\u6807\u9891\u7387", (int)80);
            KDLabelContainer lbcFormat = CtrlSwingUtilities.createLabelContainer((JComponent)this._cmbFormat, (String)"\u683c\u5f0f", (int)80);
            TableLayout2 layout = new TableLayout2(5, 2);
            layout.setColsSpacing(TableLayout2.ALL, 20);
            layout.setRowsSpacing(TableLayout2.ALL, 3);
            layout.setRowSpacing(3, 6);
            layout.setFixedHeight(new int[]{0, 1, 2, 3}, 20);
            layout.setRatableHeight(4, 100);
            this.setLayout((LayoutManager)layout);
            this.add((Component)lbcId, TableLayout2.param((int)0, (int)0, (int)0, (int)1));
            this.add((Component)lbcName, TableLayout2.param((int)1, (int)0, (int)1, (int)1));
            this.add((Component)lbcTimeCycle, TableLayout2.param((int)2, (int)0));
            this.add((Component)lbcTimeAgg, TableLayout2.param((int)2, (int)1));
            this.add((Component)lbcFormat, TableLayout2.param((int)3, (int)0));
            this.add((Component)this.createFormulaPane(), TableLayout2.param((int)4, (int)0, (int)4, (int)1));
        }

        private KDPanel createFormulaPane() {
            this._txaFormula = new KDTextArea();
            KDLabel lab = new KDLabel("\u516c\u5f0f\uff1a");
            this._btnWizard = new KDWorkButton("\u516c\u5f0f\u5411\u5bfc");
            this._chkCalculateAgain = new KDCheckBox("\u516c\u5f0f\u8fdb\u884c\u4e8c\u6b21\u8fd0\u7b97");
            KDScrollPane scpFormula = new KDScrollPane((Component)this._txaFormula);
            TableLayout2 layout = new TableLayout2(4, 4);
            layout.setFixedHeight(0, 20);
            layout.setRatableHeight(1, 100);
            layout.setFixedHeight(2, 20);
            layout.setRowsSpacing(TableLayout2.ALL, 3);
            layout.setFixedWidth(0, 60);
            layout.setRatableWidth(1, 100);
            layout.setFixedWidth(2, 61);
            layout.setFixedWidth(3, 60);
            layout.setRatableHeight(3, 100);
            layout.setColsSpacing(TableLayout2.ALL, 3);
            KDPanel pan = new KDPanel((LayoutManager)layout);
            pan.setOpaque(false);
            pan.add((Component)lab, (Object)TableLayout2.param((int)0, (int)0));
            pan.add((Component)this._btnWizard, (Object)TableLayout2.param((int)0, (int)3));
            pan.add((Component)scpFormula, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)3));
            pan.add((Component)this._chkCalculateAgain, (Object)TableLayout2.param((int)2, (int)2, (int)2, (int)3));
            KDLabel lblFMemo = new KDLabel("\u5907\u6ce8\uff1a");
            this._txaFMemo = new KDTextArea();
            KDScrollPane scrpFormula = new KDScrollPane((Component)this._txaFMemo);
            pan.add((Component)lblFMemo, (Object)TableLayout2.param((int)2, (int)0));
            pan.add((Component)scrpFormula, (Object)TableLayout2.param((int)3, (int)0, (int)3, (int)3));
            return pan;
        }

        private void installListener() {
            this._btnWizard.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    _formulaWizard.setResult(_txaFormula.getText());
                    if (_formulaWizard.show()) {
                        _txaFormula.setText(_formulaWizard.getResult());
                    }
                }
            });
        }

        public void setEditable(boolean isEditable) {
            this._txtNumber.setEnabled(isEditable);
            this._txtName.setEnabled(isEditable);
            this._cmbTimeAgg.setEnabled(isEditable);
            this._cmbFormat.setEnabled(isEditable);
            this._txaFormula.setEnabled(isEditable);
            this._chkCalculateAgain.setEnabled(isEditable);
            this._btnWizard.setVisible(isEditable);
            this._txaFMemo.setEnabled(isEditable);
        }

        public void prepareCtrlValue(MetricModel model) {
            if (model == null) {
                this._txtNumber.setText("");
                this._txtName.setText("");
                this._cmbTimeAgg.setSelectedItem(null);
                this._cmbTimeCycle.setSelectedItem(null);
                this._cmbFormat.setSelectedItem(null);
                this._txaFormula.setText("");
                this._chkCalculateAgain.setSelected(false);
                this._txaFMemo.setText("");
            } else {
                this._txtNumber.setText(model.getNumber());
                this._txtName.setText(model.getName());
                this._cmbTimeAgg.setSelectedItem((Object)model.getTimeAgg());
                this._cmbTimeCycle.setSelectedItem((Object)model.getTimeCycle());
                this._cmbFormat.setSelectedItem((Object)model.getFormatString());
                this._txaFormula.setText(model.getFormula());
                this._chkCalculateAgain.setSelected(model.isFormulaCalculateAgain());
                this._txaFMemo.setText(model.getFMemo());
            }
        }

        public void updateModel(MetricModel model) {
            model.setNumber(this._txtNumber.getText().trim());
            model.setName(this._txtName.getText().trim());
            model.setTimeAgg((TimeAgg)this._cmbTimeAgg.getSelectedItem());
            model.setTimeCycle((TimeCycle)this._cmbTimeCycle.getSelectedItem());
            model.setFormatString((String)this._cmbFormat.getSelectedItem());
            model.setFormula(this._txaFormula.getText());
            model.setFormulaCalculateAgain(this._chkCalculateAgain.isSelected());
            model.setFMemo(this._txaFMemo.getText().trim());
        }

        public boolean verify() {
            String formula;
            MetricModel model = new MetricModel();
            this.updateModel(model);
            String errInfo = MetricDimensionDialog.checkModel(model);
            if (errInfo != null) {
                WindowUtil.msgboxInfo((Object)errInfo, (String)"\u6307\u6807\u5c5e\u6027", (Component)((Object)this));
                return false;
            }
            String number = model.getNumber();
            if (!StringUtil.equalsIgnoreCase((String)this._selfNumber, (String)number)) {
                Enumeration e = ((DefaultKingdeeTreeNode)this._editingTree.getModel().getRoot()).breadthFirstEnumeration();
                while (e.hasMoreElements()) {
                    MetricModel m;
                    DefaultKingdeeTreeNode ctrlNode = (DefaultKingdeeTreeNode)e.nextElement();
                    Object moNode = ctrlNode.getUserObject();
                    if (!(moNode instanceof MetricDimensionNode) || !StringUtil.equalsIgnoreCase((String)number, (String)(m = ((MetricDimensionNode)moNode).getMetricModel()).getNumber())) continue;
                    WindowUtil.msgboxInfo((Object)("\u7f16\u7801 " + number + " \u5df2\u5b58\u5728\u3002"), (String)"\u6307\u6807\u5c5e\u6027", (Component)((Object)this));
                    return false;
                }
            }
            if (!StringUtil.isEmptyString((String)(formula = model.getFormula()))) {
                FormularChecker checker = new FormularChecker();
                checker.setAllVarExist(true);
                if (!checker.check(formula, "\u6307\u6807\u5c5e\u6027", (Component)((Object)this))) {
                    return false;
                }
            }
            return true;
        }

        public void setEditing(KDTree editingTree, String selfNumber, DefaultKingdeeTreeNode selfCtrlNode) {
            this._editingTree = editingTree;
            this._selfNumber = selfNumber;
            if (this._formulaWizard == null) {
                this._formulaWizard = new FormulaWizardWrapper((Component)editingTree);
                this._formulaWizardSupply = new CustomGroup();
                this._formulaWizardSupply.setTitle("\u5f15\u7528\u5bf9\u8c61");
                this._formulaWizard.addSupply(this._formulaWizardSupply);
            }
            DefaultKingdeeTreeNode realRoot = (DefaultKingdeeTreeNode)this._editingTree.getModel().getRoot();
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)realRoot.getChildAt(0);
            KDTree tree = this._formulaWizardSupply.getTree();
            tree.removeAllChildrenFromParent((MutableTreeNode)this._formulaWizardSupply.getRoot());
            this.createSupplyTree(this._formulaWizardSupply, null, root, selfCtrlNode);
            tree.expandAllNodes(true, (TreeNode)this._formulaWizardSupply.getRoot());
        }

        private void createSupplyTree(Group group, DefaultKingdeeTreeNode wizardParentNode, DefaultKingdeeTreeNode editingNode, DefaultKingdeeTreeNode selfCtrlNode) {
            if (editingNode == null) {
                return;
            }
            MetricDimensionNode moNode = (MetricDimensionNode)editingNode.getUserObject();
            MetricModel model = moNode.getMetricModel();
            DefaultKingdeeTreeNode wizardNode = editingNode == selfCtrlNode ? group.addNode(wizardParentNode, model.getName() + "\uff08\u5f53\u524d\u8282\u70b9\uff09", new Formula("")) : group.addNode(wizardParentNode, model.getText4UI(), new Formula(model.getNumberWithMark()));
            int c = editingNode.getChildCount();
            for (int i = 0; i < c; ++i) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)editingNode.getChildAt(i);
                this.createSupplyTree(group, wizardNode, child, selfCtrlNode);
            }
        }
    }

    private static class InnerUI {
        private KDPanel _panel;
        private EditableTree _treeWrapper;
        private DetailUI _detailUI;
        private boolean _isDirty;
        private KDTextArea txaDiscription;

        public InnerUI() {
            this.init();
            this.installListener();
        }

        private void init() {
            this._treeWrapper = new EditableTree();
            this._treeWrapper.setCustomTailor(new TreeCustomTailor());
            KDTreeView treeView = this._treeWrapper.createTreeView();
            treeView.setTitle("\u6307\u6807\u7ef4\u5ea6\u6a21\u578b");
            this._detailUI = new DetailUI();
            this._detailUI.setEditable(false);
            this._detailUI.setOpaque(false);
            this._detailUI.setCustomInsets(new Insets(8, 8, 0, 8));
            KDContainer ctnEdit = new KDContainer();
            ctnEdit.setTitle("\u6307\u6807\u5c5e\u6027");
            ctnEdit.setEnableActive(false);
            ctnEdit.getContentPane().setLayout(new BorderLayout());
            ctnEdit.getContentPane().add((Component)((Object)this._detailUI), "Center");
            TableLayout2 layout = new TableLayout2(3, 1);
            layout.setRowSpacing(0, 10);
            layout.setRatableHeight(0, 100);
            layout.setFixedHeight(1, 260);
            layout.setFixedHeight(2, 70);
            this._panel = new KDPanel((LayoutManager)layout);
            this._panel.add((Component)treeView, (Object)TableLayout2.param((int)0, (int)0));
            this._panel.add((Component)ctnEdit, (Object)TableLayout2.param((int)1, (int)0));
            this._panel.add((Component)this.getDiscriptionPanel(), (Object)TableLayout2.param((int)2, (int)0));
        }

        public String getDiscriptionTxt() {
            return this.txaDiscription.getText().trim();
        }

        public void setDiscriptionTxt(String discription) {
            if (discription != null) {
                this.txaDiscription.setText(discription);
            }
        }

        private KDPanel getDiscriptionPanel() {
            KDPanel panDiscription = new KDPanel();
            TableLayout2 tly = new TableLayout2(3, 1);
            tly.setRowSpacing(0, 3);
            tly.setRatableHeight(2, 100);
            tly.setFixedHeight(1, 21);
            panDiscription.setLayout((LayoutManager)tly);
            KDLabel lblDiscription = new KDLabel("\u8bf4\u660e\uff1a");
            this.txaDiscription = new KDTextArea();
            KDScrollPane scrpDiscription = new KDScrollPane((Component)this.txaDiscription);
            panDiscription.add((Component)lblDiscription, (Object)TableLayout2.param((int)1, (int)0));
            panDiscription.add((Component)scrpDiscription, (Object)TableLayout2.param((int)2, (int)0));
            return panDiscription;
        }

        private void installListener() {
            KDTree tree = this._treeWrapper.getTree();
            tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultKingdeeTreeNode ctrlNode;
                    Object moNode;
                    TreePath path = e.getNewLeadSelectionPath();
                    MetricModel metricModel = null;
                    if (path != null && (moNode = (ctrlNode = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject()) instanceof MetricDimensionNode) {
                        metricModel = ((MetricDimensionNode)moNode).getMetricModel();
                    }
                    _detailUI.prepareCtrlValue(metricModel);
                }
            });
        }

        public JComponent getCtrl() {
            return this._panel;
        }

        public EditableTree getTreeWrapper() {
            return this._treeWrapper;
        }

        public void setModel(MetricDimensionNode moRoot) {
            if (moRoot != null) {
                DefaultKingdeeTreeNode ctrlRoot = this.modelToCtrl(moRoot);
                KDTree tree = this._treeWrapper.getTree();
                DefaultKingdeeTreeNode realCtrlRoot = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
                tree.removeAllChildrenFromParent((MutableTreeNode)realCtrlRoot);
                tree.addNodeInto((MutableTreeNode)ctrlRoot, (MutableTreeNode)realCtrlRoot);
                tree.setSelectionNode(ctrlRoot);
            }
        }

        private DefaultKingdeeTreeNode modelToCtrl(MetricDimensionNode moNode) {
            DefaultKingdeeTreeNode ctrlNode = new DefaultKingdeeTreeNode();
            MetricDimensionDialog.initCtrlNode(ctrlNode, moNode);
            int c = moNode.getChildCount();
            for (int i = 0; i < c; ++i) {
                MetricDimensionNode moChild = moNode.getChild(i);
                DefaultKingdeeTreeNode ctrlChild = this.modelToCtrl(moChild);
                ctrlNode.add((MutableTreeNode)ctrlChild);
            }
            return ctrlNode;
        }

        public MetricDimensionNode getModel() {
            KDTree tree = this._treeWrapper.getTree();
            DefaultKingdeeTreeNode realCtrlRoot = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
            if (realCtrlRoot.getChildCount() == 0) {
                return null;
            }
            DefaultKingdeeTreeNode ctrlRoot = (DefaultKingdeeTreeNode)realCtrlRoot.getChildAt(0);
            return this.modelFromCtrl(ctrlRoot);
        }

        private MetricDimensionNode modelFromCtrl(DefaultKingdeeTreeNode ctrlNode) {
            MetricDimensionNode moNode = (MetricDimensionNode)ctrlNode.getUserObject();
            moNode.removeAllChildren();
            int c = ctrlNode.getChildCount();
            for (int i = 0; i < c; ++i) {
                DefaultKingdeeTreeNode ctrlChild = (DefaultKingdeeTreeNode)ctrlNode.getChildAt(i);
                MetricDimensionNode moChild = this.modelFromCtrl(ctrlChild);
                moNode.addChild(moChild);
            }
            return moNode;
        }

        public boolean isDirty() {
            return this._isDirty;
        }

        private class TreeCustomTailor
        implements EditableTree.ITreeCustomTailor {
            private DetailUI detailUI;

            private TreeCustomTailor() {
            }

            @Override
            public void initNewNode(KDTree tree, DefaultKingdeeTreeNode ctrlNode) {
                MetricModel metricModel = new MetricModel();
                metricModel.setName("\u65b0\u8282\u70b9");
                metricModel.setTimeAgg(TimeAgg.SUM);
                metricModel.setTimeCycle(TimeCycle.MONTH);
                MetricDimensionNode moNode = new MetricDimensionNode();
                moNode.setMetricModel(metricModel);
                MetricDimensionDialog.initCtrlNode(ctrlNode, moNode);
            }

            @Override
            public boolean modifyNode(KDTree tree, DefaultKingdeeTreeNode ctrlNode) {
                MetricDimensionNode moNode = (MetricDimensionNode)ctrlNode.getUserObject();
                MetricModel model = moNode.getMetricModel();
                if (this.detailUI == null) {
                    this.detailUI = new DetailUI();
                    this.detailUI.setEditable(true);
                }
                this.detailUI.setEditing(tree, model.getNumber(), ctrlNode);
                this.detailUI.prepareCtrlValue(model);
                SimpleDialog dlg = SimpleDialog.create((Component)tree);
                dlg.setComponent((Component)((Object)this.detailUI));
                dlg.setSize(430, 350);
                dlg.setTitle("\u6307\u6807\u5c5e\u6027");
                if (dlg.showDialog()) {
                    this.detailUI.updateModel(model);
                    tree.setNodeText(ctrlNode, model.getText4UI());
                    InnerUI.this._detailUI.prepareCtrlValue(model);
                    return true;
                }
                return false;
            }

            @Override
            public boolean isMultiRootSupported() {
                return false;
            }

            @Override
            public void modelChanged(String operateType) {
                InnerUI.this._isDirty = true;
            }
        }
    }
}

