/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.schedule.scheme;

import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.common.mm.schedule.ScheduleConst;
import com.kingdee.bos.bi.model.common.mm.schedule.ScheduleSchemeModel;
import com.kingdee.bos.bi.model.ui.ProgressbarGlassPane;
import com.kingdee.bos.bi.model.ui.dialog.schedule.F7Selector;
import com.kingdee.bos.bi.model.ui.dialog.schedule.ManuallyExecutingDialog;
import com.kingdee.bos.bi.model.ui.dialog.schedule.logs.ScheduleLogDialog;
import com.kingdee.bos.bi.model.ui.dialog.schedule.scheme.AbstractScheduleSchemeDialog;
import com.kingdee.bos.bi.model.ui.exception.BIModelBizException;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.eas.base.job.QuartzParser;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;

public class ScheduleSchemeDialog
extends AbstractScheduleSchemeDialog {
    private static final long serialVersionUID = -5614779824988624323L;
    private List schemeList = null;
    private List schemeIteamList = null;
    private ProgressbarGlassPane progressGlasspane;

    public ScheduleSchemeDialog() {
    }

    public ScheduleSchemeDialog(Dialog owner) {
        super(owner);
    }

    public ScheduleSchemeDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected void todoInit() {
        super.todoInit();
    }

    @Override
    protected void todoAddControls(Container parent, Cell thisCell) {
        super.todoAddControls(parent, thisCell);
        this.initTblMain();
        this.initialUpdateStrategy();
    }

    private void initialUpdateStrategy() {
        if (this.schemeList != null && this.schemeList.size() > 0) {
            ScheduleSchemeModel m = (ScheduleSchemeModel)this.schemeList.get(0);
            this.scheduleXML = m.getQuartsExp();
            this.txtScheduleTime.setText(this.toScheduleTime(this.scheduleXML));
        }
    }

    private void initTblMain() {
        if (this.schemeList != null && this.schemeList.size() > 0) {
            int n = this.schemeList.size();
            block0: for (int r = 0; r < n; ++r) {
                ScheduleSchemeModel model = (ScheduleSchemeModel)this.schemeList.get(r);
                IRow row_RX = this.tblMain.addRow(r);
                ICell cell_R0 = row_RX.getCell("scheduleIteam");
                KDPromptBox pbxSelectAppModel = new KDPromptBox();
                F7Selector dlg = new F7Selector((Dialog)((Object)this));
                dlg.setF7DialogTitle("\u9009\u62e9\u8c03\u5ea6\u6761\u76ee", "\u5907\u9009\u8c03\u5ea6\u6761\u76ee");
                pbxSelectAppModel.setSelector((KDPromptSelector)dlg);
                dlg.setCurrAppmodelId(model == null ? null : model.getScheduleIteamId());
                dlg.setSupply(this.loadSchemeIteamList());
                dlg.getBtnOk().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ScheduleSchemeDialog.this.action_schemeIteamChanged();
                    }
                });
                if (model == null) {
                    return;
                }
                cell_R0.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)pbxSelectAppModel));
                ComboBoxObject appModelObj = null;
                int m = this.schemeIteamList.size();
                for (int i = 0; i < m; ++i) {
                    appModelObj = (ComboBoxObject)this.schemeIteamList.get(i);
                    if (!appModelObj.getCode().equals(model.getScheduleIteamId())) continue;
                    pbxSelectAppModel.setData((Object)appModelObj);
                    cell_R0.setValue((Object)appModelObj);
                    row_RX.getCell("scheduleType").setValue((Object)ScheduleConst.getScheduleType(appModelObj.getInfo()));
                    continue block0;
                }
            }
        }
    }

    protected void action_schemeIteamChanged() {
        IRow row = this.tblMain.getRow(this.currRow);
        ICell cell = row.getCell("scheduleIteam");
        KDPromptBox pbxSelectAppModel = (KDPromptBox)cell.getEditor().getComponent();
        if (pbxSelectAppModel.getSelector().getData() == null) {
            return;
        }
        String scheduleIteamType = ((ComboBoxObject)pbxSelectAppModel.getSelector().getData()).getInfo();
        row.getCell("scheduleType").setValue((Object)ScheduleConst.getScheduleType(scheduleIteamType));
    }

    private List loadSchemeIteamList() {
        try {
            if (this.schemeIteamList == null) {
                this.schemeIteamList = ScheduleSchemeModel.loadScheduleIteamList(this.facade);
            }
        }
        catch (SQLException e) {
            log.error((Object)("\u83b7\u53d6\u8c03\u5730\u6761\u76ee\u5217\u8868\u51fa\u9519\uff1a" + e));
        }
        return this.schemeIteamList;
    }

    @Override
    public void action_SetTime() {
        this.openProcessSchedulePlan();
    }

    private void openProcessSchedulePlan() {
        try {
            String prevscheduleXML = this.scheduleXML;
            if (prevscheduleXML == null || prevscheduleXML.length() < "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Scheduale xmlns=\"http://www.kingdee.com/2003/K-PDL1.0\" RetryTime=\"0\" Type=\"EVERYDAY\" BeginTime=\"1258446031557\" EndTime=\"1258446031557\" UseCalendar=\"false\" InstructionType=\"0\"></Scheduale>".length()) {
                prevscheduleXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Scheduale xmlns=\"http://www.kingdee.com/2003/K-PDL1.0\" RetryTime=\"0\" Type=\"EVERYDAY\" BeginTime=\"1258446031557\" EndTime=\"1258446031557\" UseCalendar=\"false\" InstructionType=\"0\"></Scheduale>";
            }
            this.scheduleXML = ProcessSchedulePlan.open((Object)((Object)this), (String)prevscheduleXML);
            if (this.scheduleXML != null && this.scheduleXML.length() > 0 && !this.scheduleXML.equals(prevscheduleXML)) {
                this.setIsScheduleChanged(true);
                this.txtScheduleTime.setText(this.toScheduleTime(this.scheduleXML));
            }
        }
        catch (LinkageError e) {
            WindowUtil.msgboxWarning((Object)"\u975eEAS\u73af\u5883\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u8c03\u5ea6\u65f6\u95f4\u5468\u671f\uff01", (String)"\u7cfb\u7edf\u63d0\u793a", (Component)((Object)this));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private String toScheduleTime(String xml) {
        if (xml == null || xml.length() == 0 || xml.equals("null")) {
            return "";
        }
        ScheduleDef scheduleDef = null;
        QuartzParser quartzParser = null;
        String result = null;
        try {
            scheduleDef = KpdlParser.parseSchedule((String)xml);
            quartzParser = new QuartzParser(scheduleDef.getDefine());
            result = quartzParser.parse();
        }
        catch (WfKpdlParseException wfKpdlParseException) {
            // empty catch block
        }
        return result == null ? xml : result;
    }

    protected void action_CellChanged() {
        if (this.currCol == 0 && this.tblMain != null && this.tblMain.getRow(this.currRow) != null && this.tblMain.getRow(this.currRow).getCell(0) != null && this.tblMain.getRow(this.currRow).getCell(0).getEditor() != null) {
            KDComboBox cb_col_one = (KDComboBox)this.tblMain.getRow(this.currRow).getCell(0).getEditor().getComponent();
            ComboBoxObject m_col_one = (ComboBoxObject)cb_col_one.getSelectedItem();
            if (m_col_one != null) {
                this.tblMain.getRow(this.currRow).getCell(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(m_col_one.getIteams())));
                this.tblMain.getRow(this.currRow).getCell(1).setValue(m_col_one.getIteams().get(0));
            }
            if (m_col_one != null) {
                // empty if block
            }
        }
    }

    @Override
    public void action_Add() {
        this.tblMain.addRow();
        KDPromptBox pbxSelectAppModel = new KDPromptBox();
        F7Selector dlg = new F7Selector((Dialog)((Object)this));
        dlg.setF7DialogTitle("\u9009\u62e9\u8c03\u5ea6\u6761\u76ee", "\u5907\u9009\u8c03\u5ea6\u6761\u76ee");
        pbxSelectAppModel.setSelector((KDPromptSelector)dlg);
        dlg.setSupply(this.loadSchemeIteamList());
        dlg.getBtnOk().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScheduleSchemeDialog.this.action_schemeIteamChanged();
            }
        });
        this.tblMain.getCell(this.tblMain.getRowCount() - 1, 0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)pbxSelectAppModel));
    }

    @Override
    public void action_Delete() {
        if (this.checkSelected()) {
            ArrayList selectBlocks = this.tblMain.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            int n = selectBlocks.size();
            for (int i = 0; i < n; ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u5220\u9664\uff01", (String)this.getTitle(), (Component)((Object)this));
                    return;
                }
                this.tblMain.removeRow(selectBlock.getTop());
            }
        }
    }

    @Override
    public void action_Up() {
        if (this.checkSelected()) {
            ArrayList selectBlocks = this.tblMain.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            int rowIndex = -1;
            IRow row = null;
            int n = selectBlocks.size();
            for (int i = 0; i < n; ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u79fb\u52a8\uff01", (String)this.getTitle(), (Component)((Object)this));
                    break;
                }
                if (this.tblMain.getRowCount() == rowIndex) {
                    return;
                }
                rowIndex = selectBlock.getTop();
                if (rowIndex == -1 || rowIndex == 0) {
                    return;
                }
                int targetRowIndex = rowIndex - 1;
                row = this.tblMain.removeRow(rowIndex);
                this.tblMain.addRow(targetRowIndex, row);
                this.tblMain.getSelectManager().setActiveRowIndex(targetRowIndex);
                this.tblMain.getSelectManager().select(targetRowIndex, 0);
            }
        }
    }

    @Override
    public void action_Down() {
        if (this.checkSelected()) {
            ArrayList selectBlocks = this.tblMain.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            int rowIndex = -1;
            IRow row = null;
            int n = selectBlocks.size();
            for (int i = 0; i < n; ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u79fb\u52a8\uff01", (String)this.getTitle(), (Component)((Object)this));
                    break;
                }
                if (this.tblMain.getRowCount() == rowIndex) {
                    return;
                }
                rowIndex = selectBlock.getTop();
                if (rowIndex == -1 || rowIndex == this.tblMain.getRowCount() - 1) {
                    return;
                }
                int targetRowIndex = rowIndex + 1;
                row = this.tblMain.removeRow(rowIndex);
                this.tblMain.addRow(targetRowIndex, row);
                this.tblMain.getSelectManager().setActiveRowIndex(targetRowIndex);
                this.tblMain.getSelectManager().select(targetRowIndex, 0);
            }
        }
    }

    private boolean checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    @Override
    public boolean action_CheckBeforeSave() {
        if (this.tblMain.getRowCount() == 0) {
            WindowUtil.msgboxInfo((Object)"\u81f3\u5c11\u8981\u6709\u4e00\u6761\u6570\u636e\u89c4\u5219\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (this.txtScheduleTime.getText() == null || this.txtScheduleTime.getText().trim().length() == 0) {
            WindowUtil.msgboxInfo((Object)"\u5fc5\u987b\u8bbe\u7f6e\u65f6\u95f4\u5468\u671f\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        for (int r = this.tblMain.getRowCount() - 1; r >= 0; --r) {
            IRow row = this.tblMain.getRow(r);
            for (int c = this.tblMain.getColumnCount() - 1; c >= 0; --c) {
                ICell cell = row.getCell(c);
                if (cell.getValue() != null) continue;
                WindowUtil.msgboxInfo((Object)"\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01", (String)this.getTitle(), (Component)((Object)this));
                return false;
            }
        }
        if (this.getDiscriptionTxt().length() > 2000) {
            WindowUtil.msgboxWarning((Object)"\u8bf4\u660e\u6587\u5b57\u7684\u6700\u5927\u957f\u5ea6\u4e3a2000\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    public Vector getComBoxModelIteams() {
        return null;
    }

    public void setComBoxModelIteams(Vector comBoxIteams) {
    }

    public List getModelList() {
        ArrayList<ScheduleSchemeModel> lst = new ArrayList<ScheduleSchemeModel>();
        ScheduleSchemeModel m = null;
        int n = this.tblMain.getRowCount();
        for (int r = 0; r < n; ++r) {
            m = new ScheduleSchemeModel();
            IRow row = this.tblMain.getRow(r);
            m.setScheduleIteamId(((ComboBoxObject)row.getCell("scheduleIteam").getValue()).getCode());
            m.setScheduleIteamType(((ComboBoxObject)row.getCell("scheduleType").getValue()).getCode());
            m.setQuartsExp(this.scheduleXML == null ? "" : this.scheduleXML);
            lst.add(m);
        }
        return lst;
    }

    public void setModelList(List schemeList) {
        this.schemeList = schemeList;
    }

    public Vector getComBoxFailIteams() {
        return null;
    }

    public void setComBoxFailIteams(Vector comBoxFailIteams) {
    }

    @Override
    public void action_Run() {
        ManuallyExecutingDialog runDlg = (ManuallyExecutingDialog)((Object)WindowUtil.createWindow(ManuallyExecutingDialog.class, (Component)((Object)this)));
        if (runDlg.showDialog()) {
            Date dateBegin = (Date)runDlg.datBegin.getValue();
            Date dateEnd = (Date)runDlg.datEnd.getValue();
            List dataRuleList = this.getRunDataList();
            if (this.facade != null && this.id != null && dateBegin != null && dateEnd != null) {
                if (dataRuleList != null && dataRuleList.size() > 0) {
                    this.runSchedule(dateBegin, dateEnd, dataRuleList);
                } else {
                    WindowUtil.msgboxInfo((Object)"\u6ca1\u6709\u6570\u636e\u89c4\u5219\uff0c\u4e0d\u80fd\u624b\u5de5\u6267\u884c\uff01", (String)this.getTitle(), (Component)((Object)this));
                }
            }
        }
    }

    public void runSchedule(final Date dateBegin, final Date dateEnd, final List scheduleIteams) {
        this.setProgressPaneVisible(true);
        this.excuteLongTimeTask(new Runnable(){

            @Override
            public void run() {
                try {
                    ScheduleSchemeDialog.this.facade.runCommonSchedule(ScheduleSchemeDialog.this.id, scheduleIteams, dateBegin, dateEnd);
                }
                catch (BIModelRemoteException e) {
                    ScheduleSchemeDialog.this.setProgressPaneVisible(false);
                    WindowUtil.msgboxWarning((Object)("\u6267\u884c\u65f6\u51fa\u73b0\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage()), (String)ScheduleSchemeDialog.this.getTitle(), (Component)((Object)ScheduleSchemeDialog.this));
                    return;
                }
                catch (BIModelBizException e) {
                    ScheduleSchemeDialog.this.setProgressPaneVisible(false);
                    WindowUtil.msgboxError((Object)("\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage()), (String)ScheduleSchemeDialog.this.getTitle(), (Component)((Object)ScheduleSchemeDialog.this));
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ScheduleSchemeDialog.this.setProgressPaneVisible(false);
                WindowUtil.msgboxInfo((Object)"\u624b\u5de5\u6267\u884c\u5b8c\u6bd5\uff01", (String)ScheduleSchemeDialog.this.getTitle(), (Component)((Object)ScheduleSchemeDialog.this));
            }
        });
    }

    private void excuteLongTimeTask(Runnable runnable) {
        new Thread(runnable).start();
    }

    private void setProgressPaneVisible(boolean b) {
        if (this.progressGlasspane == null) {
            this.progressGlasspane = new ProgressbarGlassPane((Window)((Object)this));
        }
        this.progressGlasspane.display(b);
    }

    public List getRunDataList() {
        ArrayList<String> lst = new ArrayList<String>();
        IRow row = null;
        for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
            row = this.tblMain.getRow(r);
            lst.add(((ComboBoxObject)row.getCell("scheduleIteam").getValue()).getCode());
        }
        return lst;
    }

    @Override
    public void action_Log() {
        ScheduleLogDialog logDlg = (ScheduleLogDialog)((Object)WindowUtil.createWindow(ScheduleLogDialog.class, (Component)((Object)this)));
        logDlg.setFacade(this.facade);
        logDlg.setScheduleId(this.id);
        if (logDlg.showDialog()) {
            // empty if block
        }
    }
}

