/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.util;

import com.kingdee.bos.util.backport.concurrent.locks.Lock;
import com.kingdee.bos.util.backport.concurrent.locks.ReentrantLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRULinkedHashMap
extends LinkedHashMap {
    private final int maxCapacity;
    private final Lock lock = new ReentrantLock();
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public LRULinkedHashMap(int maxCapacity) {
        super(maxCapacity, 0.75f, true);
        this.maxCapacity = maxCapacity;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return this.size() > this.maxCapacity;
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.lock.lock();
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object get(Object key) {
        try {
            this.lock.lock();
            Object v = super.get(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        try {
            this.lock.lock();
            Object object = super.put(key, value);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        try {
            this.lock.lock();
            int n = super.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.lock.lock();
            super.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection getAll() {
        try {
            this.lock.lock();
            ArrayList arrayList = new ArrayList(super.entrySet());
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }
}

