/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.IExceptionHandler;
import com.kingdee.bos.ctrl.analysis.bicomponent.CellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.ChartComponent;
import com.kingdee.bos.ctrl.analysis.bicomponent.ChartDataBuilder2;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.DataCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.DefaultChartDataBuilder;
import com.kingdee.bos.ctrl.analysis.bicomponent.MemberCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetComponent;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeEvent;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.ChangeSlicer;
import com.kingdee.bos.ctrl.analysis.olap.Filter;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.ModelFactory;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.KDTables2KDSBook;
import com.kingdee.bos.ctrl.kdf.export.KDTables2KDSBookVO;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.IVariantParser;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.extend.KDTableImagePrinter;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.remoting.RemoteConnection;
import com.kingdee.bos.olap.remoting.RemoteException;
import com.kingdee.bos.olap.remoting.RemoteInvoke;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.bireport.IBireportBaseFacade;
import com.kingdee.eas.framework.bireport.client.AbstractBireportBaseMainUI;
import com.kingdee.eas.framework.bireport.client.BireportActionConfig;
import com.kingdee.eas.framework.bireport.client.BireportBaseFilterUI;
import com.kingdee.eas.framework.bireport.client.ChartModel;
import com.kingdee.eas.framework.bireport.client.ChartModelListener;
import com.kingdee.eas.framework.bireport.client.TemplatePrintDataSource;
import com.kingdee.eas.framework.bireport.util.BIReportException;
import com.kingdee.eas.framework.bireport.util.BenchmarkTimer;
import com.kingdee.eas.framework.bireport.util.CellMatrix;
import com.kingdee.eas.framework.bireport.util.KDCloseableTabbedPane;
import com.kingdee.eas.framework.bireport.util.MultiLayoutPane;
import com.kingdee.eas.framework.bireport.util.OlapParams;
import com.kingdee.eas.framework.bireport.util.SelectChartMemberDlg;
import com.kingdee.eas.framework.config.UserCustomConfigInfo;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.rptclient.gr.rptclient.frame.UINewFrame;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public abstract class BireportBaseMainUI
extends AbstractBireportBaseMainUI
implements IPrintActionListener {
    public static final String UICONTEXT_KEY_INITPARAMS = "com.kingdee.eas.framework.bireport.client.BireportBaseMainUI#UICONTEXT_KEY_INITPARAMS";
    public static final String UICONTEXT_KEY_BE_JOINQUERY = "com.kingdee.eas.framework.bireport.client.BireportBaseMainUI#UICONTEXT_KEY_BE_JOINQUERY";
    public static final String UICONTEXT_KEY_JOINQUERY_PARAMS = "com.kingdee.eas.framework.bireport.client.BireportBaseMainUI#UICONTEXT_KEY_JOINQUERY_PARAMS";
    private static final Logger logger = CoreUIObject.getLogger(BireportBaseMainUI.class);
    private boolean shouldReloadPrintVar = true;
    private JMenuItem popMenuItemcustomChart = new JMenuItem();
    protected CommonQueryDialog queryDialog = new CommonQueryDialog();
    protected CustomerQueryPanel userPanel = null;
    private CustomerQueryPanel[] userPanels = null;
    private ComponentConfig config;
    private WorksheetComponent ws;
    private String error = null;
    private Map mycontext = new HashMap();
    protected RptParams params = null;
    private KDSplitPane split = null;
    private MultiLayoutPane msp = new MultiLayoutPane(new ChartTabbledCloseHandler());
    private Object constraints = null;
    private Container parent = null;
    private List ccList = new ArrayList();
    private boolean showChart = false;
    private boolean showSlice = false;
    private BireportActionConfig actionConfig;
    private SelectChartMemberDlg scmDlg = null;
    private KDTableImagePrinter tableImagePrinter = null;
    private IExceptionHandler expHandler = new IExceptionHandler(){

        public void handleException(Exception e) {
            BireportBaseMainUI.this.error = e.getMessage();
        }
    };
    private Map uiInfo = null;
    private OlapParams returnParams;
    private boolean shouldCloseFirst = false;

    public BireportBaseMainUI() throws Exception {
        this.btnShowSlice.setVisible(false);
        this.menuShowSlice.setVisible(false);
        this.actionShowSlice.setVisible(false);
        this.btnSizerData.setVisible(false);
        this.menuSizerData.setVisible(false);
        this.actionSizerData.setVisible(false);
        this.btnShowCustomStyle.setVisible(false);
        this.menuShowCustomStyle.setVisible(false);
        this.actionShowCustomStyle.setVisible(false);
    }

    public void setActionConfig(BireportActionConfig ac) {
        this.actionConfig = ac;
        this.actionDisplayConfig.setVisible(ac.isDisplayConfigActionVisible());
        this.actionSwapAxes.setVisible(ac.isSwapAxesActionVisible());
        this.actionShowChart.setVisible(ac.isChartActionVisible());
        this.btnShowChart.setVisible(ac.isChartActionVisible());
        this.actionShowSortRank.setVisible(ac.isSortRankActionVisible());
        this.actionChartAnalysis.setVisible(ac.isAnalysisChartActionVisible());
        this.actionSizerData.setVisible(ac.isFilterDataActionVisible());
        this.actionShowCustomStyle.setVisible(ac.isCustomStyleActionVisible());
        this.actionShowCustomStyle.setVisible(false);
    }

    private void resetWorksheetAction() {
        this.setActionConfig(this.actionConfig);
    }

    private void disableWorksheetAction() {
        this.actionDisplayConfig.setVisible(false);
        this.actionSwapAxes.setVisible(false);
        this.actionShowChart.setVisible(false);
        this.btnShowChart.setVisible(false);
        this.actionShowSortRank.setVisible(false);
        this.actionChartAnalysis.setVisible(false);
        this.actionSizerData.setVisible(false);
        this.actionShowCustomStyle.setVisible(false);
    }

    protected void setShowDialogOnLoad(boolean showDialogOnLoad) {
        this.setShowDialogOnLoad(showDialogOnLoad, false);
    }

    protected void setShowDialogOnLoad(boolean showDialogOnLoad, boolean showFilterAction) {
        this.mycontext.put("showDialogOnLoad", showDialogOnLoad);
        if (!showDialogOnLoad && this.params == null) {
            this.params = new RptParams();
        }
        this.actionFilt.setVisible(showFilterAction);
    }

    protected boolean isShowDialogOnLoad() {
        Boolean b = (Boolean)this.mycontext.get("showDialogOnLoad");
        return b == null ? true : b;
    }

    @Override
    public void actionShowChart_actionPerformed(ActionEvent e) throws Exception {
        if (this.ws == null) {
            return;
        }
        this.showChart(!this.showChart);
    }

    @Override
    public void actionShowSlice_actionPerformed(ActionEvent e) throws Exception {
        if (this.ws == null) {
            return;
        }
        this.showSlice(!this.showSlice);
    }

    @Override
    public void actionShowCustomStyle_actionPerformed(ActionEvent e) throws Exception {
        if (this.ws != null) {
            this.ws.dataStyle();
        }
    }

    @Override
    public void actionCustomChart_actionPerformed(ActionEvent e) throws Exception {
        if (this.ws == null || this.ws.getOlapModel() == null) {
            return;
        }
        if (this.scmDlg == null) {
            this.scmDlg = new SelectChartMemberDlg((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)), EASResource.getString((String)"com.kingdee.eas.framework.bireport.client.BireportBaseMainUI.CustomChart"), true);
        }
        if (this.scmDlg.showDlg(this.ws.getOlapModel())) {
            Member[] ms = this.scmDlg.getMemgers();
            this.addChart(ms, ChartType.CT_COLUMNCLUSTERED);
            this.showChart(true);
            this.doChartLayout();
        }
    }

    @Override
    public void actionChartAnalysis_actionPerformed(ActionEvent e) throws Exception {
        OlapParams op = (OlapParams)this.getReturnParams();
        if (this.ws == null || this.ws.getOlapModel() == null || op == null) {
            return;
        }
        this.ws.openChartAnalysis(op.getConnection(), op.getMdx(), op.getFiltString(), this.config);
    }

    protected void showChart(boolean aShowChart) {
        if (this.showChart == aShowChart) {
            return;
        }
        this.showChart = aShowChart;
        this.btnShowChart.setSelected(aShowChart);
        if (aShowChart) {
            this.menuShowChart.setText(this.menuShowChart.getText() + "  \u221a");
        } else {
            this.menuShowChart.setText(this.menuShowChart.getText().substring(0, this.menuShowChart.getText().length() - 3));
        }
        this.msp.setVisible(this.showChart);
        this.changeSplitLayout(this.showChart);
        OlapModel model = this.ws.getOlapModel();
        if (this.showChart) {
            if (model != null) {
                this.flushAllChart();
                int n = this.ccList.size();
                for (int i = 0; i < n; ++i) {
                    ChartComponent cc = (ChartComponent)this.ccList.get(i);
                    cc.setExceptionHandler(this.expHandler);
                    if (cc.getOlapModel() == model) {
                        cc.refresh();
                        model.addModelChangeListener((ModelChangeListener)cc);
                        continue;
                    }
                    cc.setModel(model);
                }
            }
            this.split.setDividerLocation(0.5);
        } else if (model != null) {
            int n = this.ccList.size();
            for (int i = 0; i < n; ++i) {
                ChartComponent cc = (ChartComponent)this.ccList.get(i);
                cc.setExceptionHandler(null);
                model.removeModelChangeListener((ModelChangeListener)cc);
            }
        }
        this.updateUI();
    }

    private void showSlice(boolean showSlice) {
    }

    private void showChartOnSelected() throws Exception {
        KDTable tbl = this.getTableForPrintSetting();
        KDTSelectBlock b = tbl.getSelectManager().get();
        if (b == null) {
            return;
        }
        HashSet<Member> mList = new HashSet<Member>();
        int n = b.getRight();
        for (int i = b.getLeft(); i <= n; ++i) {
            int m = b.getBottom();
            for (int j = b.getTop(); j <= m; ++j) {
                Member[] buf = this.getDataCellItemInfo(j, i);
                if (buf == null) continue;
                mList.addAll(Arrays.asList(buf));
            }
        }
        Member[] ms = new Member[mList.size()];
        mList.toArray(ms);
        this.addChart(ms, ChartType.CT_MULTIPIE);
        this.showChart(true);
        this.doChartLayout();
    }

    protected KDChart buildKDChart() {
        KDChart chart = new KDChart();
        chart.setPreferredSize(new Dimension(300, 300));
        chart.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isControlDown() && e.getClickCount() == 1 && e.getModifiers() == 1) {
                    KDChart cc = (KDChart)e.getSource();
                    BireportBaseMainUI.this.removeChart(cc);
                }
            }
        });
        return chart;
    }

    protected ChartModel getChartModel(String uniqueName) {
        int n = this.msp.getMultiPartCount();
        for (int i = 0; i < n; ++i) {
            KDChart chart = (KDChart)this.msp.getMultiPartComponent(i);
            if (!uniqueName.equals(chart.getName())) continue;
            return (ChartModel)chart.getUserObject();
        }
        return null;
    }

    protected KDChart getChart(String uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        int n = this.msp.getMultiPartCount();
        for (int i = 0; i < n; ++i) {
            KDChart chart = (KDChart)this.msp.getMultiPartComponent(i);
            if (!uniqueName.equals(chart.getName())) continue;
            return chart;
        }
        return null;
    }

    private void flushAllChart() {
        int n = this.msp.getMultiPartCount();
        for (int i = 0; i < n; ++i) {
            KDChart chart = (KDChart)this.msp.getMultiPartComponent(i);
            ((ChartModel)chart.getUserObject()).flush();
        }
    }

    protected ChartModel addChart() {
        DefaultChartDataBuilder dc = new DefaultChartDataBuilder(this.ws.getOlapModel());
        ChartModel cm = new ChartModel(dc, new ChartModelListener(){

            @Override
            public void finishDataSet(ChartModel cm, DefaultChartDataBuilder dc) {
                KDChart chart = BireportBaseMainUI.this.getChart(cm.getUniqueName());
                if (chart == null) {
                    chart = BireportBaseMainUI.this.buildKDChart();
                }
                chart.setName(cm.getUniqueName());
                chart.setUserObject((Object)cm);
                cm.setChart(chart);
                chart.getChartTitle().setText(cm.getTitle());
                BireportBaseMainUI.this.msp.addMultiPartComponent(cm.getTitle(), (Component)chart);
            }

            @Override
            public void flushDataSet(ChartModel cm, DefaultChartDataBuilder dc) {
                KDChart chart = cm.getChart();
                ChartComponent cc = new ChartComponent(chart, BireportBaseMainUI.this.config);
                cc.setExceptionHandler(BireportBaseMainUI.this.expHandler);
                cc.setModel(BireportBaseMainUI.this.ws.getOlapModel(), false);
                cc.setChartDataBuilder((ChartDataBuilder2)dc);
                BireportBaseMainUI.this.ccList.add(cc);
                if (cm.getChartType() != null) {
                    ChartType ct = cm.getChartType();
                    chart.setChartType(ct);
                    if (ct == ChartType.CT_PIE || ct == ChartType.CT_PIEEXPLODED || ct == ChartType.CT_PIE3D || ct == ChartType.CT_MULTIPIE) {
                        chart.setPieChartSectionLabelType(0);
                    }
                }
                dc.setReverse(cm.isReverse());
                chart.setDisplayLegend(true);
                cc.refresh();
                chart.updateUI();
            }
        });
        return cm;
    }

    protected void addChart(Member[] ms, ChartType chartType) {
        StringBuffer s = new StringBuffer();
        String[] m = new String[ms.length];
        ChartModel cm = this.addChart();
        int n = ms.length;
        for (int i = 0; i < n; ++i) {
            s.append(ms[i].getCaption());
            if (i != n - 1) {
                s.append('-');
            }
            m[i] = ms[i].getUniqueName();
            cm.addShowMember(ms[i].getDimension().getName(), ms[i].getName());
        }
        cm.setTitle(s.toString()).setChartType(chartType).finishDataSet();
    }

    protected void addDefaultChart() {
        this.addChart().setTitle(this.getUITitle()).setChartType(ChartType.CT_COLUMNCLUSTERED3D).finishDataSet();
    }

    protected void removeChart(KDChart chart) {
        OlapModel model = this.ws.getOlapModel();
        if (model != null) {
            int n = this.ccList.size();
            for (int i = 0; i < n; ++i) {
                ChartComponent cc = (ChartComponent)this.ccList.get(i);
                if (cc.getKdchart() != chart) continue;
                model.removeModelChangeListener((ModelChangeListener)cc);
                cc.setExceptionHandler(null);
                this.ccList.remove(cc);
                break;
            }
        }
        this.msp.removeMultiPartComponent((Component)chart);
        if (this.ccList.size() == 0) {
            this.showChart(false);
        }
        this.doChartLayout();
    }

    protected void clearChart() {
        OlapModel model = this.ws.getOlapModel();
        if (model != null) {
            int n = this.ccList.size();
            for (int i = 0; i < n; ++i) {
                model.removeModelChangeListener((ModelChangeListener)this.ccList.get(i));
            }
        }
        this.ccList.clear();
        this.msp.clearMultiPartComponent();
    }

    protected void doChartLayout() {
        this.msp.reLayout();
        this.msp.updateUI();
    }

    private void changeSplitLayout(boolean showSplit) {
        KDTable tbl = this.getTableForPrintSetting();
        if (this.split == null) {
            this.split = new KDSplitPane(1);
            tbl.setPreferredSize(new Dimension(tbl.getWidth() / 2, tbl.getHeight()));
            this.split.add((Component)((Object)this.msp), (Object)"right");
        }
        if (showSplit) {
            this.parent.remove(this.ws.getJComponent());
            this.split.add((Component)this.ws.getJComponent(), (Object)"left");
            this.parent.add((Component)this.split, this.constraints);
        } else {
            this.split.remove((Component)this.ws.getJComponent());
            this.parent.remove((Component)this.split);
            this.parent.add((Component)this.ws.getJComponent(), this.constraints);
        }
    }

    @Override
    public void actionSwapAxes_actionPerformed(ActionEvent e) throws Exception {
        if (this.ws == null || this.ws.getOlapModel() == null) {
            return;
        }
        this.ws.swapAxis();
    }

    @Override
    public void actionDisplayConfig_actionPerformed(ActionEvent e) throws Exception {
        if (this.ws == null || this.ws.getOlapModel() == null) {
            return;
        }
        this.ws.openLayoutDesigner();
    }

    protected boolean enableSlicer() {
        return false;
    }

    protected boolean enableTablePreferences() {
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionConfig = new BireportActionConfig();
        this.actionConfig.setDisplayConfigActionVisible(false);
        this.actionConfig.setFilterDataActionVisible(false);
        this.actionConfig.setCustomStyleActionVisible(false);
        this.msp.setFrameTitle(this.getUITitle());
        this.config = ComponentConfig.getConfig();
        KDTable tbl = this.getTableForPrintSetting();
        tbl.checkParsed();
        this.enableCustomChart(this.isEnableCustomChart());
        this.constraints = tbl.getClientProperty((Object)"KDLayoutConstraints");
        this.parent = tbl.getParent();
        this.ws = new WorksheetComponent(tbl, this.config, this.enableSlicer());
        this.parent.add((Component)this.ws.getJComponent(), this.constraints);
        this.ws.setExceptionHandler(this.expHandler);
        tbl.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    BireportBaseMainUI.this.onTableSelectChanged(e);
                }
                catch (Exception exc) {
                    BireportBaseMainUI.this.handUIException(exc);
                }
            }
        });
        tbl.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    BireportBaseMainUI.this.onTableClicked(e);
                }
                catch (Exception exc) {
                    BireportBaseMainUI.this.handUIException(exc);
                }
            }
        });
        tbl.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    BireportBaseMainUI.this.onTableKeyPressed(e);
                }
                catch (Exception exc) {
                    BireportBaseMainUI.this.handUIException(exc);
                }
            }
        });
        this.popMenuItemcustomChart.setText(EASResource.getString((String)"com.kingdee.eas.framework.bireport.client.BireportBaseMainUI.ShowSelectColumnChart"));
        this.getMenuManager(tbl).getMenu().add(this.popMenuItemcustomChart);
        this.popMenuItemcustomChart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BireportBaseMainUI.this.setCursorOfWair();
                    BireportBaseMainUI.this.showChartOnSelected();
                }
                catch (Exception ex) {
                    BireportBaseMainUI.this.handleException(ex);
                }
                finally {
                    BireportBaseMainUI.this.setCursorOfDefault();
                }
            }
        });
        Map ctx = this.getUIContext();
        if (Boolean.valueOf(String.valueOf(this.getUIContext().get(UICONTEXT_KEY_BE_JOINQUERY))).booleanValue()) {
            this.onJoinQuery((RptParams)this.getUIContext().get(UICONTEXT_KEY_JOINQUERY_PARAMS));
        } else if (ctx.get("RPTFilter") != null) {
            this.onJoinQuery((RptParams)ctx.get("RPTFilter"));
        } else {
            this.init();
            if (this.isShowDialogOnLoad()) {
                if (!this.showQueryDialog(true)) {
                    this.close();
                }
            } else {
                this.query();
            }
        }
        KDTable t = this.getTableForOA();
        if (t != null && !this.enableTablePreferences()) {
            this.tHelper.getDisabledTables().add(t);
        }
    }

    public void onJoinQuery(RptParams jparams) throws Exception {
        this.init();
        this.params = jparams;
        this.query();
        this.shouldReloadPrintVar = true;
    }

    protected void init() throws Exception {
        this.initActionConfig();
    }

    protected BireportBaseMainUI createJoinQueryUIWindow(Class rptUIClass, UIContext ctx, RptParams joinQueryParams) throws Exception {
        if (ctx == null) {
            ctx = new UIContext((Object)this);
        }
        ctx.put((Object)UICONTEXT_KEY_BE_JOINQUERY, (Object)true);
        ctx.put((Object)UICONTEXT_KEY_JOINQUERY_PARAMS, (Object)joinQueryParams);
        IUIWindow win = this._createJoinQueryUIWindow((CoreUIObject)this, rptUIClass.getName(), ctx, null, false);
        BireportBaseMainUI ui = (BireportBaseMainUI)win.getUIObject();
        return ui;
    }

    private IUIWindow _createJoinQueryUIWindow(CoreUIObject parentUI, String className, UIContext ctx, Map dataObjects, boolean useExists) throws Exception {
        String mode = parentUI.getUIWindow() instanceof UINewFrame ? "com.kingdee.eas.base.uiframe.client.UINewFrameFactory" : "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        return UIFactory.createUIFactory((String)mode).create(className, (Map)ctx, dataObjects);
    }

    protected void setUIContextInitParams(RptParams aParams) {
        this.getUIContext().put(UICONTEXT_KEY_INITPARAMS, aParams);
    }

    protected RptParams getUIContextInitParams() {
        return (RptParams)this.getUIContext().get(UICONTEXT_KEY_INITPARAMS);
    }

    protected void initActionConfig() {
        if (this.isGroupSumReport()) {
            this.setActionConfig(BireportActionConfig.getGroupSumReportConfig());
        } else {
            this.setActionConfig(this.actionConfig);
        }
    }

    public BireportActionConfig getActionConfig() {
        return this.actionConfig;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.setButtonDefaultStyl(this.btnFilt);
        this.btnFilt.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemFilt.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnDisplayConfig.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.menuItemDisplayConfig.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.btnShowChart.setIcon(EASResource.getIcon((String)"imgTbtn_chart"));
        this.menuShowChart.setIcon(EASResource.getIcon((String)"imgTbtn_chart"));
        this.btnCustomChart.setIcon(EASResource.getIcon((String)"imgTbtn_graphsetting"));
        this.menuCustomChart.setIcon(EASResource.getIcon((String)"imgTbtn_graphsetting"));
        this.btnSwapAxes.setIcon(EASResource.getIcon((String)"imgTbtn_swapaxes"));
        this.menuSwapAxes.setIcon(EASResource.getIcon((String)"imgTbtn_swapaxes"));
        this.btnShowSortRank.setIcon(EASResource.getIcon((String)"imgTbtn_sortorder"));
        this.menuShowSortRank.setIcon(EASResource.getIcon((String)"imgTbtn_sortorder"));
        this.btnChartAnalysis.setIcon(EASResource.getIcon((String)"imgTbtn_graphsetting"));
        this.menuChartAnalysis.setIcon(EASResource.getIcon((String)"imgTbtn_graphsetting"));
        this.btnSizerData.setIcon(EASResource.getIcon((String)"imgTbtn_billfilter"));
        this.menuSizerData.setIcon(EASResource.getIcon((String)"imgTbtn_billfilter"));
        this.btnShowCustomStyle.setIcon(EASResource.getIcon((String)"imgTbtn_showsetting"));
        this.menuShowCustomStyle.setIcon(EASResource.getIcon((String)"imgTbtn_showsetting"));
    }

    protected void setButtonIcon(JButton btn, String imgResourceName) {
        Icon icon = EASResource.getIcon((String)imgResourceName);
        btn.setToolTipText(btn.getText());
        btn.setText(btn.getText());
        btn.setIcon(icon);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.query();
        if (this.showChart) {
            this.showChart = false;
            this.showChart(true);
        }
        this.shouldReloadPrintVar = true;
    }

    @Override
    public void actionFilt_actionPerformed(ActionEvent e) throws Exception {
        this.showQueryDialog(false);
        if (this.showChart) {
            this.showChart = false;
            this.showChart(true);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.doPrint(false);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.doPrint(true);
    }

    protected String getPrintTemplatePath() {
        return null;
    }

    protected Map getPrintTemplateLabelMap() {
        return null;
    }

    private void doPrint(boolean preview) throws Exception {
        KDTable tbl = this.getTableForPrintSetting();
        String tempPath = this.getPrintTemplatePath();
        if (tempPath != null && tempPath.length() > 0) {
            KDNoteHelper nh = new KDNoteHelper();
            TemplatePrintDataSource ds = new TemplatePrintDataSource(tbl, this.getPrintTemplateLabelMap());
            if (preview) {
                nh.printPreview(tempPath, (Object)ds, (Component)((Object)this));
            } else {
                nh.print(tempPath, (Object)ds, (Component)((Object)this));
            }
        } else {
            this.preparePrintPage(tbl);
            this.tableImagePrinter = new KDTableImagePrinter();
            this.tableImagePrinter.setSpace(20);
            this.tableImagePrinter.addDataParser(KDTable.class, KDTableImagePrinter.TABLE_PARSER);
            this.tableImagePrinter.addDataParser(Image.class, KDTableImagePrinter.IMAGE_PARSER);
            this.tableImagePrinter.setParent((Component)((Object)this));
            ArrayList<Object> pList = new ArrayList<Object>();
            pList.add(tbl);
            List imageList = new ChartImage().getImageList();
            int n = imageList.size();
            for (int i = 0; i < n; ++i) {
                ChartImage ci = (ChartImage)imageList.get(i);
                pList.add(new ImageIcon(ci.data).getImage());
            }
            this.tableImagePrinter.setPrintData(pList.toArray());
            this.tableImagePrinter.getPrinter().setVariantParser(new IVariantParser(){

                public String parse(String name, PainterInfo info) {
                    return String.valueOf(BireportBaseMainUI.this.getPrintExtVarProvider().requestVarData(name).getValue());
                }
            });
            this.tableImagePrinter.setHeader(HeadFootParser.parseHeadFootPage2Model((Page)this.getTableForPrintSetting().getPrintManager().getHeader()));
            this.tableImagePrinter.setFooter(HeadFootParser.parseHeadFootPage2Model((Page)this.getTableForPrintSetting().getPrintManager().getFooter()));
            String configName = tbl.getPrintManager().getNewPrintManager().getPrinter().getPrintConfig().createXmlTrans().getName();
            Element e = this.getKDFForTable(tbl).getKDTableNewPrintConfig(configName);
            if (e != null) {
                this.tableImagePrinter.fromXmlElement(e);
            }
            this.tableImagePrinter.getPrinter().addPrintActionListener((IPrintActionListener)this);
            if (preview) {
                this.tableImagePrinter.printPreview();
            } else {
                this.tableImagePrinter.print();
            }
            tbl.getPrintManager().fromXmlElement(this.tableImagePrinter.getPrinter().getPrintConfig().toXmlElement());
        }
    }

    public void beforePrintOrPreview() {
    }

    public void beforePreview() {
    }

    public void beforePrint() {
    }

    public void closePreview() {
        if (this.tableImagePrinter != null) {
            KDPrinter pTable = this.getTableForPrintSetting().getPrintManager().getNewPrintManager().getPrinter();
            Element printElement = this.tableImagePrinter.getPrinter().getPrintConfig().toXmlElement();
            pTable.getPrintConfig().fromXmlElement(printElement);
            this.printService.savePrintSetting();
        }
    }

    public void addCellStylePattern(String stylePattern) {
        this.ws.getStyleExpert().addCellStylePattern(stylePattern);
    }

    public void clearCellStylePattern() {
        this.ws.getStyleExpert().clear();
    }

    public void addMergeItem(String[] memberUniqueNames, int contentIndex) {
        this.ws.getMergeExpert().addItem(memberUniqueNames, contentIndex);
    }

    public void clearMergeItem() {
        this.ws.getMergeExpert().clear();
    }

    protected void initQueryDialog(CommonQueryDialog queryDialog) {
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanels == null) {
            int i;
            this.userPanels = this.getCustomerQueryPanels();
            int n = this.userPanels.length;
            this.userPanel = this.userPanels[0];
            for (i = 0; i < n; ++i) {
                this.userPanels[i].loadFields();
            }
            for (i = 0; i < n; ++i) {
                this.userPanels[i].initLayout();
                this.queryDialog.addUserPanel((KDPanel)this.userPanels[i]);
            }
            Dimension dd = this.getQueryDialogSize(this.userPanels);
            this.queryDialog.setWidth(dd.width);
            this.queryDialog.setHeight(dd.height);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.getQueryDialogTitle(this.userPanels));
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(this.isQueryDialogShowFilter());
            this.queryDialog.setShowSorter(this.isQueryDialogShowSorter());
            this.queryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            this.initQueryDialog(this.queryDialog);
            CustomerParams cp = null;
            if (this.params != null) {
                cp = this.buildCustomerParams();
            }
            for (int i2 = 0; i2 < n; ++i2) {
                Method m = this.userPanels[i2].getClass().getMethod("onInit", RptParams.class);
                m.invoke((Object)this.userPanels[i2], this.getUIContextInitParams());
                if (this.params == null) continue;
                this.userPanels[i2].setCustomerParams(cp);
            }
        }
    }

    protected String getQueryDialogTitle(CustomerQueryPanel[] userPanels) {
        return userPanels[0].getUITitle();
    }

    protected Dimension getQueryDialogSize(CustomerQueryPanel[] userPanels) {
        Dimension size = new Dimension(100, 100);
        int n = userPanels.length;
        for (int i = 0; i < n; ++i) {
            Dimension d = userPanels[i].getSize();
            if (d.height > size.height) {
                size.height = d.height;
            }
            if (d.width <= size.width) continue;
            size.width = d.width;
        }
        size.height += 35;
        size.width += 228;
        size.height += 105;
        if (size.width <= 290 && size.height <= 280) {
            size.width = 290;
            size.height = 280;
        } else if (size.width <= 580 && size.height <= 435) {
            size.width = 580;
            size.height = 435;
        } else if (size.width <= 680 && size.height <= 510) {
            size.width = 680;
            size.height = 510;
        } else if (size.width <= 792 && size.height <= 566) {
            size.width = 792;
            size.height = 566;
        }
        size.width -= 228;
        size.height -= 105;
        return size;
    }

    protected CommonQueryDialog getQueryDialog() {
        return this.queryDialog;
    }

    protected boolean isQueryDialogShowFilter() {
        return false;
    }

    protected boolean isQueryDialogShowSorter() {
        return false;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            this.initQueryDialog();
            int n = this.userPanels.length;
            for (int i = 0; i < n; ++i) {
                this.userPanels[i].getUIContext().clear();
                this.userPanels[i].getUIContext().putAll(this.getUIContext());
            }
            if (useDefaultSolution) {
                QueryPanelInfo qpi;
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                QuerySolutionInfo solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), queryName);
                if (solution != null && (qpi = solution.getQueryPanelInfo().get(0)) != null) {
                    try {
                        CustomerParams cp;
                        byte[] bs = qpi.getParam();
                        if (bs != null) {
                            this.params = (RptParams)CommonUtil.getObject((byte[])bs);
                        }
                        if (this.params != null) {
                            cp = this.buildCustomerParams();
                            for (int i = 0; i < n; ++i) {
                                this.userPanels[i].setCustomerParams(cp);
                            }
                        } else {
                            cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                            if (cp != null) {
                                Object obj = this.buildRptParams(cp);
                                this.params = obj instanceof RptParams ? (RptParams)obj : null;
                                for (int i = 0; i < n; ++i) {
                                    this.userPanels[i].setCustomerParams(cp);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Load customer params failed.", (Throwable)e);
                    }
                }
            }
            boolean ok = false;
            if ((this.params == null || !useDefaultSolution) && this.queryDialog.show()) {
                this.params = new RptParams();
                for (int i = 0; i < n; ++i) {
                    this.params.putAll(((BireportBaseFilterUI)this.userPanels[i]).getCustomCondition().toMap());
                }
                ok = true;
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                CustomerParams cp = this.buildCustomerParams();
                for (int i = 0; i < n; ++i) {
                    this.userPanels[i].setCustomerParams(cp);
                }
                this.query();
                this.shouldReloadPrintVar = true;
                return true;
            }
        }
        catch (RuntimeException rue) {
            throw rue;
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    protected KDTable getTableForOA() {
        return this.getTableForPrintSetting();
    }

    public File[] toExcelFiles(KDTable[] tables) throws Exception {
        if (tables != null) {
            ExportManager exportM = new ExportManager();
            String path = null;
            File tempFile = File.createTempFile("eastemp", ".xls");
            path = tempFile.getCanonicalPath();
            KDTables2KDSBookVO[] tablesVO = new KDTables2KDSBookVO[tables.length];
            for (int i = 0; i < tables.length; ++i) {
                tablesVO[i] = new KDTables2KDSBookVO(tables[i]);
                tablesVO[i].setTableName(this.getUITitle());
            }
            KDSBook book = null;
            book = KDTables2KDSBook.getInstance().exportKDTablesToKDSBook(tablesVO, true, true);
            List imageList = new ChartImage().getImageList();
            int n = imageList.size();
            for (int i = 0; i < n; ++i) {
                ChartImage ci = (ChartImage)imageList.get(i);
                KDSBook.KDSImage img = new KDSBook.KDSImage(ci.data, ci.type, ci.width, ci.height);
                img.setSheetName(ci.name);
                book.addImage(img);
            }
            exportM.exportToExcel(book, path);
            return new File[]{new File(path)};
        }
        return null;
    }

    public File[] toHTMLFiles(KDTable[] tables) throws Exception {
        if (tables != null) {
            ExportManager exportM = new ExportManager();
            String path = null;
            File tempFile = File.createTempFile("eastemp", ".html");
            path = tempFile.getCanonicalPath();
            KDTables2KDSBookVO[] tablesVO = new KDTables2KDSBookVO[tables.length];
            for (int i = 0; i < tables.length; ++i) {
                tablesVO[i] = new KDTables2KDSBookVO(tables[i]);
                tablesVO[i].setTableName(this.getUITitle());
            }
            KDSBook book = null;
            book = KDTables2KDSBook.getInstance().exportKDTablesToKDSBook(tablesVO, true, true);
            List imageList = new ChartImage().getImageList();
            int n = imageList.size();
            for (int i = 0; i < n; ++i) {
                ChartImage ci = (ChartImage)imageList.get(i);
                KDSBook.KDSImage img = new KDSBook.KDSImage(ci.data, ci.type, ci.width, ci.height);
                img.setSheetName(ci.name);
                book.addImage(img);
            }
            PrintableBook printBook = new PrintableBook(book);
            String[] fs = exportM.exportToHtmlFile(printBook, path);
            ArrayList<File> list = new ArrayList<File>();
            list.add(new File(path));
            if (fs != null && fs.length > 0) {
                int n2 = fs.length;
                for (int i = 0; i < n2; ++i) {
                    list.add(new File(fs[i]));
                }
            }
            File[] files = new File[list.size()];
            list.toArray(files);
            return files;
        }
        return null;
    }

    public Object getLastEntityViewInfo() {
        return this.params;
    }

    protected IMetaDataPK getQueryMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.framework.bireport.app", "BireportEmptyQuery");
    }

    protected void close() {
        SysUtil.abort();
    }

    protected void disposeUIWindow() {
        try {
            this.closeRequest();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.msp.dispose();
        super.disposeUIWindow();
    }

    protected static String getRes(String key) {
        return EASResource.getString((String)"com.kingdee.eas.framework.bireport.BireportResource", (String)key);
    }

    protected boolean isAllowLoadPrintSetting() {
        return true;
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        class MyExtVarProvider
        implements ExtVarProvider {
            Map varMap = null;

            MyExtVarProvider() {
                this.initVarMap();
            }

            private void initVarMap() {
                this.varMap = BireportBaseMainUI.this.preparePrintVariantMap();
                BireportBaseMainUI.this.shouldReloadPrintVar = false;
            }

            public Variant requestVarData(String varName) {
                if (BireportBaseMainUI.this.shouldReloadPrintVar) {
                    this.initVarMap();
                }
                if (this.varMap == null) {
                    return null;
                }
                Object obj = this.varMap.get(varName);
                if (!(obj instanceof Variant)) {
                    Variant v = new Variant();
                    v.setObject(obj);
                    return v;
                }
                return (Variant)obj;
            }
        }
        return new MyExtVarProvider();
    }

    protected Member[] getSlicer() {
        return ((ChangeSlicer)this.ws.getOlapModel().getExtension("changeSlicer")).getSlicer();
    }

    protected Member getSlicerByDimensionName(String dimensionName) {
        Member[] ms = this.getSlicer();
        if (ms != null) {
            String buf = dimensionName.toLowerCase();
            int n = ms.length;
            for (int i = 0; i < n; ++i) {
                if (!ms[i].getDimension().getName().toLowerCase().equals(buf)) continue;
                return ms[i];
            }
        }
        return null;
    }

    protected Member[] getSelectedDataCellItemInfo() {
        KDTSelectBlock block = this.getTableForPrintSetting().getSelectManager().get();
        if (block != null) {
            return this.getDataCellItemInfo(block.getTop(), block.getLeft());
        }
        return null;
    }

    protected Member[] getDataCellItemInfo(int row, int col) {
        CellItem ci;
        ICell cell = this.getTableForPrintSetting().getCell(row, col);
        if (cell != null && (ci = this.ws.getCellItem(cell)) != null && ci.isDataCellItem()) {
            return ((DataCellItem)ci).getMemberContext();
        }
        return null;
    }

    protected void onTableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    protected void onTableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void onTableKeyPressed(KeyEvent e) throws Exception {
    }

    private void initWorksheetComponentStyle(ComponentConfig config) {
        config.showNestMemberForRow = false;
        config.showNestMemberForColumn = false;
        config.showColumnDimensionHeader = false;
        config.showPopupMenuForDimensionHeader = false;
        config.showPopupMenuForMember = false;
        config.showPopupMenuForData = false;
        config.showTreeIconForColumnHeader = true;
        config.showColumnHeaderInTableHeader = true;
        config.drillDownWhenDoubleClickMember = false;
        config.useNonEmpty = false;
        config.expandMode = 1;
        config.showDimensionNavigator = this.isShowDimensionNavigator();
        config.showNestMemberForColumn = this.isShowNestingForColumns();
        config.showNestMemberForRow = this.isShowNestingForRows();
        config.autoMergeColumnHead = this.isAutoMergeColumnHead();
        config.autoMergeRowHead = this.isAutoMergeRowHead();
        config.nullPointSmooth = this.isNullPointSmooth();
    }

    protected boolean isShowNestingForColumns() {
        return false;
    }

    protected boolean isShowNestingForRows() {
        return false;
    }

    protected boolean isShowDimensionNavigator() {
        return true;
    }

    protected boolean isGroupSumReport() {
        return false;
    }

    private boolean isRemoteConnection() {
        return true;
    }

    public RptParams getReturnParams() {
        return this.returnParams;
    }

    protected void query() throws Exception {
        UserPreferenceData upd;
        UserCustomConfigInfo userConfigInfo;
        RptParams p;
        BenchmarkTimer.enable(true);
        BenchmarkTimer.startTime("BI Report client query cost");
        this.error = null;
        this.initWorksheetComponentStyle(this.config);
        this.onBeforeQuery();
        this.toolBar.remove((Component)this.btnShowCustomStyle);
        this.menuView.remove((JMenuItem)this.menuShowCustomStyle);
        this.actionShowCustomStyle.setVisible(false);
        this.btnShowCustomStyle.setEnabled(false);
        this.menuShowCustomStyle.setEnabled(false);
        this.setShouldCloseFirst(true);
        String olapUseMode = null;
        if (this.isGroupSumReport()) {
            olapUseMode = "Group_Sum_Report";
        }
        p = (p = this.getParamsForRequest()) == null ? new RptParams() : RptParams.parseFrom((Map)p.toMap());
        p.setString("PERMISSION_PARAM_USER_ID", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        p.setString("PERMISSION_PARAM_ORG_ID", SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        p.setBoolean("useNonEmpty", this.config.useNonEmpty);
        p.setBoolean("nonEmptyForRow", this.config.nonEmptyForRow);
        p.setBoolean("nonEmptyForColumn", this.config.nonEmptyForColumn);
        Map uiParams = this.prepareUIParams();
        if (uiParams != null) {
            p.setObject("OLAP_KEY_UIPARAMS", (Object)uiParams);
        }
        IObjectPK pk = super.buildPK();
        p.setObject("OLAP_KEY_PK", (Object)pk);
        boolean remoteConnection = this.isRemoteConnection();
        int caller = ((Object)((Object)this)).hashCode();
        OlapModel model = null;
        try {
            model = this.requestModel(p, remoteConnection, olapUseMode, caller);
        }
        catch (BIReportException e) {
            MsgBox.showInfo((String)e.getMessage());
            return;
        }
        this.clearChart();
        this.ws.setModel(model);
        if (this.isShowDefaultChart()) {
            this.addDefaultChart();
        }
        model.addModelChangeListener(new ModelChangeListener(){

            public void modelChanged(ModelChangeEvent e) {
                try {
                    BireportBaseMainUI.this.onModelChanged(e);
                }
                catch (Exception ex) {
                    BireportBaseMainUI.this.error = ex.getMessage();
                }
            }

            public void structureChanged(ModelChangeEvent e) {
            }
        });
        Map uiInfo = (Map)this.getReturnParams().getObject("OLAP_KEY_UIINFO");
        if (uiInfo != null) {
            this.uiInfo = uiInfo;
        }
        if ((userConfigInfo = (UserCustomConfigInfo)this.getReturnParams().getObject("OLAP_KEY_USERCUSTOMCONFIG")) != null && (upd = this.tHelper.getUserDataFromDB(userConfigInfo)) != null) {
            this.tHelper.applyConfigFromData(this.getTableForOA(), (UserCustomConfigItemData)upd.getTables().values().iterator().next());
        }
        try {
            this.onModelChanged(null);
        }
        catch (Exception e) {
            this.error = e.getMessage();
        }
        this.onAfterQuery();
        this.doChartLayout();
        if (this.error != null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.error);
        }
        BenchmarkTimer.stopTime();
    }

    protected void onModelChanged(ModelChangeEvent e) throws Exception {
        if (!this.ws.isEmpty()) {
            this.resetWorksheetAction();
            if (this.ws.getOlapModel() != null) {
                this.setTableDataCellStyle(this.getMeasurePrecision());
                this.mergeRegionHeader();
            }
        } else {
            this.disableWorksheetAction();
        }
        this.afterModelChanged();
    }

    protected void afterModelChanged() throws Exception {
    }

    protected void mergeRegionHeader() throws Exception {
        Object value;
        IRow row;
        KDTable tbl = this.getTableForPrintSetting();
        int topH = tbl.getHeadRowCount();
        int cols = tbl.getColumnCount();
        int rows = tbl.getRowCount();
        if (this.isAutoMergeColumnHead()) {
            Object[][] r = new Object[topH][cols];
            for (int i = 0; i < topH; ++i) {
                row = this.config.showColumnHeaderInTableHeader ? tbl.getHeadRow(i) : tbl.getRow(i);
                for (int j = 0; j < cols; ++j) {
                    value = row.getCell(j).getValue();
                    r[i][j] = value == null ? null : String.valueOf(value);
                }
            }
            List colList = CellMatrix.parseAutoMatchMergeRegion(r, false, true, false, tbl);
            KDTableUtil.mergeTableCell((List)colList, (boolean)this.config.showColumnHeaderInTableHeader, (KDTable)tbl);
        }
        if (this.isAutoMergeRowHead()) {
            int leftH = OlapModelUtil.getLeftAxisHies((OlapModel)this.ws.getOlapModel()).length + OlapModelUtil.getDimensionPropertyCount((Axis)OlapModelUtil.getLeftAxis((OlapModel)this.ws.getOlapModel()));
            Object[][] c = new Object[rows][leftH];
            String lastV = null;
            Pattern p = Pattern.compile(this.getSumKeyPattern());
            for (int i = 0; i < rows; ++i) {
                lastV = null;
                for (int j = 0; j < leftH; ++j) {
                    String v;
                    row = tbl.getRow(i);
                    value = row.getCell(j).getValue();
                    String string = v = value == null ? null : String.valueOf(value);
                    if (value instanceof MemberCellItem) {
                        lastV = v;
                    } else {
                        v = lastV;
                    }
                    c[i][j] = v != null && p.matcher(v).matches() ? v : null;
                }
            }
            List rowList = CellMatrix.parseAutoMatchMergeRegion(c, true, false, false, null);
            KDTableUtil.mergeTableCell((List)rowList, (boolean)false, (KDTable)tbl);
        }
    }

    protected boolean isAutoMergeRowHead() {
        return true;
    }

    protected boolean isAutoMergeColumnHead() {
        return true;
    }

    protected boolean isNullPointSmooth() {
        return false;
    }

    protected void setTableDataCellStyle(int precision) throws Exception {
    }

    protected void setSumKeyPattern(String sumKeyPattern) {
        this.mycontext.put("sumKeyPattern", sumKeyPattern);
    }

    protected String getSumKeyPattern() {
        String key = (String)this.mycontext.get("sumKeyPattern");
        String heji = "\u5408\u8ba1";
        String xiaoji = "\u5c0f\u8ba1";
        if ("l1".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
            heji = "Total|Ttl";
            xiaoji = "Subtotal";
        }
        String sumKeyPattern = heji + "|" + xiaoji;
        return key == null ? sumKeyPattern : key;
    }

    protected void setMeasurePrecision(int precision) {
        this.mycontext.put("measurePrecision", new Integer(precision));
    }

    protected int getMeasurePrecision() {
        Integer p = (Integer)this.mycontext.get("measurePrecision");
        return p == null ? 2 : p;
    }

    protected void setShowDefaultChart(boolean showDefaultChart) {
        this.mycontext.put("showDefaultChart", showDefaultChart);
    }

    protected boolean isShowDefaultChart() {
        Boolean b = (Boolean)this.mycontext.get("showDefaultChart");
        return b == null ? true : b;
    }

    protected void enableCustomChart(boolean b) {
        this.mycontext.put("enableCustomChart", b);
        this.popMenuItemcustomChart.setVisible(b);
        this.actionCustomChart.setVisible(b);
    }

    protected boolean isEnableCustomChart() {
        Boolean b = (Boolean)this.mycontext.get("enableCustomChart");
        return b == null ? false : b;
    }

    protected void setSumCellBackground(String sumKeyPattern, Color bgColor) throws Exception {
        int k;
        int m;
        int to;
        int from;
        KDTMergeBlock mb;
        ICell cell;
        int j;
        IRow row;
        int i;
        KDTable tbl = this.getTableForPrintSetting();
        int leftH = OlapModelUtil.getLeftAxisHies((OlapModel)this.ws.getOlapModel()).length;
        int topH = OlapModelUtil.getTopAxisHies((OlapModel)this.ws.getOlapModel()).length;
        int cols = tbl.getColumnCount();
        int rows = tbl.getRowCount();
        int n = i = this.config.showColumnHeaderInTableHeader ? 0 : topH;
        while (i < rows) {
            row = tbl.getRow(i);
            for (j = 0; j < leftH; ++j) {
                cell = row.getCell(j);
                mb = cell.getMergeBlock();
                if (mb == null || !String.valueOf(cell.getValue()).matches(sumKeyPattern)) continue;
                from = mb.getTop();
                to = mb.getBottom();
                for (m = from; m <= to; ++m) {
                    for (k = leftH; k < cols; ++k) {
                        tbl.getCell(m, k).getStyleAttributes().setBackground(bgColor);
                    }
                }
                break;
            }
            ++i;
        }
        for (i = 0; i < topH; ++i) {
            row = this.config.showColumnHeaderInTableHeader ? (row = tbl.getHeadRow(i)) : tbl.getRow(i);
            for (j = leftH; j < cols; ++j) {
                cell = row.getCell(j);
                mb = cell.getMergeBlock();
                if (mb == null || !String.valueOf(cell.getValue()).matches(sumKeyPattern)) continue;
                from = mb.getLeft();
                to = mb.getRight();
                for (m = from; m <= to; ++m) {
                    int n2 = k = this.config.showColumnHeaderInTableHeader ? 0 : topH;
                    while (k < rows) {
                        tbl.getCell(k, m).getStyleAttributes().setBackground(bgColor);
                        ++k;
                    }
                }
                j += from - to > 0 ? from - to : 0;
            }
        }
    }

    protected OlapModel getOlapModel() {
        return this.ws.getOlapModel();
    }

    @Override
    public void actionShowSortRank_actionPerformed(ActionEvent e) throws Exception {
        if (this.ws == null || this.ws.getOlapModel() == null) {
            return;
        }
        this.ws.sortRank();
    }

    @Override
    public void actionSizerData_actionPerformed(ActionEvent e) throws Exception {
        if (this.ws == null || this.ws.getOlapModel() == null) {
            return;
        }
        this.ws.sizerData();
    }

    protected KDTable getTableForCommon() {
        return this.getTableForPrintSetting();
    }

    public boolean isSimpleModelForTablePreference() {
        return true;
    }

    protected BireportBaseFilterUI getQueryDialogUserPanel() throws Exception {
        throw new Exception("Method getQueryDialogUserPanel() not emplements!");
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return this.getQueryDialogUserPanel();
    }

    protected CustomerQueryPanel[] getCustomerQueryPanels() throws Exception {
        return new CustomerQueryPanel[]{this.getCustomerQueryPanel()};
    }

    protected abstract IBireportBaseFacade getRemoteInstance() throws BOSException;

    protected abstract RptParams getParamsForInit();

    protected abstract RptParams getParamsForRequest();

    protected abstract void onBeforeQuery() throws Exception;

    protected abstract void onAfterQuery() throws Exception;

    protected Map prepareUIParams() throws Exception {
        return null;
    }

    protected Map getPreparedUIInfo() throws Exception {
        return this.uiInfo;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman man = super.prepareInit();
        if (man != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.framework.bireport.app.BireportBaseMainUIHandler");
            request.put("className", (Object)((Object)((Object)this)).getClass().getName());
            String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
            request.put("queryName", (Object)queryName);
            man.setRequestContext((Serializable)request);
        }
        return man;
    }

    protected abstract KDTable getTableForPrintSetting();

    protected abstract void preparePrintPageHeader(HeadFootModel var1);

    protected abstract Map preparePrintVariantMap();

    private IUIActionPostman prepareEtlModel(RptParams rptParams, boolean remoteConnection, int caller) throws BOSException {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(UtilRequest.isPrepare((String)"ActionFilt", (CoreUIObject)this));
        if (!handler.isAvailabe()) {
            return handler;
        }
        RequestContext request = new RequestContext();
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("handleEtlModel");
        request.put("rptParams", (Object)rptParams);
        request.put("remoteConnection", (Object)remoteConnection);
        request.put("caller", (Object)new Integer(caller));
        request.setConfigPK(this.buildPK());
        BOSObjectType bosType = null;
        bosType = this.getRemoteInstance().getType();
        request.put("bosType", (Object)bosType);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public void setShouldCloseFirst(boolean b) {
        this.shouldCloseFirst = true;
    }

    public OlapModel requestModel(RptParams params, boolean remoteConnection, String olapUseMode, int caller) throws OlapException, OLAPException, BOSException, EASBizException, Exception {
        if (olapUseMode != null) {
            params.setString("OLAP_USEMODE", olapUseMode);
        }
        if (this.shouldCloseFirst) {
            params.setBoolean("OLAP_KEY_SHOULDCLOSEFIRST", true);
        }
        this.prepareEtlModel(params, remoteConnection, caller).callHandler();
        IBireportBaseFacade facade = this.getRemoteInstance();
        this.returnParams = facade.etlModel(params, remoteConnection, caller);
        if (remoteConnection) {
            RemoteConnection con = new RemoteConnection((RemoteInvoke)new BirtBaseRemoteInvokeAdapter(facade, caller), false);
            con.setDefaultCubeName(this.returnParams.getDefaultCubeName());
            con.setSr(this.returnParams.getSchemaReader());
            this.returnParams.setConnection((Connection)con);
        }
        this.shouldCloseFirst = false;
        OlapModel model = this.makeModel(this.returnParams.getMdx(), this.returnParams.getFiltString());
        model.setMdxResult(this.returnParams.getResult());
        return model;
    }

    public OlapModel makeModel(String mdx, String filter) throws OlapException, OLAPException {
        OlapModel model = ModelFactory.makeKDOlapModel((Connection)this.returnParams.getConnection(), (String)mdx);
        if (filter != null && filter.trim().length() > 0) {
            ((Filter)model.getExtension("filter")).setCondition(filter);
        }
        return model;
    }

    public void closeRequest() throws OLAPException {
        if (this.returnParams != null && this.returnParams.getConnection() != null) {
            this.returnParams.getConnection().close();
        }
    }

    protected CustomerParams buildCustomerParams() throws Exception {
        return RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params);
    }

    protected Object buildRptParams(CustomerParams cp) throws Exception {
        return RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
    }

    class BirtBaseRemoteInvokeAdapter
    implements RemoteInvoke {
        private IBireportBaseFacade facade;
        private int caller;

        BirtBaseRemoteInvokeAdapter(IBireportBaseFacade aFacade, int aCaller) {
            this.facade = aFacade;
            this.caller = aCaller;
        }

        public Object invoke(String method, Class[] argTypes, Object[] argValues) throws RemoteException {
            try {
                return this.facade.invokeConnectionAction(method, argTypes, argValues, this.caller);
            }
            catch (BOSException e) {
                if (e instanceof BIReportException) {
                    throw new RemoteException(e.getCause());
                }
                throw new RemoteException((Throwable)e);
            }
            catch (EASBizException e) {
                throw new RemoteException((Throwable)e);
            }
        }

        public Object[] invokeBatch(String[] methods, Class[][] argTypes, Object[][] argValues) throws RemoteException {
            int count = methods.length;
            StringBuffer sbMethod = new StringBuffer();
            sbMethod.append("OLAP_BATCH_INVOKE");
            for (int i = 0; i < count; ++i) {
                sbMethod.append(",").append(methods[i]);
            }
            Object[] argTypeAndValues = new Object[]{argTypes, argValues};
            Object[] ret = null;
            try {
                ret = (Object[])this.facade.invokeConnectionAction(sbMethod.toString(), null, argTypeAndValues, this.caller);
                return ret;
            }
            catch (BOSException e) {
                if (e instanceof BIReportException) {
                    throw new RemoteException(e.getCause());
                }
                throw new RemoteException((Throwable)e);
            }
            catch (EASBizException e) {
                throw new RemoteException((Throwable)e);
            }
        }
    }

    class ChartImage {
        int width = 400;
        int height = 300;
        int type = 6;
        byte[] data;
        String name;

        ChartImage() {
        }

        public List getImageList() {
            ArrayList<ChartImage> imageList = new ArrayList<ChartImage>();
            try {
                if (BireportBaseMainUI.this.showChart) {
                    int n = BireportBaseMainUI.this.ccList.size();
                    for (int i = 0; i < n; ++i) {
                        int h;
                        ChartComponent cc = (ChartComponent)BireportBaseMainUI.this.ccList.get(i);
                        KDChart kdchart = cc.getKdchart();
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        int w = kdchart.getWidth();
                        if (w < 10) {
                            w = 400;
                        }
                        if ((h = kdchart.getHeight()) < 10) {
                            h = 300;
                        }
                        ChartUtilities.writeChartAsPNG((OutputStream)os, (JFreeChart)kdchart.getDelegate(), (int)w, (int)h);
                        ChartImage ci = new ChartImage();
                        ci.width = w;
                        ci.height = h;
                        ci.data = os.toByteArray();
                        ci.name = kdchart.getChartTitle().getText();
                        imageList.add(ci);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return imageList;
        }
    }

    class ChartTabbledCloseHandler
    implements KDCloseableTabbedPane.CloseHandler {
        ChartTabbledCloseHandler() {
        }

        @Override
        public void close(Component tabbedComponent, int tabIndex) {
            if (BireportBaseMainUI.this.msp.getMultiPartCount() == 1) {
                MsgBox.showInfo((Component)tabbedComponent, (String)EASResource.getString((String)"com.kingdee.eas.framework.bireport.client.BireportBaseMainUI.ChartCloseInformation"));
            } else if (MsgBox.showConfirm2((Component)tabbedComponent, (String)EASResource.getString((String)"com.kingdee.eas.framework.bireport.client.BireportBaseMainUI.ChartCloseConfirm")) == 0) {
                BireportBaseMainUI.this.removeChart((KDChart)tabbedComponent);
            }
        }
    }
}

