/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.client;

import com.kingdee.bos.ctrl.analysis.bicomponent.DefaultChartDataBuilder;
import com.kingdee.bos.ctrl.analysis.bicomponent.IChartDataVisibleHandler;
import com.kingdee.bos.ctrl.analysis.bicomponent.OnlyLeafMemberVisibleHandler;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.eas.framework.bireport.client.ChartModelListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ChartModel {
    private DefaultChartDataBuilder dc = null;
    private ChartModelListener cl;
    private ChartType chartType;
    private String title;
    private boolean reverse;
    private Map showMap = new HashMap();
    private Map notShowMap = new HashMap();
    private String uniqueName;
    private KDChart chart = null;
    private boolean flushed = false;

    public ChartModel(DefaultChartDataBuilder dc, ChartModelListener cl) {
        this.dc = dc;
        this.cl = cl;
    }

    public ChartModel reset() {
        this.chartType = null;
        this.title = null;
        this.reverse = false;
        this.flushed = false;
        this.showMap.clear();
        this.notShowMap.clear();
        if (this.dc != null) {
            this.dc.reset();
        }
        return this;
    }

    public ChartModel addShowMember(String dimName, String memberUniqueName) {
        this.addElement(this.showMap, dimName, memberUniqueName);
        return this;
    }

    public ChartModel addNotShowMember(String dimName, String memberUniqueName) {
        this.addElement(this.notShowMap, dimName, memberUniqueName);
        return this;
    }

    public ChartModel addShowMembers(String dimName, String[] memberUniqueNames) {
        this.addElement(this.showMap, dimName, memberUniqueNames);
        return this;
    }

    public ChartModel addNotShowMembers(String dimName, String[] memberUniqueNames) {
        this.addElement(this.notShowMap, dimName, memberUniqueNames);
        return this;
    }

    public ChartModel setSeriesGroups(String[] seriesDimensionName, String[] groupsDimensionName) {
        this.dc.setSeriesGroups(seriesDimensionName, groupsDimensionName);
        return this;
    }

    public ChartModel setTopFilter(int topCount, String[] seriesDimItems) {
        this.dc.setTopFilter(topCount, seriesDimItems);
        return this;
    }

    private void addElement(Map map, String name, String value) {
        this.addElement(map, name, new String[]{value});
    }

    private void addElement(Map map, String name, String[] values) {
        HashSet<String> list = (HashSet<String>)map.get(name);
        if (list == null) {
            list = new HashSet<String>();
        }
        list.addAll(Arrays.asList(values));
        map.put(name, list);
    }

    public ChartModel setReverse(boolean b) {
        this.reverse = b;
        return this;
    }

    public ChartModel addVisibleHandler(IChartDataVisibleHandler handler) {
        this.dc.addVisibleHandler(handler);
        return this;
    }

    public ChartModel removeVisibleHandler(IChartDataVisibleHandler handler) {
        this.dc.removeVisibleHandler(handler);
        return this;
    }

    public ChartModel clearVisibleHandler() {
        this.dc.clearVisibleHandler();
        return this;
    }

    public ChartModel addOnlyLeafVisibleHandler(String dimPattern) {
        this.dc.addVisibleHandler((IChartDataVisibleHandler)new OnlyLeafMemberVisibleHandler(dimPattern));
        return this;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public ChartModel finishDataSet() {
        this.dc.setReverse(this.reverse);
        for (String name : this.showMap.keySet()) {
            this.dc.setShowMembers(name, ((Set)this.showMap.get(name)).toArray(new String[0]));
        }
        for (String name : this.notShowMap.keySet()) {
            this.dc.setNotShowMembers(name, ((Set)this.notShowMap.get(name)).toArray(new String[0]));
        }
        this.cl.finishDataSet(this, this.dc);
        return this;
    }

    public void flush() {
        if (!this.flushed) {
            this.cl.flushDataSet(this, this.dc);
            this.flushed = true;
        }
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public ChartModel setChartType(ChartType chartType) {
        this.chartType = chartType;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public ChartModel setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public ChartModel setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public KDChart getChart() {
        return this.chart;
    }

    public void setChart(KDChart chart) {
        this.chart = chart;
    }
}

