/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;

public class TemplatePrintDataSource
implements BOSQueryDelegate {
    public static final String DS_LABEL = "label";
    public static final String DS_HEADER = "header";
    public static final String DS_BODY = "body";
    public static final String DS_FIELD_PREFIX = "f";
    private KDTable tbl;
    private int cols;
    private DynamicRowSet lableDRS;

    public TemplatePrintDataSource(KDTable tbl, Map labelMap) throws SQLException {
        this.tbl = tbl;
        this.cols = tbl.getColumnCount();
        this.initLabelRowSet(labelMap);
    }

    private void initLabelRowSet(Map map) throws SQLException {
        if (map != null && map.size() > 0) {
            String key;
            int n = map.size();
            this.lableDRS = new DynamicRowSet(n);
            int i = 0;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                key = String.valueOf(iter.next());
                this.lableDRS.setColInfo(++i, key, key, 1, null);
            }
            this.lableDRS.moveToInsertRow();
            iter = map.keySet().iterator();
            while (iter.hasNext()) {
                key = String.valueOf(iter.next());
                this.lableDRS.updateString(key, String.valueOf(map.get(key)));
            }
            this.lableDRS.insertRow();
            this.lableDRS.beforeFirst();
        } else {
            this.lableDRS = new DynamicRowSet(1);
        }
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        try {
            String name = ds.getID();
            if (DS_HEADER.equals(name)) {
                return this.getHeader();
            }
            if (DS_BODY.equals(name)) {
                return this.getBody();
            }
            return this.lableDRS;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private IRowSet getHeader() throws SQLException {
        DynamicRowSet drs = this.createRowSet(this.cols);
        int n = this.tbl.getHeadRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tbl.getHeadRow(i);
            this.insertRow(drs, row);
        }
        drs.beforeFirst();
        return drs;
    }

    private IRowSet getBody() throws SQLException {
        DynamicRowSet drs = this.createRowSet(this.cols);
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tbl.getRow(i);
            this.insertRow(drs, row);
        }
        drs.beforeFirst();
        return drs;
    }

    private DynamicRowSet createRowSet(int colCount) throws SQLException {
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 0; i < colCount; ++i) {
            int n = i + 1;
            drs.setColInfo(n, DS_FIELD_PREFIX + n, DS_FIELD_PREFIX + n, 1, null);
        }
        return drs;
    }

    private void insertRow(DynamicRowSet drs, IRow row) throws SQLException {
        drs.moveToInsertRow();
        for (int i = 0; i < this.cols; ++i) {
            drs.updateString(i + 1, String.valueOf(row.getCell(i).getValue()));
        }
        drs.insertRow();
    }
}

