/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.olap.Filter;
import com.kingdee.bos.ctrl.analysis.olap.ModelFactory;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.remoting.RemoteConnection;
import com.kingdee.bos.olap.remoting.RemoteException;
import com.kingdee.bos.olap.remoting.RemoteInvoke;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.IBireportBaseFacade;
import com.kingdee.eas.framework.bireport.util.BIReportException;
import com.kingdee.eas.framework.bireport.util.OlapParams;
import com.kingdee.eas.framework.report.util.RptParams;

public class OlapRequest {
    private OlapParams returnParams;
    private boolean shouldCloseFirst = false;

    public void setShouldCloseFirst(boolean b) {
        this.shouldCloseFirst = true;
    }

    public OlapModel requestModel(RptParams params, IBireportBaseFacade facade, boolean remoteConnection, String olapUseMode, int caller) throws OlapException, OLAPException, BOSException, EASBizException {
        if (olapUseMode != null) {
            params.setString("OLAP_USEMODE", olapUseMode);
        }
        if (this.shouldCloseFirst) {
            params.setBoolean("OLAP_KEY_SHOULDCLOSEFIRST", true);
        }
        this.returnParams = facade.etlModel(params, remoteConnection, caller);
        if (remoteConnection) {
            RemoteConnection con = new RemoteConnection((RemoteInvoke)new BirtBaseRemoteInvokeAdapter(facade, caller), false);
            con.setDefaultCubeName(this.returnParams.getDefaultCubeName());
            con.setSr(this.returnParams.getSchemaReader());
            this.returnParams.setConnection((Connection)con);
        }
        this.shouldCloseFirst = false;
        OlapModel model = this.makeModel(this.returnParams.getMdx(), this.returnParams.getFiltString());
        model.setMdxResult(this.returnParams.getResult());
        return model;
    }

    public OlapModel makeModel(String mdx, String filter) throws OlapException, OLAPException {
        OlapModel model = ModelFactory.makeKDOlapModel((Connection)this.returnParams.getConnection(), (String)mdx);
        if (filter != null && filter.trim().length() > 0) {
            ((Filter)model.getExtension("filter")).setCondition(filter);
        }
        return model;
    }

    public OlapParams getReturnParams() {
        return this.returnParams;
    }

    public void close() throws OLAPException {
        if (this.returnParams != null && this.returnParams.getConnection() != null) {
            this.returnParams.getConnection().close();
        }
    }

    class BirtBaseRemoteInvokeAdapter
    implements RemoteInvoke {
        private IBireportBaseFacade facade;
        private int caller;

        BirtBaseRemoteInvokeAdapter(IBireportBaseFacade aFacade, int aCaller) {
            this.facade = aFacade;
            this.caller = aCaller;
        }

        public Object invoke(String method, Class[] argTypes, Object[] argValues) throws RemoteException {
            try {
                return this.facade.invokeConnectionAction(method, argTypes, argValues, this.caller);
            }
            catch (BOSException e) {
                if (e instanceof BIReportException) {
                    throw new RemoteException(e.getCause());
                }
                throw new RemoteException((Throwable)e);
            }
            catch (EASBizException e) {
                throw new RemoteException((Throwable)e);
            }
        }

        public Object[] invokeBatch(String[] methods, Class[][] argTypes, Object[][] argValues) throws RemoteException {
            int count = methods.length;
            StringBuffer sbMethod = new StringBuffer();
            sbMethod.append("OLAP_BATCH_INVOKE");
            for (int i = 0; i < count; ++i) {
                sbMethod.append(",").append(methods[i]);
            }
            Object[] argTypeAndValues = new Object[]{argTypes, argValues};
            Object[] ret = null;
            try {
                ret = (Object[])this.facade.invokeConnectionAction(sbMethod.toString(), null, argTypeAndValues, this.caller);
                return ret;
            }
            catch (BOSException e) {
                if (e instanceof BIReportException) {
                    throw new RemoteException(e.getCause());
                }
                throw new RemoteException((Throwable)e);
            }
            catch (EASBizException e) {
                throw new RemoteException((Throwable)e);
            }
        }
    }
}

