/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.util;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SqlQuery {
    private final ClauseList select = new ClauseList(true);
    private final ClauseList from = new ClauseList(true);
    private final ClauseList where = new ClauseList(false);
    private final ClauseList groupBy = new ClauseList(false);
    private final ClauseList having = new ClauseList(false);
    private final ClauseList orderBy = new ClauseList(false);
    private final List fromAliases = new ArrayList();
    private final String quoteIdentifierString = "\"";
    private final StringBuffer buf = new StringBuffer(128);

    public String quoteIdentifier(String val) {
        StringBuffer buf = new StringBuffer();
        this.quoteIdentifier(val, buf);
        return buf.toString();
    }

    public void quoteIdentifier(String val, StringBuffer buf) {
        String q = "\"";
        if (q == null) {
            buf.append(val);
            return;
        }
        if (val.startsWith(q) && val.endsWith(q)) {
            buf.append(val);
            return;
        }
        int k = val.indexOf(46);
        if (k > 0) {
            String val1 = Util.replace((String)val.substring(0, k), (String)q, (String)(q + q));
            String val2 = Util.replace((String)val.substring(k + 1), (String)q, (String)(q + q));
            buf.append(q);
            buf.append(val1);
            buf.append(q);
            buf.append(".");
            buf.append(q);
            buf.append(val2);
            buf.append(q);
        } else {
            String val2 = Util.replace((String)val, (String)q, (String)(q + q));
            buf.append(q);
            buf.append(val2);
            buf.append(q);
        }
    }

    public String quoteIdentifier(String qual, String name) {
        StringBuffer buf = new StringBuffer();
        this.quoteIdentifier(qual, name, buf);
        return buf.toString();
    }

    public void quoteIdentifier(String qual, String name, StringBuffer buf) {
        if (qual == null) {
            this.quoteIdentifier(name, buf);
        } else {
            Util.assertTrue((qual.length() != 0 ? 1 : 0) != 0, (String)"qual should probably be null, not empty");
            this.quoteIdentifier(qual, buf);
            buf.append('.');
            this.quoteIdentifier(name, buf);
        }
    }

    public boolean addFromQuery(String query, String alias) {
        Util.assertPrecondition((alias != null ? 1 : 0) != 0);
        if (this.fromAliases.contains(alias)) {
            return false;
        }
        this.buf.setLength(0);
        this.buf.append('(');
        this.buf.append(query);
        this.buf.append(')');
        if (alias != null) {
            Util.assertTrue((alias.length() > 0 ? 1 : 0) != 0);
            this.buf.append(" as ");
            this.buf.append(alias);
            this.fromAliases.add(alias);
        }
        this.from.add(this.buf.toString());
        return true;
    }

    public void addFrom(SqlQuery sqlQuery, String alias) throws OLAPException {
        this.addFromQuery(sqlQuery.toString(), alias);
    }

    public void addSelectAll(String expression) {
        this.select.add(expression);
    }

    public void addSelect(String expression, String alias) {
        this.buf.setLength(0);
        this.buf.append(expression);
        if (alias != null) {
            this.buf.append(" as ");
            this.quoteIdentifier(alias, this.buf);
        }
        this.select.add(this.buf.toString());
    }

    public void addWhere(String exprLeft, String exprMid, String exprRight) {
        int len = exprLeft.length() + exprMid.length() + exprRight.length();
        StringBuffer buf = new StringBuffer(len);
        buf.append(exprLeft);
        buf.append(exprMid);
        buf.append(exprRight);
        this.addWhere(buf.toString());
    }

    public void addWhere(String expression) {
        this.where.add(expression);
    }

    public void addGroupBy(String expression) {
        this.groupBy.add(expression);
    }

    public void addHaving(String expression) {
        this.having.add(expression);
    }

    public void addOrderBy(String expression) {
        this.orderBy.add(expression);
    }

    public String toString() {
        this.buf.setLength(0);
        this.select.toBuffer(this.buf, "select ", ", ");
        this.from.toBuffer(this.buf, " from ", ", ");
        this.where.toBuffer(this.buf, " where ", " and ");
        this.groupBy.toBuffer(this.buf, " group by ", ", ");
        this.having.toBuffer(this.buf, " having ", " and ");
        this.orderBy.toBuffer(this.buf, " order by ", ", ");
        return this.buf.toString();
    }

    private class ClauseList
    extends ArrayList {
        private final boolean allowDups;

        ClauseList(boolean allowDups) {
            this.allowDups = allowDups;
        }

        void add(String element) {
            if (this.allowDups || !this.contains(element)) {
                super.add(element);
            }
        }

        void toBuffer(StringBuffer buf, String first, String sep) {
            Iterator it = this.iterator();
            boolean firstTime = true;
            while (it.hasNext()) {
                String s = (String)it.next();
                if (firstTime) {
                    buf.append(first);
                    firstTime = false;
                } else {
                    buf.append(sep);
                }
                buf.append(s);
            }
        }
    }
}

