/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bim.rpt.client;

import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.report.forapp.bim.BimReportHelper;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.report.ReportInfo;
import com.kingdee.bos.metadata.report.TemplateCollection;
import com.kingdee.bos.metadata.report.TemplateInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.myeas.ToolBarStyleEnum;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.bim.rpt.client.AbstractBIMFormListUI;
import com.kingdee.eas.bim.rpt.client.Messages;
import com.kingdee.eas.bim.rpt.client.util.BIMCommonReportUtil;
import com.kingdee.eas.bim.rpt.client.util.BIMQueryDelegate;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.JDOMException;

public class BIMFormListUI
extends AbstractBIMFormListUI {
    private static final Logger logger = CoreUIObject.getLogger(BIMFormListUI.class);
    private String dirRoot;
    private String reportPK;
    private IMetaDataPK mainQueryPK;
    private EntityViewInfo entityView;
    private EntityViewInfo selEntityView;
    private ReportInfo rptInfo;
    private OrgType orgType;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initWorkButton();
        Map uiContext = this.getUIContext();
        this.dirRoot = uiContext.get("BIMCommonRptPath").toString();
        this.reportPK = uiContext.get("BIMCommonRptPK").toString();
        this.mainQueryPK = (IMetaDataPK)uiContext.get("BIMMainQueryPK");
        this.entityView = (EntityViewInfo)uiContext.get("BIMMainQuery");
        this.selEntityView = (EntityViewInfo)uiContext.get("BIMSelEntityInfo");
        this.rptInfo = (ReportInfo)uiContext.get("BIMReportInfo");
        this.orgType = (OrgType)uiContext.get("OrgType");
        this.initKDTable();
    }

    protected void initWorkButton() {
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.setButtonDefaultStyl(this.btnSelPrint);
        this.btnSelPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnSelPrintPreview);
        this.btnSelPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.setButtonDefaultStyl(this.btnSetDefault);
        this.btnSetDefault.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
    }

    private final void setButtonDefaultStyl(KDWorkButton button) {
        ToolBarStyleEnum toolBarStyleEnum = (ToolBarStyleEnum)UIFrameContext.getInstance().getProperty((Object)"ToolbarStyle");
        if (toolBarStyleEnum == null || toolBarStyleEnum.equals((Object)ToolBarStyleEnum.IconText)) {
            button.setIsControlByParent(false);
        } else {
            button.setIsControlByParent(true);
        }
    }

    private void initKDTable() throws JDOMException, IOException {
        this.tblMain.checkParsed();
        TemplateCollection templates = this.rptInfo.getFormTemplates();
        String defaultTpl = BIMCommonReportUtil.getUserDefaultFormTemplate(this.dirRoot, this.reportPK);
        if (defaultTpl == null || defaultTpl.trim().length() == 0) {
            defaultTpl = BIMCommonReportUtil.getDefaultFormTemplate(this.dirRoot, this.reportPK, this.rptInfo).trim();
        }
        int n = templates.size();
        for (int i = 0; i < n; ++i) {
            TemplateInfo template = templates.get(i);
            IRow row = this.tblMain.addRow();
            ICell cell = row.getCell(0);
            String tplName = template.getName().trim();
            cell.setValue((Object)tplName);
            cell = row.getCell(1);
            cell.setValue((Object)template.getAlias());
            cell = row.getCell(2);
            cell.setValue((Object)template.getDescription());
            cell = row.getCell(3);
            cell.setValue((Object)(tplName.equals(defaultTpl) ? 1 : 0));
        }
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        if (this.tblMain.getRow(0) != null) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.print(false);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.printPreview(false);
    }

    public void actionSelFormPrint_actionPerformed(ActionEvent e) throws Exception {
        this.print(true);
    }

    public void actionSelFormPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.printPreview(true);
    }

    private void print(boolean isSelPrint) throws Exception {
        String selFormName = this.getSelectedKeyValue();
        if (selFormName == null) {
            this.showWarnMessage();
            return;
        }
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, "actionFormPrint");
        try {
            BIMQueryDelegate query = isSelPrint ? new BIMQueryDelegate(this.mainQueryPK, this.selEntityView) : new BIMQueryDelegate(this.mainQueryPK, this.entityView);
            BimReportHelper.printForm((String)this.getFormPath(selFormName), (BOSQueryDelegate)query, (Component)((Object)this));
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMFormListUI.PrintError"), (String)err.getMessage());
            logger.error((Object)("\u62a5\u8868\u5957\u6253\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
        }
    }

    private void printPreview(boolean isSelPrint) throws Exception {
        String selFormName = this.getSelectedKeyValue();
        if (selFormName == null) {
            this.showWarnMessage();
            return;
        }
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, "actionFormPrintPreview");
        try {
            BIMQueryDelegate query = isSelPrint ? new BIMQueryDelegate(this.mainQueryPK, this.selEntityView) : new BIMQueryDelegate(this.mainQueryPK, this.entityView);
            BimReportHelper.browseForm((String)this.getFormPath(selFormName), (BOSQueryDelegate)query, (Component)((Object)this));
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMFormListUI.PrintPreviewError"), (String)err.getMessage());
            logger.error((Object)("\u5957\u6253\u9884\u89c8\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }

    public void actionSetDefault_actionPerformed(ActionEvent e) throws Exception {
        String selFormName = this.getSelectedKeyValue();
        if (selFormName == null) {
            this.showWarnMessage();
            return;
        }
        try {
            BIMCommonReportUtil.setDefaultFormTemplate(this.dirRoot, this.reportPK, selFormName, this.rptInfo);
            MsgBox.showInfo((String)Messages.getString("BIMFormListUI.SetSuccess"));
            this.refresh(e);
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMFormListUI.SetTplFailed"), (String)err.getMessage());
            logger.error((Object)("\u5957\u6253\u9884\u89c8\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
        }
    }

    private void refresh(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        this.initKDTable();
    }

    private String getFormPath(String selFormName) {
        String kdfFullPath = this.dirRoot + "/" + BIMCommonReportUtil.getPKDir(this.reportPK);
        kdfFullPath = kdfFullPath + selFormName + ".kdf";
        return kdfFullPath;
    }

    private void showWarnMessage() {
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
    }

    protected String getSelectedKeyValue() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("name");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }
}

