/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bim.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.bim.BimReportHelper;
import com.kingdee.bos.ctrl.report.reportframework.FileStreamStorage;
import com.kingdee.bos.ctrl.report.reportframework.IReportEnv;
import com.kingdee.bos.ctrl.report.reportframework.ReportException;
import com.kingdee.bos.ctrl.report.reportframework.SimpleReportEnv;
import com.kingdee.bos.ctrl.report.reportframework.browse.IReportBrowseListener;
import com.kingdee.bos.ctrl.report.reportframework.browse.IReportBrowser;
import com.kingdee.bos.ctrl.report.reportframework.invoke.IReportInvoker;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.mdquery.MDQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.report.BIMRptCompress;
import com.kingdee.bos.metadata.report.BIMRptStorage;
import com.kingdee.bos.metadata.report.ReportInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.bim.rpt.client.AbstractBIMMDReportUI;
import com.kingdee.eas.bim.rpt.client.Messages;
import com.kingdee.eas.bim.rpt.client.util.BIMCommonReportUtil;
import com.kingdee.eas.bim.rpt.client.util.BIMReportInvoker;
import com.kingdee.eas.bim.rpt.client.util.BIMRptBrowseHandler;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.help.UnsupportedOperationException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BIMMDReportUI
extends AbstractBIMMDReportUI {
    private static final String OLAP_REPORT_TYPE = "1";
    private static final String CUSTOM_FILTER_UI = "CustomFilterUI";
    private static final Logger logger = CoreUIObject.getLogger(BIMMDReportUI.class);
    private String dirRoot;
    private String reportPK;
    private ReportInfo rptInfo;
    private OrgType orgType = OrgType.NONE;
    private IReportBrowser rptBrw;
    private ArrayList queryList = null;
    private EntityViewInfo mainFilter = new EntityViewInfo();

    public BIMMDReportUI() throws Exception {
        BIMCommonReportUtil.initMetaDataLoader();
    }

    public void onLoad() throws Exception {
        this.dirRoot = BIMCommonReportUtil.createRootDir();
        Object menuParams = this.getUIContext().get("UIClassParam");
        if (menuParams == null) {
            MsgBox.showError((String)Messages.getString("BIMMDReportUI.RptNotExists"));
            SysUtil.abort();
        } else {
            this.reportPK = menuParams.toString();
        }
        try {
            this.rptInfo = BIMCommonReportUtil.syncLocalMetadata(this.reportPK, this.dirRoot, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMMDReportUI.SyncRptTplError"), (String)e.getMessage());
            SysUtil.abort();
        }
        this.setUITitle(this.rptInfo.getAlias());
        MDQueryInfo mdQueryInfo = BIMCommonReportUtil.injectClientMDQuery(this.dirRoot, this.rptInfo);
        try {
            this.orgType = OrgType.getEnum((String)this.rptInfo.getExtendedProperty("OrgType"));
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)err.getMessage());
            logger.error((Object)("\u83b7\u53d6\u5f53\u524d\u62a5\u8868\u6240\u5c5e\u7ec4\u7ec7\u7c7b\u578b\u5931\u8d25: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
            SysUtil.abort();
        }
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, "actionOnLoad");
        try {
            this.queryList = BIMCommonReportUtil.injectAllClientQuery(this.dirRoot, this.reportPK);
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMMDReportUI.ClientInjectMetaError"), (String)err.getMessage());
            logger.error((Object)("\u5ba2\u6237\u7aef\u6ce8\u5165\u5143\u6570\u636e\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
            SysUtil.abort();
        }
        try {
            BIMCommonReportUtil.injectServerQuery(this.reportPK);
        }
        catch (Exception err) {
            MsgBox.showError((String)Messages.getString("BIMMDReportUI.ServerInjectMetaError"), (String)err.getMessage());
            err.printStackTrace();
            logger.error((Object)("\u670d\u52a1\u7aef\u6ce8\u5165\u5143\u6570\u636e\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
            SysUtil.abort();
        }
        String strMainQueryPK = mdQueryInfo.getCube().getDataSource().getName();
        strMainQueryPK = strMainQueryPK.substring(0, strMainQueryPK.length() - 6);
        MetaDataPK mainQueryPK = new MetaDataPK(strMainQueryPK);
        this.queryFilter((IMetaDataPK)mainQueryPK);
        HashMap<QueryInfo, EntityViewInfo> evMap = new HashMap<QueryInfo, EntityViewInfo>();
        int n = this.queryList.size();
        for (int i = 0; i < n; ++i) {
            EntityViewInfo ev = new EntityViewInfo();
            this.setDataObject((IObjectValue)ev);
            QueryInfo queryInfo = (QueryInfo)this.queryList.get(i);
            if (queryInfo.getFullName().equalsIgnoreCase(strMainQueryPK)) {
                ev = this.checkQueryCU(queryInfo) ? this.getEntityViewInfo(this.mainFilter) : this.mainFilter;
            } else if (this.checkQueryCU(queryInfo)) {
                ev = this.getEntityViewInfo(ev);
            }
            evMap.put(queryInfo, ev);
        }
        logger.debug((Object)"\u663e\u793aMD\u5185\u5bb9...");
        IRowSet rsTpl = BIMCommonReportUtil.getTemplates(this.reportPK);
        BIMRptStorage rpt = null;
        try {
            rsTpl.absolute(1);
            Object content = rsTpl.getObject("FContent");
            byte[] contentData = null;
            if (content instanceof Blob) {
                Blob blob = (Blob)content;
                contentData = blob.getBytes(1L, (int)blob.length());
            } else if (content instanceof byte[]) {
                contentData = (byte[])content;
            } else {
                throw new UnsupportedOperationException("Not support this db type!");
            }
            rpt = BIMRptCompress.upZipReport((byte[])contentData);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        boolean isNew = false;
        FileStreamStorage rptSto = null;
        String mdFileName = this.dirRoot + "/";
        HashMap kmdTpls = rpt.getKMDTemplates();
        if (kmdTpls == null) {
            isNew = true;
            mdFileName = mdFileName + BIMCommonReportUtil.formatPKString(this.reportPK);
            mdFileName = mdFileName + ".kmd";
            rptSto = new FileStreamStorage(mdFileName);
        } else {
            Set keySet = kmdTpls.keySet();
            Object[] keys = keySet.toArray();
            if (keys.length > 0) {
                String kmdTplPK = keys[0].toString();
                mdFileName = mdFileName + BIMCommonReportUtil.formatPKString(kmdTplPK);
                mdFileName = mdFileName + ".kmd";
                rptSto = new FileStreamStorage(mdFileName);
            }
        }
        try {
            BIMReportInvoker rptIvk = new BIMReportInvoker(this.reportPK, OLAP_REPORT_TYPE);
            SimpleReportEnv rptEnv = new SimpleReportEnv();
            rptEnv.setReportStorage(rptSto);
            rptEnv.setReportInvoker((IReportInvoker)rptIvk);
            this.rptBrw = BimReportHelper.browseOlapReport((IReportEnv)rptEnv, (boolean)isNew, (MDQueryInfo)mdQueryInfo, evMap);
            BIMRptBrowseHandler rptSaveListener = new BIMRptBrowseHandler(this.dirRoot, this.reportPK);
            this.rptBrw.addBrowseListener((IReportBrowseListener)rptSaveListener);
            this.resetUILayout();
            Component[] comps = this.getComponents();
            this.findAllTables(comps);
        }
        catch (ReportException err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMMDReportUI.PrepareRptEnvError"), (String)err.getMessage());
            logger.error((Object)("\u51c6\u5907\u62a5\u8868\u73af\u5883\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
            SysUtil.abort();
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMMDReportUI.ShowRptError"), (String)err.getMessage());
            logger.error((Object)("\u663e\u793a\u62a5\u8868\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
            SysUtil.abort();
        }
    }

    private void findAllTables(Component[] components) {
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            if (components[i] instanceof KDTable) {
                if (components[i] == null || !(components[i] instanceof KDTable)) continue;
                this.tHelper.getDisabledTables().add(components[i]);
                continue;
            }
            if (!(components[i] instanceof Container)) continue;
            Container container = (Container)components[i];
            this.findAllTables(container.getComponents());
        }
    }

    private void resetUILayout() {
        this.resetUIContentLayout();
        this.resetUIMenuBarLayout();
        this.resetUIToolBarLayout();
    }

    private void resetUIContentLayout() {
        super.initUIContentLayout();
        try {
            Component rptPanel = this.rptBrw.getComponent();
            this.add(rptPanel, new KDLayout.Constraints(10, 10, 996, 610, 15));
        }
        catch (ReportException e) {
            e.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMMDReportUI.GetRptPanelError"), (String)e.getMessage());
            SysUtil.abort();
        }
    }

    private void resetUIMenuBarLayout() {
        this.menuBar.remove((Component)this.menuFile);
        this.menuBar.remove((Component)this.menuHelp);
        KDMenu[] rptMenus = null;
        try {
            rptMenus = this.rptBrw.getMenus();
        }
        catch (ReportException e) {
            e.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMMDReportUI.GetBrowserMenuError"), (String)e.getMessage());
            logger.error((Object)("\u663e\u793a\u62a5\u8868\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)e)));
            SysUtil.abort();
            return;
        }
        int n = rptMenus.length;
        for (int i = 0; i < n; ++i) {
            this.menuBar.add((JMenu)rptMenus[i]);
        }
        rptMenus[0].add((JMenuItem)this.menuItemExitCurrent);
        this.menuBar.add((JMenu)this.menuHelp);
        this.menuHelp.add((JMenuItem)this.menuItemHelp);
        this.menuHelp.add((Component)this.kDSeparator12);
        this.menuHelp.add((JMenuItem)this.menuItemAbout);
    }

    private void resetUIToolBarLayout() {
        KDToolBar rptToolBar = null;
        try {
            rptToolBar = this.rptBrw.getToolBar();
        }
        catch (ReportException e) {
            e.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMMDReportUI.GetBrowserToolbarError"), (String)e.getMessage());
            logger.error((Object)("\u663e\u793a\u62a5\u8868\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)e)));
            SysUtil.abort();
            return;
        }
        Component[] comps = rptToolBar.getComponents();
        int n = comps.length;
        for (int i = 0; i < n; ++i) {
            this.toolBar.add(comps[i]);
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.rptBrw.close();
        this.getUIWindow().close();
    }

    protected final EntityViewInfo getEntityViewInfo(EntityViewInfo QueryFilter) throws BOSException {
        FilterInfo filterCU = this.getDefaultFilterForQuery();
        if (filterCU != null && filterCU.size() > 0) {
            if (QueryFilter.getFilter() != null && QueryFilter.getFilter().size() > 0 && !QueryFilter.getFilter().toString().equals("")) {
                FilterItemCollection filters = QueryFilter.getFilter().getFilterItems();
                boolean hasCUFilter = false;
                for (int i = 0; i < filters.size(); ++i) {
                    if (!filters.get(i).getPropertyName().equals("CU.id")) continue;
                    hasCUFilter = true;
                    break;
                }
                if (!hasCUFilter) {
                    QueryFilter.getFilter().mergeFilter(filterCU, "AND");
                }
            } else {
                QueryFilter.setFilter(filterCU);
            }
        }
        return QueryFilter;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0");
        return filter;
    }

    private boolean checkQueryCU(QueryInfo queryInfo) {
        return BIMCommonReportUtil.checkQueryCU(queryInfo);
    }

    private void queryFilter(IMetaDataPK mainQueryPK) {
        CommonQueryDialog dialog = this.initCommonQueryDialog(mainQueryPK);
        if (dialog.show()) {
            this.mainFilter = dialog.getEntityViewInfoResult();
        } else {
            SysUtil.abort();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog(IMetaDataPK mainQueryPK) {
        CommonQueryDialog dialog = null;
        String dialogPK = this.rptInfo.getExtendedProperty(CUSTOM_FILTER_UI);
        if (dialogPK != null && dialogPK != "") {
            try {
                dialog = (CommonQueryDialog)Class.forName(dialogPK).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                MsgBox.showError((Component)((Object)this), (String)Messages.getString("BIMMDReportUI.InitCustomQueryDialogError"), (String)e.getMessage());
                SysUtil.abort();
            }
        } else {
            dialog = new CommonQueryDialog();
        }
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        dialog.setQueryObjectPK(mainQueryPK);
        dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        return dialog;
    }
}

