/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bim.rpt.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.report.reportframework.browse.ReportBrowseEvent;
import com.kingdee.bos.ctrl.report.reportframework.browse.ReportBrowseHandler;
import com.kingdee.bos.metadata.report.FileUtil;
import com.kingdee.eas.bim.rpt.client.Messages;
import com.kingdee.eas.bim.rpt.client.util.BIMCommonReportUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashMap;

public class BIMRptBrowseHandler
extends ReportBrowseHandler {
    private String dirRoot;
    private String reportPK;
    private String kmdPK;

    public BIMRptBrowseHandler(String dirRoot, String reportPK) {
        this.dirRoot = dirRoot;
        this.reportPK = reportPK;
        this.kmdPK = reportPK;
    }

    public void saveCompleted(ReportBrowseEvent evt) {
        String fileName = this.dirRoot + "/";
        fileName = fileName + BIMCommonReportUtil.formatPKString(this.kmdPK);
        byte[] template = FileUtil.loadFile2Stream((String)(fileName = fileName + ".kmd"));
        if (template == null) {
            MsgBox.showError((String)(Messages.getString("BIMRptBrowseHandler.nofile") + fileName));
            return;
        }
        HashMap<String, byte[]> kmdTpl = new HashMap<String, byte[]>();
        kmdTpl.put(this.kmdPK, template);
        try {
            BIMCommonReportUtil.saveKMDTemplates(this.reportPK, kmdTpl);
        }
        catch (BOSException e) {
            e.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMRptBrowseHandler.saveFailed"), (String)e.getMessage());
        }
    }
}

