/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.InnerMetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeCollection;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.cache.CacheConfigHelper;
import com.kingdee.eas.common.cache.CacheConfigNode;
import com.kingdee.eas.common.cache.CacheXMLConfiguration;
import com.kingdee.eas.common.cache.ICacheConfigFileManager;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.ConfigurationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CacheConfigFileManagerImpl
implements ICacheConfigFileManager {
    private Logger logger = Logger.getLogger(CacheConfigFileManagerImpl.class);
    private EntityObjectCollection entityCollection = null;
    private FacadeCollection facadeCollection = null;
    private CacheXMLConfiguration cacheConfig = null;
    private List methodBlackList = new ArrayList();

    protected CacheConfigFileManagerImpl(String metaDataPath, String configFilePath, boolean isCreateNewFile) throws DataAccessException {
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)metaDataPath);
        IMetaDataLoader loader = InnerMetaDataLoaderFactory.getInstance((Context)ctx, (boolean)true);
        this.entityCollection = loader.getEntityCollection();
        this.facadeCollection = loader.getFacadeCollection();
        this.initBlackList();
        if (configFilePath == null) {
            configFilePath = "c:/";
        }
        if (!configFilePath.endsWith("/") && !configFilePath.endsWith("\\")) {
            configFilePath = configFilePath + "/";
        }
        String fileName = "CacheConfig.xml";
        File configFile = new File(configFilePath + fileName);
        try {
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "0_CacheConfigFileManagerImpl"));
        }
        this.initCacheConfig(isCreateNewFile, configFile);
    }

    private void initCacheConfig(boolean isCreateNewFile, File configFile) throws ConfigurationException {
        if (isCreateNewFile) {
            this.setCacheConfig(CacheXMLConfiguration.newInstance(configFile));
        } else {
            this.setCacheConfig(CacheXMLConfiguration.getInstance(configFile));
        }
        this.getCacheConfig().updateCacheConfigVersion();
    }

    public static ICacheConfigFileManager getInstance(String metaDataPath, boolean isCreateNewFile) throws DataAccessException {
        return new CacheConfigFileManagerImpl(metaDataPath, null, isCreateNewFile);
    }

    public static ICacheConfigFileManager getInstance(String metaDataPath, String configFilePath, boolean isCreateNewFile) throws DataAccessException {
        return new CacheConfigFileManagerImpl(metaDataPath, configFilePath, isCreateNewFile);
    }

    private void initBlackList() {
        this.methodBlackList.add("getValue");
        this.methodBlackList.add("update");
        this.methodBlackList.add("delete");
        this.methodBlackList.add("addnew");
        this.methodBlackList.add("exists");
        this.methodBlackList.add("getPKList");
    }

    protected String checkMethod(MethodInfo method, boolean isEntityMethod) {
        String methodName = method.getName();
        if (methodName == null || methodName.trim().length() == 0) {
            return "nocache";
        }
        if (this.methodBlackList.contains(methodName) || methodName.startsWith("get") && (methodName.endsWith("Info") || methodName.endsWith("Collection"))) {
            return "nocache";
        }
        if (isEntityMethod) {
            return "";
        }
        TypeReference retType = method.getReturnValueType();
        if (retType == null || !retType.toString().startsWith("com.kingdee.eas")) {
            return "nocache";
        }
        String strRetType = retType.toString();
        try {
            Object retObj = Class.forName(strRetType).newInstance();
            if (retObj instanceof DataBaseInfo) {
                BOSObjectType bosType = ((DataBaseInfo)retObj).getBOSType();
                return bosType == null ? "nocache" : bosType.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "nocache";
    }

    private Map initMetaDataMap(Iterator it, Map metaDataMap) {
        while (it.hasNext()) {
            BusinessObjectInfo bizObject = (BusinessObjectInfo)it.next();
            Object bosType = bizObject.get("bosType");
            if (bizObject == null || bosType == null) continue;
            metaDataMap.put(bosType.toString(), bizObject);
            MethodCollection methods = bizObject.getMethods();
            for (MethodInfo method : methods) {
                metaDataMap.put(bosType.toString() + method.getName(), method);
            }
        }
        return metaDataMap;
    }

    private void removeRedundance(Iterator it, Map metaDataMap) {
        while (it.hasNext()) {
            CacheConfigNode etyNode = (CacheConfigNode)it.next();
            if (etyNode == null || etyNode.getBosType() == null) continue;
            if (!metaDataMap.containsKey(etyNode.getBosType())) {
                this.getCacheConfig().removeCacheConfigNode(etyNode);
                continue;
            }
            List methodNodes = etyNode.getMethods();
            for (CacheConfigNode mtdNode : methodNodes) {
                if (metaDataMap.containsKey(etyNode.getBosType() + mtdNode.getName())) continue;
                etyNode.removeMethod(mtdNode);
            }
        }
    }

    @Override
    public void removeRedundanceNode() {
        HashMap metaDataMap = new HashMap();
        this.initMetaDataMap(this.entityCollection.iterator(), metaDataMap);
        this.initMetaDataMap(this.facadeCollection.iterator(), metaDataMap);
        this.removeRedundance(this.getCacheConfig().getEntityConfigList().iterator(), metaDataMap);
        this.removeRedundance(this.getCacheConfig().getFacadeConfigList().iterator(), metaDataMap);
        this.save2File();
    }

    @Override
    public void createCacheConfigFile() throws MissingDAOMetaDataException {
        this.buildeEntityCofig();
        this.buildFacadeConfig();
        this.save2File();
    }

    @Override
    public void save2File() throws ConfigurationException {
        this.getCacheConfig().store();
    }

    @Override
    public void buildeEntityCofig() {
        Iterator eit = this.entityCollection.iterator();
        int count = 0;
        while (eit.hasNext()) {
            String sName;
            EntityObjectInfo entity = (EntityObjectInfo)eit.next();
            if (!this.isBaseDataEntity(entity)) continue;
            String des = entity.getDescription();
            if (des == null || des.trim().length() == 0) {
                des = entity.getAlias();
            }
            if (des == null || des.trim().length() == 0) {
                des = EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "1_CacheConfigFileManagerImpl");
            }
            if ((sName = entity.getName()) == null) continue;
            String sBosType = "";
            if (entity.get("bosType") == null) continue;
            sBosType = entity.get("bosType").toString();
            boolean isNewEntity = false;
            CacheConfigNode etyNode = this.getCacheConfig().getConfigNodeByBostype("entity", sBosType);
            if (etyNode == null) {
                etyNode = CacheConfigNode.CreateEntityNode(sName, sBosType, "true", "true", des);
                isNewEntity = true;
            }
            MethodCollection methods = entity.getMethods();
            this.buildMethodConfig(etyNode, methods, true);
            if (isNewEntity) {
                this.getCacheConfig().addConfigNode(etyNode);
            }
            ++count;
        }
    }

    protected boolean isBaseDataEntity(EntityObjectInfo entity) {
        boolean isDataBase = false;
        for (EntityObjectInfo baseEntity = entity.getBaseEntity(); baseEntity != null && !(isDataBase = baseEntity.getName().equalsIgnoreCase("DataBase")); baseEntity = baseEntity.getBaseEntity()) {
        }
        return isDataBase;
    }

    @Override
    public void buildFacadeConfig() {
        Iterator fit = this.facadeCollection.iterator();
        int count = 0;
        while (fit.hasNext()) {
            int mCount;
            String sName;
            FacadeInfo facade = (FacadeInfo)fit.next();
            String des = facade.getDescription();
            if (des == null || des.trim().length() == 0) {
                des = facade.getAlias();
            }
            if (des == null || des.trim().length() == 0) {
                des = EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "1_CacheConfigFileManagerImpl");
            }
            if ((sName = facade.getName()) == null) continue;
            String sBosType = "";
            if (facade.get("bosType") == null) continue;
            sBosType = facade.get("bosType").toString();
            MethodCollection methods = facade.getMethods();
            boolean isNewFacade = false;
            CacheConfigNode fcdNode = this.getCacheConfig().getConfigNodeByBostype("facade", sBosType);
            if (fcdNode == null) {
                fcdNode = CacheConfigNode.CreateFacadeNode(sName, sBosType, "false", "false", des);
                isNewFacade = true;
            }
            if ((mCount = this.buildMethodConfig(fcdNode, methods, false)) <= 0 || !isNewFacade) continue;
            this.getCacheConfig().addConfigNode(fcdNode);
            ++count;
        }
    }

    private int buildMethodConfig(CacheConfigNode node, MethodCollection methods, boolean isEntityMethod) {
        int methodCount = 0;
        Iterator mit = methods.iterator();
        HashMap<String, MethodInfo> methodMap = new HashMap<String, MethodInfo>();
        while (mit.hasNext()) {
            MethodInfo method = (MethodInfo)mit.next();
            String bosType = this.checkMethod(method, isEntityMethod);
            if (bosType.equalsIgnoreCase("nocache")) continue;
            String des = method.getDescription();
            if (des == null || des.trim().length() == 0) {
                des = method.getAlias();
            }
            if (des == null || des.trim().length() == 0) {
                des = EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "1_CacheConfigFileManagerImpl");
            }
            String strBosType = bosType.toString();
            CacheConfigNode mNode = null;
            mNode = isEntityMethod ? this.getCacheConfig().getEntityConfigNode(node.getName(), method.getName()) : this.getCacheConfig().getFacadeConfigNode(node.getName(), method.getName());
            if (mNode != null || methodMap.get(method.getName()) != null) continue;
            node.addChild(CacheConfigNode.CreateMethodNode(method.getName(), "read", "false", strBosType, "", des));
            methodMap.put(method.getName(), method);
            ++methodCount;
            this.logger.debug((Object)(EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "2_CacheConfigFileManagerImpl") + method.getName() + EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "3_CacheConfigFileManagerImpl") + method.getReturnValueType()));
        }
        return methodCount;
    }

    @Override
    public void run() {
        try {
            this.createCacheConfigFile();
            this.removeRedundanceNode();
        }
        catch (MissingDAOMetaDataException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            CacheConfigHelper.updateCacheConfigFile("W:/eas/Server/fileserver.ear/easWebClient/metas/*.jar", "C:/kingdee/eas");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CacheXMLConfiguration getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(CacheXMLConfiguration cacheConfig) {
        this.cacheConfig = cacheConfig;
    }
}

