/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.cache;

import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.framework.cache.config.CacheStrategy;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.config.MethodIntent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.cache.CacheConfigDAO;
import com.kingdee.eas.common.cache.CacheConfigNode;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CacheConfigImpl
implements ICacheConfig {
    private static Logger logger = Logger.getLogger(CacheConfigImpl.class);
    private static Map<String, CacheConfigNode> configMap;
    private boolean isCreateByClient = true;
    private Set<String> writeMethodSet = new HashSet<String>();
    private Set<String> readMethodSet = new HashSet<String>();
    private Boolean isServerCache = null;

    private static Map<String, CacheConfigNode> getConfigMap(boolean isCreateByClient) {
        if (configMap == null) {
            try {
                configMap = CacheConfigDAO.getInstance(isCreateByClient).initConfigMap();
            }
            catch (Exception ex) {
                configMap = new HashMap<String, CacheConfigNode>();
                logger.error((Object)ex);
            }
        }
        return configMap;
    }

    public CacheConfigImpl() {
        this(true);
    }

    public CacheConfigImpl(boolean isCreateByClient) {
        this.isCreateByClient = isCreateByClient;
        this.initMethodSet();
    }

    private void initMethodSet() {
        this.writeMethodSet.add("cancel");
        this.writeMethodSet.add("cancelCancel");
        this.writeMethodSet.add("submit");
        this.writeMethodSet.add("save");
        this.writeMethodSet.add("updatePartial");
        this.writeMethodSet.add("batchExecute");
    }

    public boolean needCache(BOSObjectType bosType) {
        if (bosType == null) {
            return false;
        }
        return this.needCache() && this.getConfigNode(bosType.toString()) != null;
    }

    public boolean needCache() {
        boolean isCacheEnabled = false;
        try {
            isCacheEnabled = this.getConfigDao().isSystemCacheEnabled();
            if (this.isCreateByClient && isCacheEnabled) {
                isCacheEnabled = this.getConfigDao().isUserCacheEnabled();
            }
        }
        catch (Exception ex) {
            isCacheEnabled = false;
            logger.error((Object)ex);
        }
        return isCacheEnabled;
    }

    private CacheConfigDAO getConfigDao() {
        return CacheConfigDAO.getInstance(this.isCreateByClient);
    }

    public CacheStrategy getCacheStrategy(BOSObjectType bosType) {
        if (this.needCache(bosType)) {
            return CacheStrategy.DEFAULT;
        }
        return null;
    }

    public MethodIntent getMethodIntent(BOSObjectType bosType, Method mthd) {
        MethodIntent retValue = MethodIntent.UNKNOWN;
        if (bosType != null && mthd != null && (retValue = this.getGuessResult(mthd)).equals((Object)MethodIntent.UNKNOWN)) {
            String methodType;
            CacheConfigNode configNode = this.getConfigNode(bosType.toString() + mthd.getName());
            String string = methodType = configNode != null ? configNode.getType() : "";
            if (methodType.equalsIgnoreCase("write")) {
                retValue = MethodIntent.WRITE;
            }
            if (methodType.equalsIgnoreCase("read")) {
                retValue = this.isCacheMethod(bosType, mthd) ? MethodIntent.GET : MethodIntent.GET_WITHOUT_CACHING;
            }
        }
        return retValue;
    }

    private MethodIntent getGuessResult(Method mthd) {
        MethodIntent methodIntent = MethodIntent.UNKNOWN;
        if (this.writeMethodSet.contains(mthd.getName())) {
            methodIntent = MethodIntent.WRITE;
        }
        if (this.readMethodSet.contains(mthd.getName())) {
            methodIntent = MethodIntent.GET;
        }
        return methodIntent;
    }

    private CacheConfigNode getConfigNode(String nodeKey) {
        CacheConfigNode confignode = CacheConfigImpl.getConfigMap(this.isCreateByClient).get(nodeKey);
        if (confignode != null) {
            return confignode;
        }
        return null;
    }

    private boolean isCacheMethod(BOSObjectType bosType, Method mthd) {
        boolean retValue = false;
        CacheConfigNode configNode = this.getConfigNode(bosType.toString() + mthd.getName());
        if (configNode != null) {
            retValue = configNode.isCache();
        }
        if (!retValue) {
            // empty if block
        }
        return retValue;
    }

    public boolean needCache(IMetaDataPK queryPk) {
        if (!this.needCache()) {
            return false;
        }
        BOSObjectType type = Utils.getBOSTypeFromQueryPK((IMetaDataPK)queryPk);
        return this.needCache(type);
    }

    public CacheStrategy getCacheStrategy(IMetaDataPK queryPk) {
        if (this.needCache(queryPk)) {
            return CacheStrategy.DEFAULT;
        }
        return null;
    }

    public BOSObjectType getFacadeRealBosType(BOSObjectType bosType, Method mthd) {
        String mthdRegion;
        if (bosType == null || mthd == null) {
            return null;
        }
        BOSObjectType objType = null;
        CacheConfigNode configNode = this.getConfigNode(bosType.toString() + mthd.getName());
        String string = mthdRegion = configNode != null ? configNode.getRegion() : "";
        if (mthdRegion != null && mthdRegion.trim().length() > 0) {
            objType = BOSObjectType.create((String)mthdRegion);
        }
        return objType;
    }

    public boolean needServerCache() {
        if (this.isServerCache == null) {
            boolean isValid = this.getConfigDao().isServerCacheEnabled();
            this.isServerCache = isValid;
        }
        return this.isServerCache;
    }

    public void setServerCache(boolean isValid) {
        this.isServerCache = isValid;
    }

    public String[] getMemcacheServerList() {
        return this.getConfigDao().getMemcacheServerList();
    }

    public int getMemcacheHashAlg() {
        return this.getConfigDao().getMemcacheHashAlg();
    }

    public Map getStoreLevelMap() {
        return this.getConfigDao().getStoreLevelMap();
    }

    public boolean needQueryCache(BOSObjectType bosType) {
        return this.needCache() && this.needCache(bosType) && this.getConfigNode(bosType.toString()).isQueryCache();
    }

    public boolean needQueryCache(IMetaDataPK queryPk) {
        if (!this.needCache()) {
            return false;
        }
        BOSObjectType bosType = Utils.getBOSTypeFromQueryPK((IMetaDataPK)queryPk);
        return this.needCache(bosType) && this.getConfigNode(bosType.toString()).isQueryCache();
    }

    public boolean isCreateByClient() {
        return this.isCreateByClient;
    }

    public boolean isIgnoreException() {
        return this.getConfigDao().isIgnoreException();
    }

    public String getOuterCacheServerType() {
        return this.getConfigDao().getOuterCacheServerType();
    }

    public String[] getOuterEhcacheServerList() {
        return this.getConfigDao().getOuterEhcacheServerList();
    }

    public boolean needOrmOuterCache(String bosType) {
        CacheConfigNode node = this.getConfigNode(bosType);
        if (node == null) {
            return false;
        }
        return node.isOrmOuterCache();
    }

    public boolean isOrmCloneWhenGetCache(String bosType) {
        CacheConfigNode node = this.getConfigNode(bosType);
        if (node == null) {
            return false;
        }
        return node.isOrmCloneWhenGetCache();
    }
}

