/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.calc;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.common.calc.CalcResource;
import com.kingdee.eas.common.calc.CalculatorModel;
import com.kingdee.eas.common.calc.ICalculateListener;
import com.kingdee.eas.common.calc.ICalculatorActionListener;
import com.kingdee.eas.common.calc.ICalculatorModelListener;
import com.kingdee.eas.common.calc.express.ExpressDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalculatorPanel
extends KDPanel
implements KeyListener,
MouseListener,
ICalculatorModelListener,
ICalculateListener,
ChangeListener,
ClipboardOwner {
    private static final Color backgroundColor = new Color(217, 217, 208);
    private Dialog parent;
    private ICalculatorActionListener actionListener;
    private String[] labels;
    private List buttonList;
    private KDWorkButton btnMr;
    private JTextField jtExpress;
    private KDSpinner spinner;
    private KDLabel jlPrecision;
    private CalculatorModel cm;

    public CalculatorPanel(Dialog dialog, ICalculatorActionListener aActionListener) {
        this.parent = dialog;
        this.actionListener = aActionListener;
        this.labels = CalculatorModel.commandButtonlabels;
        this.buttonList = new ArrayList();
        this.cm = new CalculatorModel();
        this.jbInit();
        this.initUI();
    }

    private void initUI() {
        this.jtExpress.setHorizontalAlignment(4);
        this.jtExpress.setBackground(Color.WHITE);
        this.jtExpress.setEditable(false);
        this.jtExpress.setFocusTraversalKeysEnabled(false);
        this.setBoldFont(this.jtExpress);
        this.jtExpress.addKeyListener(this);
        this.spinner.setEditable(false);
        this.spinner.addChangeListener((ChangeListener)this);
        this.spinner.setValue((Object)new Integer(2));
        this.addKeyListener(this);
        this.cm.addCalculateListener(this);
        this.adjustScaleByStep(0);
    }

    public void setPrecision(int precision, boolean enableChange) {
        if (precision < 0 || precision > 15) {
            throw new ArithmeticException("Precision out of range [0,15]");
        }
        this.spinner.setValue((Object)new Integer(precision));
        this.spinner.setEnabled(true);
        this.adjustScaleByStep(0);
        this.spinner.setEnabled(enableChange);
    }

    private void setBoldFont(JComponent jc) {
        int fontSize = jc.getFont().getSize() + 2;
        if (fontSize < 14) {
            fontSize = 14;
        }
        String fontName = "DialogInput";
        Font f = new Font(fontName, 1, fontSize);
        jc.setFont(f);
    }

    public void jbInit() {
        this.jtExpress = new KDTextField();
        this.spinner = new KDSpinner();
        this.jlPrecision = new KDLabel(CalcResource.getRes("precision"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        this.setLayout(new GridBagLayout());
        this.setBackground(backgroundColor);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(10, 10, 2, 10);
        this.jtExpress.setPreferredSize(new Dimension(10, 27));
        this.jtExpress.setMinimumSize(new Dimension(0, 27));
        this.add(this.jtExpress, c);
        KDPanel jp = new KDPanel((LayoutManager)new GridBagLayout());
        jp.setBackground(backgroundColor);
        jp.setPreferredSize(new Dimension(100, 27));
        this.jlPrecision.setPreferredSize(new Dimension(60, 27));
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 10.0;
        jp.add((Component)this.jlPrecision, (Object)c);
        c.insets = new Insets(2, 0, 2, 2);
        c.gridx = 1;
        this.spinner.setSize(38, 20);
        this.spinner.setPreferredSize(this.spinner.getSize());
        this.spinner.setMinimumSize(new Dimension(38, 20));
        jp.add((Component)this.spinner, (Object)c);
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 2;
        jp.add((Component)new JLabel(), (Object)c);
        c.gridx = 4;
        jp.add((Component)this.createButton1(this.labels[0]), (Object)c);
        c.gridx = 5;
        jp.add((Component)this.createButton1(this.labels[1]), (Object)c);
        c.gridx = 6;
        jp.add((Component)this.createButton1(this.labels[2]), (Object)c);
        c.gridx = 7;
        jp.add((Component)this.createButton1(this.labels[3]), (Object)c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 8, 0, 8);
        this.add((Component)jp, c);
        KDPanel group = new KDPanel((LayoutManager)new GridBagLayout());
        group.setBackground(backgroundColor);
        c.insets = new Insets(2, 2, 2, 2);
        for (int i = 4; i < this.labels.length; ++i) {
            KDWorkButton jb = null;
            c.gridy = 3 + (i - 4) / 6;
            if ((i - 4) % 6 == 0) {
                c.gridx = 0;
                jb = this.createButton2(this.labels[i]);
            } else {
                ++c.gridx;
                jb = this.createButton1(this.labels[i]);
            }
            group.add((Component)jb, (Object)c);
        }
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(0, 8, 8, 8);
        this.add((Component)group, c);
    }

    private KDWorkButton createButton1(String text) {
        return this.createButton(text, new Dimension(38, 27), Color.BLUE);
    }

    private KDWorkButton createButton2(String text) {
        return this.createButton(text, new Dimension(60, 27), Color.RED);
    }

    private KDWorkButton createButton3(String text) {
        return this.createButton(text, new Dimension(51, 27), Color.RED);
    }

    private KDWorkButton createButton(String text, Dimension dd, Color color) {
        KDWorkButton jb = new KDWorkButton(text);
        jb.setActionCommand(text);
        jb.setPreferredSize(dd);
        jb.setMaximumSize(dd);
        jb.setMinimumSize(dd);
        jb.setSize(dd);
        jb.setFocusable(false);
        jb.setForeground(color);
        jb.addKeyListener((KeyListener)this);
        jb.addMouseListener((MouseListener)this);
        this.buttonList.add(jb);
        if ("MR".equals(text)) {
            this.btnMr = jb;
        }
        return jb;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.tranceKeyEventToButtonClick(e);
    }

    private void tranceKeyEventToButtonClick(KeyEvent e) {
        String keyChar = String.valueOf(e.getKeyChar());
        switch (e.getKeyCode()) {
            default: {
                break;
            }
            case 8: {
                keyChar = "BACK";
                break;
            }
            case 10: {
                keyChar = "=";
                break;
            }
            case 27: {
                keyChar = "C";
                if (!"C".equals(this.cm.getLastCommand()) || !"0".equals(this.cm.getExpressValue())) break;
                this.actionListener.cancel();
                break;
            }
            case 120: {
                keyChar = "+/-";
                break;
            }
            case 76: {
                if (!e.isControlDown()) break;
                keyChar = "MC";
                break;
            }
            case 82: {
                if (e.isControlDown()) {
                    keyChar = "MR";
                    break;
                }
                keyChar = "1/x";
                break;
            }
            case 77: {
                if (!e.isControlDown()) break;
                keyChar = "MS";
                break;
            }
            case 80: {
                if (!e.isControlDown()) break;
                keyChar = "M+";
                break;
            }
            case 127: {
                keyChar = "CE";
                break;
            }
            case 50: {
                if (!e.isShiftDown()) break;
                keyChar = "sqrt";
                break;
            }
            case 38: {
                if (e.isControlDown()) {
                    this.adjustScaleByStep(1);
                    break;
                }
                keyChar = "BACK";
                break;
            }
            case 40: {
                if (!e.isControlDown()) break;
                this.adjustScaleByStep(-1);
                break;
            }
            case 67: {
                if (e.isControlDown()) {
                    this.copyToClipboard();
                    break;
                }
                keyChar = "NIL";
                break;
            }
            case 86: {
                if (!e.isControlDown()) break;
                this.pasteFromClipboard();
                break;
            }
            case 44: {
                if (!e.isControlDown()) break;
                keyChar = "separate";
                break;
            }
            case 69: {
                if (!e.isControlDown()) break;
                this.openExpressDialog();
            }
        }
        int i = this.getLabelIndex(keyChar);
        if (i != -1) {
            ((JButton)this.buttonList.get(i)).doClick();
        }
        this.dispatchUserEvent(new UserEvent(e.getSource(), keyChar));
    }

    @Override
    public void lostOwnership(Clipboard clipboard1, Transferable transferable) {
    }

    private void copyToClipboard() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkSystemClipboardAccess();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        StringSelection st = new StringSelection(this.cm.getExpressValue());
        Clipboard cp = tk.getSystemClipboard();
        cp.setContents(st, this);
    }

    private void pasteFromClipboard() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkSystemClipboardAccess();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard cp = tk.getSystemClipboard();
        try {
            String express = (String)cp.getContents(this).getTransferData(DataFlavor.stringFlavor);
            for (int i = 0; i < express.length(); ++i) {
                char ch = express.charAt(i);
                String cmd = String.valueOf(ch);
                if (ch == 'r' || ch == 'R') {
                    cmd = "1/x";
                } else if (ch == '@') {
                    cmd = "sqrt";
                } else if (ch == '\n') {
                    cmd = "=";
                }
                int j = this.getLabelIndex(cmd);
                if (j != -1) {
                    ((JButton)this.buttonList.get(j)).doClick();
                }
                this.dispatchUserEvent(new UserEvent(this.jtExpress, cmd));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void adjustScaleByStep(int step) {
        if (!this.spinner.isEnabled()) {
            return;
        }
        int value = (Integer)this.spinner.getValue() + step;
        if (value < 0) {
            value = 0;
        } else if (value > 15) {
            value = 15;
        }
        this.cm.setScale(value);
        this.spinner.setValue((Object)new Integer(value));
        this.jtExpress.requestFocus();
    }

    private int getLabelIndex(String label) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.labels[i].equals(label)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getModifiers() == 16 && e.getSource() instanceof JButton) {
            this.dispatchUserEvent(new UserEvent(e.getSource(), ((JButton)e.getSource()).getActionCommand()));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseevent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseevent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseevent) {
    }

    public void dispatchUserEvent(UserEvent e) {
        this.cm.dispatch(e.getCommand());
        if (this.cm.isOKCommand(e.getCommand())) {
            this.actionListener.ok();
        }
    }

    public void sendCommand(String command) {
        this.cm.dispatch(command);
    }

    @Override
    public void displayChanged(String value) {
        this.jtExpress.setText(value);
    }

    @Override
    public void memoryStatusChanged(boolean flag) {
        String tag = flag ? "*" : "";
        this.btnMr.setText(this.btnMr.getActionCommand() + tag);
        this.btnMr.setToolTipText(this.cm.getStatus().getMemory());
    }

    @Override
    public void messageAccepted(String msg) {
        this.jtExpress.setText(msg);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.adjustScaleByStep(0);
    }

    public String getExpressValue() {
        return this.cm.getExpressValue();
    }

    @Override
    public void calculated(String value) {
        this.cm.setExpressValue(value);
    }

    @Override
    public void error(String errorMessage) {
    }

    private void openExpressDialog() {
        ExpressDialog dlg = new ExpressDialog(this.parent);
        dlg.addCalculatorListener(this);
        dlg.show();
    }

    class UserEvent
    extends EventObject {
        private String command;

        public String getCommand() {
            return this.command;
        }

        @Override
        public String toString() {
            return this.command;
        }

        public UserEvent(Object source, String command) {
            super(source);
            this.command = null;
            this.command = command;
        }
    }
}

