/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util;

import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.sql.dom.SqlInsert;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

class EntityRefInfo {
    private Hashtable items;
    private final IMetaDataLoader loader;
    private Logger logger = Logger.getLogger(EntityRefInfo.class);

    public EntityRefInfo(IMetaDataLoader loader) {
        this.loader = loader;
        this.items = new Hashtable();
    }

    public void addRefItem(BOSObjectType type, BOSObjectType refType, String refTableName, String refFieldName) {
        this.items.put(new EntityRefKey(type, refTableName, refFieldName), refType);
    }

    public void output(PrintStream out) {
        out.println("delete from T_SYS_EntityRef;");
        Enumeration keys = this.items.keys();
        while (keys.hasMoreElements()) {
            EntityRefKey key = (EntityRefKey)keys.nextElement();
            BOSObjectType refType = (BOSObjectType)this.items.get(key);
            this.outputLine(out, key, refType);
        }
    }

    private void outputLine(PrintStream out, EntityRefKey key, BOSObjectType refType) {
        out.println(this.buildLine(key, refType));
    }

    private String buildLine(EntityRefKey key, BOSObjectType refType) {
        LanguageCollection langs = this.loader.getSolution().getLanguages();
        SqlInsert insert = new SqlInsert("T_SYS_EntityRef");
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("FBOSType");
        columnList.add("FRefTableName");
        columnList.add("FRefFieldName");
        columnList.add("FIsBOSFK");
        columnList.add("FEntityName");
        columnList.add("FRefEntityName");
        int n = langs.size();
        for (int i = 0; i < n; ++i) {
            String postFix = "_" + langs.get(i).getPostfix();
            columnList.add("FEntityAlias" + postFix);
            columnList.add("FRefEntityAlias" + postFix);
        }
        insert.columnList = columnList;
        EntityObjectInfo entity = null;
        EntityObjectInfo refEntity = null;
        try {
            entity = this.loader.getEntity(key.type);
            refEntity = this.loader.getEntity(refType);
        }
        catch (MetaDataNotFoundException e) {
            this.logger.error((Object)("<<<<<<<<<<<<<<<<<<refTableName:" + key.refTableName + "  refFieldName" + key.refFieldName));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        ArrayList<SqlExpr> valueList = new ArrayList<SqlExpr>();
        valueList.add(SqlExpr.toCharExpr((String)key.type.toString()));
        valueList.add(SqlExpr.toCharExpr((String)key.refTableName));
        valueList.add(SqlExpr.toCharExpr((String)key.refFieldName));
        valueList.add(SqlExpr.toExpr((int)1));
        valueList.add(SqlExpr.toCharExpr((String)entity.getName()));
        valueList.add(SqlExpr.toCharExpr((String)refEntity.getName()));
        int n2 = langs.size();
        for (int i = 0; i < n2; ++i) {
            Locale locale = langs.get(i).getOriginalLocale();
            valueList.add(SqlExpr.toNCharExpr((String)EntityRefInfo.escapeString(entity.getAlias(locale))));
            valueList.add(SqlExpr.toNCharExpr((String)EntityRefInfo.escapeString(refEntity.getAlias(locale))));
        }
        insert.valueList = valueList;
        return insert.toString();
    }

    private static final String escapeString(String str) {
        if (str == null) {
            return null;
        }
        return StringUtils.replace((String)str, (String)"'", (String)"''");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildReference(Connection conn) {
        long start = System.currentTimeMillis();
        Statement stat = null;
        try {
            stat = conn.createStatement();
            stat.addBatch("delete from T_SYS_EntityRef  ");
            Enumeration keys = this.items.keys();
            String sql = null;
            int index = 0;
            while (keys.hasMoreElements()) {
                BOSObjectType refType;
                EntityRefKey key = (EntityRefKey)keys.nextElement();
                sql = this.buildLine(key, refType = (BOSObjectType)this.items.get(key));
                if (StringUtils.isEmpty((String)sql)) continue;
                stat.addBatch(sql);
                if (++index % 2000 != 0) continue;
                stat.executeBatch();
            }
            stat.executeBatch();
            System.out.println("buildReference cost:" + (System.currentTimeMillis() - start));
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Statement)stat);
        }
    }

    private static class EntityRefKey {
        public final BOSObjectType type;
        public final String refTableName;
        public final String refFieldName;

        public EntityRefKey(BOSObjectType type, String refTableName, String refFieldName) {
            assert (type != null);
            assert (!StringUtils.isEmpty((String)refTableName));
            assert (!StringUtils.isEmpty((String)refFieldName));
            this.type = type;
            this.refTableName = refTableName;
            this.refFieldName = refFieldName;
        }

        public int hashCode() {
            return (this.type + this.refTableName + this.refFieldName).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof EntityRefKey)) {
                return false;
            }
            EntityRefKey that = (EntityRefKey)obj;
            return this.type.equals((Object)that.type) && this.refTableName.equals(that.refTableName) && this.refFieldName.equals(that.refFieldName);
        }
    }
}

