/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.client;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.EASClientFileList;
import com.kingdee.eas.client.startup.update.check.EASJnlpCacheEntryManager;
import com.kingdee.eas.client.startup.update.check.JnlpServerCtrlParameter;
import com.kingdee.eas.client.startup.update.check.JnlpServerCtrlParamsUtils;
import com.kingdee.eas.client.startup.update.download.EasClientDownloaderFactory;
import com.kingdee.eas.client.startup.update.download.IEasClientDownloader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ClientUpdateChecker {
    public boolean needUpdate() throws IOException {
        boolean changed = false;
        changed = this.checkEasJnlp();
        if (changed) {
            return true;
        }
        changed = this.checkResourceLst();
        return changed;
    }

    private boolean checkEasJnlp() throws IOException {
        String easJnlpAddress = ClientConfigUtil.getUpdateUrl() + "eas.jnlp?autoDownload=true";
        File easJnlpFile = this.download(easJnlpAddress);
        EASClientFileList serverEasJnlp = EASJnlpCacheEntryManager.load((File)easJnlpFile);
        easJnlpFile.delete();
        File localEasJnlpFile = new File(this.getLocalCacheDir(), "eas.jnlp");
        EASClientFileList localCacheEasJnlp = EASJnlpCacheEntryManager.load((File)localEasJnlpFile);
        JnlpServerCtrlParameter easJnlpCtrlParam = JnlpServerCtrlParamsUtils.parse((URL)serverEasJnlp.getHref());
        boolean hasChanges = this.compareFileList(serverEasJnlp, localCacheEasJnlp, easJnlpCtrlParam);
        return hasChanges;
    }

    private boolean checkResourceLst() throws IOException {
        String resourceLstAddress = ClientConfigUtil.getUpdateUrl() + "resource.lst";
        File resourceLstFile = this.download(resourceLstAddress);
        EASClientFileList serverResourceLst = EASJnlpCacheEntryManager.load((File)resourceLstFile);
        resourceLstFile.delete();
        File localResourceLstFile = new File(this.getLocalCacheDir(), "resource.lst");
        EASClientFileList localCacheResourceLst = EASJnlpCacheEntryManager.load((File)localResourceLstFile);
        JnlpServerCtrlParameter resourceLstCtrlParam = JnlpServerCtrlParamsUtils.parse((URL)serverResourceLst.getHref());
        boolean hasChanges = this.compareFileList(serverResourceLst, localCacheResourceLst, resourceLstCtrlParam);
        return hasChanges;
    }

    private boolean compareFileList(EASClientFileList serverFileList, EASClientFileList localFileList, JnlpServerCtrlParameter ctrlParam) {
        Map<String, EASClientFile> serverResources = this.toMap(serverFileList.getCacheEntries());
        Map<String, EASClientFile> localResources = this.toMap(localFileList.getCacheEntries());
        String[] excludedResItems = new String[]{};
        if (ctrlParam.getResItemsExcluded() != null && ctrlParam.getResItemsExcluded() != null) {
            String separator = ctrlParam.getSeperator();
            excludedResItems = ctrlParam.getResItemsExcluded().split(separator);
        }
        excludedResItems = Arrays.copyOf(excludedResItems, excludedResItems.length + 1);
        excludedResItems[excludedResItems.length - 1] = "resource.lst";
        LinkedHashSet<String> hrefs = new LinkedHashSet<String>();
        hrefs.addAll(serverResources.keySet());
        hrefs.addAll(localResources.keySet());
        block0: for (String href : hrefs) {
            for (String excludedResItem : excludedResItems) {
                if (href.contains(excludedResItem)) continue block0;
            }
            EASClientFile serverFile = serverResources.get(href);
            EASClientFile localFile = localResources.get(href);
            if (serverFile == null || localFile == null) {
                return true;
            }
            if (!serverFile.getMd5Version().equals(localFile.getMd5Version())) {
                return true;
            }
            if (serverFile.getMd5VersionNew().equals(localFile.getMd5VersionNew())) continue;
            return true;
        }
        return false;
    }

    private Map<String, EASClientFile> toMap(List<EASClientFile> cacheEntries) {
        HashMap<String, EASClientFile> map = new HashMap<String, EASClientFile>();
        for (EASClientFile entry : cacheEntries) {
            map.put(entry.getPath(), entry);
        }
        return map;
    }

    private File getLocalCacheDir() {
        File baseDir = ClientConfigUtil.getLocalDirFile();
        File cacheDir = new File(baseDir, "cache");
        return cacheDir;
    }

    private File download(String downloadAddress) throws IOException {
        File file = File.createTempFile("temp", "");
        file.deleteOnExit();
        IEasClientDownloader downloader = EasClientDownloaderFactory.getDownloader((String)"http");
        downloader.downloadFile(downloadAddress, file);
        return file;
    }
}

