/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.AbstractLocateDialogUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import org.apache.log4j.Logger;

public class LocateDialogUI
extends AbstractLocateDialogUI {
    private static final Logger logger = CoreUIObject.getLogger(LocateDialogUI.class);
    private ArrayList leftList = null;
    private ArrayList rightList = null;
    private ArrayList lastRightList = null;
    Map hm = new HashMap();
    private KDTable table = null;
    private int curRowIndex = -1;
    private int curColIndex = 0;
    private boolean first = true;
    private int result = 0;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        String cellValue;
        ICell cell;
        int j;
        IColumn column;
        int i;
        KDTSelectManager manager;
        boolean flag;
        super.actionLocate_actionPerformed(e);
        IColumn[] curColumns = this.getSearchColumns();
        int endIndex = this.getSearchEndColIndex(curColumns);
        boolean isAllNull = true;
        for (int i2 = 0; i2 < curColumns.length; ++i2) {
            if (curColumns[i2] == null) continue;
            isAllNull = false;
        }
        if (isAllNull) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoSelectedCols"));
            return;
        }
        String keyword = this.txtKeyword.getText();
        if (StringUtils.isEmpty((String)keyword)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_KeywordEmpty"));
            return;
        }
        int rowCount = this.table.getRowCount();
        if (!this.rightList.equals(this.lastRightList)) {
            this.initStartPosition(rowCount);
            this.lastRightList = (ArrayList)this.rightList.clone();
        }
        if (this.radioSearchDown.isSelected()) {
            flag = false;
            this.initStartPosition(rowCount);
            if (this.curRowIndex == rowCount - 1) {
                if (this.curColIndex == endIndex) {
                    this.curColIndex = 0;
                    this.curRowIndex = -1;
                } else {
                    ++this.curColIndex;
                }
            } else {
                ++this.curRowIndex;
            }
            manager = this.table.getSelectManager();
            for (i = this.curColIndex; i <= endIndex; ++i) {
                column = curColumns[i];
                if (column == null) {
                    ++this.curColIndex;
                }
                if (column != null) {
                    for (j = this.curRowIndex; j < rowCount; ++j) {
                        this.curColIndex = i;
                        this.curRowIndex = j;
                        cell = this.table.getCell(this.curRowIndex, this.curColIndex);
                        cellValue = this.table.getCellDisplayText(cell);
                        if (keyword == null || cellValue == null || !this.searchCondition(keyword, cellValue)) continue;
                        manager.select(j, this.curColIndex);
                        this.table.scrollToVisible(j, this.curColIndex);
                        ++this.result;
                        flag = true;
                        break;
                    }
                    if (!flag && this.curColIndex != endIndex) {
                        this.curRowIndex = 0;
                    }
                }
                if (flag) break;
            }
            if (this.curRowIndex == rowCount - 1 && this.curColIndex == endIndex) {
                if (this.result == 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoResult"));
                } else {
                    this.result = 0;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_SearchCompleted"));
                }
            }
        }
        if (this.radioSearchUp.isSelected()) {
            flag = false;
            this.initStartPosition(rowCount);
            if (this.curRowIndex == 0) {
                if (this.curColIndex == 0) {
                    this.curColIndex = endIndex;
                    this.curRowIndex = rowCount;
                } else {
                    --this.curColIndex;
                }
            } else {
                --this.curRowIndex;
            }
            manager = this.table.getSelectManager();
            for (i = this.curColIndex; i >= 0; --i) {
                column = curColumns[i];
                if (column == null) {
                    --this.curColIndex;
                }
                if (column != null) {
                    for (j = this.curRowIndex; j >= 0; --j) {
                        this.curColIndex = i;
                        this.curRowIndex = j;
                        cell = this.table.getCell(this.curRowIndex, this.curColIndex);
                        cellValue = this.table.getCellDisplayText(cell);
                        if (keyword == null || cellValue == null || !this.searchCondition(keyword, cellValue)) continue;
                        manager.select(j, this.curColIndex);
                        this.table.scrollToVisible(j, this.curColIndex);
                        ++this.result;
                        flag = true;
                        break;
                    }
                    if (!flag && this.curColIndex != 0) {
                        this.curRowIndex = rowCount;
                    }
                }
                if (flag) break;
            }
            if (this.curRowIndex == 0 && this.curColIndex == 0) {
                if (this.result == 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoResult"));
                } else {
                    this.result = 0;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_SearchCompleted"));
                }
            }
        }
        this.first = false;
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionSelectAllToRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAllToRight_actionPerformed(e);
        this.result = 0;
        Object[] leftObjList = this.leftList.toArray();
        this.lastRightList = (ArrayList)this.rightList.clone();
        for (int i = 0; i < leftObjList.length; ++i) {
            if (leftObjList[i] == null) continue;
            String key = (String)this.hm.get(leftObjList[i]);
            int colIndex = this.table.getColumn(key).getColumnIndex();
            this.rightList.set(colIndex, leftObjList[i]);
            this.listRightColumns.addElement(leftObjList[i]);
            this.leftList.set(colIndex, null);
            this.listLeftColumns.removeElement(leftObjList[i]);
        }
        this.listRightColumns.removeAllElements();
        Object[] rightObjList = this.rightList.toArray();
        DefaultListModel model = (DefaultListModel)this.listRightColumns.getModel();
        for (int i = 0; i < rightObjList.length; ++i) {
            if (rightObjList[i] == null) continue;
            model.addElement(rightObjList[i]);
        }
    }

    @Override
    public void actionSelectToRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectToRight_actionPerformed(e);
        this.result = 0;
        Object[] leftSelectedValues = this.listLeftColumns.getSelectedValues();
        this.lastRightList = (ArrayList)this.rightList.clone();
        for (int i = 0; i < leftSelectedValues.length; ++i) {
            if (leftSelectedValues[i] == null) continue;
            String key = (String)this.hm.get(leftSelectedValues[i]);
            int colIndex = this.table.getColumn(key).getColumnIndex();
            this.rightList.set(colIndex, leftSelectedValues[i]);
            this.listRightColumns.addElement(leftSelectedValues[i]);
            this.leftList.set(colIndex, null);
            this.listLeftColumns.removeElement(leftSelectedValues[i]);
        }
        this.listRightColumns.removeAllElements();
        Object[] rightObjList = this.rightList.toArray();
        DefaultListModel model = (DefaultListModel)this.listRightColumns.getModel();
        for (int i = 0; i < rightObjList.length; ++i) {
            if (rightObjList[i] == null) continue;
            model.addElement(rightObjList[i]);
        }
    }

    @Override
    public void actionSelectToLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectToLeft_actionPerformed(e);
        this.result = 0;
        Object[] rightSelectedValues = this.listRightColumns.getSelectedValues();
        this.lastRightList = (ArrayList)this.rightList.clone();
        for (int i = rightSelectedValues.length - 1; i >= 0; --i) {
            if (rightSelectedValues[i] == null) continue;
            String key = (String)this.hm.get(rightSelectedValues[i]);
            int colIndex = this.table.getColumn(key).getColumnIndex();
            this.leftList.set(colIndex, rightSelectedValues[i]);
            this.listLeftColumns.addElement(rightSelectedValues[i]);
            this.rightList.set(colIndex, null);
            this.listRightColumns.removeElement(rightSelectedValues[i]);
        }
        this.listLeftColumns.removeAllElements();
        Object[] leftObjList = this.leftList.toArray();
        DefaultListModel model = (DefaultListModel)this.listLeftColumns.getModel();
        for (int i = 0; i < leftObjList.length; ++i) {
            if (leftObjList[i] == null) continue;
            model.addElement(leftObjList[i]);
        }
    }

    @Override
    public void actionSelectAllToLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAllToLeft_actionPerformed(e);
        this.result = 0;
        Object[] rightObjList = this.rightList.toArray();
        this.lastRightList = (ArrayList)this.rightList.clone();
        for (int i = 0; i < rightObjList.length; ++i) {
            if (rightObjList[i] == null) continue;
            String key = (String)this.hm.get(rightObjList[i]);
            int colIndex = this.table.getColumn(key).getColumnIndex();
            this.leftList.set(colIndex, rightObjList[i]);
            this.listLeftColumns.addElement(rightObjList[i]);
            this.rightList.set(colIndex, null);
            this.listRightColumns.removeElement(rightObjList[i]);
        }
        this.listLeftColumns.removeAllElements();
        Object[] leftObjList = this.leftList.toArray();
        DefaultListModel model = (DefaultListModel)this.listLeftColumns.getModel();
        for (int i = 0; i < leftObjList.length; ++i) {
            if (leftObjList[i] == null) continue;
            model.addElement(leftObjList[i]);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.table = (KDTable)this.getUIContext().get("curTable");
        int totalColumns = this.table.getColumnCount();
        this.leftList = new ArrayList(totalColumns);
        this.rightList = new ArrayList(totalColumns);
        IRow row = this.table.getHeadRow(0);
        for (int i = 0; i < totalColumns; ++i) {
            String text = (String)row.getCell(i).getValue();
            String columnKey = this.table.getColumn(i).getKey();
            this.rightList.add(i, text);
            if (this.table.getColumn(i).getStyleAttributes().isHided()) {
                this.rightList.set(i, null);
            }
            this.leftList.add(i, null);
            this.hm.put(text, columnKey);
        }
        this.lastRightList = (ArrayList)this.rightList.clone();
        Object[] rightObjList = this.rightList.toArray();
        DefaultListModel model = (DefaultListModel)this.listRightColumns.getModel();
        for (int i = 0; i < rightObjList.length; ++i) {
            if (rightObjList[i] == null) continue;
            model.addElement(rightObjList[i]);
        }
        this.initStartPosition(this.table.getRowCount());
    }

    protected IColumn[] getSearchColumns() {
        IColumn[] columns = new IColumn[this.rightList.size()];
        for (int i = 0; i < this.rightList.size(); ++i) {
            String text = (String)this.rightList.get(i);
            if (text != null) {
                IColumn column;
                String key = (String)this.hm.get(text);
                columns[i] = column = this.table.getColumn(key);
                continue;
            }
            columns[i] = null;
        }
        return columns;
    }

    protected boolean searchCondition(String keyword, String cellValue) {
        boolean equalsCondition = this.chkFullMatch.isSelected() && !this.chkCaseSensitive.isSelected() ? keyword.equalsIgnoreCase(cellValue) : (!this.chkFullMatch.isSelected() && this.chkCaseSensitive.isSelected() ? cellValue.indexOf(keyword) > -1 : (this.chkFullMatch.isSelected() && this.chkCaseSensitive.isSelected() ? keyword.equals(cellValue) : cellValue.toLowerCase().indexOf(keyword.toLowerCase()) > -1));
        return equalsCondition;
    }

    protected void initStartPosition(int rowCount) {
        ArrayList blocks = this.table.getSelectManager().getBlocks();
        IColumn[] initColumns = this.getSearchColumns();
        if (blocks.size() != 0) {
            KDTSelectBlock selectBlock = (KDTSelectBlock)blocks.get(0);
            this.curRowIndex = selectBlock.getBeginRow();
            this.curColIndex = selectBlock.getBeginCol();
            if (this.rightList.get(this.curColIndex) == null) {
                if (this.radioSearchDown.isSelected()) {
                    this.curRowIndex = -1;
                    this.curColIndex = 0;
                } else {
                    this.curRowIndex = rowCount;
                    this.curColIndex = initColumns.length - 1;
                }
            }
        }
    }

    private int getSearchEndColIndex(IColumn[] columns) {
        int endColIndex = columns.length - 1;
        if (this.radioSearchDown.isSelected()) {
            endColIndex = columns.length - 1;
            for (int i = columns.length - 1; i >= 0; --i) {
                IColumn column = columns[i];
                if (column == null) continue;
                endColIndex = i;
                break;
            }
        } else {
            endColIndex = 0;
            for (int i = 0; i < columns.length - 1; ++i) {
                IColumn column = columns[i];
                if (column == null) continue;
                endColIndex = i;
                break;
            }
        }
        return endColIndex;
    }
}

