/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.appframework.exception.IMultiException;
import com.kingdee.bos.appframework.exception.IMultiExceptionMessageFormatter;
import com.kingdee.bos.appframework.exception.ValidateErrorFormatter;
import com.kingdee.bos.appframework.exception.ValidateFailedException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.LineResult;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.client.AbstractTableEditUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.util.EASMultiException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class TableEditUI
extends AbstractTableEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TableEditUI.class);
    private IIDList idList = null;
    private IObjectCollection editCollection = null;
    private IObjectCollection oldEditCollection = null;
    private List deleteList = null;
    private boolean isSaved;

    public void loadCollectionFields() {
        this.dataBinder.loadCollectionFields();
    }

    public void storeCollectionFields() {
        this.dataBinder.storeCollectionFields();
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public void setSaved(boolean isSaved) {
        this.isSaved = isSaved;
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if (OprtState.VIEW.equals(this.oprtState)) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionAddLine.setEnabled(false);
        } else {
            this.actionRemoveLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionSave.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.actionAddLine.setEnabled(true);
        }
    }

    protected abstract IObjectCollection createNewCollection();

    protected abstract IObjectValue createNewData();

    protected abstract ICoreBase getBizInterface() throws Exception;

    protected final void setDataCollection(IObjectCollection collection) {
        this.editCollection = collection;
        this.initOldEditCollection(collection);
        this.dataBinder.setObjectCollection(this.editCollection);
    }

    protected void initOldEditCollection(IObjectCollection collection) {
        this.oldEditCollection = this.createNewCollection();
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue vo = collection.getObject(i);
            this.oldEditCollection.addObject((IObjectValue)((AbstractObjectValue)vo).clone());
        }
    }

    protected CoreBaseCollection getCoreBaseCollection() {
        return (CoreBaseCollection)this.editCollection.cast(CoreBaseCollection.class);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnSave);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_temporarilysave"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_temporarilysave"));
        this.setButtonDefaultStyl(this.btnSubmit);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.menuItemAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.menuItemInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.menuItemRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    public void onLoad() throws Exception {
        this.initUIControl();
        super.onLoad();
        this.tblMain.checkParsed();
        this.idList = (IIDList)this.getUIContext().get("IDList");
        if (this.idList == null) {
            this.idList = new RealModeIDList();
        }
        this.loadDataCollection();
        this.getUIContext().put("DataBinder", this.dataBinder);
    }

    protected void initUIControl() throws Exception {
    }

    protected void loadDataCollection() throws Exception {
        if ("ADDNEW".equals(this.getOprtState())) {
            if (this.getUIContext().get("InitDataObject") != null && this.getUIContext().get("InitDataObject") instanceof IObjectCollection) {
                this.setDataCollection((IObjectCollection)this.getUIContext().get("InitDataObject"));
            } else {
                this.editCollection = this.createNewCollection();
                this.editCollection.addObject(this.createNewData());
                this.setDataCollection(this.editCollection);
            }
            this.loadCollectionFields();
        } else {
            this.inOnload();
        }
        this.showMessageForStatus();
    }

    protected void inOnload() throws Exception {
        if (this.getUIContext().get("InitDataObject") != null && this.getUIContext().get("InitDataObject") instanceof IObjectCollection) {
            this.setDataCollection((IObjectCollection)this.getUIContext().get("InitDataObject"));
        } else if (this.idList != null && this.idList.size() > 0) {
            this.setDataCollection(this.getCollection(this.idList));
        } else {
            return;
        }
        this.loadCollectionFields();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected IObjectCollection getCollection(IIDList idList) throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            FilterItemInfo filterItem = new FilterItemInfo(this.getKeyFieldName(), (Object)idList.getID(i));
            filter.getFilterItems().add(filterItem);
            maskString.append("#");
            maskString.append(i);
            if (i == idList.size() - 1) continue;
            maskString.append(" OR ");
        }
        filter.setMaskString(maskString.toString());
        ev.setFilter(filter);
        ev.setSelector(this.getSelectors());
        return this.getBizInterface().getCollection(ev);
    }

    protected void showMessageForStatus() {
        this.setShowMessagePolicy(2);
        if ("EDIT".equals(this.getOprtState())) {
            this.showEdit();
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.showAddNew();
        }
    }

    protected void showAddNew() {
        String msg = null;
        String res = null;
        Object[] objs = null;
        res = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew_New");
        objs = new Object[]{this.getClassAlise()};
        msg = MessageFormat.format(res, objs);
        this.setMessageText(msg);
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected void showEdit() {
        String msg = null;
        String res = null;
        Object[] objs = null;
        res = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit_New");
        objs = new Object[]{this.getClassAlise()};
        msg = MessageFormat.format(res, objs);
        this.setMessageText(msg);
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected String getClassAlise() {
        String className = FrameWorkUtils.getClassAlias((CoreBaseInfo)this.createNewData());
        return className;
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.storeLineFields(table, row, obj);
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewData();
        IRow row = table.addRow();
        this.loadLineFields(table, row, detailData);
        this.editCollection.addObject(detailData);
        this.afterAddLine(table, detailData);
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
    }

    protected void afterInsertLine(KDTable table, IObjectValue lineData) {
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewData();
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.editCollection.addObject(detailData);
        this.loadLineFields(table, row, detailData);
        this.afterInsertLine(table, detailData);
    }

    protected boolean confirmMsg(String msg) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)msg));
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete");
        if (this.confirmMsg(msg)) {
            ArrayList<Integer> selectList = new ArrayList<Integer>();
            int size = table.getSelectManager().size();
            KDTSelectManager selectManager = this.tblMain.getSelectManager();
            for (int row = 0; row < size; ++row) {
                KDTSelectBlock selectBlock = selectManager.get(row);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                for (int i = top; i <= bottom; ++i) {
                    if (table.getRow(top) == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                        return;
                    }
                    selectList.add(new Integer(i));
                }
            }
            for (int i = 0; i < selectList.size(); ++i) {
                int row = Integer.parseInt(String.valueOf(selectList.get(i))) - i;
                IObjectValue detailData = (IObjectValue)table.getRow(row).getUserObject();
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                table.removeRow(row);
                if (collection != null && detailData != null) {
                    collection.removeObject(detailData);
                }
                this.editCollection.removeObject(detailData);
                this.afterRemoveLine(table, detailData);
            }
        }
    }

    public boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeCollectionFields();
        }
        catch (Exception exc) {
            return false;
        }
        if (this.editCollection != null && this.oldEditCollection != null) {
            if (this.editCollection.size() != this.oldEditCollection.size()) {
                return true;
            }
            for (int i = 0; i < this.getTable().getRowCount(); ++i) {
                boolean isNotEqual = false;
                boolean isNotExist = true;
                IObjectValue vo = (IObjectValue)this.getTable().getRow(i).getUserObject();
                String Id = ((CoreBaseInfo)vo).getId() != null ? ((CoreBaseInfo)vo).getId().toString() : null;
                for (int j = 0; j < this.oldEditCollection.size(); ++j) {
                    String oldId;
                    IObjectValue oldVo = this.oldEditCollection.getObject(j);
                    String string = oldId = ((CoreBaseInfo)oldVo).getId() != null ? ((CoreBaseInfo)oldVo).getId().toString() : null;
                    if (Id != oldId && !Id.equals(oldId)) continue;
                    isNotExist = false;
                    boolean bl = isNotEqual = !ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)oldVo, (AbstractObjectValue)vo);
                    if (isNotEqual) break;
                }
                if (!isNotEqual && !isNotExist) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        try {
            b = this.isModify();
            if (b) {
                int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
                if (result == 0) {
                    this.actionSubmit.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    return !this.actionSubmit.isInvokeFailed();
                }
                if (result == 1) {
                    return true;
                }
            }
        }
        catch (Exception exc) {
            return false;
        }
        return true;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getTable() != null) {
            this.addLine(this.getTable());
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getTable() != null) {
            this.insertLine(this.getTable());
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getTable() != null) {
            this.removeLine(this.getTable());
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        this.processDeleteList();
        this.runRemove();
        Result result = this.runSave();
        this.processResult(result);
        this.setSaved(true);
    }

    public void runRemove() throws Exception {
        ObjectUuidPK[] pks = new ObjectUuidPK[this.deleteList.size()];
        for (int i = 0; i < this.deleteList.size(); ++i) {
            pks[i] = (ObjectUuidPK)this.deleteList.get(i);
        }
        this.getBizInterface().delete((IObjectPK[])pks);
    }

    public Result runSave() throws Exception {
        return this.getBizInterface().save(this.getCoreBaseCollection());
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        this.processDeleteList();
        this.runRemove();
        Result result = this.runSubmit();
        this.processResult(result);
        this.setSaved(true);
    }

    public Result runSubmit() throws Exception {
        return this.getBizInterface().submit(this.getCoreBaseCollection());
    }

    private void processDeleteList() {
        this.deleteList = new ArrayList();
        boolean isNotExist = true;
        for (int i = 0; i < this.oldEditCollection.size(); ++i) {
            isNotExist = true;
            IObjectValue vo = this.oldEditCollection.getObject(i);
            String oldId = ((CoreBaseInfo)vo).getId() != null ? ((CoreBaseInfo)vo).getId().toString() : null;
            for (int j = 0; j < this.editCollection.size(); ++j) {
                String id;
                IObjectValue newVo = this.editCollection.getObject(j);
                String string = id = ((CoreBaseInfo)newVo).getId() != null ? ((CoreBaseInfo)newVo).getId().toString() : null;
                if (id == null || !id.equals(oldId)) continue;
                isNotExist = false;
                break;
            }
            if (!isNotExist || oldId == null) continue;
            this.deleteList.add(new ObjectUuidPK(oldId));
        }
    }

    protected final void verify(ActionEvent e) throws Exception {
        block3: {
            this.beforeStoreFields(e);
            this.storeCollectionFields();
            this.verifyInput(e);
            if (this.getValidateHelper() != null) {
                try {
                    this.getValidateHelper().validateAll();
                }
                catch (ValidateFailedException ve) {
                    if (ve.getErrors().size() <= 0) break block3;
                    ve.setFormatter((IMultiExceptionMessageFormatter)new ValidateErrorFormatter());
                    throw new EASMultiException((IMultiException)ve);
                }
            }
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
    }

    protected void verifyInput(ActionEvent e) throws Exception {
    }

    private void processResult(Result rlt) throws Exception {
        LineResult lRlt;
        int i;
        ValidateFailedException ve = new ValidateFailedException();
        this.editCollection = this.createNewCollection();
        boolean bool = true;
        for (i = 0; i < rlt.size(); ++i) {
            lRlt = rlt.getLineResult(i);
            if (lRlt.isSucess() || !bool) continue;
            bool = false;
        }
        for (i = 0; i < rlt.size(); ++i) {
            lRlt = rlt.getLineResult(i);
            if (lRlt.isSucess() && bool) {
                IObjectPK pk = lRlt.getPk();
                this.editCollection.addObject((IObjectValue)this.getBizInterface().getValue(pk, this.getSelectors()));
                continue;
            }
            if (lRlt.isSucess()) continue;
            ve.addError(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"70_TableEditUI") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"71_TableEditUI"), ((IObjectCollection)this.getTable().getUserObject()).getObject(i), lRlt.getException());
        }
        if (bool) {
            this.setDataCollection(this.editCollection);
            this.loadCollectionFields();
        }
        if (ve != null && ve.getErrors().size() > 0) {
            ve.setFormatter((IMultiExceptionMessageFormatter)new ValidateErrorFormatter());
            EASMultiException mulE = new EASMultiException((IMultiException)ve);
            throw mulE;
        }
    }
}

