/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.client.AbstractTreeDetailListUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.IMoveTreeListener;
import com.kingdee.eas.framework.client.MoveTree;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.framework.client.uisidebar.UISideBarFactory;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.QuickFilteringSupportManager;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.framework.util.WindowsUtility;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class TreeDetailListUI
extends AbstractTreeDetailListUI {
    private Logger logger = Logger.getLogger(TreeDetailListUI.class);
    protected ITreeBuilder treeBuilder;
    private boolean isIncludeChild = false;
    private TreeBaseInfo sourceTreeNode;
    private KDTreeNode sourceSelectNode;
    private MoveTree moveTreeDialog = null;
    private MoveTree moveGroupTreeDialog = null;
    private boolean nodeFilter = false;
    private static final String GroupOperate = "GroupOperate";
    private TreeBaseInfo editData = null;
    private TreeSelectionListener treeSelectionListener;

    public void setNodeFilter(boolean nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    public boolean isNodeFilter() {
        return this.nodeFilter;
    }

    protected void initGroupButton() {
        this.treeView.getControlPane().add((Component)this.btnGroupAddNew);
        this.treeView.getControlPane().add((Component)this.btnGroupView);
        this.treeView.getControlPane().add((Component)this.btnGroupEdit);
        this.treeView.getControlPane().add((Component)this.btnGroupRemove);
        this.treeView.getControlPane().add((Component)this.btnGroupMoveTree);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
            this.sourceTreeNode = (TreeBaseInfo)this.getSelectedTreeNode().getUserObject();
            this.sourceSelectNode = this.getSelectedTreeNode();
            if (!this.getTreeInterface().exists((IObjectPK)new ObjectUuidPK(this.sourceTreeNode.getId()))) {
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
        }
        this.setLocatePre(false);
        this.buildTreeFilter();
        this.execQuery();
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
        this.setSelectFirstRow(this.tblMain);
        this.setLocatePre(true);
    }

    protected FilterItemInfo getSingleNodeFilter(TreeBaseInfo treeNode) {
        if (treeNode == null) {
            return new FilterItemInfo(this.getQueryFieldName(), (Object)"null");
        }
        return new FilterItemInfo(this.getQueryFieldName(), (Object)treeNode.getId().toString());
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = this.mainQueryPK.getFullName()) && !this.isFirstDefaultQuery()) {
            if (this.dialog == null) {
                this.dialog = this.initCommonQueryDialog();
                this.dialog.setMaxReturnCountVisible(true);
            }
            this.dialog.setTablePanelFirst(false);
            if (this.isSupportDynQuery()) {
                this.dialog.setDynQueryVisible(true);
            }
            if (this.dialog.show()) {
                this.tHelper.setDialog(this.dialog);
                this.setDefaultEntityViewInfo(this.dialog.getEntityViewInfoResult());
                this.mainQuery = this.getEntityViewInfo((EntityViewInfo)this.dialog.getEntityViewInfoResult().clone());
                if (this.isNodeFilter()) {
                    KDTreeNode treeNode = this.getSelectedTreeNode();
                    FilterItemInfo filterItem = null;
                    if (treeNode == null) {
                        filterItem = this.getSingleNodeFilter(null);
                    } else if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                        TreeBaseInfo info = (TreeBaseInfo)treeNode.getUserObject();
                        filterItem = this.getSingleNodeFilter(info);
                    }
                    if (filterItem != null) {
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(filterItem);
                        if (this.mainQuery.getFilter().getFilterItems().size() > 0) {
                            this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
                        } else {
                            this.mainQuery.setFilter(filterInfo);
                        }
                    }
                }
                if (this.orgContextManager != null) {
                    this.mainQuery.getFilter().mergeFilter(this.orgContextManager.changeQueryContext(this.getUIContext()), "and");
                }
                if (this.mainQuery.getSorter() != null && this.mainQuery.getSorter().size() > 0) {
                    this.setIsIgnoreOrder(true);
                } else {
                    this.setIsIgnoreOrder(false);
                }
                this.prepareQuery(null).callHandler();
                this.handleDynQuery(this.mainQuery, this.dialog);
                this.doQuery(this.dialog);
                this.setLocatePre(true);
                this.execQuery();
                UISideBarFactory.reBuildSideBar(this);
            } else {
                this.tHelper.setDialog(this.dialog);
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (e.getPrevSelectBlock() == null || e.getSelectBlock() == null) {
            return;
        }
        if (!e.getPrevSelectBlock().equals((Object)e.getSelectBlock()) && e.getSelectBlock().getBeginRow() == e.getSelectBlock().getEndRow()) {
            this.selectNode();
        }
    }

    protected void selectNode() throws Exception {
        if (this.getSelectedTreeKeyValue() == null || !this.isLocateTree()) {
            return;
        }
        this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        TreeBaseInfo selectRow = this.getTreeInterface().getTreeBaseInfo(this.getSelectedTreeKeyValue());
        String fullLN = selectRow.getLongNumber();
        int endLevel = selectRow.getLevel();
        this.treeMain.setSelectionRow(0);
        TreePath oldPath = this.treeMain.getSelectionPath();
        KDTreeNode selectNode = this.getSelectedTreeNode();
        if (!(selectNode.getUserObject() instanceof TreeBaseInfo)) {
            selectNode = this.getSelectedTreeNode();
        }
        this.getSelectNode(fullLN, selectNode, endLevel);
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
    }

    protected boolean isLocateTree() {
        return true;
    }

    protected abstract IObjectPK getSelectedTreeKeyValue();

    private boolean getSelectNode(String fullLN, KDTreeNode selectNode, int endLevel) throws Exception {
        int j;
        boolean isRefreshNode = true;
        boolean flag = false;
        if (selectNode.getChildCount() == 0) {
            return false;
        }
        if (endLevel - selectNode.getLevel() <= 0) {
            return false;
        }
        for (j = 0; j < selectNode.getChildCount() && isRefreshNode; ++j) {
            if (selectNode.getChildAt(j) instanceof KDTreeNode) continue;
            this.treeBuilder.setExpandLevel(endLevel - selectNode.getLevel());
            this.treeBuilder.refreshTreeNode(this.treeMain, selectNode);
            isRefreshNode = false;
        }
        for (j = 0; j < selectNode.getChildCount(); ++j) {
            KDTreeNode tempNode = (KDTreeNode)((Object)selectNode.getChildAt(j));
            TreeBaseInfo tempTree = (TreeBaseInfo)tempNode.getUserObject();
            if (!fullLN.startsWith(tempTree.getLongNumber())) continue;
            if (StringUtility.isMatch(tempTree.getLongNumber(), fullLN, false)) {
                this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)tempNode);
                flag = true;
                break;
            }
            flag = this.getSelectNode(fullLN, tempNode, endLevel);
        }
        return flag;
    }

    protected abstract String getGroupEditUIName();

    protected String getGroupEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)GroupOperate, (Object)"false");
        this.prepareGroupUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getGroupEditUIModal()).create(this.getGroupEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.setActionEvent(e);
        if (this.isDoRefresh(uiWindow, this.getGroupEditUIModal())) {
            this.refresh(e);
        }
    }

    @Override
    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedNodeKeyValue());
        uiContext.put((Object)GroupOperate, (Object)"false");
        this.prepareGroupUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getGroupEditUIModal()).create(this.getGroupEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.setActionEvent(e);
        if (this.isDoRefresh(uiWindow, this.getGroupEditUIModal())) {
            this.refresh(e);
        }
    }

    @Override
    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        EditUI ui;
        this.checkTreeNodeSelected(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedNodeKeyValue());
        uiContext.put((Object)GroupOperate, (Object)"false");
        this.prepareGroupUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getGroupEditUIModal()).create(this.getGroupEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        IUIObject obj = uiWindow.getUIObject();
        if (obj instanceof EditUI && (ui = (EditUI)obj).getUIContext().containsKey("InitDataObject")) {
            this.editData = (TreeBaseInfo)ui.getUIContext().get("InitDataObject");
        }
        this.setActionEvent(e);
        if (this.isDoRefresh(uiWindow, this.getGroupEditUIModal())) {
            this.refresh(e);
        }
    }

    public IUIActionPostman prepareNodeChange(RequestContext request, String action) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(UtilRequest.isPrepare(action, this));
        if (!handler.isAvailabe()) {
            return handler;
        }
        handler.setRequestContext((Serializable)this.prepareQueryContext(null));
        handler.setRequestContext((Serializable)this.prepareInitTree());
        RequestContext requestContext = new RequestContext();
        requestContext.setClassName(this.getUIHandlerClassName());
        requestContext.setMethodName("handleNodeChange");
        KDTreeNode node = (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent());
        if (node != null) {
            KDTreeNode parent = (KDTreeNode)((Object)node.getParent());
            if (parent != null) {
                requestContext.put("parentNode", parent.getUserObject() instanceof TreeBaseInfo ? parent.getUserObject() : null);
            } else {
                requestContext.put("parentNode", null);
            }
        }
        try {
            BOSObjectType bosType = this.getBizType();
            requestContext.setBosType(bosType);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        handler.setRequestContext((Serializable)requestContext);
        return handler;
    }

    public IUIActionPostman prepareGroupRemove(RequestContext request) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(UtilRequest.isPrepare("ActionGroupRemove", this));
        if (!handler.isAvailabe()) {
            return handler;
        }
        handler.setRequestContext((Serializable)this.prepareQueryContext(null));
        handler.setRequestContext((Serializable)this.prepareInitTree());
        RequestContext requestContext = new RequestContext();
        requestContext.setClassName(this.getUIHandlerClassName());
        requestContext.setMethodName("handleGroupRemove");
        try {
            BOSObjectType bosType = this.getBizType();
            requestContext.setBosType(bosType);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        requestContext.put("removeKey", this.getSelectedNodeKeyValue());
        KDTreeNode treeNode = (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent());
        treeNode = (KDTreeNode)((Object)treeNode.getParent());
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            requestContext.put("parentNode", treeNode.getUserObject());
        } else {
            requestContext.put("parentNode", null);
        }
        handler.setRequestContext((Serializable)requestContext);
        return handler;
    }

    @Override
    public RequestContext prepareActionGroupRemove(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionGroupRemove(itemAction);
        RequestContext req = this.prepareInitTree();
        request.putAll(req);
        try {
            BOSObjectType bosType = this.getBizType();
            request.setBosType(bosType);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return request;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    protected String getEditUIName() {
        return null;
    }

    protected void handleGroupRemove() throws Exception {
        IUIActionPostman handler = this.prepareGroupRemove(new RequestContext());
        handler.callHandler();
    }

    protected void handleNodeChange(String action) throws Exception {
        IUIActionPostman handler = this.prepareNodeChange(new RequestContext(), action);
        handler.callHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        KDTreeNode treeNode = (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent());
        if (treeNode.getChildCount() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_OnlyLeaf_CanDelete"));
            SysUtil.abort();
        }
        if (this.confirmRemove()) {
            this.handleGroupRemove();
            String selectID = null;
            try {
                this.setOprtState("REMOVE");
                selectID = this.getSelectedNodeKeyValue();
                this.pubFireVOChangeListener(selectID);
            }
            catch (Throwable ex) {
                this.handUIException(ex);
                this.abort();
            }
            try {
                ITreeBase treeInterface = this.getTreeInterface();
                treeInterface.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedNodeKeyValue())));
            }
            catch (ObjectNotFoundException onfe) {
                onfe.printStackTrace();
                this.refreshList();
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            catch (Throwable e1) {
                e1.printStackTrace();
                this.handUIException(e1);
                this.abort();
            }
            finally {
                try {
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(selectID);
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
            this.setActionEvent(e);
            this.refresh(e);
        }
    }

    protected String getMoveGroupTitle() {
        return this.btnGroupMoveTree.getToolTipText();
    }

    protected String getMoveDetailTitle() {
        return this.btnMoveTree.getToolTipText();
    }

    @Override
    public void actionGroupMoveTree_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedTreeNode() == null) {
            return;
        }
        if (!(this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo)) {
            return;
        }
        Window onwer = ComponentUtil.getOwnerWindow((Component)((Object)this));
        this.moveGroupTreeDialog = onwer instanceof Frame ? new MoveTree((Frame)onwer, this.getMoveGroupTitle(), this.getRootName(), this.getTreeInterface(), (TreeBaseInfo)this.getSelectedTreeNode().getUserObject(), true, this.getDefaultFilterForTree()) : (onwer instanceof Dialog ? new MoveTree((Dialog)onwer, this.getMoveGroupTitle(), this.getRootName(), this.getTreeInterface(), (TreeBaseInfo)this.getSelectedTreeNode().getUserObject(), true, this.getDefaultFilterForTree()) : new MoveTree((Component)((Object)this), this.getMoveGroupTitle(), this.getRootName(), this.getTreeInterface(), (TreeBaseInfo)this.getSelectedTreeNode().getUserObject(), true, this.getDefaultFilterForTree()));
        this.moveGroupTreeDialog.addMoveTreeListener(new IMoveTreeListener(){

            @Override
            public void SelectTreeCancel(MoveTreeEvent e) {
                TreeDetailListUI.this.moveGroupTreeDialog.dispose();
                TreeDetailListUI.this.moveGroupTreeDialog = null;
            }

            @Override
            public void SelectTreeNode(MoveTreeEvent e) {
                TreeDetailListUI.this.moveGroupTreeNode(e);
            }
        });
        this.moveGroupTreeDialog.setLocation(WindowsUtility.getWindowCenter((Component)((Object)this.moveGroupTreeDialog)));
        this.moveGroupTreeDialog.show();
    }

    protected boolean isMoveGroup() {
        return true;
    }

    protected void moveGroupTreeNode(MoveTreeEvent e) {
        try {
            if (this.sourceTreeNode == null) {
                this.sourceTreeNode = (TreeBaseInfo)this.getSelectedTreeNode().getUserObject();
            }
            if (this.sourceSelectNode == null) {
                this.sourceSelectNode = this.getSelectedTreeNode();
            }
            if (!this.isMoveGroup()) {
                return;
            }
            if (e.getTargetTreeBaseInfo() != null && this.sourceTreeNode.getId().toString().equals(e.getTargetTreeBaseInfo().getId().toString())) {
                return;
            }
            CacheServiceFactory.getInstance().discardType(this.getTreeInterface().getType());
            this.getTreeInterface().moveTreeNode(this.sourceTreeNode, e.getTargetTreeBaseInfo());
            KDTreeNode sourceParentNode = (KDTreeNode)((Object)this.sourceSelectNode.getParent());
            sourceParentNode.remove((MutableTreeNode)((Object)this.sourceSelectNode));
            e.getTargetNode().add((MutableTreeNode)((Object)this.sourceSelectNode));
            this.moveGroupTreeDialog.dispose();
            this.moveGroupTreeDialog = null;
            this.initTree();
            this.treeMain.setSelectionRow(0);
        }
        catch (Exception ex) {
            this.handUIException(ex);
            super.abort();
        }
    }

    @Override
    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        Window curWindow;
        TreeBaseInfo tree = null;
        if (this.getSelectedTreeNode() == null) {
            return;
        }
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
            tree = (TreeBaseInfo)this.getSelectedTreeNode().getUserObject();
        }
        if ((curWindow = ComponentUtil.getOwnerWindow((Component)((Object)this))) instanceof Frame) {
            this.moveTreeDialog = new MoveTree((Frame)curWindow, this.getMoveDetailTitle(), this.getRootName(), this.getTreeInterface(), tree, false, this.getDefaultFilterForTree());
        } else if (curWindow instanceof Dialog) {
            this.moveTreeDialog = new MoveTree((Dialog)curWindow, this.getMoveDetailTitle(), this.getRootName(), this.getTreeInterface(), tree, false, this.getDefaultFilterForTree());
        }
        this.moveTreeDialog.addMoveTreeListener(new IMoveTreeListener(){

            @Override
            public void SelectTreeCancel(MoveTreeEvent e) {
                TreeDetailListUI.this.moveTreeDialog.dispose();
                TreeDetailListUI.this.moveTreeDialog = null;
            }

            @Override
            public void SelectTreeNode(MoveTreeEvent e) {
                TreeDetailListUI.this.moveTreeNode(e);
            }
        });
        this.moveTreeDialog.setLocation(WindowsUtility.getWindowCenter((Component)((Object)this.moveTreeDialog)));
        this.moveTreeDialog.show();
    }

    protected boolean isMoveTree() {
        return true;
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        try {
            if (this.sourceTreeNode == null) {
                this.sourceTreeNode = this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo ? (TreeBaseInfo)this.getSelectedTreeNode().getUserObject() : null;
            }
            if (this.sourceSelectNode == null) {
                this.sourceSelectNode = this.getSelectedTreeNode();
            }
            if (this.getSelectedKeyValue() == null) {
                return;
            }
            if (!this.isMoveTree()) {
                return;
            }
            if (this.getSelectDetailTreeName() == null) {
                return;
            }
            int currentRow = 0;
            ArrayList selectList = null;
            if (this.tblMain.getSelectManager().get() != null) {
                currentRow = this.tblMain.getSelectManager().get().getBeginRow();
                selectList = this.getSelectedIdValues();
            }
            if (e.getTargetTreeBaseInfo() == null && !this.canMoveDetailToRoot()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getcanMoveDetailToRootMsg());
                return;
            }
            for (int j = 0; j < selectList.size(); ++j) {
                ObjectUuidPK selectDetailPK = new ObjectUuidPK(selectList.get(j).toString());
                CoreBaseInfo editData = this.getBizInterface().getValue((IObjectPK)selectDetailPK);
                editData.put(this.getSelectDetailTreeName(), e.getTargetTreeBaseInfo());
                this.getBizInterface().update((IObjectPK)selectDetailPK, editData);
                this.tblMain.removeRow(currentRow);
            }
            this.moveTreeDialog.dispose();
            this.moveTreeDialog = null;
            this.initTree();
            this.treeMain.setSelectionRow(0);
        }
        catch (Exception ex) {
            this.handUIException(ex);
            super.abort();
        }
    }

    protected boolean canMoveDetailToRoot() {
        return true;
    }

    protected String getcanMoveDetailToRootMsg() {
        return EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CanNotMoveToRoot");
    }

    protected String getSelectDetailTreeName() {
        return null;
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        KDTreeNode treeNode = (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent());
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            if (uiContext.containsKey((Object)"ID") && uiContext.get((Object)"ID") != null) {
                if (treeNode.getParent() instanceof KDTreeNode) {
                    KDTreeNode parent = (KDTreeNode)((Object)treeNode.getParent());
                    if (parent.getUserObject() instanceof TreeBaseInfo) {
                        uiContext.put((Object)"ParentNode", parent.getUserObject());
                    } else {
                        uiContext.put((Object)"ParentNode", null);
                    }
                } else {
                    uiContext.put((Object)"ParentNode", null);
                }
            } else {
                uiContext.put((Object)"ParentNode", treeNode.getUserObject());
            }
        } else {
            uiContext.put((Object)"ParentNode", null);
        }
    }

    @Override
    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            uiContext.put((Object)"ParentNode", treeNode.getUserObject());
        } else {
            uiContext.put((Object)"ParentNode", null);
        }
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent());
    }

    public void checkTreeNodeSelected(ActionEvent e) {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        ItemAction action = this.getActionFromActionEvent(e);
        if (treeNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
        if (!action.equals((Object)this.actionGroupAddNew) && !(treeNode.getUserObject() instanceof TreeBaseInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Root_CannotSelected"));
            SysUtil.abort();
        }
        if (!action.equals((Object)this.actionGroupAddNew) && treeNode.getUserObject() instanceof TreeBaseInfo) {
            try {
                this.checkTreeObjectExists(e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                SysUtil.abort();
            }
        }
    }

    private void checkTreeObjectExists(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode.getUserObject() == null) {
            return;
        }
        if (!this.getTreeInterface().exists((IObjectPK)new ObjectUuidPK(((TreeBaseInfo)treeNode.getUserObject()).getId().toString()))) {
            this.refresh(e);
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    protected String getSelectedNodeKeyValue() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            return ((TreeBaseInfo)treeNode.getUserObject()).getId().toString();
        }
        System.out.println("Warnning it is virtual node and abort!");
        SysUtil.abort();
        return null;
    }

    protected boolean isOptimizeTree() {
        return false;
    }

    @Override
    protected String getObjectUpdateId() {
        return this.getSelectedNodeKeyValue();
    }

    protected void buildTreeFilter() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        EntityViewInfo defaultEntityViewInfo = this.getDefaultEntityViewInfo();
        FilterItemCollection col = this.removeQueryFilterAndSorter(this.mainQuery);
        if (this.isOptimizeTree()) {
            this.mainQuery.getFilter().setMaskString("");
            this.setTreeFilterForInclude(this.mainQuery.getFilter());
        } else {
            if (treeNode.getUserObject() instanceof TreeBaseInfo) {
                this.setFilterIncludeChild(col, (TreeBaseInfo)treeNode.getUserObject());
            } else {
                this.setFilterIncludeChild(col, null);
            }
            int count = this.mainQuery.getFilter().getFilterItems().size();
            this.mainQuery.getFilter().setMaskString("");
            if (count > 0) {
                StringBuffer master = new StringBuffer();
                for (int i = 0; i < count; ++i) {
                    if (i > 0) {
                        master.append(" OR ");
                    }
                    master.append("#");
                    master.append(i);
                }
                this.mainQuery.getFilter().setMaskString(master.toString());
            }
        }
        this.TreeFilterMerge(this.getTreeFilter());
        try {
            this.getEntityViewInfo(this.mainQuery);
            if (defaultEntityViewInfo != null) {
                this.MergeCommonQuery(defaultEntityViewInfo);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            this.abort();
        }
        if (this.getCurrentOrder() != null) {
            this.mainQuery.getSorter().add(this.getCurrentOrder());
        }
    }

    private TreeBaseInfo getSelectTreeInfo() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode.getUserObject() instanceof TreeBaseInfo) {
            return (TreeBaseInfo)treeNode.getUserObject();
        }
        return null;
    }

    protected boolean isApplyDetfaultTreeFilter() {
        return true;
    }

    private void setTreeFilterForInclude(FilterInfo filter) {
        if (this.isIsIncludeChild()) {
            String longNumber;
            FilterInfo cuFilter = null;
            if (this.isApplyDetfaultTreeFilter()) {
                cuFilter = this.getDefaultFilterForTree();
            }
            String[] RelationName = StringUtil.split((String)this.getQueryFieldName(), (String)".");
            TreeBaseInfo tree = this.getSelectTreeInfo();
            String string = longNumber = tree == null ? "" : tree.getLongNumber();
            if (cuFilter == null || cuFilter.getFilterItems() == null || cuFilter.getFilterItems().size() == 0) {
                cuFilter = new FilterInfo();
                if (longNumber != null && longNumber.length() > 0) {
                    cuFilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!" + "%"), CompareType.LIKE));
                    cuFilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.EQUALS));
                    cuFilter.setMaskString("#0 OR #1");
                } else {
                    cuFilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
                }
            } else {
                FilterInfo tempFilter = new FilterInfo();
                if (longNumber != null && longNumber.length() > 0) {
                    tempFilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!" + "%"), CompareType.LIKE));
                    tempFilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.EQUALS));
                    tempFilter.setMaskString("#0 OR #1");
                } else {
                    tempFilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
                }
                try {
                    if (FilterUtility.hasFilterItem(cuFilter)) {
                        cuFilter.mergeFilter(tempFilter, "AND");
                    } else {
                        cuFilter = tempFilter;
                    }
                }
                catch (BOSException e) {
                    this.logger.debug((Object)"merge tree error for inlude child !", (Throwable)e);
                    this.handleException((Exception)((Object)e));
                }
            }
            if (cuFilter != null) {
                for (int i = 0; i < cuFilter.getFilterItems().size(); ++i) {
                    String[] s = StringUtil.split((String)cuFilter.getFilterItems().get(i).getPropertyName(), (String)".");
                    boolean isGroupFilter = false;
                    for (int j = 0; j < s.length; ++j) {
                        if (!RelationName[0].equals(s[j])) continue;
                        isGroupFilter = true;
                        break;
                    }
                    if (isGroupFilter) continue;
                    cuFilter.getFilterItems().get(i).setPropertyName(RelationName[0] + "." + cuFilter.getFilterItems().get(i).getPropertyName());
                }
            }
            if (filter != null && filter.getFilterItems().size() > 0) {
                try {
                    if (cuFilter != null && cuFilter.getFilterItems().size() > 0) {
                        filter.mergeFilter(cuFilter, "AND");
                    }
                }
                catch (BOSException e) {
                    this.logger.debug((Object)"merge tree error for inlude child !", (Throwable)e);
                    this.handleException((Exception)((Object)e));
                }
            } else {
                filter = (FilterInfo)cuFilter.clone();
            }
            this.mainQuery.setFilter(filter);
        } else {
            TreeBaseInfo tree = this.getSelectTreeInfo();
            FilterItemInfo filterItem = this.getSingleNodeFilter(tree);
            if (filterItem != null) {
                filter.getFilterItems().add(filterItem);
            }
        }
    }

    private void TreeFilterMerge(FilterInfo filter) {
        if (filter != null && filter.getFilterItems().size() > 0) {
            try {
                if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems() != null && this.mainQuery.getFilter().getFilterItems().size() > 0) {
                    this.mainQuery.getFilter().mergeFilter(filter, "AND");
                } else {
                    this.mainQuery.setFilter(filter);
                }
            }
            catch (BOSException ex) {
                MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
                super.abort();
            }
        }
    }

    protected FilterInfo getTreeFilter() {
        return null;
    }

    private void setFilterIncludeChild(FilterItemCollection cols, TreeBaseInfo tree) {
        FilterItemInfo filterItem = this.getSingleNodeFilter(tree);
        if (filterItem != null) {
            cols.add(filterItem);
        }
        if (this.isIsIncludeChild()) {
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(this.getDefaultFilterForTree());
            ev.getSelector().add(new SelectorItemInfo("id"));
            try {
                TreeBaseCollection treeCols = null;
                treeCols = this.getTreeInterface().getAllChildren(tree, ev);
                if (treeCols != null) {
                    ArrayList<String> filterList = new ArrayList<String>();
                    for (int i = 0; i < treeCols.size(); ++i) {
                        filterList.add(treeCols.get(i).getId().toString());
                    }
                    if (filterList.size() > 0) {
                        String strIdLists = StringUtils.arrayToString((Object[])filterList.toArray(), (String)",");
                        cols.add(new FilterItemInfo(this.getQueryFieldName(), (Object)strIdLists, CompareType.INCLUDE));
                    }
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    protected final void setIsIncludeChild(boolean isInclude) {
        this.isIncludeChild = isInclude;
    }

    protected final boolean isIsIncludeChild() {
        return this.isIncludeChild;
    }

    @Override
    protected void chkIncludeChild_itemStateChanged(ItemEvent e) throws Exception {
        this.isIncludeChild = this.chkIncludeChild.isSelected();
        if (this.treeMain.getRowCount() == 0) {
            return;
        }
        this.treeMain_valueChanged(null);
    }

    protected abstract String getQueryFieldName();

    protected String getRootName() {
        return "root";
    }

    protected Object getRootObject() {
        return this.getRootName();
    }

    @Override
    public void onLoad() throws Exception {
        this.setDoRequestData(false);
        super.onLoad();
        this.setDoRequestData(true);
        this.initGroupButton();
        this.initWorkButton();
        UIActionMonitor.startAction((String)this.getMetaDataPK().getFullName(), (String)"refresh");
        this.handleNodeChange("ActionRefresh");
        this.initTree();
        this.isIncludeChild = this.chkIncludeChild.isSelected();
        this.treeMain.setSelectionRow(0);
        UIActionMonitor.endAction((String)this.getMetaDataPK().getFullName(), (String)"refresh", (long)0L);
        this.initFocusPolicy();
    }

    protected void initFocusPolicy() {
        ArrayList compList = new ArrayList();
        this.lookForFocusComponent((Container)((Object)this), compList);
        Component[] component = new Component[compList.size()];
        for (int index = 0; index < compList.size(); ++index) {
            component[index] = (Component)compList.get(index);
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(component));
        this.setFocusCycleRoot(true);
    }

    private void lookForFocusComponent(Container container, List compList) {
        if (container == null || container instanceof JToolBar || container instanceof JButton) {
            return;
        }
        if (container instanceof JTree) {
            compList.add(container);
        } else if (container instanceof KDTable) {
            compList.add(container);
        } else if (container instanceof IKDTextComponent) {
            if (container.isEnabled() && container.isVisible()) {
                compList.add(container);
            }
        } else if (container instanceof Container) {
            Component[] component = container.getComponents();
            for (int index = 0; index < component.length; ++index) {
                this.lookForFocusComponent((Container)component[index], compList);
            }
        }
    }

    @Override
    public RequestContext prepareQueryContext(RequestRowSetEvent e) {
        RequestContext request = super.prepareQueryContext(e);
        EntityViewInfo info = request.getQuery();
        if (info == null) {
            info = new EntityViewInfo();
        }
        if (this.getCurrentOrder() != null) {
            info.getSorter().add(this.getCurrentOrder());
        }
        request.setQuery(info);
        return request;
    }

    public RequestContext prepareInitTree() {
        RequestContext request = new RequestContext();
        ITreeBase _interface = null;
        try {
            _interface = this.getTreeInterface();
            if (_interface != null) {
                request.put("TreeCtrlBOSObjectType", _interface.getType());
            }
            request.put("TreeInitialLevel", new Integer(this.getTreeInitialLevel()));
            request.put("TreeExpandLevel", new Integer(this.getTreeExpandLevel()));
            request.put("selectorForTree", this.getSelectorForTree());
            request.put("selectedKeyValue", this.getSelectedKeyValue());
            KDTreeNode selectedTreeNode = this.getSelectedTreeNode();
            if (selectedTreeNode != null) {
                TreeBaseInfo nodeInfo = selectedTreeNode.getUserObject() instanceof TreeBaseInfo ? (TreeBaseInfo)selectedTreeNode.getUserObject() : null;
                request.put("selectedTreeNode", nodeInfo);
            }
            request.put("isIncludeChild", this.isIsIncludeChild());
            request.put("isOptimizeTree", this.isOptimizeTree());
            request.put("isApplyDetfaultTreeFilter", this.isApplyDetfaultTreeFilter());
            request.put("queryFieldName", this.getQueryFieldName());
            request.put("treeFilter", this.getTreeFilter());
            request.put("currentOrder", this.getCurrentOrder());
            request.put("defaultEntityViewInfo", this.getDefaultEntityViewInfo());
        }
        catch (Exception selectedTreeNode) {
            // empty catch block
        }
        FilterInfo defaultFilterForTree = this.getDefaultFilterForTree();
        if (defaultFilterForTree != null) {
            request.put("treeDefaultFilter", defaultFilterForTree.clone());
        }
        return request;
    }

    @Override
    public IUIActionPostman prepareInit() {
        this.isIncludeChild = this.chkIncludeChild.isSelected();
        IUIActionPostman postman = super.prepareInit();
        if (postman != null && postman.isAvailabe()) {
            RequestContext request = this.prepareInitTree();
            postman.setRequestContext((Serializable)request);
        }
        return postman;
    }

    @Override
    public RequestContext prepareActionRefresh(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionRefresh(itemAction);
        RequestContext requestContext = this.prepareInitTree();
        request.putAll(requestContext);
        return request;
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.treeMain.requestFocus();
    }

    protected void initTree() throws Exception {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        TreeSelectionListener treeSelectionListener = this.treeSelectionListener = listeners.length > 0 ? listeners[0] : null;
        if (this.treeSelectionListener != null) {
            this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder(this.getLNTreeNodeCtrl(), this.getTreeInitialLevel(), this.getTreeExpandLevel(), this.getDefaultFilterForTree(), this.getSelectorForTree());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)((Object)rootNode));
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.treeMain);
        if (this.treeSelectionListener != null) {
            this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeMain.setShowPopMenuDefaultItem(true);
        this.initPopmenu();
    }

    protected SelectorItemCollection getSelectorForTree() {
        return null;
    }

    protected int getTreeInitialLevel() {
        return 3;
    }

    protected int getTreeExpandLevel() {
        return 3;
    }

    protected FilterInfo getDefaultFilterForTree() {
        return this.getDefaultCUFilter(this.isIgnoreTreeCUFilter());
    }

    protected boolean isIgnoreTreeCUFilter() {
        return false;
    }

    protected void initPopmenu() {
        JPopupMenu menu = this.treeMain.getPopupMenu();
        EventListener[] ls = this.treeMain.getListeners(TreePopupMenuListener.class);
        if (ls == null || ls.length == 0) {
            this.treeMain.addTreePopupMenu(new TreePopupMenuListener(){

                public boolean popMenu(TreePopupMenuEvent event) {
                    return true;
                }
            });
            menu.add((Component)new KDSeparator());
            JMenuItem itemAdd = new JMenuItem((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionGroupAddNew), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
            itemAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
            menu.add(itemAdd);
            JMenuItem itemEdit = new JMenuItem((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionGroupEdit), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
            itemEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
            menu.add(itemEdit);
            JMenuItem itemView = new JMenuItem((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionGroupView), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
            itemView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
            menu.add(itemView);
            JMenuItem itemRemove = new JMenuItem((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionGroupRemove), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
            itemRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
            menu.add(itemRemove);
        }
    }

    protected ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    protected abstract ITreeBase getTreeInterface() throws Exception;

    private TreeSelectionListener[] removeAllTreeSelectionListener() {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.treeMain.removeTreeSelectionListener(listeners[i]);
        }
        return listeners;
    }

    private void addAllTreeSelectionListener(TreeSelectionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.treeMain.addTreeSelectionListener(listeners[i]);
        }
    }

    @Override
    public IUIActionPostman prepareRefresh(RequestContext request) {
        return this.prepareNodeChange(request, "ActionRefresh");
    }

    @Override
    public void refreshList() throws Exception {
        ActionEvent event = new ActionEvent(this.btnRefresh, 1001, this.btnRefresh.getActionCommand());
        this.refresh(event);
    }

    @Override
    protected void refresh(ActionEvent e) throws Exception {
        ItemAction action = null;
        if (e != null) {
            action = this.getActionFromActionEvent(e);
        }
        if (action == null) {
            return;
        }
        if (action.equals((Object)this.actionGroupRemove)) {
            KDTreeNode treeNode = (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent());
            if (treeNode != null && treeNode.getParent() != null) {
                TreePath parentPath = this.treeMain.getSelectionPath().getParentPath();
                KDTreeNode parentNode = (KDTreeNode)((Object)treeNode.getParent());
                parentNode.remove((MutableTreeNode)((Object)treeNode));
                this.treeMain.updateUI();
                this.treeMain.setSelectionPath(parentPath);
                this.treeBuilder.refreshTreeNode(this.treeMain, parentNode, this.getDefaultFilterForTree());
                this.treeMain.expandPath(parentPath);
            }
        } else if (action.equals((Object)this.actionRefresh)) {
            TreePath oldPath = null;
            if (!this.isDefaultTreeModelUsed(this.treeMain)) {
                oldPath = this.treeMain.getSelectionPath();
            }
            this.initTree();
            this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, this.treeMain.getModel(), oldPath));
        } else if (action.equals((Object)this.actionView) && this.isModify) {
            this.initTree();
            this.treeMain.setSelectionRow(0);
            this.isModify = false;
        } else if (action.equals((Object)this.actionGroupAddNew)) {
            TreePath oldPath;
            UIActionMonitor.startAction((String)this.getMetaDataPK().getFullName(), (String)"refresh");
            this.handleNodeChange("ActionGroupAddNew");
            KDTreeNode treeNode = (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent());
            if (treeNode != null && treeNode.getParent() == null) {
                oldPath = this.treeMain.getSelectionPath();
                this.treeBuilder.refreshTreeNode(this.treeMain, treeNode, this.getDefaultFilterForTree());
                this.treeMain.setSelectionPath(oldPath);
                this.treeMain.expandPath(oldPath);
            }
            if (treeNode != null && treeNode.getParent() != null) {
                oldPath = this.treeMain.getSelectionPath();
                TreePath parentPath = this.treeMain.getSelectionPath().getParentPath();
                KDTreeNode parentNode = (KDTreeNode)((Object)treeNode.getParent());
                TreeSelectionListener[] listeners = this.removeAllTreeSelectionListener();
                this.treeBuilder.refreshTreeNode(this.treeMain, parentNode, this.getDefaultFilterForTree());
                this.addAllTreeSelectionListener(listeners);
                this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, this.treeMain.getModel(), oldPath));
                this.treeMain.expandPath(oldPath);
            }
            UIActionMonitor.endAction((String)this.getMetaDataPK().getFullName(), (String)"refresh", (long)0L);
        } else if (action.equals((Object)this.actionGroupEdit)) {
            UIActionMonitor.startAction((String)this.getMetaDataPK().getFullName(), (String)"refresh");
            this.handleNodeChange("ActionGroupEdit");
            KDTreeNode treeNode = (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent());
            if (treeNode != null && treeNode.getParent() != null) {
                TreePath oldPath = this.treeMain.getSelectionPath();
                TreePath parentPath = this.treeMain.getSelectionPath().getParentPath();
                KDTreeNode parentNode = (KDTreeNode)((Object)treeNode.getParent());
                TreeSelectionListener[] listeners = this.removeAllTreeSelectionListener();
                if (this.editData != null) {
                    this.onParentChanged(treeNode);
                }
                this.treeBuilder.refreshTreeNode(this.treeMain, parentNode, this.getDefaultFilterForTree());
                this.addAllTreeSelectionListener(listeners);
                this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, this.treeMain.getModel(), oldPath));
                this.editData = null;
            }
            UIActionMonitor.endAction((String)this.getMetaDataPK().getFullName(), (String)"refresh", (long)0L);
        } else if (action.equals((Object)this.actionGroupView)) {
            this.initTree();
            this.treeMain.setSelectionRow(0);
            this.isModify = false;
        } else {
            this.execQuery();
        }
    }

    private void onParentChanged(KDTreeNode treeNode) throws Exception {
        String newParentId;
        KDTreeNode rootNode = (KDTreeNode)((Object)treeNode.getRoot());
        ArrayList nodes = new ArrayList();
        this.getAllNodesByRoot(rootNode, nodes);
        TreeBaseInfo newParent = this.editData.innerGetParent();
        if (newParent == null) {
            return;
        }
        String newParentName = newParent.getName();
        String string = newParentId = newParent instanceof CoreBaseInfo ? newParent.getId().toString() : null;
        if (newParentName == null) {
            return;
        }
        for (Object obj : nodes) {
            if (!(obj instanceof KDTreeNode)) continue;
            KDTreeNode node = (KDTreeNode)((Object)obj);
            if (node.getUserObject() != null && node.getUserObject() instanceof CoreBaseInfo) {
                String parentId = ((CoreBaseInfo)node.getUserObject()).getId().toString();
                if (!newParentId.equals(parentId)) continue;
                this.treeBuilder.refreshTreeNode(this.treeMain, node, this.getDefaultFilterForTree());
                continue;
            }
            if (!newParentName.equals(node.toString())) continue;
            this.treeBuilder.refreshTreeNode(this.treeMain, node, this.getDefaultFilterForTree());
        }
    }

    private void getAllNodesByRoot(KDTreeNode root, List retSet) {
        if (root == null) {
            return;
        }
        for (int index = 0; index < root.getChildCount(); ++index) {
            TreeNode obj = root.getChildAt(index);
            if (!(obj instanceof KDTreeNode)) continue;
            KDTreeNode currNode = (KDTreeNode)((Object)obj);
            retSet.add(currNode);
            if (currNode.getChildCount() <= 0) continue;
            this.getAllNodesByRoot(currNode, retSet);
        }
    }

    @Override
    protected void initWorkButton() {
        this.getUIToolBar().remove((Component)this.btnGroupAddNew);
        this.getUIToolBar().remove((Component)this.btnGroupView);
        this.getUIToolBar().remove((Component)this.btnGroupEdit);
        this.getUIToolBar().remove((Component)this.btnGroupRemove);
        this.getUIToolBar().remove((Component)this.btnGroupMoveTree);
        super.initWorkButton();
        this.btnGroupAddNew.setText(null);
        this.btnGroupAddNew.setIcon(EASResource.getIcon((String)"imgTree_new"));
        this.menuItemGroupAddNew.setIcon(EASResource.getIcon((String)"imgTree_new"));
        this.btnGroupView.setText(null);
        this.btnGroupView.setIcon(EASResource.getIcon((String)"imgTree_view"));
        this.btnGroupEdit.setText(null);
        this.btnGroupEdit.setIcon(EASResource.getIcon((String)"imgTree_edit"));
        this.btnGroupRemove.setText(null);
        this.btnGroupRemove.setIcon(EASResource.getIcon((String)"imgTree_delete"));
        this.btnGroupMoveTree.setText(null);
        this.btnGroupMoveTree.setIcon(EASResource.getIcon((String)"imgTree_move"));
        this.menuItemGroupMoveTree.setIcon(EASResource.getIcon((String)"imgTree_move"));
        this.setButtonDefaultStyl(this.btnMoveTree);
        this.btnMoveTree.setIcon(EASResource.getIcon((String)"imgTbtn_movedata"));
        this.menuItemMoveTree.setIcon(EASResource.getIcon((String)"imgTbtn_movedata"));
    }

    boolean isDefaultTreeModelUsed(KDTree tree) {
        DefaultKingdeeTreeNode root;
        boolean result = false;
        if (tree.getModel() != null && tree.getModel().getRoot() instanceof DefaultKingdeeTreeNode && (root = (DefaultKingdeeTreeNode)tree.getModel().getRoot()) != null && "KDTree".equals(root.getText()) && root.getChildCount() == 3) {
            result = true;
        }
        return result;
    }

    @Override
    protected QuickFilteringSupportManager createQuickFilteringSupportManager() throws Exception {
        if (this.isViewForIdList() || this.getQuickFilteringSupportManager() != null) {
            return this.getQuickFilteringSupportManager();
        }
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && this.getBizType() != null) {
            qfsi.setBosType(this.getBizType().toString());
        }
        qfsi.setMustQueryAtFirst(true);
        return new QuickFilteringSupportManager(this, qfsi, (Component)this.pnlMain);
    }
}

